/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TempDataTypeObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.datatypes.SelectDataTypeDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class StructuredTypePropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private static final String[] INVALID_DATATYPES = new String[]{"LONG VARCHAR", "LONG VARGRAPHIC", "BLOB", "CLOB", "DBCLOB", "DATALINK"};
    private StructuredTypeProxyUDB structuredType;
    private JComboBox cbScheme;
    private JTextField tfOwner;
    private JTextField tfSuperType;
    private JTextField tfFinal;
    private JTextField tfInstantiable;
    private JButton bnDataType;
    private SelectDataTypeDialog datatypeDialog = null;
    private TempDataTypeObject tempDTO;
    private JTextField tfRef2RefType;
    private JTextField tfRefType2Ref;
    private JTextField tfInlineLength;
    private JComboBox cbWithFunctionAccess;

    public StructuredTypePropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.structuredType = (StructuredTypeProxyUDB)object;
        this.setHeight(400);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
        this.tempDTO = new TempDataTypeObject(this.structuredType.getDesign());
        this.structuredType.copyDataType(this.tempDTO);
    }

    @Override
    public String getCaption() {
        return Messages.getString("StructuredTypePropertyDialogUDB.StructuredTypeProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.setObjectConstraints(this.tfName, 20);
        this.initScheme();
        this.initOwner();
        this.initSuperType();
        this.initFinal();
        this.initInstantiable();
        this.initUsingType();
        this.initRef2RefType();
        this.initRefType2Ref();
        this.initInlineLength();
        this.initWithFunctionAccess();
    }

    private void initScheme() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.Scheme"));
        this.general.add(label);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbScheme, 50);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.Owner"));
        this.general.add(label);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.tfOwner.setEditable(false);
        this.tfOwner.setEnabled(false);
        this.general.add(this.tfOwner);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfOwner, 80);
    }

    private void initSuperType() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.SuperType"));
        this.general.add(label);
        this.tfSuperType = new JTextField("", 26);
        this.tfSuperType.setEditable(false);
        this.general.add(this.tfSuperType);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfSuperType, 110);
    }

    private void initFinal() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.Final"));
        this.general.add(label);
        this.tfFinal = new JTextField("", 26);
        this.tfFinal.setEditable(false);
        this.general.add(this.tfFinal);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfFinal, 140);
    }

    private void initInstantiable() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.Instantiable"));
        this.general.add(label);
        this.tfInstantiable = new JTextField("", 26);
        this.tfInstantiable.setEditable(false);
        this.general.add(this.tfInstantiable);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.tfInstantiable, 170);
    }

    private void initUsingType() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.RefUsingType"));
        this.general.add(label);
        this.bnDataType = new JButton();
        this.bnDataType.setFont(new Font(this.bnDataType.getFont().getName(), 0, this.bnDataType.getFont().getSize()));
        this.bnDataType.setHorizontalAlignment(0);
        this.bnDataType.setPreferredSize(this.tfName.getPreferredSize());
        this.bnDataType.setEnabled(this.isEditable());
        this.bnDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TempDataTypeObject temp = new TempDataTypeObject(StructuredTypePropertyDialogUDB.this.structuredType.getDesign());
                StructuredTypePropertyDialogUDB.this.tempDTO.copyDataType(temp);
                StructuredTypePropertyDialogUDB.this.datatypeDialog = new SelectDataTypeDialog(StructuredTypePropertyDialogUDB.this.getAppView(), temp, StructuredTypePropertyDialogUDB.this.bnDataType);
                StructuredTypePropertyDialogUDB.this.datatypeDialog.initProperties(false);
                int result = StructuredTypePropertyDialogUDB.this.datatypeDialog.showDialog();
                if (result == 1 && StructuredTypePropertyDialogUDB.this.checkDatatype(temp)) {
                    temp.copyDataType(StructuredTypePropertyDialogUDB.this.tempDTO);
                } else {
                    StructuredTypePropertyDialogUDB.this.bnDataType.setText(StructuredTypePropertyDialogUDB.this.tempDTO.getDataType());
                }
            }
        });
        this.general.add(this.bnDataType);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.bnDataType, 200);
    }

    private void initRef2RefType() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.RefToRefTypeCastFunction"));
        this.general.add(label);
        this.tfRef2RefType = new JTextField("", 26);
        this.general.add(this.tfRef2RefType);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.tfRef2RefType, 230);
    }

    private void initRefType2Ref() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.RefTypeToRefTypeCastFunction"));
        this.general.add(label);
        this.tfRefType2Ref = new JTextField("", 26);
        this.general.add(this.tfRefType2Ref);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.tfRefType2Ref, 260);
    }

    private void initInlineLength() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.InlineLength"));
        this.general.add(label);
        this.tfInlineLength = new JTextField("", 26);
        this.general.add(this.tfInlineLength);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.tfInlineLength, 290);
    }

    private void initWithFunctionAccess() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.WithFunctionAccess"));
        this.general.add(label);
        this.cbWithFunctionAccess = new JComboBox<String>(StructuredTypeProxyUDB.YES_NO);
        this.setBG(this.cbWithFunctionAccess);
        this.cbWithFunctionAccess.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbWithFunctionAccess);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbWithFunctionAccess, 320);
    }

    private boolean checkDatatype(DataTypeObject datatypeObject) {
        if (datatypeObject.getType() instanceof StructuredType) {
            JOptionPane.showMessageDialog(this, Messages.getString("StructuredTypePropertyDialogUDB.PropertyCantBeStructuredType"), Messages.getString("StructuredTypePropertyDialogUDB.Error"), 0);
            return false;
        }
        String datatype = datatypeObject.getDataType();
        if (datatype.indexOf(40) > -1) {
            datatype = datatype.substring(0, datatype.indexOf(40)).trim();
        }
        for (int i = 0; i < INVALID_DATATYPES.length; ++i) {
            if (!datatype.equalsIgnoreCase(INVALID_DATATYPES[i])) continue;
            JOptionPane.showMessageDialog(this, MessageFormat.format(Messages.getString("StructuredTypePropertyDialogUDB.PropertyCantBeDatatype"), INVALID_DATATYPES[i]), Messages.getString("StructuredTypePropertyDialogUDB.Error"), 0);
            return false;
        }
        return true;
    }

    @Override
    public void initProperties() {
        StructuredType st = (StructuredType)this.structuredType.getObject();
        this.initCaption(this.structuredType.getName());
        this.tfName.setText(this.structuredType.getName());
        this.cbScheme.setSelectedItem(this.structuredType.getSchema());
        this.tfSuperType.setText(this.structuredType.hasParentType() ? this.structuredType.getParentType().getName() : Messages.getString("StructuredTypePropertyDialogUDB.NONE"));
        this.tfFinal.setText(st.isFinal() ? "YES" : "NO");
        this.tfInstantiable.setText(st.isInstantiable() ? "YES" : "NO");
        this.bnDataType.setText(this.structuredType.getDataType());
        this.bnDataType.setEnabled(this.isEditable() && st.getParentType() == null);
        this.tfRef2RefType.setText(this.structuredType.getRef2RefTypeCastFunction());
        this.tfRefType2Ref.setText(this.structuredType.getRefType2RefCastFunction());
        this.tfInlineLength.setText(this.structuredType.getInlineLength());
        this.cbWithFunctionAccess.setSelectedItem(this.structuredType.getWithFunctionAccess());
        this.getCommentsList().insert(this.structuredType.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.structuredType != null) {
            this.structuredType.setName(this.tfName.getText());
            this.tempDTO.copyDataType(this.structuredType);
            Object selected = this.cbScheme.getSelectedItem();
            if (selected instanceof SchemaUDB) {
                this.structuredType.setSchema((SchemaUDB)selected);
            } else {
                this.structuredType.setSchema(null);
                this.structuredType.setOwner(null);
            }
            this.structuredType.setRef2RefTypeCastFunction(this.tfRef2RefType.getText());
            this.structuredType.setRefType2RefCastFunction(this.tfRefType2Ref.getText());
            this.structuredType.setInlineLength(this.tfInlineLength.getText());
            this.structuredType.setWithFunctionAccess((String)this.cbWithFunctionAccess.getSelectedItem());
            this.structuredType.setComment(this.getCommentsList().getText());
        }
    }

    private class SchemeListener
    implements ActionListener {
        private SchemeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SchemaUDB schema = (SchemaUDB)StructuredTypePropertyDialogUDB.this.cbScheme.getSelectedItem();
            try {
                if (schema != null) {
                    StructuredTypePropertyDialogUDB.this.tfOwner.setText(schema.getOwner().toString());
                }
            }
            catch (NullPointerException e1) {
                StructuredTypePropertyDialogUDB.this.tfOwner.setText("");
            }
        }
    }
}

