/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserAndGroupPermissionsDialogUDB
extends CustomDialog
implements AbstractEditorConstants {
    private static final long serialVersionUID = -5507810685639529816L;
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    private static String CHECKED_WITH_GRANT_OPTION = "v->";
    protected static final String EDIT = Messages.getString("UserAndGroupPermissionsDialogUDB.Edit");
    private StorageObject storageObject;
    private TableProxySetUDB tablesSet;
    private TableViewProxySetUDB viewSet;
    private StorageDesignUDB storageDesign;
    private JButton bnCancel;
    private JTabbedPane tpane;
    private JPanel jpanel;
    private JPanel objectsPanel;
    private TableTable tablesTable;
    private ViewsTable viewsTable;
    private JDialog dialog;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            UserAndGroupPermissionsDialogUDB.this.bnCancel.doClick();
        }
    };

    public UserAndGroupPermissionsDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view);
        this.storageDesign = (StorageDesignUDB)storageDesign;
        this.storageObject = object;
        this.jpanel = new JPanel(new BorderLayout());
        this.jpanel.add((Component)this.getTabbedPane(), "Center");
        JPanel bottomPanel = new JPanel();
        if (this.isEditable()) {
            JButton bnOK = new JButton(Messages.getString("UserAndGroupPermissionsDialogUDB.OK"));
            bnOK.addActionListener(new OKAction());
            bnOK.setCursor(Cursor.getPredefinedCursor(12));
            bnOK.setMnemonic(79);
            bottomPanel.add(bnOK);
            JButton bnApply = new JButton(Messages.getString("UserAndGroupPermissionsDialogUDB.Apply"));
            bnApply.addActionListener(new ApplyAction());
            bnApply.setCursor(Cursor.getPredefinedCursor(12));
            bnApply.setMnemonic(65);
            bottomPanel.add(bnApply);
            bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        this.bnCancel = new JButton(this.isEditable() ? Messages.getString("UserAndGroupPermissionsDialogUDB.Cancel") : Messages.getString("UserAndGroupPermissionsDialogUDB.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        boolean condition = true;
        bottomPanel.add(this.bnCancel);
        this.jpanel.add((Component)bottomPanel, "South");
        this.addTabs();
        this.initProperties();
        this.add((Component)this.jpanel, "Center");
    }

    @Override
    protected boolean isEditable() {
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    protected void addTabs() {
        this.initTables();
        this.initViews();
    }

    private JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane();
            this.tpane.setPreferredSize(new Dimension(820, 320));
            this.tpane.setTabPlacement(3);
        }
        return this.tpane;
    }

    private void initTables() {
        this.tablesSet = (TableProxySetUDB)this.storageDesign.getTableProxySet();
        this.tablesTable = new TableTable();
        JScrollPane scrollpane = new JScrollPane(this.tablesTable);
        scrollpane.setPreferredSize(new Dimension(800, 320));
        scrollpane.setHorizontalScrollBar(new JScrollBar());
        scrollpane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(scrollpane);
        this.getTabbedPane().addTab(Messages.getString("UserAndGroupPermissionsDialogUDB.Tables"), this.objectsPanel);
        this.tablesTable.updateUI();
        TablesModel tableModel = (TablesModel)this.tablesTable.getModel();
        Iterator it = this.tablesSet.iterator();
        while (it.hasNext()) {
            TableProxyUDB t = (TableProxyUDB)it.next();
            String[] list = PermissionsUDB.getTablePrivilegesValues();
            Vector<Object> vect = new Vector<Object>();
            vect.addElement(t);
            for (int j = 0; j < list.length; ++j) {
                JButton button = new JButton();
                vect.addElement(button);
            }
            Object[] objects = vect.toArray();
            tableModel.addRow(objects);
        }
    }

    private void initViews() {
        this.viewSet = (TableViewProxySetUDB)this.storageDesign.getTableViewProxySet();
        this.viewsTable = new ViewsTable();
        this.viewsTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.viewsTable);
        scrollpane.setPreferredSize(new Dimension(800, 320));
        scrollpane.setHorizontalScrollBar(new JScrollBar());
        scrollpane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(scrollpane);
        this.getTabbedPane().addTab(Messages.getString("UserAndGroupPermissionsDialogUDB.Views"), this.objectsPanel);
        this.viewsTable.updateUI();
        ViewsModel tableModel = (ViewsModel)this.viewsTable.getModel();
        Iterator it = this.viewSet.iterator();
        while (it.hasNext()) {
            TableViewProxyUDB view = (TableViewProxyUDB)it.next();
            String[] list = PermissionsUDB.getViewPrivilegesValues();
            Vector<Object> vect = new Vector<Object>();
            vect.addElement(view);
            for (int j = 0; j < list.length; ++j) {
                JButton button = new JButton();
                vect.addElement(button);
            }
            Object[] objects = vect.toArray();
            tableModel.addRow(objects);
        }
    }

    private boolean hasSelectedTablePrivileges(int row) {
        for (int k = 1; k < this.tablesTable.getColumnCount(); ++k) {
            if (!(this.tablesTable.getValueAt(row, k) instanceof JButton)) continue;
            JButton button = (JButton)this.tablesTable.getValueAt(row, k);
            if (button.getText().equals(CHECKED)) {
                return true;
            }
            if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSelectedViewPrivileges(int row) {
        for (int k = 1; k < this.viewsTable.getColumnCount(); ++k) {
            if (!(this.viewsTable.getValueAt(row, k) instanceof JButton)) continue;
            JButton button = (JButton)this.viewsTable.getValueAt(row, k);
            if (button.getText().equals(CHECKED)) {
                return true;
            }
            if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
            return true;
        }
        return false;
    }

    public String getCaption() {
        return Messages.getString("UserAndGroupPermissionsDialogUDB.Permissions");
    }

    private PermissionsUDB getPermission(StorageObject user, StorageObject proxy) {
        Iterator it = this.storageDesign.getPermissionsSet().iterator();
        while (it.hasNext()) {
            PermissionsUDB perm = (PermissionsUDB)it.next();
            if (perm.getUser() != user && perm.getGroup() != user || perm.getTable() != proxy && perm.getView() != proxy) continue;
            return perm;
        }
        return null;
    }

    public void initProperties() {
        int k;
        PermissionsUDB perm;
        int i;
        for (i = 0; i < this.tablesTable.getRowCount(); ++i) {
            TableProxyUDB t = (TableProxyUDB)this.tablesTable.getValueAt(i, 0);
            perm = this.getPermission(this.storageObject, t);
            for (k = 0; k < this.tablesTable.getColumnCount(); ++k) {
                if (!(this.tablesTable.getValueAt(i, k) instanceof JButton)) continue;
                JButton button = (JButton)this.tablesTable.getValueAt(i, k);
                if (perm != null) {
                    if (perm.getPrivileges().indexOf(this.tablesTable.getColumnName(k)) > -1) {
                        button.setText(CHECKED);
                        button.updateUI();
                        continue;
                    }
                    if (perm.getPrivilegesWithGrantOption().indexOf(this.tablesTable.getColumnName(k)) > -1) {
                        button.setText(CHECKED_WITH_GRANT_OPTION);
                        button.updateUI();
                        continue;
                    }
                    button.setText(EMPTY_VALUE);
                    button.updateUI();
                    continue;
                }
                button.setText(EMPTY_VALUE);
                button.updateUI();
            }
        }
        for (i = 0; i < this.viewsTable.getRowCount(); ++i) {
            TableViewProxyUDB view = (TableViewProxyUDB)this.viewsTable.getValueAt(i, 0);
            perm = this.getPermission(this.storageObject, view);
            for (k = 0; k < this.viewsTable.getColumnCount(); ++k) {
                if (!(this.viewsTable.getValueAt(i, k) instanceof JButton)) continue;
                JButton btn = (JButton)this.viewsTable.getValueAt(i, k);
                if (perm != null) {
                    if (perm.getPrivileges().indexOf(this.viewsTable.getColumnName(k)) > -1) {
                        btn.setText(CHECKED);
                        btn.updateUI();
                        continue;
                    }
                    if (perm.getPrivilegesWithGrantOption().indexOf(this.viewsTable.getColumnName(k)) > -1) {
                        btn.setText(CHECKED_WITH_GRANT_OPTION);
                        btn.updateUI();
                        continue;
                    }
                    btn.setText(EMPTY_VALUE);
                    btn.updateUI();
                    continue;
                }
                btn.setText(EMPTY_VALUE);
                btn.updateUI();
            }
        }
    }

    protected void setProperties() {
        JButton button;
        int k;
        PermissionsUDB perm;
        int i;
        for (i = 0; i < this.tablesTable.getRowCount(); ++i) {
            TableProxyUDB t = (TableProxyUDB)this.tablesTable.getValueAt(i, 0);
            perm = this.getPermission(this.storageObject, t);
            if (this.hasSelectedTablePrivileges(i)) {
                if (perm == null) {
                    perm = this.storageDesign.getPermissionsSet().createPermissions();
                    perm.setTable(t);
                    if (this.storageObject instanceof OwnerUDB) {
                        perm.setUser((OwnerUDB)this.storageObject);
                    } else if (this.storageObject instanceof UserGroupUDB) {
                        perm.setGroup((UserGroupUDB)this.storageObject);
                    }
                }
                perm.clear();
                for (k = 0; k < this.tablesTable.getColumnCount(); ++k) {
                    if (!(this.tablesTable.getValueAt(i, k) instanceof JButton)) continue;
                    button = (JButton)this.tablesTable.getValueAt(i, k);
                    if (button.getText().equals(CHECKED)) {
                        perm.setPrivileges(this.tablesTable.getColumnName(k));
                        continue;
                    }
                    if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                    perm.setPrivilegesWithGrantOption(this.tablesTable.getColumnName(k));
                }
                continue;
            }
            if (perm == null) continue;
            this.storageDesign.getPermissionsSet().remove(perm);
        }
        for (i = 0; i < this.viewsTable.getRowCount(); ++i) {
            TableViewProxyUDB view = (TableViewProxyUDB)this.viewsTable.getValueAt(i, 0);
            perm = this.getPermission(this.storageObject, view);
            if (this.hasSelectedViewPrivileges(i)) {
                if (perm == null) {
                    perm = this.storageDesign.getPermissionsSet().createPermissions();
                    perm.setView(view);
                    if (this.storageObject instanceof OwnerUDB) {
                        perm.setUser((OwnerUDB)this.storageObject);
                    } else if (this.storageObject instanceof UserGroupUDB) {
                        perm.setGroup((UserGroupUDB)this.storageObject);
                    }
                }
                perm.clear();
                for (k = 0; k < this.viewsTable.getColumnCount(); ++k) {
                    if (!(this.viewsTable.getValueAt(i, k) instanceof JButton)) continue;
                    button = (JButton)this.viewsTable.getValueAt(i, k);
                    if (button.getText().equals(CHECKED)) {
                        perm.setPrivileges(this.viewsTable.getColumnName(k));
                        continue;
                    }
                    if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                    perm.setPrivilegesWithGrantOption(this.viewsTable.getColumnName(k));
                }
                continue;
            }
            if (perm == null) continue;
            this.storageDesign.getPermissionsSet().remove(perm);
        }
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("UserAndGroupPermissionsDialogUDB.Permissions"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    class ButtonTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                JButton currentButton = (JButton)e.getSource();
                if (currentButton.getText() == null) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(CHECKED)) {
                    currentButton.setText(CHECKED_WITH_GRANT_OPTION);
                } else if (currentButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(EMPTY_VALUE)) {
                    currentButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button = (JButton)value;
            this.button.setOpaque(true);
            this.button.setBackground(table.getBackground());
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            return this.button;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setText(value == null ? "" : "  " + ((JButton)value).getText());
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setHorizontalAlignment(2);
            this.setText(value == null ? "" : "  " + value.toString());
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserAndGroupPermissionsDialogUDB.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserAndGroupPermissionsDialogUDB.this.setProperties();
            UserAndGroupPermissionsDialogUDB.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserAndGroupPermissionsDialogUDB.this.setProperties();
            UserAndGroupPermissionsDialogUDB.this.storageObject.setDirty(true);
            UserAndGroupPermissionsDialogUDB.this.close();
        }
    }

    public class ViewsModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return PermissionsUDB.getViewPrivilegesValues().length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            String[] perms = PermissionsUDB.getViewPrivilegesValues();
            if (column == 0) {
                return Messages.getString("UserAndGroupPermissionsDialogUDB.View");
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (column != i) continue;
                return perms[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!UserAndGroupPermissionsDialogUDB.this.isEditable()) {
                return false;
            }
            return columnIndex > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class ViewsTable
    extends JTable {
        ViewsModel dataModel;

        public ViewsTable() {
            this.dataModel = new ViewsModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    class TableTable
    extends JTable {
        TablesModel dataModel;

        public TableTable() {
            this.dataModel = new TablesModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    public class TablesModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return PermissionsUDB.getTablePrivilegesValues().length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            String[] perms = PermissionsUDB.getTablePrivilegesValues();
            if (column == 0) {
                return Messages.getString("UserAndGroupPermissionsDialogUDB.Table");
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (column != i) continue;
                return perms[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!UserAndGroupPermissionsDialogUDB.this.isEditable()) {
                return false;
            }
            return columnIndex > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

