/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.viewbuilder;

import com.adbs.ast.AstToken;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataRelation;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.ast.ParsingException;
import com.adbs.ast.SQLExpressionColumn;
import com.adbs.ast.SQLExpressionOperatorBinary;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.querybuilder.CriteriaItem;
import com.adbs.querybuilder.CriteriaList;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.PlainTextSQLBuilder;
import com.adbs.querybuilder.QueryBase;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.StatisticsOutputColumn;
import com.adbs.querybuilder.StatisticsOutputColumnList;
import com.adbs.querybuilder.SubQuery;
import com.adbs.querybuilder.UnionGroup;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.DB2SyntaxProvider;
import com.adbs.syntax.FirebirdSyntaxProvider;
import com.adbs.syntax.InformixSyntaxProvider;
import com.adbs.syntax.MSSQLServerVersion;
import com.adbs.syntax.MSSQLSyntaxProvider;
import com.adbs.syntax.MySQLSyntaxProvider;
import com.adbs.syntax.OracleServerVersion;
import com.adbs.syntax.OracleSyntaxProvider;
import com.adbs.syntax.PostgreSQLSyntaxProvider;
import com.adbs.syntax.SQLiteSyntaxProvider;
import com.adbs.syntax.SybaseSyntaxProvider;
import com.adbs.utils.Helpers;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.viewbuilder.DSHelper;
import oracle.dbtools.crest.swingui.editor.viewbuilder.DeletedMetadataObject;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QueryHelper;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.string.DMSQLFormatter;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class QBUtils {
    private static List deletedSQLNames;
    private static List dsPositions;
    public static boolean isIncorrectSQL;
    public static String incorrectSQL;
    private static RSyntaxTextArea jTextPane;
    private static List deletedMDObjects;
    private static Map metadataObjectsMap;
    public static final Map<String, BaseSyntaxProvider> SYNTAX_PROVIDERS;
    private static String previousSyntaxProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initMetadata(DesignPart model, QueryBuilder queryBuilder, PlainTextSQLBuilder plainTextSQLBuilder, boolean useFKeys) {
        OracleSyntaxProvider sp;
        isIncorrectSQL = false;
        queryBuilder.setOfflineMode(true);
        queryBuilder.setMetadataProvider(null);
        MetadataContainer metadataContainer = queryBuilder.getMetadataContainer();
        metadataContainer.beginUpdate();
        RDBMSType rdbmsType = model instanceof LogicalDesign ? model.getDesign().getRDBMSSiteSet().getDefaultRDBMSSite(model.getAppView().getSettings()).getType() : model.getSelectedRDBMSType();
        if (StorageDesignOraclev9i.RDBMS_TYPE == rdbmsType) {
            sp = new OracleSyntaxProvider();
            sp.setServerVersion(OracleServerVersion.Oracle9);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        } else if (StorageDesignOraclev10g.RDBMS_TYPE == rdbmsType) {
            sp = new OracleSyntaxProvider();
            sp.setServerVersion(OracleServerVersion.Oracle10);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        } else if (StorageDesignOraclev11g.RDBMS_TYPE == rdbmsType || StorageDesignOraclev12c.RDBMS_TYPE == rdbmsType) {
            sp = new OracleSyntaxProvider();
            sp.setServerVersion(OracleServerVersion.Oracle11);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        } else if (StorageDesignSqlServerv2k.RDBMS_TYPE == rdbmsType) {
            sp = new MSSQLSyntaxProvider();
            sp.setServerVersion(MSSQLServerVersion.MSSQL2000);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        } else if (StorageDesignSqlServerv2k5.RDBMS_TYPE == rdbmsType || StorageDesignSqlServerv2k8.RDBMS_TYPE == rdbmsType) {
            sp = new MSSQLSyntaxProvider();
            sp.setServerVersion(MSSQLServerVersion.MSSQL2005);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        } else if (StorageDesignDB2v70.RDBMS_TYPE == rdbmsType || StorageDesignDB2v80.RDBMS_TYPE == rdbmsType) {
            sp = new DB2SyntaxProvider();
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        } else if (StorageDesignUDBv71.RDBMS_TYPE == rdbmsType || StorageDesignUDBv81.RDBMS_TYPE == rdbmsType || StorageDesignUDBv9.RDBMS_TYPE == rdbmsType) {
            sp = new DB2SyntaxProvider();
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        }
        try {
            if (model instanceof LogicalDesign) {
                LogicalDesign logicalModel = (LogicalDesign)model;
                Iterator it = logicalModel.getEntitySet().iterator();
                while (it.hasNext()) {
                    Entity entity = (Entity)it.next();
                    QBUtils.addEntityToMetadata(entity, metadataContainer, null, logicalModel, false, false, useFKeys);
                }
                Iterator tvit = logicalModel.getEntityViewSet().iterator();
                while (tvit.hasNext()) {
                    EntityView enView = (EntityView)tvit.next();
                    QBUtils.addViewToMetadata(enView, metadataContainer, null, null, false, false);
                }
            } else {
                RelationalDesign relModel = (RelationalDesign)model;
                Iterator it = relModel.getTableSet().iterator();
                while (it.hasNext()) {
                    Table table = (Table)it.next();
                    QBUtils.addTableToMetadata(table, metadataContainer, null, relModel, false, false, useFKeys);
                }
                Iterator tvit = relModel.getTableViewSet().iterator();
                while (tvit.hasNext()) {
                    TableView tbView = (TableView)tvit.next();
                    QBUtils.addViewToMetadata(tbView, metadataContainer, null, null, false, false);
                }
            }
            plainTextSQLBuilder.setUseAltNames(false);
        }
        catch (Exception ex) {
        }
        finally {
            metadataContainer.endUpdate();
        }
    }

    public static void initSQL(AbstractView view, QueryBuilder queryBuilder) {
        int ind;
        if (!previousSyntaxProvider.equalsIgnoreCase(view.getSyntaxProvider())) {
            queryBuilder.setSyntaxProvider(SYNTAX_PROVIDERS.get(view.getSyntaxProvider()));
            previousSyntaxProvider = view.getSyntaxProvider();
        }
        isIncorrectSQL = false;
        if (view.getSchemaObject() != null) {
            queryBuilder.getMetadataContainer().setDefaultSchemaNamesStr(view.getSchemaObject().getName());
        } else {
            queryBuilder.getMetadataContainer().getDefaultSchemaNames().clear();
        }
        String sql = view.getUserDefinedSQL();
        String vdef_up = sql.toUpperCase();
        int indw = vdef_up.indexOf("WITH READ ONLY");
        String vend = "";
        if (indw > -1) {
            vend = sql.substring(indw);
            sql = sql.substring(0, indw);
        } else {
            indw = vdef_up.indexOf("WITH CHECK OPTION");
            if (indw > -1) {
                vend = sql.substring(indw);
                sql = sql.substring(0, indw);
            }
        }
        String sqlu = sql.toUpperCase();
        if (sqlu.indexOf("CREATE") > -1 && (ind = sqlu.indexOf("SELECT")) > 0) {
            char ch = sqlu.charAt(ind - 1);
            if (ch != ' ' && (ch < '\t' || ch > '\r')) {
                ind = sqlu.indexOf("SELECT", ind + 1);
            }
            sql = sql.substring(ind);
        }
        QBUtils.setSQL(queryBuilder, sql, true);
    }

    public static void initProperties(AbstractView view, QueryBuilder queryBuilder, PlainTextSQLBuilder plainTextSQLBuilder, RSyntaxTextArea tp, DesignPartView usedDPV, boolean includeSchema, boolean useFKeys) {
        OracleSyntaxProvider sp;
        long time = System.currentTimeMillis();
        boolean isLogicalView = view instanceof EntityView;
        isIncorrectSQL = false;
        jTextPane = tp;
        deletedSQLNames = view.getDeletedSQLNames();
        deletedMDObjects.clear();
        metadataObjectsMap.clear();
        MetadataContainer metadataContainer = queryBuilder.getMetadataContainer();
        System.out.println("init setOfflineMode  " + System.currentTimeMillis());
        queryBuilder.setOfflineMode(true);
        System.out.println("init setMetadataProvider(null)  " + System.currentTimeMillis());
        queryBuilder.setMetadataProvider(null);
        int mb = 0x100000;
        Runtime runtime = Runtime.getRuntime();
        System.out.println("memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
        System.out.println("init setDefaultSchemaNamesStr  " + System.currentTimeMillis());
        if (view.getSchemaObject() != null) {
            metadataContainer.setDefaultSchemaNamesStr(view.getSchemaObject().getName());
        }
        System.out.println("init setSyntaxProvider  " + System.currentTimeMillis());
        RDBMSType rdbmsType = isLogicalView ? view.getDesign().getRDBMSSiteSet().getDefaultRDBMSSite(view.getAppView().getSettings()).getType() : view.getDesignPart().getSelectedRDBMSType();
        if (!"".equalsIgnoreCase(view.getSyntaxProvider())) {
            queryBuilder.setSyntaxProvider(SYNTAX_PROVIDERS.get(view.getSyntaxProvider()));
        } else if (StorageDesignOraclev9i.RDBMS_TYPE == rdbmsType) {
            sp = new OracleSyntaxProvider();
            sp.setServerVersion(OracleServerVersion.Oracle9);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        } else if (StorageDesignOraclev10g.RDBMS_TYPE == rdbmsType) {
            sp = new OracleSyntaxProvider();
            sp.setServerVersion(OracleServerVersion.Oracle10);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        } else if (StorageDesignOraclev11g.RDBMS_TYPE == rdbmsType || StorageDesignOraclev12c.RDBMS_TYPE == rdbmsType) {
            sp = new OracleSyntaxProvider();
            sp.setServerVersion(OracleServerVersion.Oracle11);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        } else if (StorageDesignSqlServerv2k.RDBMS_TYPE == rdbmsType) {
            sp = new MSSQLSyntaxProvider();
            sp.setServerVersion(MSSQLServerVersion.MSSQL2000);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        } else if (StorageDesignSqlServerv2k5.RDBMS_TYPE == rdbmsType || StorageDesignSqlServerv2k8.RDBMS_TYPE == rdbmsType) {
            sp = new MSSQLSyntaxProvider();
            sp.setServerVersion(MSSQLServerVersion.MSSQL2005);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        } else if (StorageDesignDB2v70.RDBMS_TYPE == rdbmsType || StorageDesignDB2v80.RDBMS_TYPE == rdbmsType) {
            sp = new DB2SyntaxProvider();
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        } else if (StorageDesignUDBv71.RDBMS_TYPE == rdbmsType || StorageDesignUDBv81.RDBMS_TYPE == rdbmsType || StorageDesignUDBv9.RDBMS_TYPE == rdbmsType) {
            sp = new DB2SyntaxProvider();
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        }
        System.out.println("end setSyntaxProvider  " + System.currentTimeMillis());
        try {
            TableView tbView;
            EntityView enView;
            boolean useAltNames;
            Map map = QBUtils.getSQLNamesMap(view);
            LogicalDesign logicalModel = null;
            RelationalDesign relModel = null;
            if (isLogicalView) {
                logicalModel = (LogicalDesign)view.getDesignPart();
            } else {
                relModel = (RelationalDesign)view.getDesignPart();
            }
            System.out.println("init Tables  " + System.currentTimeMillis());
            System.out.println("memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
            metadataContainer.beginUpdate();
            boolean bl = useAltNames = !view.isValidSQL();
            if (view.getSQLNames().size() == 0 || tp != null) {
                Iterator tvit;
                Iterator it;
                if (usedDPV != null) {
                    EntityView enView2;
                    Entity entity;
                    TableView tbView2;
                    Table table;
                    List topViews = usedDPV.getTopviewsList();
                    ArrayList<String> added = new ArrayList<String>();
                    for (TopView tv : topViews) {
                        if (tv.getModel() instanceof Table) {
                            table = (Table)tv.getModel();
                            if (added.contains(table.getObjectID())) continue;
                            QBUtils.addTableToMetadata(table, metadataContainer, map, relModel, useAltNames, includeSchema, useFKeys);
                            added.add(table.getObjectID());
                            continue;
                        }
                        if (tv.getModel() instanceof TableView) {
                            tbView2 = (TableView)tv.getModel();
                            if (added.contains(tbView2.getObjectID())) continue;
                            QBUtils.addViewToMetadata(tbView2, metadataContainer, map, view, useAltNames, includeSchema);
                            added.add(tbView2.getObjectID());
                            continue;
                        }
                        if (tv.getModel() instanceof Entity) {
                            entity = (Entity)tv.getModel();
                            if (added.contains(entity.getObjectID())) continue;
                            QBUtils.addEntityToMetadata(entity, metadataContainer, map, logicalModel, useAltNames, includeSchema, useFKeys);
                            added.add(entity.getObjectID());
                            continue;
                        }
                        if (!(tv.getModel() instanceof EntityView) || added.contains((enView2 = (EntityView)tv.getModel()).getObjectID())) continue;
                        QBUtils.addViewToMetadata(enView2, metadataContainer, map, view, useAltNames, false);
                        added.add(enView2.getObjectID());
                    }
                    for (SQLNameHelper helper : view.getSQLNames()) {
                        if (!helper.isContainer() || added.contains(helper.getID())) continue;
                        if (helper.isView()) {
                            if (isLogicalView) {
                                enView2 = (EntityView)logicalModel.getEntityViewSet().getObjectByID(helper.getID());
                                if (enView2 == null) continue;
                                QBUtils.addViewToMetadata(enView2, metadataContainer, map, view, useAltNames, includeSchema);
                                continue;
                            }
                            tbView2 = (TableView)relModel.getTableViewSet().getObjectByID(helper.getID());
                            if (tbView2 == null) continue;
                            QBUtils.addViewToMetadata(tbView2, metadataContainer, map, view, useAltNames, includeSchema);
                            continue;
                        }
                        if (isLogicalView) {
                            entity = (Entity)logicalModel.getEntitySet().getObjectByID(helper.getID());
                            if (entity == null) continue;
                            QBUtils.addEntityToMetadata(entity, metadataContainer, map, logicalModel, useAltNames, includeSchema, useFKeys);
                            continue;
                        }
                        table = (Table)relModel.getTableSet().getObjectByID(helper.getID());
                        if (table == null) continue;
                        QBUtils.addTableToMetadata(table, metadataContainer, map, relModel, useAltNames, includeSchema, useFKeys);
                    }
                } else if (isLogicalView) {
                    it = logicalModel.getEntitySet().iterator();
                    while (it.hasNext()) {
                        Entity entity = (Entity)it.next();
                        QBUtils.addEntityToMetadata(entity, metadataContainer, map, logicalModel, useAltNames, includeSchema, useFKeys);
                    }
                    System.out.println("init Views  " + System.currentTimeMillis());
                    System.out.println("memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
                    tvit = logicalModel.getEntityViewSet().iterator();
                    while (tvit.hasNext()) {
                        enView = (EntityView)tvit.next();
                        QBUtils.addViewToMetadata(enView, metadataContainer, map, view, useAltNames, includeSchema);
                    }
                } else {
                    it = relModel.getTableSet().iterator();
                    while (it.hasNext()) {
                        Table table = (Table)it.next();
                        QBUtils.addTableToMetadata(table, metadataContainer, map, relModel, useAltNames, includeSchema, useFKeys);
                    }
                    System.out.println("init Views  " + System.currentTimeMillis());
                    System.out.println("memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
                    tvit = relModel.getTableViewSet().iterator();
                    while (tvit.hasNext()) {
                        tbView = (TableView)tvit.next();
                        QBUtils.addViewToMetadata(tbView, metadataContainer, map, view, useAltNames, includeSchema);
                    }
                }
            } else {
                for (SQLNameHelper helper : view.getSQLNames()) {
                    if (!helper.isContainer()) continue;
                    if (helper.isView()) {
                        if (isLogicalView) {
                            enView = (EntityView)logicalModel.getEntityViewSet().getObjectByID(helper.getID());
                            if (enView == null) continue;
                            QBUtils.addViewToMetadata(enView, metadataContainer, map, view, useAltNames, includeSchema);
                            continue;
                        }
                        tbView = (TableView)relModel.getTableViewSet().getObjectByID(helper.getID());
                        if (tbView == null) continue;
                        QBUtils.addViewToMetadata(tbView, metadataContainer, map, view, useAltNames, includeSchema);
                        continue;
                    }
                    if (isLogicalView) {
                        Entity entity = (Entity)logicalModel.getEntitySet().getObjectByID(helper.getID());
                        if (entity == null) continue;
                        QBUtils.addEntityToMetadata(entity, metadataContainer, map, logicalModel, useAltNames, includeSchema, useFKeys);
                        continue;
                    }
                    Table table = (Table)relModel.getTableSet().getObjectByID(helper.getID());
                    if (table == null) continue;
                    QBUtils.addTableToMetadata(table, metadataContainer, map, relModel, useAltNames, includeSchema, useFKeys);
                }
            }
            if (useAltNames) {
                System.out.println("init Deleted tables  " + System.currentTimeMillis());
                System.out.println("memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
                for (SQLNameHelper helper : QBUtils.getDeletedContainersOnly()) {
                    Object mo = helper.getSchema() != null && helper.getSchema().length() > 0 ? (helper.isView() ? metadataContainer.addView(helper.getSchema(), helper.getTableName(), false, null) : metadataContainer.addTable(helper.getSchema(), helper.getTableName(), false, null)) : (helper.isView() ? metadataContainer.addView(null, helper.getTableName(), false, null) : metadataContainer.addTable(null, helper.getTableName(), false, null));
                    mo.setAltName(mo.getFullNameStrNotQuoted());
                    mo.setShortDescription(helper.getID());
                    DeletedMetadataObject dmdo = new DeletedMetadataObject((MetadataObject)mo);
                    deletedMDObjects.add(dmdo);
                }
                System.out.println("init Deleted columns  " + System.currentTimeMillis());
                for (SQLNameHelper helper : QBUtils.getDeletedColumnsOnly()) {
                    MetadataObject mo;
                    String fullName = helper.getTableName();
                    if (helper.getSchema() != null && helper.getSchema().length() > 0) {
                        fullName = helper.getSchema() + "." + helper.getTableName();
                    }
                    if ((mo = metadataContainer.findObjectByFullName(fullName)) == null) continue;
                    MetadataField mf = mo.getFields().addField(helper.getColumnName());
                    mf.setAltName(helper.getColumnName());
                    mf.setShortDescription(helper.getID());
                    DeletedMetadataObject dmdo = new DeletedMetadataObject(mo, mf);
                    deletedMDObjects.add(dmdo);
                }
                System.out.println("init Deleted columns End " + System.currentTimeMillis());
            }
            metadataContainer.endUpdate();
            String sql = view.getUserDefinedSQL();
            if (!view.getUserDefined()) {
                sql = view.generateSQL();
            }
            String vdef_up = sql.toUpperCase();
            int indw = vdef_up.indexOf("WITH READ ONLY");
            String vend = "";
            if (indw > -1) {
                vend = sql.substring(indw);
                sql = sql.substring(0, indw);
            } else {
                indw = vdef_up.indexOf("WITH CHECK OPTION");
                if (indw > -1) {
                    vend = sql.substring(indw);
                    sql = sql.substring(0, indw);
                }
            }
            sql = QBUtils.getSQL(sql);
            System.out.println("memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
            String layout = QBUtils.semiEncodeText(view.getLayoutSQL());
            if (layout != null && layout.length() > 0) {
                QBUtils.parseDSPositions(layout);
                long l = System.currentTimeMillis();
                queryBuilder.setLayoutSQL(layout);
                System.out.println("Total setLayoutSQL: " + (System.currentTimeMillis() - l));
            } else {
                if (jTextPane != null) {
                    jTextPane.setText(sql);
                }
                QBUtils.setSQL(queryBuilder, sql, true);
            }
            QBUtils.saveDSPositions(queryBuilder);
            if (useAltNames) {
                plainTextSQLBuilder.setUseAltNames(true);
            }
            System.out.println("memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        System.out.println("Total initProperties Time: " + (System.currentTimeMillis() - time));
    }

    private static void addTableToMetadata(Table table, MetadataContainer metadataContainer, Map map, RelationalDesign relDesign, boolean useAltNames, boolean includeSchema, boolean useFKeys) {
        String schemaName;
        StorageDesign sd = table.getRelationalModel().getStorageDesign();
        MetadataTable moTable = null;
        SQLNameHelper helper = null;
        if (map != null) {
            helper = (SQLNameHelper)map.get(table.getObjectID());
        }
        String tbName = table.getName();
        if (helper != null) {
            tbName = helper.getTableName();
        }
        if (table.getSchemaObject() != null) {
            schemaName = table.getSchemaObject().getName();
            if (helper != null) {
                schemaName = helper.getSchema();
            }
            moTable = metadataContainer.addTable(schemaName, tbName, false, null);
        } else {
            schemaName = null;
            if (helper != null) {
                schemaName = helper.getSchema();
            }
            moTable = schemaName != null && schemaName.length() > 0 ? metadataContainer.addTable(schemaName, tbName, false, null) : metadataContainer.addTable(null, tbName, false, null);
        }
        moTable.beginUpdate();
        boolean quoted = sd.isNameShouildBeQuoted(table);
        if (useAltNames || includeSchema) {
            moTable.setAltName(moTable.getFullNameStrNotQuoted());
            moTable.setAltNameCaseSensitive(quoted);
        }
        moTable.setShortDescription(table.getObjectID());
        moTable.setLongDescription(table.getCommentInRDBMS());
        moTable.endUpdate();
        ContainedObject[] columns = table.getElementsAndNestedElements();
        if (columns.length > 0) {
            MetadataFieldList fieldList = moTable.getFields();
            fieldList.beginUpdate();
            for (int i = 0; i < columns.length; ++i) {
                Column col = (Column)columns[i];
                SQLNameHelper ch = null;
                if (map != null) {
                    ch = (SQLNameHelper)map.get(col.getObjectID());
                }
                String colName = col.getName();
                if (ch != null) {
                    colName = ch.getColumnName();
                }
                MetadataField mf = fieldList.add();
                mf.beginUpdate();
                SQLQualifiedName qualName = mf.getName();
                if (col.isNested()) {
                    int dotIndex = colName.indexOf(46);
                    while (dotIndex > -1) {
                        qualName.addName(colName.substring(0, dotIndex));
                        colName = colName.substring(dotIndex + 1);
                        dotIndex = colName.indexOf(46);
                    }
                }
                qualName.addName(colName);
                quoted = sd.isNameShouildBeQuoted(col);
                if (quoted) {
                    for (int k = 0; k < qualName.getCount(); ++k) {
                        AstToken astToken = qualName.get(k);
                        ((AstTokenIdentifier)astToken).setCaseSensitive(true);
                    }
                }
                if (useAltNames) {
                    String fname = col.getName();
                    mf.setAltName(fname);
                    qualName = mf.getName();
                    if (quoted) {
                        mf.setAltNameCaseSensitive(true);
                    }
                }
                mf.setShortDescription(col.getObjectID());
                if (col.isPKElement()) {
                    mf.setPrimaryKey(true);
                }
                mf.endUpdate();
            }
            fieldList.endUpdate();
        }
        if (useFKeys) {
            MetadataRelation mr = null;
            Iterator itf = relDesign.getFKIndexAssociationSet().getAssociationsWith(table).iterator();
            while (itf.hasNext()) {
                mr = moTable.getRelations().add();
                mr.beginUpdate();
                FKIndexAssociation fk = (FKIndexAssociation)itf.next();
                ContainedObject[] cols = fk.getRemoteIndex().getElements();
                for (int i = 0; i < cols.length; ++i) {
                    Column col = (Column)cols[i];
                    SQLNameHelper ch = null;
                    if (map != null) {
                        ch = (SQLNameHelper)map.get(col.getObjectID());
                    }
                    String colName = col.getName();
                    if (ch != null) {
                        colName = ch.getColumnName();
                    }
                    mr.getKeyFields().add(colName);
                }
                Table t = fk.getTable();
                SQLNameHelper th = null;
                if (map != null) {
                    th = (SQLNameHelper)map.get(t.getObjectID());
                }
                if (t.getSchemaObject() != null) {
                    String schemaName2 = t.getSchemaObject().getName();
                    if (th != null) {
                        schemaName2 = th.getSchema();
                    }
                    mr.setChildSchemaStr(schemaName2);
                }
                mr.setChildNameStr(t.getName());
                cols = fk.getLocalFKIndex().getElements();
                for (int i = 0; i < cols.length; ++i) {
                    Column col = (Column)cols[i];
                    SQLNameHelper ch = null;
                    if (map != null) {
                        ch = (SQLNameHelper)map.get(col.getObjectID());
                    }
                    String colName = col.getName();
                    if (ch != null) {
                        colName = ch.getColumnName();
                    }
                    mr.getChildFields().add(colName);
                }
                mr.endUpdate();
            }
        }
        metadataObjectsMap.put(table.getObjectID(), moTable);
    }

    private static void addEntityToMetadata(Entity entity, MetadataContainer metadataContainer, Map map, LogicalDesign logicalDesign, boolean useAltNames, boolean includeSchema, boolean useFKeys) {
        String tname;
        String schemaName;
        MetadataTable moTable = null;
        SQLNameHelper helper = null;
        if (map != null) {
            helper = (SQLNameHelper)map.get(entity.getObjectID());
        }
        String tbName = entity.getName();
        if (helper != null) {
            tbName = helper.getTableName();
        }
        if (entity.getSchemaObject() != null) {
            schemaName = entity.getSchemaObject().getName();
            if (helper != null) {
                schemaName = helper.getSchema();
            }
            moTable = metadataContainer.addTable(schemaName, tbName, false, null);
        } else {
            schemaName = null;
            if (helper != null) {
                schemaName = helper.getSchema();
            }
            moTable = schemaName != null && schemaName.length() > 0 ? metadataContainer.addTable(schemaName, tbName, false, null) : metadataContainer.addTable(null, tbName, false, null);
        }
        moTable.beginUpdate();
        if (useAltNames && !(tname = entity.getName()).equals(moTable.getNameStrNotQuoted())) {
            moTable.setAltName(moTable.getFullNameStrNotQuoted());
        }
        moTable.setShortDescription(entity.getObjectID());
        moTable.setLongDescription(entity.getCommentInRDBMS());
        moTable.endUpdate();
        ContainedObject[] columns = entity.getElementsAndNestedElements();
        if (columns.length > 0) {
            MetadataFieldList fieldList = moTable.getFields();
            fieldList.beginUpdate();
            for (int i = 0; i < columns.length; ++i) {
                String fname;
                ContainedObject col = columns[i];
                SQLNameHelper ch = null;
                if (map != null) {
                    ch = (SQLNameHelper)map.get(col.getObjectID());
                }
                String colName = col.getName();
                if (ch != null) {
                    colName = ch.getColumnName();
                }
                MetadataField mf = fieldList.add();
                mf.beginUpdate();
                mf.getName().addName(colName);
                if (useAltNames && !(fname = col.getName()).equals(mf.getNameStrNotQuoted())) {
                    mf.setAltName(fname);
                }
                mf.setShortDescription(col.getObjectID());
                mf.endUpdate();
            }
            fieldList.endUpdate();
        }
        if (useFKeys) {
            MetadataRelation mr = null;
            Iterator itf = logicalDesign.getRelationSet().getRelationsToSource(entity).iterator();
            while (itf.hasNext()) {
                mr = moTable.getRelations().add();
                mr.beginUpdate();
                Relation fk = (Relation)itf.next();
                Attribute[] cols = fk.getFKAttributes(fk.getTargetEntity());
                for (int i = 0; i < cols.length; ++i) {
                    Attribute fkAttribute = cols[i];
                    ContainedObject col = ((ContainedObject)fkAttribute).getDelegateElement();
                    if (col == null) continue;
                    SQLNameHelper ch = null;
                    if (map != null) {
                        ch = (SQLNameHelper)map.get(col.getObjectID());
                    }
                    String colName = col.getName();
                    if (ch != null) {
                        colName = ch.getColumnName();
                    }
                    mr.getKeyFields().add(colName);
                }
                Entity t = fk.getTargetEntity();
                SQLNameHelper th = null;
                if (map != null) {
                    th = (SQLNameHelper)map.get(t.getObjectID());
                }
                if (t.getSchemaObject() != null) {
                    String schemaName2 = t.getSchemaObject().getName();
                    if (th != null) {
                        schemaName2 = th.getSchema();
                    }
                    mr.setChildSchemaStr(schemaName2);
                }
                mr.setChildNameStr(t.getName());
                cols = fk.getFKAttributes(t);
                for (int i = 0; i < cols.length; ++i) {
                    Attribute col = cols[i];
                    SQLNameHelper ch = null;
                    if (map != null) {
                        ch = (SQLNameHelper)map.get(col.getObjectID());
                    }
                    String colName = col.getName();
                    if (ch != null) {
                        colName = ch.getColumnName();
                    }
                    mr.getChildFields().add(colName);
                }
                mr.endUpdate();
            }
        }
        metadataObjectsMap.put(entity.getObjectID(), moTable);
    }

    private static void addViewToMetadata(AbstractView tbView, MetadataContainer metadataContainer, Map map, AbstractView view, boolean useAltNames, boolean includeSchema) {
        if (tbView != view) {
            MetadataView moView;
            String schemaName;
            SQLNameHelper helper = null;
            if (map != null) {
                helper = (SQLNameHelper)map.get(tbView.getObjectID());
            }
            String tbName = tbView.getName();
            if (helper != null) {
                tbName = helper.getTableName();
            }
            if (tbView.getSchemaObject() != null) {
                schemaName = tbView.getSchemaObject().getName();
                if (helper != null) {
                    schemaName = helper.getSchema();
                }
                moView = metadataContainer.addView(schemaName, tbName, false, null);
            } else {
                schemaName = null;
                if (helper != null) {
                    schemaName = helper.getSchema();
                }
                moView = schemaName != null && schemaName.length() > 0 ? metadataContainer.addView(schemaName, tbName, false, null) : metadataContainer.addView(null, tbName, false, null);
            }
            moView.beginUpdate();
            if (useAltNames || includeSchema) {
                moView.setAltName(moView.getFullNameStrNotQuoted());
            }
            moView.setShortDescription(tbView.getObjectID());
            moView.endUpdate();
            boolean hasHeader = tbView.hasValidHeader();
            ContainedObject[] columns = tbView.getElementsAndNestedElements();
            if (columns.length > 0) {
                MetadataFieldList fieldList = moView.getFields();
                fieldList.beginUpdate();
                for (int i = 0; i < columns.length; ++i) {
                    ContainedObject col = columns[i];
                    SQLNameHelper ch = null;
                    if (map != null) {
                        ch = (SQLNameHelper)map.get(col.getObjectID());
                    }
                    String colName = col.getName();
                    if (col instanceof AbstractViewElement) {
                        colName = ((AbstractViewElement)col).getPresentationName(hasHeader);
                    }
                    if (ch != null) {
                        colName = ch.getColumnName();
                    }
                    MetadataField mf = fieldList.add();
                    mf.beginUpdate();
                    mf.getName().addName(colName);
                    if (useAltNames) {
                        mf.setAltName(colName);
                    }
                    mf.setShortDescription(col.getObjectID());
                    mf.beginUpdate();
                }
                fieldList.endUpdate();
            }
            metadataObjectsMap.put(tbView.getObjectID(), moView);
        }
    }

    private static Map getSQLNamesMap(AbstractView view) {
        TreeMap<String, SQLNameHelper> map = new TreeMap<String, SQLNameHelper>();
        for (SQLNameHelper helper : view.getSQLNames()) {
            map.put(helper.getID(), helper);
        }
        return map;
    }

    private static List getDeletedContainersOnly() {
        ArrayList<SQLNameHelper> list = new ArrayList<SQLNameHelper>();
        for (SQLNameHelper helper : deletedSQLNames) {
            if (!helper.isContainer()) continue;
            list.add(helper);
        }
        return list;
    }

    private static List getDeletedColumnsOnly() {
        ArrayList<SQLNameHelper> list = new ArrayList<SQLNameHelper>();
        for (SQLNameHelper helper : deletedSQLNames) {
            if (helper.isContainer()) continue;
            list.add(helper);
        }
        return list;
    }

    public static void setIncludeSchema(AbstractView view, QueryBuilder queryBuilder, PlainTextSQLBuilder plainTextSQLBuilder, boolean includeSchema) {
        if (includeSchema) {
            MetadataContainer metadataContainer = queryBuilder.getMetadataContainer();
            String sql = plainTextSQLBuilder.getSQL();
            if (!includeSchema) {
                if (view.getSchemaObject() != null) {
                    metadataContainer.setDefaultSchemaNamesStr(view.getSchemaObject().getName());
                }
            } else {
                metadataContainer.getDefaultSchemaNames().clear();
            }
            plainTextSQLBuilder.setUseAltNames(false);
            queryBuilder.setUseAltNames(false);
            QBUtils.setSQL(queryBuilder, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMetadata(AbstractView view, QueryBuilder queryBuilder, PlainTextSQLBuilder plainTextSQLBuilder, boolean includeSchema) {
        if (!isIncorrectSQL) {
            StorageDesign sd = null;
            if (view instanceof TableView) {
                sd = ((RelationalDesign)view.getDesignPart()).getStorageDesign();
            } else {
                try {
                    sd = view.getDesign().getStorageDesign(view.getDesign().getSelectedRDBMSSite());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            MetadataContainer metadataContainer = queryBuilder.getMetadataContainer();
            String sql = plainTextSQLBuilder.getSQL();
            QBUtils.setSQL(queryBuilder, "");
            try {
                if (!includeSchema) {
                    if (view.getSchemaObject() != null) {
                        metadataContainer.setDefaultSchemaNamesStr(view.getSchemaObject().getName());
                    }
                } else {
                    metadataContainer.getDefaultSchemaNames().clear();
                }
                HashMap<String, MetadataObject> map = new HashMap<String, MetadataObject>();
                System.out.println("update change names  " + System.currentTimeMillis());
                for (SQLNameHelper helper : view.getSQLNames()) {
                    MetadataObject mo;
                    String fullName = helper.getTableName();
                    if (helper.getSchema() != null && helper.getSchema().length() > 0) {
                        fullName = helper.getSchema() + "." + helper.getTableName();
                    }
                    if ((mo = (MetadataObject)map.get(fullName)) == null) {
                        mo = (MetadataObject)metadataObjectsMap.get(helper.getID());
                        if (mo == null) {
                            mo = metadataContainer.findObjectByFullName(fullName);
                        }
                        if (mo != null) {
                            map.put(fullName, mo);
                        }
                    }
                    if (mo == null) continue;
                    if (helper.isContainer()) {
                        ContainerObject co = (ContainerObject)view.getDesign().getDesignObject(helper.getID());
                        if (co == null) continue;
                        boolean quoted = false;
                        if (sd != null) {
                            quoted = sd.isNameShouildBeQuoted(co);
                        }
                        if (!helper.getTableName().equalsIgnoreCase(co.getName())) {
                            System.out.println("update table name  start  " + System.currentTimeMillis());
                            mo.beginUpdate();
                            mo.setNameStr(co.getName());
                            if (quoted) {
                                mo.getName().setCaseSensitive(true);
                            }
                            mo.endUpdate();
                            System.out.println("update table name  end  " + System.currentTimeMillis());
                        }
                        quoted = false;
                        String sn = "";
                        if (co.getSchemaObject() != null) {
                            sn = co.getSchemaObject().getName();
                            if (sd != null) {
                                quoted = sd.isNameShouildBeQuoted(co.getSchemaObject());
                            }
                        }
                        if ((helper.getSchema() != null || "".equals(sn)) && (helper.getSchema() == null || helper.getSchema().equalsIgnoreCase(sn))) continue;
                        mo.beginUpdate();
                        mo.setSchemaStr(sn);
                        if (quoted) {
                            mo.getSchema().setCaseSensitive(true);
                        }
                        mo.endUpdate();
                        continue;
                    }
                    int idx = mo.getFields().findFieldByName(helper.getColumnName());
                    if (idx <= -1) continue;
                    MetadataField field = mo.getFields().get(idx);
                    DesignObject column = view.getDesign().getDesignObject(field.getShortDescription());
                    if (column == null) continue;
                    boolean quoted = false;
                    if (sd != null) {
                        quoted = sd.isNameShouildBeQuoted(column);
                    }
                    String colName = column.getName();
                    if (column instanceof AbstractViewElement) {
                        colName = ((AbstractViewElement)column).getPresentationName();
                    }
                    if (helper.getColumnName().equalsIgnoreCase(colName)) continue;
                    System.out.println("update column name  start  " + System.currentTimeMillis());
                    field.beginUpdate();
                    field.setNameStr(column.getName());
                    if (quoted) {
                        SQLQualifiedName qualName = field.getName();
                        if (quoted) {
                            for (int k = 0; k < qualName.getCount(); ++k) {
                                AstToken astToken = qualName.get(k);
                                ((AstTokenIdentifier)astToken).setCaseSensitive(true);
                            }
                        }
                    }
                    field.endUpdate();
                    System.out.println("update column name  end  " + System.currentTimeMillis());
                }
                System.out.println("update plainTextSQLBuilder.setUseAltNames  " + System.currentTimeMillis());
                plainTextSQLBuilder.setUseAltNames(false);
                queryBuilder.setUseAltNames(false);
                System.out.println("update setSQL  " + System.currentTimeMillis());
                QBUtils.setSQL(queryBuilder, sql);
                System.out.println("update end setSQL  " + System.currentTimeMillis());
                for (DeletedMetadataObject dmdo : deletedMDObjects) {
                    if (dmdo.isContainer()) {
                        QBUtils.deleteDataSource(queryBuilder, dmdo.getMetadataObject());
                        metadataContainer.remove(dmdo.getMetadataObject());
                        continue;
                    }
                    if (dmdo.getMetadataField() == null) continue;
                    QBUtils.deleteColumn(queryBuilder, dmdo.getMetadataField());
                    if (dmdo.getMetadataObject() == null || dmdo.getMetadataObject().getFields() == null) continue;
                    dmdo.getMetadataObject().getFields().remove(dmdo.getMetadataField());
                }
            }
            finally {
                int mb = 0x100000;
                Runtime runtime = Runtime.getRuntime();
                System.out.println("endUpdate memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
            }
            QBUtils.updateDSPositions(queryBuilder);
        }
    }

    public static String semiEncodeText(String unencoded) {
        if (unencoded == null || "".equalsIgnoreCase(unencoded)) {
            return unencoded;
        }
        String string = unencoded;
        if (string.indexOf(38) >= 0) {
            string = StringUtilities.replace(string, "&", "&amp;");
        }
        return string;
    }

    private static void parseDSPositions(String layout) {
        dsPositions.clear();
        try {
            Element subqueries;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            StringReader sr = new StringReader(layout);
            Document doc = parser.parse(new InputSource(sr));
            Element root = doc.getDocumentElement();
            if (root != null && (subqueries = (Element)Helpers.findChildByName((String)"SubQueries", (Node)root)) != null) {
                NodeList list = subqueries.getElementsByTagName("SubQuery");
                for (int i = 0; i < list.getLength(); ++i) {
                    Element elm = (Element)list.item(i);
                    NodeList usq = elm.getElementsByTagName("UnionSubQuery");
                    for (int j = 0; j < usq.getLength(); ++j) {
                        Element elmUSQ = (Element)usq.item(j);
                        NodeList dsList = elmUSQ.getElementsByTagName("DataSource");
                        int d = 0;
                        while (d < dsList.getLength()) {
                            Element elmDS = (Element)dsList.item(d);
                            int left = Integer.parseInt(elmDS.getAttribute("X"));
                            int top = Integer.parseInt(elmDS.getAttribute("Y"));
                            int width = Integer.parseInt(elmDS.getAttribute("Width"));
                            int height = Integer.parseInt(elmDS.getAttribute("Height"));
                            DSHelper dsHelper = new DSHelper();
                            dsHelper.queryNbr = i + "." + j;
                            dsHelper.top = top;
                            dsHelper.Left = left;
                            dsHelper.width = width;
                            dsHelper.height = height;
                            dsHelper.number = d++;
                            dsPositions.add(dsHelper);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void saveDSPositions(QueryBuilder queryBuilder) {
        List list = QBUtils.getAllDataSources(queryBuilder);
        for (QueryHelper queryHelper : list) {
            DataSource dataSource = queryHelper.dataSource;
            DSHelper dsHelper = QBUtils.findDSHelper(queryHelper, true);
            if (dsHelper == null) continue;
            dsHelper.mo = dataSource.getMetadataObject();
        }
    }

    private static DSHelper findDSHelper(QueryHelper queryHelper, boolean byNumber) {
        for (DSHelper dsHelper : dsPositions) {
            if (!(byNumber ? dsHelper.queryNbr.equalsIgnoreCase(queryHelper.queryNbr) && dsHelper.number == queryHelper.number : dsHelper.mo == queryHelper.dataSource.getMetadataObject() && dsHelper.queryNbr.equalsIgnoreCase(queryHelper.queryNbr) && dsHelper.number == queryHelper.number)) continue;
            return dsHelper;
        }
        return null;
    }

    public static void updateDSPositions(QueryBuilder queryBuilder) {
        List list = QBUtils.getAllDataSources(queryBuilder);
        for (QueryHelper queryHelper : list) {
            DataSource dataSource = queryHelper.dataSource;
            DSHelper dsHelper = QBUtils.findDSHelper(queryHelper, false);
            if (dsHelper != null) {
                dataSource.setTop(dsHelper.top);
                dataSource.setLeft(dsHelper.Left);
                dataSource.setWidth(dsHelper.width);
                dataSource.setHeight(dsHelper.height);
                continue;
            }
            System.out.println(queryHelper.number);
        }
    }

    private static List getAllDataSources(QueryBuilder queryBuilder) {
        int i;
        ArrayList<QueryHelper> result = new ArrayList<QueryHelper>();
        ArrayList dsList = new ArrayList();
        for (i = 0; i < queryBuilder.getQuery().getCount(); ++i) {
            dsList.clear();
            UnionSubQuery usq = (UnionSubQuery)queryBuilder.getQuery().get(i);
            usq.getFromClause().getDatasourceByClass(DataSource.class, dsList);
            int count = 0;
            for (Object ds : dsList) {
                QueryHelper qh = new QueryHelper();
                qh.dataSource = (DataSource)ds;
                qh.queryNbr = "0." + i;
                qh.number = count++;
                result.add(qh);
            }
        }
        for (i = 1; i < queryBuilder.getSubQueryList().size(); ++i) {
            SubQuery sq = (SubQuery)queryBuilder.getSubQueryList().get(i);
            int nbr = 0;
            for (int j = 0; j < sq.getCount(); ++j) {
                QueryBase obj = sq.get(j);
                if (obj instanceof UnionGroup) {
                    UnionGroup ug = (UnionGroup)obj;
                    List list = ug.getUnionSubQueryList();
                    for (Object ob : list) {
                        if (!(ob instanceof UnionSubQuery)) continue;
                        dsList.clear();
                        UnionSubQuery usq = (UnionSubQuery)ob;
                        usq.getFromClause().getDatasourceByClass(DataSource.class, dsList);
                        Iterator it2 = dsList.iterator();
                        int count = 0;
                        while (it2.hasNext()) {
                            Object ds = it2.next();
                            QueryHelper qh = new QueryHelper();
                            qh.dataSource = (DataSource)ds;
                            qh.queryNbr = i + "." + nbr;
                            qh.number = count++;
                            result.add(qh);
                        }
                        ++nbr;
                    }
                    continue;
                }
                dsList.clear();
                UnionSubQuery usq = (UnionSubQuery)obj;
                usq.getFromClause().getDatasourceByClass(DataSource.class, dsList);
                Iterator it = dsList.iterator();
                int count = 0;
                while (it.hasNext()) {
                    Object ds = it.next();
                    QueryHelper qh = new QueryHelper();
                    qh.dataSource = (DataSource)ds;
                    qh.queryNbr = i + "." + nbr;
                    qh.number = count++;
                    result.add(qh);
                }
                ++nbr;
            }
        }
        return result;
    }

    private static List getAllCriteriaLists(QueryBuilder queryBuilder) {
        int i;
        ArrayList<CriteriaList> result = new ArrayList<CriteriaList>();
        for (i = 0; i < queryBuilder.getQuery().getCount(); ++i) {
            UnionSubQuery usq = (UnionSubQuery)queryBuilder.getQuery().get(i);
            result.add(usq.getCriteriaList());
        }
        for (i = 0; i < queryBuilder.getQuery().getSubQueryCount(); ++i) {
            SubQuery sq = queryBuilder.getQuery().getSubQuery(i);
            for (int j = 0; j < sq.getCount(); ++j) {
                UnionSubQuery usq = (UnionSubQuery)sq.get(j);
                result.add(usq.getCriteriaList());
            }
        }
        return result;
    }

    private static List getAllLinks(QueryBuilder queryBuilder) {
        int i;
        ArrayList result = new ArrayList();
        for (i = 0; i < queryBuilder.getQuery().getCount(); ++i) {
            UnionSubQuery usq = (UnionSubQuery)queryBuilder.getQuery().get(i);
            result.addAll(usq.getFromClause().links);
        }
        for (i = 0; i < queryBuilder.getQuery().getSubQueryCount(); ++i) {
            SubQuery sq = queryBuilder.getQuery().getSubQuery(i);
            for (int j = 0; j < sq.getCount(); ++j) {
                UnionSubQuery usq = (UnionSubQuery)sq.get(j);
                result.addAll(usq.getFromClause().links);
            }
        }
        return result;
    }

    private static void deleteDataSource(QueryBuilder queryBuilder, MetadataObject mo) {
        try {
            List list = QBUtils.getAllDataSources(queryBuilder);
            for (QueryHelper queryHelper : list) {
                DataSource dataSource = queryHelper.dataSource;
                if (dataSource.getMetadataObject() != mo) continue;
                dataSource.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void deleteColumn(QueryBuilder queryBuilder, MetadataField mf) {
        try {
            List list = QBUtils.getAllLinks(queryBuilder);
            for (Link link : list) {
                SQLExpressionColumn ec;
                boolean deleted = false;
                if (link.getLinkExpression() == null || !(link.getLinkExpression() instanceof SQLExpressionOperatorBinary)) continue;
                SQLExpressionOperatorBinary eob = (SQLExpressionOperatorBinary)link.getLinkExpression();
                if (eob.lExpression instanceof SQLExpressionColumn) {
                    ec = (SQLExpressionColumn)eob.lExpression;
                    if (ec.column != null && ec.column.getMetadataField() != null && ec.column.getMetadataField().getShortDescription().equalsIgnoreCase(mf.getShortDescription())) {
                        link.dispose();
                        deleted = true;
                    }
                }
                if (deleted || !(eob.rExpression instanceof SQLExpressionColumn)) continue;
                ec = (SQLExpressionColumn)eob.rExpression;
                if (ec.column == null || ec.column.getMetadataField() == null || !ec.column.getMetadataField().getShortDescription().equalsIgnoreCase(mf.getShortDescription())) continue;
                link.dispose();
            }
            list = QBUtils.getAllCriteriaLists(queryBuilder);
            for (CriteriaList cl : list) {
                for (int i = cl.getCount() - 1; i >= 0; --i) {
                    CriteriaItem ci = cl.get(i);
                    if (ci.getExpressionField() == null || !ci.getExpressionField().getShortDescription().equalsIgnoreCase(mf.getShortDescription())) continue;
                    ci.dispose();
                }
            }
            list = QBUtils.getAllDataSources(queryBuilder);
            for (QueryHelper queryHelper : list) {
                DataSource dataSource = queryHelper.dataSource;
                MetadataFieldList mfl = dataSource.getFields();
                for (int i = mfl.getCount() - 1; i >= 0; --i) {
                    MetadataField field = mfl.get(i);
                    if (!mf.getShortDescription().equalsIgnoreCase(field.getShortDescription())) continue;
                    mfl.delete(i);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setSQL(QueryBuilder queryBuilder, String sql) {
        QBUtils.setSQL(queryBuilder, sql, false);
    }

    public static void setSQL(QueryBuilder queryBuilder, String sql, boolean showErrorLater) {
        block11: {
            isIncorrectSQL = false;
            incorrectSQL = "";
            try {
                if (!"".equalsIgnoreCase(sql.trim())) {
                    queryBuilder.setSQL(sql);
                }
            }
            catch (Exception e) {
                isIncorrectSQL = true;
                incorrectSQL = sql;
                if (showErrorLater || jTextPane == null) break block11;
                boolean parseError = false;
                int pos = -1;
                for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                    if (cause instanceof ParsingException) {
                        pos = ((ParsingException)cause).errorPos.pos;
                        parseError = true;
                        break;
                    }
                    if (cause.getCause() == cause) break;
                }
                if (parseError) {
                    MessageDialogs.showWarningMessage(e.getMessage());
                } else {
                    MessageDialogs.showErrorMessage(e.getMessage());
                }
                if (pos > -1) {
                    try {
                        jTextPane.requestFocus();
                        jTextPane.setCaretPosition(pos);
                        jTextPane.setSelectionStart(pos);
                        int end = sql.indexOf(" ", pos);
                        if (end == -1) {
                            end = sql.length();
                        }
                        jTextPane.setSelectionEnd(end);
                    }
                    catch (Exception e2) {}
                }
                jTextPane.setCaretPosition(0);
            }
        }
    }

    private static ContainerObject getContainerObject(AbstractView view, String name) {
        if (view instanceof EntityView) {
            LogicalDesign logicalModel = (LogicalDesign)view.getDesignPart();
            Iterator it = logicalModel.getEntitySet().iterator();
            while (it.hasNext()) {
                Entity entity = (Entity)it.next();
                if (!entity.getName().equalsIgnoreCase(name)) continue;
                return entity;
            }
            it = logicalModel.getEntityViewSet().iterator();
            while (it.hasNext()) {
                EntityView entityView = (EntityView)it.next();
                if (!entityView.getName().equalsIgnoreCase(name)) continue;
                return entityView;
            }
        } else {
            RelationalDesign rd = (RelationalDesign)view.getDesignPart();
            Iterator it = rd.getTableSet().iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                if (!table.getName().equalsIgnoreCase(name)) continue;
                return table;
            }
            it = rd.getTableViewSet().iterator();
            while (it.hasNext()) {
                TableView tableView = (TableView)it.next();
                if (!tableView.getName().equalsIgnoreCase(name)) continue;
                return tableView;
            }
        }
        return null;
    }

    private static AbstractViewElement getColumnView(ContainerObject container, AbstractView view, String containerAlias, String name, String alias, String expression, Map found) {
        for (AbstractViewElement c : view.getElementsCollection()) {
            if (found.get(c) != null) continue;
            if (c.getReferencedContainer() != null && container != null) {
                if (c.getReferencedContainer() != container) continue;
                if (name.length() > 0 && alias.length() > 0 && expression.length() > 0 && containerAlias.length() > 0 && name.equalsIgnoreCase(c.getName()) && alias.equalsIgnoreCase(c.getAlias()) && expression.equalsIgnoreCase(c.getExpression()) && containerAlias.equalsIgnoreCase(c.getTableAlias())) {
                    return c;
                }
                if (name.length() > 0 && alias.length() > 0 && expression.length() > 0 && name.equalsIgnoreCase(c.getName()) && alias.equalsIgnoreCase(c.getAlias()) && expression.equalsIgnoreCase(c.getExpression())) {
                    return c;
                }
                if (name.length() > 0 && alias.length() > 0 && name.equalsIgnoreCase(c.getName()) && alias.equalsIgnoreCase(c.getAlias())) {
                    return c;
                }
                if (name.length() > 0 && expression.length() > 0 && name.equalsIgnoreCase(c.getName()) && expression.equalsIgnoreCase(c.getExpression())) {
                    return c;
                }
                if (alias.length() > 0 && expression.length() > 0 && alias.equalsIgnoreCase(c.getAlias()) && expression.equalsIgnoreCase(c.getExpression())) {
                    return c;
                }
                if (alias.length() > 0 && alias.equalsIgnoreCase(c.getAlias())) {
                    return c;
                }
                if (expression.length() > 0 && expression.equalsIgnoreCase(c.getExpression())) {
                    return c;
                }
                if (name.length() <= 0 || !name.equalsIgnoreCase(c.getName())) continue;
                return c;
            }
            if (name.length() > 0 && alias.length() > 0 && expression.length() > 0 && name.equalsIgnoreCase(c.getName()) && alias.equalsIgnoreCase(c.getAlias()) && expression.equalsIgnoreCase(c.getExpression())) {
                return c;
            }
            if (name.length() > 0 && alias.length() > 0 && expression.length() > 0 && name.equalsIgnoreCase(c.getName()) && alias.equalsIgnoreCase(c.getAlias()) && expression.equalsIgnoreCase(c.getExpression())) {
                return c;
            }
            if (name.length() > 0 && alias.length() > 0 && name.equalsIgnoreCase(c.getName()) && alias.equalsIgnoreCase(c.getAlias())) {
                return c;
            }
            if (name.length() > 0 && expression.length() > 0 && name.equalsIgnoreCase(c.getName()) && expression.equalsIgnoreCase(c.getExpression())) {
                return c;
            }
            if (alias.length() > 0 && expression.length() > 0 && alias.equalsIgnoreCase(c.getAlias()) && expression.equalsIgnoreCase(c.getExpression())) {
                return c;
            }
            if (alias.length() > 0 && alias.equalsIgnoreCase(c.getAlias())) {
                return c;
            }
            if (expression.length() > 0 && expression.equalsIgnoreCase(c.getExpression())) {
                return c;
            }
            if (name.length() <= 0 || !name.equalsIgnoreCase(c.getName())) continue;
            return c;
        }
        return null;
    }

    public static void updateColumns(AbstractView view, QueryBuilder queryBuilder) {
        boolean isLogicalView = view instanceof EntityView;
        ArrayList oldCols = new ArrayList(view.getElementsCollection());
        view.clearContainers();
        ArrayList<ContainerObject> added = new ArrayList<ContainerObject>();
        ArrayList<AbstractViewElement> columnViews = new ArrayList<AbstractViewElement>();
        StatisticsOutputColumnList outl = queryBuilder.getQueryStatistics().getOutputColumns();
        HashMap<AbstractViewElement, AbstractViewElement> found = new HashMap<AbstractViewElement, AbstractViewElement>();
        for (int i = 0; i < outl.getCount(); ++i) {
            StatisticsOutputColumn sc = outl.get(i);
            if (sc.getMetadataObject() != null) {
                ContainerObject co = QBUtils.getContainerObject(view, sc.getMetadataObject().getNameStrNotQuoted());
                if (co == null) continue;
                ContainedObject column = null;
                MetadataField mf = sc.getMetadataField();
                if (mf != null) {
                    String name = mf.getNameStrNotQuoted();
                    column = co.getElementByName(name);
                } else {
                    String cname = sc.getColumnName();
                    if (cname != null && !"".equals(cname)) {
                        column = co.getElementByName(cname);
                    }
                }
                AbstractViewElement v = QBUtils.getColumnView(co, view, sc.getObjectAlias(), sc.getColumnName(), sc.getExpressionAlias(), sc.getExpression(), found);
                if (v == null) {
                    v = isLogicalView ? new AttributeView(view.getDesignPart()) : new ColumnView(view.getDesignPart());
                    if (column != null) {
                        if (column instanceof Column || column instanceof Attribute) {
                            v.setReferencedColumn((ContainedObjectWithDomain)column);
                        } else {
                            v.setReferencedColumnView(column);
                        }
                    }
                    v.setName(sc.getColumnName());
                    v.setDesign(co.getDesign());
                    if (co instanceof Table || co instanceof Entity) {
                        v.setTable((ContainerWithKeyObject)co);
                    } else {
                        v.setView((AbstractView)co);
                    }
                    v.setContainer(view);
                    v.setTableAlias(sc.getObjectAlias());
                    if (mf != null) {
                        v.setDataType(mf.getFieldTypeName());
                    }
                } else if (column != null) {
                    if (column instanceof Column || column instanceof Attribute) {
                        v.setReferencedColumn((ContainedObjectWithDomain)column);
                    } else {
                        v.setReferencedColumnView(column);
                    }
                }
                found.put(v, v);
                v.setAlias(sc.getExpressionAlias());
                if ("".equals(sc.getObjectName())) {
                    v.setExpression(sc.getExpression());
                }
                columnViews.add(v);
                if (added.contains(co)) continue;
                added.add(co);
                view.addToContainers(co, sc.getObjectAlias());
                continue;
            }
            AbstractViewElement v = QBUtils.getColumnView(null, view, sc.getObjectAlias(), sc.getColumnName(), sc.getExpressionAlias(), sc.getExpression(), found);
            if (v == null) {
                v = isLogicalView ? new AttributeView(view.getDesignPart()) : new ColumnView(view.getDesignPart());
                v.setName(sc.getColumnName());
                v.setDesign(view.getDesign());
                v.setContainer(view);
                v.setTableAlias(sc.getObjectAlias());
                if (sc.getMetadataField() != null) {
                    v.setDataType(sc.getMetadataField().getFieldTypeName());
                } else {
                    v.setExpression(sc.getExpression());
                }
            }
            found.put(v, v);
            v.setAlias(sc.getExpressionAlias());
            if ("".equals(sc.getObjectName())) {
                v.setExpression(sc.getExpression());
            }
            columnViews.add(v);
        }
        view.clearElements();
        Iterator it = columnViews.iterator();
        int k = 0;
        while (it.hasNext()) {
            AbstractViewElement av;
            AbstractViewElement cv = (AbstractViewElement)it.next();
            view.add(cv);
            if (!view.isParsed() && columnViews.size() == oldCols.size() && !"".equals((av = (AbstractViewElement)oldCols.get(k)).getHeaderAlias())) {
                cv.setHeaderAlias(av.getHeaderAlias());
            }
            ++k;
        }
    }

    public static String formatSQL(String sql, BaseSyntaxProvider syntaxProvider) {
        DMSQLFormatter command = new DMSQLFormatter();
        if (syntaxProvider instanceof OracleSyntaxProvider) {
            return command.formatSQL(sql, "Oracle");
        }
        if (syntaxProvider instanceof MSSQLSyntaxProvider) {
            return command.formatSQL(sql, "Microsoft SQL Server");
        }
        if (syntaxProvider instanceof DB2SyntaxProvider) {
            return command.formatSQL(sql, "DB2");
        }
        if (syntaxProvider instanceof MySQLSyntaxProvider) {
            return command.formatSQL(sql, "MySQL");
        }
        if (syntaxProvider instanceof SybaseSyntaxProvider) {
            return command.formatSQL(sql, "Sybase");
        }
        return command.formatSQL(sql, "Oracle");
    }

    public static void setViewSQL(AbstractView view, QueryBuilder queryBuilder, PlainTextSQLBuilder plainTextSQLBuilder, boolean setLayoutSQL) {
        view.setUserDefined(true);
        if (isIncorrectSQL) {
            if (setLayoutSQL) {
                view.setUserDefinedSQL(QBUtils.formatSQL(incorrectSQL, queryBuilder.getSyntaxProvider()));
            } else {
                view.setUserDefinedSQL(incorrectSQL);
            }
            view.clearAll();
            view.clearContainers();
            view.getElements(incorrectSQL.replaceAll("\\s+", " ").replaceAll(" +", " "), false);
            view.setLayoutSQL("");
            view.getSQLNames().clear();
            view.setIncorrectSQL(true);
        } else {
            String ddl = plainTextSQLBuilder.getSQL();
            if (setLayoutSQL) {
                ddl = QBUtils.formatSQL(ddl, queryBuilder.getSyntaxProvider());
            }
            view.setUserDefinedSQL(ddl);
            if (setLayoutSQL) {
                String layout = queryBuilder.getLayoutSQL();
                view.setLayoutSQL(layout);
            }
            view.updateSQLNames(queryBuilder);
            view.setIncorrectSQL(false);
            if (view.getSQLNames().isEmpty() && view.getElements().length == 0) {
                view.getElements(ddl.replaceAll("\\s+", " ").replaceAll(" +", " "), false);
            }
        }
    }

    public static String getSQL(String sqlIn) {
        String sql = sqlIn;
        String sqlu = sql.toUpperCase();
        if (sqlu.indexOf("CREATE") > -1) {
            int ind = sqlu.indexOf("SELECT");
            int ind2 = sqlu.indexOf("WITH");
            if (ind > 0) {
                if (ind2 > -1 && ind2 < ind) {
                    char ch = sqlu.charAt(ind2 - 1);
                    if (ch != ' ' && (ch < '\t' || ch > '\r')) {
                        ind2 = sqlu.indexOf("WITH", ind2 + 1);
                    }
                    sql = sql.substring(ind2);
                } else {
                    char ch = sqlu.charAt(ind - 1);
                    if (ch != ' ' && (ch < '\t' || ch > '\r')) {
                        ind = sqlu.indexOf("SELECT", ind + 1);
                    }
                    sql = sql.substring(ind);
                }
            }
        }
        return sql;
    }

    static {
        dsPositions = new ArrayList();
        isIncorrectSQL = false;
        incorrectSQL = "";
        deletedMDObjects = new ArrayList();
        metadataObjectsMap = new HashMap();
        SYNTAX_PROVIDERS = new TreeMap<String, BaseSyntaxProvider>();
        previousSyntaxProvider = "Oracle";
        SYNTAX_PROVIDERS.put("DB2", (BaseSyntaxProvider)new DB2SyntaxProvider());
        SYNTAX_PROVIDERS.put("Firebird", (BaseSyntaxProvider)new FirebirdSyntaxProvider());
        SYNTAX_PROVIDERS.put("Informix", (BaseSyntaxProvider)new InformixSyntaxProvider());
        SYNTAX_PROVIDERS.put("MSSQL", (BaseSyntaxProvider)new MSSQLSyntaxProvider());
        SYNTAX_PROVIDERS.put("MySQL", (BaseSyntaxProvider)new MySQLSyntaxProvider());
        SYNTAX_PROVIDERS.put("Oracle", (BaseSyntaxProvider)new OracleSyntaxProvider());
        SYNTAX_PROVIDERS.put("PostgreSQL", (BaseSyntaxProvider)new PostgreSQLSyntaxProvider());
        SYNTAX_PROVIDERS.put("SQLite", (BaseSyntaxProvider)new SQLiteSyntaxProvider());
        SYNTAX_PROVIDERS.put("Sybase", (BaseSyntaxProvider)new SybaseSyntaxProvider());
    }
}

