/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.viewbuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.viewbuilder.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.MoveUpDownListJTable;

public class ViewBuilder
extends JPanel {
    public static final String MODIFY_LABEL = Messages.getString("ViewBuilder.Modify");
    public static final String ADD_LABEL = Messages.getString("ViewBuilder.Add");
    protected JDialog dialog;
    protected JPanel buttonPanel;
    protected JTabbedPane tpane;
    protected JPanel general;
    protected JPanel tablesPanel = new JPanel(new SpringLayout());
    protected JPanel columnsPanel = new JPanel(new SpringLayout());
    protected JPanel wherePanel = new JPanel(new SpringLayout());
    protected JPanel groupByPanel = new JPanel(new SpringLayout());
    protected JPanel havingPanel = new JPanel(new SpringLayout());
    protected JPanel orderByPanel = new JPanel(new SpringLayout());
    protected JPanel previewPanel = new JPanel(new SpringLayout());
    protected JPanel ddlPanel = new JPanel(new SpringLayout());
    protected JTextArea sqlArea = new JTextArea();
    protected JTextArea defineDDLArea = new JTextArea();
    protected JTextArea whereArea = new JTextArea();
    protected JTextArea groupByArea = new JTextArea();
    protected JTextArea havingArea = new JTextArea();
    protected JCheckBox defineDDLChBox;
    protected JButton defineWhere;
    protected JTable allTablesTable;
    protected DefaultListModel allTablesModel;
    protected JList allTablesList;
    protected SelectedTablesTable selectedTablesTable;
    protected JButton bnAddTables;
    protected JButton bnRemoveTables;
    protected JButton bnMoveUpTable;
    protected JButton bnMoveDownTable;
    private List containerList = new ArrayList();
    protected DefaultListModel allColumnsModel;
    protected JList allColumnsList;
    protected JTable selectedColumnsTable;
    protected JButton bnAddColumns;
    protected JButton bnRemoveColumns;
    protected JButton bnNewExpression;
    private List columnViewList = new ArrayList();
    protected DefaultListModel allColumnsOrderByModel;
    protected JList allColumnsOrderByList;
    protected SelectedOrderByColumnsTable selectedOrderByColumnsTable;
    protected JButton bnAddOrderByColumns;
    protected JButton bnRemoveOrderByColumns;
    protected JButton bnNewOrderByColumns;
    private List orderByList = new ArrayList();
    protected TableView view;
    protected RelationalDesign design;
    private ContainerObject contObject;
    private List expressionList = new ArrayList();

    public ViewBuilder(ContainerObject object) {
        this.contObject = object;
    }

    public JDialog getDialog(ApplicationView applView) {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)applView.getFrame(), Messages.getString("ViewBuilder.ViewBuilder"));
            this.general = new JPanel(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.general, "Center");
            this.dialog.getContentPane().add((Component)this.getButtonPanel(), "East");
            this.tpane = new JTabbedPane();
            this.general.add((Component)this.tpane, "Center");
            this.tpane.addTab("Tables", this.tablesPanel);
            this.tpane.addTab(Messages.getString("ViewBuilder.Columns"), this.columnsPanel);
            this.tpane.addTab(Messages.getString("ViewBuilder.Where"), this.wherePanel);
            this.tpane.addTab(Messages.getString("ViewBuilder.GroupByT"), this.groupByPanel);
            this.tpane.addTab(Messages.getString("ViewBuilder.Having"), this.havingPanel);
            this.tpane.addTab(Messages.getString("ViewBuilder.OrderBy"), this.orderByPanel);
            this.tpane.addTab(Messages.getString("ViewBuilder.Preview"), this.previewPanel);
            this.tpane.addTab(Messages.getString("ViewBuilder.DefineDDL"), this.ddlPanel);
            this.tpane.addChangeListener(new TabChangeListener());
            this.initTablesPane();
            this.initColumnsPane();
            this.initWherePane();
            this.initGroupByPane();
            this.initHavingPane();
            this.initOrderByPane();
            this.initPreviewPane();
            this.initDefineDDLPane();
            this.dialog.setModal(true);
            this.dialog.setSize(new Dimension(775, 355));
            this.dialog.setResizable(false);
        }
        CommonUtil.centerOnScreen(this.dialog);
        this.clear();
        this.initProperties(this.contObject);
        return this.dialog;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel panel = new JPanel(new GridLayout(3, 1, 5, 5));
            JButton ok = new JButton(Messages.getString("ViewBuilder.OK"));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewBuilder.this.stopTableCellEditing(ViewBuilder.this.selectedTablesTable);
                    ViewBuilder.this.stopTableCellEditing(ViewBuilder.this.selectedColumnsTable);
                    ViewBuilder.this.stopTableCellEditing(ViewBuilder.this.selectedOrderByColumnsTable);
                    if (ViewBuilder.this.canExit()) {
                        ViewBuilder.this.setProperties();
                        ViewBuilder.this.dialog.dispose();
                    }
                }
            });
            ok.setCursor(Cursor.getPredefinedCursor(12));
            ok.setMnemonic(79);
            JButton apply = new JButton(Messages.getString("ViewBuilder.Apply"));
            apply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewBuilder.this.stopTableCellEditing(ViewBuilder.this.selectedTablesTable);
                    ViewBuilder.this.stopTableCellEditing(ViewBuilder.this.selectedColumnsTable);
                    ViewBuilder.this.stopTableCellEditing(ViewBuilder.this.selectedOrderByColumnsTable);
                    if (ViewBuilder.this.canExit()) {
                        ViewBuilder.this.setProperties();
                    }
                }
            });
            apply.setCursor(Cursor.getPredefinedCursor(12));
            apply.setMnemonic(65);
            JButton cancel = new JButton(Messages.getString("ViewBuilder.Cancel"));
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewBuilder.this.dialog.dispose();
                }
            });
            cancel.setMnemonic(67);
            cancel.setCursor(Cursor.getPredefinedCursor(12));
            ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            apply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            panel.add(ok);
            panel.add(apply);
            panel.add(cancel);
            this.buttonPanel.add((Component)panel, "North");
        }
        return this.buttonPanel;
    }

    protected SpringLayout getPanelLayout(JPanel panel) {
        return (SpringLayout)panel.getLayout();
    }

    protected void initTablesPane() {
        this.initAllTablesList();
        this.initSelectedTablesList();
        this.initTablesButtons();
    }

    protected void initColumnsPane() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initColumnsButtons();
    }

    protected void initWherePane() {
        this.defineWhere = new JButton(Messages.getString("ViewBuilder.InsertJoinClauseForFK"));
        this.defineWhere.addActionListener(new WhereListener());
        this.wherePanel.add(this.defineWhere);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.wherePanel), this.defineWhere, 10, 12);
        JScrollPane sp = new JScrollPane(this.whereArea);
        sp.setPreferredSize(new Dimension(645, 255));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.wherePanel.add(sp);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.wherePanel), sp, 10, 42);
    }

    protected void initGroupByPane() {
        JScrollPane sp = new JScrollPane(this.groupByArea);
        this.groupByArea.setEditable(false);
        sp.setPreferredSize(new Dimension(645, 285));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.groupByPanel.add(sp);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.groupByPanel), sp, 10, 12);
    }

    protected void initHavingPane() {
        JScrollPane sp = new JScrollPane(this.havingArea);
        sp.setPreferredSize(new Dimension(645, 285));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.havingPanel.add(sp);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.havingPanel), sp, 10, 12);
    }

    protected void initOrderByPane() {
        this.initAllColumnsOrderByList();
        this.initSelectedColumnsOrderByList();
        this.initColumnsOrderByButtons();
    }

    protected void initPreviewPane() {
        JScrollPane sp = new JScrollPane(this.sqlArea);
        sp.setPreferredSize(new Dimension(645, 285));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.previewPanel.add(sp);
        this.sqlArea.setEnabled(false);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.previewPanel), sp, 10, 12);
    }

    protected void initDefineDDLPane() {
        this.defineDDLChBox = new JCheckBox(Messages.getString("ViewBuilder.UserDefinedDDL"));
        this.defineDDLChBox.addActionListener(new CheckBoxListener());
        this.ddlPanel.add(this.defineDDLChBox);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.ddlPanel), this.defineDDLChBox, 10, 12);
        JScrollPane sp = new JScrollPane(this.defineDDLArea);
        sp.setPreferredSize(new Dimension(645, 255));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.ddlPanel.add(sp);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.ddlPanel), sp, 10, 42);
    }

    protected void initAllTablesList() {
        JLabel label = new JLabel(Messages.getString("ViewBuilder.AvailableTables"));
        this.tablesPanel.add(label);
        this.allTablesModel = new DefaultListModel();
        this.allTablesList = new JList(this.allTablesModel);
        ListSelectionModel listSelectionModel = this.allTablesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListTablesSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allTablesList);
        sp.setPreferredSize(new Dimension(210, 265));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.tablesPanel.add(sp);
        CommonUtil.setLabelConstraints(this.getPanelLayout(this.tablesPanel), label, 12, 14);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), sp, 10, 32);
    }

    protected void initSelectedTablesList() {
        this.selectedTablesTable = new SelectedTablesTable();
        this.selectedTablesTable.setModel(new SelectedTablesModel());
        JPanel pnTblButtons = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        MoveUpDownListJTable upDown = new MoveUpDownListJTable(this.containerList, this.selectedTablesTable);
        this.bnMoveUpTable = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
        this.bnMoveUpTable.setToolTipText(Messages.getString("ViewBuilder.MoveUp"));
        this.bnMoveUpTable.addActionListener(new MoveUpDownListJTable.MoveUpAction(upDown));
        toolBar.add(this.bnMoveUpTable);
        this.bnMoveDownTable = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
        this.bnMoveDownTable.setToolTipText(Messages.getString("ViewBuilder.MoveDown"));
        this.bnMoveDownTable.addActionListener(new MoveUpDownListJTable.MoveDownAction(upDown));
        toolBar.add(this.bnMoveDownTable);
        pnTblButtons.add((Component)toolBar, "North");
        ListSelectionModel listSelectionModel = this.selectedTablesTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedTablesHandler());
        JScrollPane sp = new JScrollPane(this.selectedTablesTable);
        sp.setPreferredSize(new Dimension(325, 248));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        pnTblButtons.add((Component)sp, "Center");
        this.tablesPanel.add(pnTblButtons);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), pnTblButtons, 332, 14);
    }

    protected void initTablesButtons() {
        this.bnAddTables = new JButton(ADD_LABEL);
        this.bnAddTables.addActionListener(new AddTablesActionListener());
        this.bnAddTables.setPreferredSize(new Dimension(90, 26));
        this.bnAddTables.setEnabled(false);
        this.tablesPanel.add(this.bnAddTables);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), this.bnAddTables, 232, 32);
        this.bnRemoveTables = new JButton(Messages.getString("ViewBuilder.Remove"));
        this.bnRemoveTables.setEnabled(false);
        this.bnRemoveTables.addActionListener(new RemoveTablesActionListener());
        this.bnRemoveTables.setPreferredSize(new Dimension(90, 26));
        this.tablesPanel.add(this.bnRemoveTables);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), this.bnRemoveTables, 232, 62);
    }

    protected void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("ViewBuilder.AvailableColumns"));
        this.columnsPanel.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        this.allColumnsList.setCellRenderer(new AllListColumnsCellRenderer());
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListColumnsSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(210, 265));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsPanel.add(sp);
        CommonUtil.setLabelConstraints(this.getPanelLayout(this.columnsPanel), label, 12, 14);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), sp, 10, 32);
    }

    protected void initSelectedColumnsList() {
        this.selectedColumnsTable = new JTable();
        this.selectedColumnsTable.setModel(new SelectedColumnsModel());
        this.selectedColumnsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        TableColumn column = null;
        block5: for (int i = 0; i < 3; ++i) {
            column = this.selectedColumnsTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setCellEditor(new ExpressionCellEditor());
                    column.setPreferredWidth(120);
                    continue block5;
                }
                case 1: {
                    column.setCellRenderer(new LabelTableCellRenderer());
                    column.setCellEditor(new TextCellEditor());
                    column.setPreferredWidth(60);
                    continue block5;
                }
                case 2: {
                    column.setCellRenderer(new CheckBoxTableCellRenderer());
                    column.setCellEditor(new CheckBoxEditor());
                    column.setPreferredWidth(40);
                }
            }
        }
        JPanel pnTblButtons = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        MoveUpDownListJTable upDown = new MoveUpDownListJTable(this.columnViewList, this.selectedColumnsTable);
        this.bnMoveUpTable = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
        this.bnMoveUpTable.setToolTipText(Messages.getString("ViewBuilder.MoveUp"));
        this.bnMoveUpTable.addActionListener(new MoveUpDownListJTable.MoveUpAction(upDown));
        toolBar.add(this.bnMoveUpTable);
        this.bnMoveDownTable = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
        this.bnMoveDownTable.setToolTipText(Messages.getString("ViewBuilder.MoveDown"));
        this.bnMoveDownTable.addActionListener(new MoveUpDownListJTable.MoveDownAction(upDown));
        toolBar.add(this.bnMoveDownTable);
        pnTblButtons.add((Component)toolBar, "North");
        ListSelectionModel listSelectionModel = this.selectedColumnsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsTable);
        sp.setPreferredSize(new Dimension(325, 248));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        pnTblButtons.add(sp);
        this.columnsPanel.add(pnTblButtons);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), pnTblButtons, 332, 14);
    }

    private void stopEdit() {
        TableCellEditor editor;
        int col = this.selectedColumnsTable.getEditingColumn();
        int row = this.selectedColumnsTable.getEditingRow();
        if (col > -1 && row > -1 && (editor = this.selectedColumnsTable.getCellEditor(row, col)) != null) {
            editor.stopCellEditing();
        }
    }

    protected void initColumnsButtons() {
        this.bnAddColumns = new JButton(ADD_LABEL);
        this.bnAddColumns.addActionListener(new AddColumnsActionListener());
        this.bnAddColumns.setPreferredSize(new Dimension(90, 26));
        this.bnAddColumns.setEnabled(false);
        this.columnsPanel.add(this.bnAddColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), this.bnAddColumns, 232, 32);
        this.bnNewExpression = new JButton(Messages.getString("ViewBuilder.New"));
        this.bnNewExpression.setEnabled(false);
        this.bnNewExpression.addActionListener(new NewExpressionActionListener());
        this.bnNewExpression.setPreferredSize(new Dimension(90, 26));
        this.columnsPanel.add(this.bnNewExpression);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), this.bnNewExpression, 232, 62);
        this.bnRemoveColumns = new JButton(Messages.getString("ViewBuilder.Remove"));
        this.bnRemoveColumns.setEnabled(false);
        this.bnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.bnRemoveColumns.setPreferredSize(new Dimension(90, 26));
        this.columnsPanel.add(this.bnRemoveColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), this.bnRemoveColumns, 232, 92);
    }

    protected void initAllColumnsOrderByList() {
        JLabel label = new JLabel(Messages.getString("ViewBuilder.AvailableColumns"));
        this.orderByPanel.add(label);
        this.allColumnsOrderByModel = new DefaultListModel();
        this.allColumnsOrderByList = new JList(this.allColumnsOrderByModel);
        this.allColumnsOrderByList.setCellRenderer(new AllListOrderByColumnsCellRenderer());
        ListSelectionModel listSelectionModel = this.allColumnsOrderByList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListColumnsOrderBySelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsOrderByList);
        sp.setPreferredSize(new Dimension(210, 265));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.orderByPanel.add(sp);
        CommonUtil.setLabelConstraints(this.getPanelLayout(this.orderByPanel), label, 12, 14);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), sp, 10, 32);
    }

    protected void initSelectedColumnsOrderByList() {
        this.selectedOrderByColumnsTable = new SelectedOrderByColumnsTable();
        this.selectedOrderByColumnsTable.setModel(new SelectedOrderByColumnsModel());
        JPanel pnTblButtons = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        MoveUpDownListJTable upDown = new MoveUpDownListJTable(this.orderByList, this.selectedOrderByColumnsTable);
        this.bnMoveUpTable = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
        this.bnMoveUpTable.setToolTipText(Messages.getString("ViewBuilder.MoveUp"));
        this.bnMoveUpTable.addActionListener(new MoveUpDownListJTable.MoveUpAction(upDown));
        toolBar.add(this.bnMoveUpTable);
        this.bnMoveDownTable = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
        this.bnMoveDownTable.setToolTipText(Messages.getString("ViewBuilder.MoveDown"));
        this.bnMoveDownTable.addActionListener(new MoveUpDownListJTable.MoveDownAction(upDown));
        toolBar.add(this.bnMoveDownTable);
        pnTblButtons.add((Component)toolBar, "North");
        ListSelectionModel listSelectionModel = this.selectedOrderByColumnsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedOrderByColumnsHandler());
        TableColumn column = null;
        for (int i = 0; i < 2; ++i) {
            column = this.selectedOrderByColumnsTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(120);
                continue;
            }
            if (i != 1) continue;
            column.setPreferredWidth(60);
            column.setCellEditor(new ComboCellEditor());
        }
        JScrollPane sp = new JScrollPane(this.selectedOrderByColumnsTable);
        sp.setPreferredSize(new Dimension(325, 248));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        pnTblButtons.add((Component)sp, "Center");
        this.orderByPanel.add(pnTblButtons);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), pnTblButtons, 332, 14);
    }

    protected void initColumnsOrderByButtons() {
        this.bnAddOrderByColumns = new JButton(ADD_LABEL);
        this.bnAddOrderByColumns.addActionListener(new AddOrderByColumnsActionListener());
        this.bnAddOrderByColumns.setPreferredSize(new Dimension(90, 26));
        this.bnAddOrderByColumns.setEnabled(false);
        this.orderByPanel.add(this.bnAddOrderByColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), this.bnAddOrderByColumns, 232, 32);
        this.bnNewOrderByColumns = new JButton(Messages.getString("ViewBuilder.New"));
        this.bnNewOrderByColumns.setEnabled(false);
        this.bnNewOrderByColumns.addActionListener(new NewOrderByColumnsActionListener());
        this.bnNewOrderByColumns.setPreferredSize(new Dimension(90, 26));
        this.orderByPanel.add(this.bnNewOrderByColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), this.bnNewOrderByColumns, 232, 62);
        this.bnRemoveOrderByColumns = new JButton(Messages.getString("ViewBuilder.Remove"));
        this.bnRemoveOrderByColumns.setEnabled(false);
        this.bnRemoveOrderByColumns.addActionListener(new RemoveOrderByColumnsActionListener());
        this.bnRemoveOrderByColumns.setPreferredSize(new Dimension(90, 26));
        this.orderByPanel.add(this.bnRemoveOrderByColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), this.bnRemoveOrderByColumns, 232, 92);
    }

    private String appendQuotes(String name) {
        StorageDesign sd = ((RelationalDesign)this.view.getDesignPart()).getStorageDesign();
        if (sd != null) {
            return sd.getFormatedName(name);
        }
        if (name.trim().indexOf(32) > -1) {
            return "\"" + name.trim() + "\"";
        }
        return name;
    }

    protected String generateWhere() {
        StringBuffer buff = new StringBuffer();
        boolean first = true;
        int k = 0;
        Object[] elements = this.containerList.toArray();
        for (int i = 0; i < elements.length - 1; ++i) {
            ContainerElement elem = (ContainerElement)elements[i];
            if (!(elem.getContainerObject() instanceof Table)) continue;
            Table t1 = (Table)elem.getContainerObject();
            String t1Alias = elem.getContainerAlias();
            for (int j = k = i + 1; j < elements.length; ++j) {
                int b;
                Column[] cols;
                int a;
                FKIndexAssociation[] fk;
                ContainerElement nextElem = (ContainerElement)elements[j];
                if (!(nextElem.getContainerObject() instanceof Table)) continue;
                Table t2 = (Table)nextElem.getContainerObject();
                String t2Alias = nextElem.getContainerAlias();
                if (t1.getFKIndexAssociationsWith(t2).length > 0) {
                    fk = t1.getFKIndexAssociationsWith(t2);
                    for (a = 0; a < fk.length; ++a) {
                        if (!first) {
                            buff.append("\n");
                            buff.append("AND ");
                        } else {
                            first = false;
                        }
                        cols = fk[a].getColumns();
                        for (b = 0; b < cols.length; ++b) {
                            if (b > 0) {
                                buff.append("\n");
                                buff.append("AND ");
                            }
                            if (!t1Alias.trim().equalsIgnoreCase("")) {
                                buff.append(this.appendQuotes(t1Alias));
                                buff.append('.');
                            }
                            buff.append(this.appendQuotes(cols[b].getName()));
                            buff.append(" = ");
                            if (!t2Alias.trim().equalsIgnoreCase("")) {
                                buff.append(this.appendQuotes(t2Alias));
                                buff.append('.');
                            }
                            buff.append(this.appendQuotes(cols[b].getReferencedColumn(fk[a]).getName()));
                        }
                    }
                    continue;
                }
                if (t2.getFKIndexAssociationsWith(t1).length <= 0) continue;
                fk = t2.getFKIndexAssociationsWith(t1);
                for (a = 0; a < fk.length; ++a) {
                    if (!first) {
                        buff.append("\n");
                        buff.append("AND ");
                    } else {
                        first = false;
                    }
                    cols = fk[a].getColumns();
                    for (b = 0; b < cols.length; ++b) {
                        if (b > 0) {
                            buff.append("\n");
                            buff.append("AND ");
                        }
                        if (!t1Alias.trim().equalsIgnoreCase("")) {
                            buff.append(this.appendQuotes(t1Alias));
                            buff.append('.');
                        }
                        buff.append(this.appendQuotes(cols[b].getName()));
                        buff.append(" = ");
                        if (!t2Alias.trim().equalsIgnoreCase("")) {
                            buff.append(this.appendQuotes(t2Alias));
                            buff.append('.');
                        }
                        buff.append(this.appendQuotes(cols[b].getReferencedColumn(fk[a]).getName()));
                    }
                }
            }
        }
        return buff.toString();
    }

    protected String generateGroupBy() {
        StringBuffer buff = new StringBuffer();
        boolean first = true;
        for (ColumnElement elem : this.columnViewList) {
            if (!elem.getGroupBy()) continue;
            if (first) {
                first = false;
            } else {
                buff.append(",");
                buff.append("\n");
            }
            buff.append(this.getGroupByValue(elem.getColumnView()));
        }
        return buff.toString();
    }

    protected String generateSQL() {
        this.stopEdit();
        StringBuffer buff = new StringBuffer();
        if (this.selectedColumnsTable.getRowCount() > 0) {
            String alias;
            buff = new StringBuffer("CREATE VIEW ");
            buff.append(this.appendQuotes(this.view.getName()));
            int i = 0;
            for (Object elem : this.columnViewList) {
                ColumnView clmView = ((ColumnElement)elem).getColumnView();
                alias = clmView.getAlias().trim();
                if ("".equals(alias)) {
                    alias = ((ColumnElement)elem).getAlias();
                }
                if (clmView.toString().trim().equalsIgnoreCase("")) continue;
                if (i == 0) {
                    buff.append("\n");
                    buff.append("  (");
                } else {
                    buff.append(",\n   ");
                }
                buff.append(' ');
                if (!alias.trim().equalsIgnoreCase("")) {
                    buff.append(this.appendQuotes(alias));
                } else {
                    buff.append(this.appendQuotes(clmView.getReferencedName()));
                }
                ++i;
            }
            buff.append(' ');
            buff.append(')');
            buff.append("\n");
            buff.append("AS SELECT\n   ");
            i = 0;
            for (Object elem : this.columnViewList) {
                if (((ColumnElement)elem).getColumnView().toString().equalsIgnoreCase("")) continue;
                if (i > 0) {
                    buff.append(",\n   ");
                }
                buff.append(' ');
                String elem_alias = ((ColumnElement)elem).getAlias().trim();
                ColumnView cv = ((ColumnElement)elem).getColumnView();
                if (((ColumnElement)elem).getColumnView().getTableAlias().equalsIgnoreCase("")) {
                    if (!cv.getExpression().equals("")) {
                        buff.append(this.appendQuotes(cv.getExpression()));
                        if (!"".equals(elem_alias)) {
                            buff.append(" ").append(elem_alias);
                        }
                    } else if (!((ColumnElement)elem).getColumnView().getAlias().equalsIgnoreCase("")) {
                        buff.append(this.appendQuotes(((ColumnElement)elem).getColumnView().getAlias()));
                    } else {
                        buff.append(this.appendQuotes(((ColumnElement)elem).getColumnView().getName()));
                    }
                } else {
                    String alias2 = ((ColumnElement)elem).getColumnView().getTableAlias().trim();
                    if (!cv.getExpression().equals("")) {
                        buff.append(this.appendQuotes(cv.getExpression()));
                        if (!"".equals(elem_alias)) {
                            buff.append(" ").append(elem_alias);
                        }
                    } else if (!"".equals(alias2)) {
                        buff.append(this.appendQuotes(alias2) + "." + this.appendQuotes(((ColumnElement)elem).getColumnView().getReferencedName()));
                    } else {
                        buff.append(this.appendQuotes(((ColumnElement)elem).getColumnView().getReferencedName()));
                    }
                    if (((ColumnElement)elem).getColumnView().getAlias().length() > 0) {
                        buff.append(' ').append(this.appendQuotes(((ColumnElement)elem).getColumnView().getAlias()));
                    }
                }
                ++i;
            }
            if (this.containerList.size() > 0) {
                if (this.containerList.size() > 0) {
                    buff.append("\n");
                    buff.append(" FROM \n");
                }
                i = 0;
                for (Object elem : this.containerList) {
                    if (i > 0) {
                        buff.append(",\n    ");
                    } else {
                        buff.append("    ");
                    }
                    if (((ContainerElement)elem).getContainerObject() != null) {
                        String contName = ((ContainerElement)elem).getContainerObject().getName();
                        alias = ((ContainerElement)elem).getContainerAlias();
                        buff.append(this.appendQuotes(contName));
                        buff.append(' ');
                        buff.append(this.appendQuotes(alias));
                    }
                    ++i;
                }
            }
            if (!this.whereArea.getText().trim().equalsIgnoreCase("")) {
                buff.append("\n");
                buff.append(" WHERE \n");
                buff.append("    ");
                buff.append(this.whereArea.getText());
            }
            if (!this.groupByArea.getText().trim().equalsIgnoreCase("")) {
                buff.append("\n");
                buff.append(" GROUP BY \n");
                boolean first = true;
                Iterator it = this.columnViewList.iterator();
                buff.append("    ");
                while (it.hasNext()) {
                    ColumnElement elem = (ColumnElement)it.next();
                    if (!elem.getGroupBy()) continue;
                    if (first) {
                        first = false;
                    } else {
                        buff.append(",");
                        buff.append("\n");
                        buff.append("    ");
                    }
                    buff.append(this.appendQuotes(this.getValue(elem.getColumnView())));
                }
            }
            if (!this.havingArea.getText().trim().equalsIgnoreCase("")) {
                buff.append("\n");
                buff.append(" HAVING \n");
                buff.append("    ");
                buff.append(this.havingArea.getText());
            }
            if (this.orderByList.size() > 0) {
                buff.append("\n");
                buff.append(" ORDER BY \n");
                i = 0;
                for (OrderByElement elem : this.orderByList) {
                    String col = "";
                    String sort = elem.getSort();
                    for (ColumnElement el : this.columnViewList) {
                        if (!elem.getContainedObject().getName().equalsIgnoreCase(el.getColumnView().getName())) continue;
                        col = el.getAlias();
                        break;
                    }
                    if (col.equalsIgnoreCase("")) {
                        col = elem.getContainedObject().getName();
                    }
                    if (i > 0) {
                        buff.append(",\n   ");
                    } else {
                        buff.append("   ");
                    }
                    buff.append(' ');
                    buff.append(col);
                    buff.append(' ');
                    buff.append(sort);
                    ++i;
                }
                buff.append("\n");
            }
            buff.append(';');
        }
        return buff.toString();
    }

    public void initProperties(ContainerObject object) {
        if (object instanceof TableView) {
            this.view = (TableView)object;
            this.design = (RelationalDesign)this.view.getDesignPart();
            TableSet allTables = this.design.getTableSet();
            TableViewSet allViews = this.design.getTableViewSet();
            Iterator it = allTables.iterator();
            while (it.hasNext()) {
                this.allTablesModel.addElement(it.next());
            }
            it = allViews.iterator();
            while (it.hasNext()) {
                TableView v = (TableView)it.next();
                if (v == this.view) continue;
                this.allTablesModel.addElement(v);
            }
            for (int i = 0; i < this.view.getColumns().length; ++i) {
                ColumnView column = (ColumnView)this.view.getColumns()[i];
                if (this.view.getGroupByList().contains(column)) {
                    this.columnViewList.add(new ColumnElement(column, column.getAlias(), true));
                } else {
                    this.columnViewList.add(new ColumnElement(column, column.getAlias(), false));
                }
                if (column.getExpression().equalsIgnoreCase("")) continue;
                ColumnAlias ca = new ColumnAlias(column, column.getTableAlias());
                this.expressionList.add(ca);
                this.allColumnsOrderByModel.addElement(ca);
            }
            this.enableAll(!this.view.getUserDefined());
            this.whereArea.setText(this.view.getWhere());
            this.groupByArea.setText(this.view.getGroupBy());
            this.havingArea.setText(this.view.getHaving());
            for (AbstractView.ContainerHolder ch : this.view.getUsedContainers()) {
                String alias = ch.getAlias();
                ContainerObject container = ch.getContainer();
                if (container != null) {
                    ContainedObject[] cobjs = container.getElements();
                    for (int i = 0; i < cobjs.length; ++i) {
                        ContainedObject cob = cobjs[i];
                        this.allColumnsModel.addElement(new ColumnAlias(cob, alias));
                        this.allColumnsOrderByModel.addElement(new ColumnAlias(cob, alias));
                    }
                }
                if (container != null) {
                    this.containerList.add(new ContainerElement(container, alias));
                    continue;
                }
                this.view.getContainerMap().remove(alias);
            }
            if (!this.view.getUserDefined()) {
                for (ColumnView col : this.view.getOrderByList()) {
                    this.orderByList.add(new OrderByElement(col, this.view.getOrderByMap().get(col.getObjectID()).toString()));
                }
                this.sqlArea.setText(this.generateSQL());
                this.defineDDLChBox.setSelected(false);
                this.defineDDLArea.setEnabled(false);
                this.defineDDLArea.setText("");
            } else {
                this.defineDDLChBox.setSelected(true);
                this.defineDDLArea.setEnabled(true);
                this.defineDDLArea.setText(this.view.getUserDefinedSQL());
            }
        }
    }

    protected void setProperties() {
        if (this.view != null) {
            this.stopEdit();
            if (this.defineDDLChBox.isSelected()) {
                this.view.setUserDefined(true);
                String statement = this.defineDDLArea.getText();
                if (!this.getViewName(statement).trim().equalsIgnoreCase("")) {
                    this.view.setName(this.getViewName(statement));
                }
                this.view.setUserDefinedSQL(statement);
                this.view.removeAllElements();
                this.view.removeAllFromElements();
                this.view.removeAllFromOrderBy();
                this.view.removeAllGroupByList();
                this.view.setWhere("");
                this.view.setGroupBy("");
                this.view.setHaving("");
                this.view.getColumns(statement.replaceAll("\\s+", " ").replaceAll(" +", " "));
            } else {
                this.view.setUserDefined(false);
                this.view.setUserDefinedSQL(this.generateSQL());
                this.view.removeAllFromElements();
                for (ContainerElement elem : this.containerList) {
                    this.view.addToContainers(elem.getContainerObject(), elem.getContainerAlias());
                }
                ArrayList<ColumnView> cols = new ArrayList<ColumnView>();
                for (ColumnView c : this.view.getElementsCollection()) {
                    if (c.getName().trim().equalsIgnoreCase("")) continue;
                    boolean contains = false;
                    for (ColumnElement e : this.columnViewList) {
                        if (!e.getColumnView().getName().equalsIgnoreCase(c.getName())) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    cols.add(c);
                }
                Iterator it = cols.iterator();
                while (it.hasNext()) {
                    this.view.clear((ColumnView)it.next());
                }
                this.view.removeAllElements();
                this.view.removeAllGroupByList();
                ArrayList<ColumnView> list = new ArrayList<ColumnView>();
                for (ColumnElement elem : this.columnViewList) {
                    list.add(elem.getColumnView());
                    if (elem.getColumnView().getName().equalsIgnoreCase("")) continue;
                    if (elem.getColumnView().getReferencedColumnView() != null) {
                        if (elem.getAlias().equalsIgnoreCase("")) {
                            elem.getColumnView().setAlias(((ColumnView)elem.getColumnView().getReferencedColumnView()).getAlias());
                        } else {
                            elem.getColumnView().setAlias(elem.getAlias());
                        }
                    } else {
                        elem.getColumnView().setAlias(elem.getAlias());
                    }
                    this.view.add(elem.getColumnView());
                    if (!elem.getGroupBy()) continue;
                    this.view.addGroupByList(elem.getColumnView());
                }
                for (int i = 0; i < list.size(); ++i) {
                    this.view.moveToIndex((ContainedObject)list.get(i), i);
                }
                this.view.removeAllFromOrderBy();
                for (OrderByElement elem : this.orderByList) {
                    this.view.addToOrderBy(elem.getContainedObject(), elem.getSort());
                }
                this.view.setWhere(this.whereArea.getText());
                this.view.setGroupBy(this.generateGroupBy());
                this.view.setHaving(this.havingArea.getText());
            }
            this.view.setDirty(true);
        }
    }

    protected void clear() {
        this.allTablesModel.clear();
        Iterator it = this.containerList.iterator();
        while (it.hasNext()) {
            this.containerList.remove(0);
        }
        this.allColumnsModel.clear();
        int rows = this.selectedColumnsTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            this.columnViewList.remove(0);
        }
        this.allColumnsOrderByModel.clear();
        it = this.orderByList.iterator();
        while (it.hasNext()) {
            this.orderByList.remove(0);
        }
    }

    private String getViewName(String statement) {
        StringTokenizer tokenizer;
        String first = "";
        String name = "";
        String[] s = statement.split("\\s");
        for (int i = 0; i < s.length; ++i) {
            if (!s[i].equalsIgnoreCase("VIEW")) continue;
            name = s[i + 1];
            break;
        }
        if ((tokenizer = new StringTokenizer(name, ".")).countTokens() == 2) {
            first = tokenizer.nextToken().trim();
            first = Token.getValBetweenSquareBrackets(first);
            name = tokenizer.nextToken().trim();
            name = Token.getValBetweenSquareBrackets(name);
        }
        return name;
    }

    private void enableAll(boolean enabled) {
        this.whereArea.setEnabled(enabled);
        this.groupByArea.setEnabled(enabled);
        this.havingArea.setEnabled(enabled);
        this.allTablesList.setEnabled(enabled);
        this.allColumnsList.setEnabled(enabled);
        this.bnNewExpression.setEnabled(enabled);
        this.selectedTablesTable.setEnabled(enabled);
        this.selectedColumnsTable.setEnabled(enabled);
        this.selectedOrderByColumnsTable.setEnabled(enabled);
        this.bnNewOrderByColumns.setEnabled(enabled);
        this.allColumnsOrderByList.setEnabled(enabled);
        if (!enabled) {
            this.allTablesList.setSelectedIndices(new int[0]);
            this.allColumnsList.setSelectedIndices(new int[0]);
            this.allColumnsOrderByList.setSelectedIndices(new int[0]);
            this.selectedTablesTable.clearSelection();
            this.selectedColumnsTable.clearSelection();
            this.selectedOrderByColumnsTable.clearSelection();
        }
    }

    protected boolean canExit() {
        int k = 1;
        Object[] containers = this.containerList.toArray();
        for (int p = 0; p < containers.length - 1; ++p) {
            k = p + 1;
            ContainerElement element = (ContainerElement)containers[p];
            ContainerObject container = element.getContainerObject();
            String contAlias = element.getContainerAlias();
            for (int s = k; s < containers.length; ++s) {
                ContainerObject nextContainer = ((ContainerElement)containers[s]).getContainerObject();
                String nextAlias = ((ContainerElement)containers[s]).getContainerAlias();
                if (!nextAlias.equalsIgnoreCase("") && !contAlias.equalsIgnoreCase("") && nextAlias.equalsIgnoreCase(contAlias)) {
                    JOptionPane.showMessageDialog(this.dialog, Messages.getString("ViewBuilder.ThereAreTablesWithEqualNames"), Messages.getString("ViewBuilder.WrongAlias"), 0);
                    return false;
                }
                if (!nextAlias.equalsIgnoreCase("") || !contAlias.equalsIgnoreCase("") || !container.getName().equalsIgnoreCase(nextContainer.getName())) continue;
                JOptionPane.showMessageDialog(this.dialog, Messages.getString("ViewBuilder.ThereAreTablesWithEqualNames"), Messages.getString("ViewBuilder.WrongAlias"), 0);
                return false;
            }
        }
        Object[] elements = this.columnViewList.toArray();
        for (int i = 0; i <= elements.length - 1; ++i) {
            k = i + 1;
            ColumnElement elem = (ColumnElement)elements[i];
            ColumnView clmView = elem.getColumnView();
            String alias = elem.getAlias();
            String expression = clmView.getExpression();
            if (!this.checkExpression(expression, alias)) {
                JOptionPane.showMessageDialog(this.dialog, Messages.getString("ViewBuilder.ThereAreColumnExpressionsWithoutAnAlias"), Messages.getString("ViewBuilder.EmptyAlias"), 0);
                return false;
            }
            for (int j = k; j <= elements.length - 1; ++j) {
                ColumnView nextClmView = ((ColumnElement)elements[j]).getColumnView();
                String nextAlias = ((ColumnElement)elements[j]).getAlias();
                if (nextAlias.equalsIgnoreCase("") && alias.equalsIgnoreCase("")) {
                    if (!clmView.getReferencedName().equalsIgnoreCase(nextClmView.getReferencedName())) continue;
                    JOptionPane.showMessageDialog(this.dialog, Messages.getString("ViewBuilder.ThereAreColumnsWithEqualNames"), Messages.getString("ViewBuilder.WrongAlias"), 0);
                    return false;
                }
                if (nextAlias.equalsIgnoreCase(alias)) {
                    JOptionPane.showMessageDialog(this.dialog, Messages.getString("ViewBuilder.ThereAreColumnsWithEqualNames"), Messages.getString("ViewBuilder.WrongAlias"), 0);
                    return false;
                }
                if ((!alias.equalsIgnoreCase("") || !nextAlias.equalsIgnoreCase(clmView.getName())) && (!nextAlias.equalsIgnoreCase("") || !alias.equalsIgnoreCase(nextClmView.getName()))) continue;
                JOptionPane.showMessageDialog(this.dialog, Messages.getString("ViewBuilder.ThereAreColumnsWithEqualNames"), Messages.getString("ViewBuilder.WrongAlias"), 0);
                return false;
            }
        }
        return true;
    }

    public List getColumnViewList() {
        return this.columnViewList;
    }

    public void setColumnViewList(List columnViewList) {
        this.columnViewList = columnViewList;
    }

    public List getContainerList() {
        return this.containerList;
    }

    public void setContainerList(List containerList) {
        this.containerList = containerList;
    }

    private String getValue(ColumnView clmView) {
        String name = clmView.getReferencedName();
        ContainerObject container = clmView.getReferencedContainer();
        if (!clmView.getTableAlias().equalsIgnoreCase("")) {
            return name + "(" + clmView.getTableAlias() + ")";
        }
        if (container != null) {
            return name + "(" + container.getName() + ")";
        }
        if (!clmView.getExpression().equalsIgnoreCase("")) {
            return clmView.getExpression();
        }
        return name;
    }

    private String getGroupByValue(ColumnView clmView) {
        if (!"".equals(clmView.getExpression())) {
            return clmView.getExpression();
        }
        String name = this.appendQuotes(clmView.getName());
        if (!clmView.getTableAlias().equalsIgnoreCase("")) {
            return this.appendQuotes(clmView.getTableAlias()) + "." + name;
        }
        return name;
    }

    private void checkOrderByModel() {
        for (ColumnAlias clmAlias : this.expressionList) {
            if (this.allColumnsOrderByModel.contains(clmAlias)) continue;
            this.allColumnsOrderByModel.addElement(clmAlias);
        }
    }

    private ColumnAlias getColumnAlias(ColumnView av) {
        for (ColumnAlias clmAlias : this.expressionList) {
            if (clmAlias.getCol() != av) continue;
            return clmAlias;
        }
        return null;
    }

    private void checkModelsForValues(ContainerElement container, String oldValue, String newValue) {
        ColumnAlias colAlias;
        for (int i = 0; i < this.allColumnsModel.size(); ++i) {
            colAlias = (ColumnAlias)this.allColumnsModel.elementAt(i);
            if (!colAlias.getTableAlias().equalsIgnoreCase(oldValue) || !colAlias.getCol().getContainer().getName().equalsIgnoreCase(container.getContainerObject().getName())) continue;
            colAlias.setTableAlias(newValue);
            this.allColumnsModel.setElementAt(colAlias, i);
        }
        for (ColumnElement elem : this.columnViewList) {
            if ((!elem.getColumnView().getTableAlias().equalsIgnoreCase(oldValue) || elem.getColumnView().getTable() == null || !elem.getColumnView().getTable().getName().equalsIgnoreCase(container.getContainerObject().getName())) && (elem.getColumnView().getView() == null || !elem.getColumnView().getView().getName().equalsIgnoreCase(container.getContainerObject().getName()))) continue;
            elem.getColumnView().setTableAlias(newValue);
        }
        for (int i = 0; i < this.allColumnsOrderByModel.size(); ++i) {
            colAlias = (ColumnAlias)this.allColumnsOrderByModel.elementAt(i);
            if (!colAlias.getTableAlias().equalsIgnoreCase(oldValue) || !colAlias.getCol().getContainer().getName().equalsIgnoreCase(container.getContainerObject().getName())) continue;
            colAlias.setTableAlias(newValue);
            this.allColumnsOrderByModel.setElementAt(colAlias, i);
        }
        for (OrderByElement elem : this.orderByList) {
            if ((!((ColumnView)elem.getContainedObject()).getTableAlias().equalsIgnoreCase(oldValue) || ((ColumnView)elem.getContainedObject()).getTable() == null || !((ColumnView)elem.getContainedObject()).getTable().getName().equalsIgnoreCase(container.getContainerObject().getName())) && (((ColumnView)elem.getContainedObject()).getView() == null || !((ColumnView)elem.getContainedObject()).getView().getName().equalsIgnoreCase(container.getContainerObject().getName()))) continue;
            ((ColumnView)elem.getContainedObject()).setTableAlias(newValue);
        }
    }

    private boolean checkExpression(String expression, String alias) {
        return expression.equalsIgnoreCase("") || !alias.equalsIgnoreCase("");
    }

    private void stopTableCellEditing(JTable table) {
        int row = table.getEditingRow();
        int col = table.getEditingColumn();
        if (row > -1 && col > -1) {
            table.getCellEditor().stopCellEditing();
        }
    }

    class OrderByElement {
        ContainedObject containedObject;
        String sort;

        public OrderByElement(ContainedObject containedObject, String sort) {
            this.containedObject = containedObject;
            this.sort = sort;
        }

        public ContainedObject getContainedObject() {
            return this.containedObject;
        }

        public void setContainedObject(ContainedObject containedObject) {
            this.containedObject = containedObject;
        }

        public String getSort() {
            return this.sort;
        }

        public void setSort(String sort) {
            this.sort = sort;
        }
    }

    class ColumnElement {
        ColumnView columnView;
        String alias;
        boolean groupBy;

        public ColumnElement(ColumnView columnView, String alias) {
            this.columnView = columnView;
            this.alias = alias;
        }

        public ColumnElement(ColumnView columnView, String alias, boolean groupBy) {
            this(columnView, alias);
            this.groupBy = groupBy;
        }

        public ColumnView getColumnView() {
            return this.columnView;
        }

        public void setColumnView(ColumnView columnView) {
            this.columnView = columnView;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public boolean getGroupBy() {
            return this.groupBy;
        }

        public void setGroupBy(boolean groupBy) {
            this.groupBy = groupBy;
        }
    }

    class ContainerElement {
        ContainerObject containerObject;
        String containerAlias;

        public ContainerElement(ContainerObject containerObject, String containerAlias) {
            this.containerObject = containerObject;
            this.containerAlias = containerAlias;
        }

        public ContainerObject getContainerObject() {
            return this.containerObject;
        }

        public void setContainer(ContainerObject containerObject) {
            this.containerObject = containerObject;
        }

        public String getContainerAlias() {
            return this.containerAlias;
        }

        public void setContainerAlias(String containerAlias) {
            this.containerAlias = containerAlias;
        }
    }

    private class WhereListener
    implements ActionListener {
        private WhereListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ViewBuilder.this.whereArea.getText().trim().equalsIgnoreCase("")) {
                ViewBuilder.this.whereArea.setText(ViewBuilder.this.generateWhere());
            } else {
                ViewBuilder.this.whereArea.setText(ViewBuilder.this.generateWhere() + "\n" + ViewBuilder.this.whereArea.getText());
            }
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewBuilder.this.defineDDLArea.setEnabled(ViewBuilder.this.defineDDLChBox.isSelected());
            ViewBuilder.this.enableAll(!ViewBuilder.this.defineDDLChBox.isSelected());
            if (ViewBuilder.this.defineDDLChBox.isSelected()) {
                ViewBuilder.this.defineDDLArea.setText(ViewBuilder.this.generateSQL());
            } else {
                ViewBuilder.this.defineDDLArea.setText("");
                ViewBuilder.this.selectedColumnsTable.updateUI();
            }
        }
    }

    public class TabChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            if (ViewBuilder.this.tpane.getSelectedComponent() == ViewBuilder.this.tpane.getComponentAt(6)) {
                ViewBuilder.this.groupByArea.setText(ViewBuilder.this.generateGroupBy());
                ViewBuilder.this.sqlArea.setText(ViewBuilder.this.generateSQL());
            } else if (ViewBuilder.this.tpane.getSelectedComponent() == ViewBuilder.this.tpane.getComponentAt(3)) {
                ViewBuilder.this.groupByArea.setText(ViewBuilder.this.generateGroupBy());
            }
        }
    }

    class ColumnAlias {
        ContainedObject col;
        String tableAlias;

        public ColumnAlias(ContainedObject col, String tableAlias) {
            this.col = col;
            this.tableAlias = tableAlias;
        }

        public String getTableAlias() {
            return this.tableAlias;
        }

        public void setTableAlias(String tableAlias) {
            this.tableAlias = tableAlias;
        }

        public ContainedObject getCol() {
            return this.col;
        }

        public void setCol(ContainedObject col) {
            this.col = col;
        }
    }

    class AllListOrderByColumnsCellRenderer
    extends JLabel
    implements ListCellRenderer {
        AllListOrderByColumnsCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ColumnAlias col = (ColumnAlias)value;
            String alias = col.getTableAlias();
            String name = col.getCol().getName();
            StringBuffer buffer = null;
            buffer = !alias.equalsIgnoreCase("") ? new StringBuffer(alias).append(".").append(name) : new StringBuffer(name);
            this.setText(buffer.toString());
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(ViewBuilder.this.selectedTablesTable.getSelectionBackground());
                this.setForeground(Color.WHITE);
            } else {
                this.setBackground(ViewBuilder.this.selectedTablesTable.getBackground());
                this.setForeground(ViewBuilder.this.selectedTablesTable.getForeground());
            }
            return this;
        }
    }

    class AllListColumnsCellRenderer
    extends JLabel
    implements ListCellRenderer {
        AllListColumnsCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String cv_alias;
            ColumnAlias col = (ColumnAlias)value;
            String alias = col.getTableAlias();
            String name = col.getCol().getName();
            if (col.getCol() instanceof ColumnView && !"".equals(cv_alias = ((ColumnView)col.getCol()).getAlias().trim())) {
                name = cv_alias;
            }
            StringBuffer buffer = null;
            if (!alias.equalsIgnoreCase("")) {
                buffer = new StringBuffer(alias).append(".").append(name);
            } else if (col.getCol() instanceof Column) {
                buffer = new StringBuffer(col.getCol().getContainer().getName()).append(".").append(name);
            } else if (col.getCol() instanceof ColumnView) {
                buffer = new StringBuffer(col.getCol().getContainer().getName()).append(".").append(name);
            }
            if (buffer != null) {
                this.setText(buffer.toString());
            }
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(ViewBuilder.this.selectedTablesTable.getSelectionBackground());
                this.setForeground(Color.WHITE);
            } else {
                this.setBackground(ViewBuilder.this.selectedTablesTable.getBackground());
                this.setForeground(ViewBuilder.this.selectedTablesTable.getForeground());
            }
            return this;
        }
    }

    class AllListColumnsOrderBySelectionHandler
    implements ListSelectionListener {
        AllListColumnsOrderBySelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (ViewBuilder.this.allColumnsOrderByList.getSelectedIndex() == -1) {
                    ViewBuilder.this.bnAddOrderByColumns.setEnabled(false);
                } else {
                    ViewBuilder.this.bnAddOrderByColumns.setEnabled(true);
                }
            }
        }
    }

    class RemoveOrderByColumnsActionListener
    implements ActionListener {
        RemoveOrderByColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ViewBuilder.this.orderByList.size() > 0) {
                ArrayList list = new ArrayList();
                int[] selectedRows = ViewBuilder.this.selectedOrderByColumnsTable.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    list.add(ViewBuilder.this.orderByList.get(selectedRows[i]));
                }
                for (OrderByElement el : list) {
                    ViewBuilder.this.orderByList.remove(el);
                }
                ViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                ViewBuilder.this.selectedOrderByColumnsTable.clearSelection();
            }
        }
    }

    class NewOrderByColumnsActionListener
    implements ActionListener {
        NewOrderByColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnView v = new ColumnView(ViewBuilder.this.design);
            v.setExpression("");
            v.setName("");
            v.setDesign(ViewBuilder.this.view.getDesign());
            v.setContainer(ViewBuilder.this.view);
            ViewBuilder.this.orderByList.add(new OrderByElement(v, ""));
            ViewBuilder.this.selectedOrderByColumnsTable.updateUI();
        }
    }

    class AddOrderByColumnsActionListener
    implements ActionListener {
        AddOrderByColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ViewBuilder.this.allColumnsOrderByModel.isEmpty()) {
                Object[] selectedObjects = ViewBuilder.this.allColumnsOrderByList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    ColumnView v;
                    ColumnAlias col = (ColumnAlias)selectedObjects[i];
                    ContainedObject ob = col.getCol();
                    if (ob instanceof Column) {
                        v = new ColumnView(ViewBuilder.this.design);
                        v.setReferencedColumn((Column)ob);
                        v.setName(((Column)ob).getName());
                        v.setDesign(ViewBuilder.this.view.getDesign());
                        v.setTable((Table)ob.getContainer());
                        v.setContainer(ViewBuilder.this.view);
                        v.setTableAlias(col.getTableAlias());
                        v.setDataType(((Column)ob).getDataType().toString());
                        ViewBuilder.this.orderByList.add(new OrderByElement(v, "ASC"));
                        ViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                        continue;
                    }
                    if (!(ob instanceof ColumnView)) continue;
                    v = new ColumnView(ViewBuilder.this.design);
                    v.setReferencedColumnView(ob);
                    v.setName(ob.getName());
                    v.setDesign(ViewBuilder.this.view.getDesign());
                    v.setView((TableView)ob.getContainer());
                    v.setContainer(ViewBuilder.this.view);
                    v.setTableAlias(col.getTableAlias());
                    ViewBuilder.this.orderByList.add(new OrderByElement(v, "ASC"));
                    ViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                }
            }
        }
    }

    class AllListColumnsSelectionHandler
    implements ListSelectionListener {
        AllListColumnsSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (ViewBuilder.this.allColumnsList.getSelectedIndex() == -1) {
                    ViewBuilder.this.bnAddColumns.setEnabled(false);
                } else {
                    ViewBuilder.this.bnAddColumns.setEnabled(true);
                }
            }
        }
    }

    class RemoveColumnsActionListener
    implements ActionListener {
        RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ViewBuilder.this.columnViewList.size() > 0) {
                ArrayList list = new ArrayList();
                int[] selectedRows = ViewBuilder.this.selectedColumnsTable.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    list.add(ViewBuilder.this.columnViewList.get(selectedRows[i]));
                }
                for (ColumnElement el : list) {
                    ViewBuilder.this.columnViewList.remove(el);
                    ColumnAlias ca = ViewBuilder.this.getColumnAlias(el.getColumnView());
                    if (ca == null) continue;
                    ViewBuilder.this.expressionList.remove(ca);
                    ViewBuilder.this.allColumnsOrderByModel.removeElement(ca);
                    for (int i = ViewBuilder.this.orderByList.size() - 1; i >= 0; --i) {
                        OrderByElement element = (OrderByElement)ViewBuilder.this.orderByList.get(i);
                        if (element.getContainedObject() != ca.getCol()) continue;
                        ViewBuilder.this.orderByList.remove(element);
                        ViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                    }
                }
                ViewBuilder.this.selectedColumnsTable.updateUI();
                ViewBuilder.this.selectedColumnsTable.clearSelection();
            }
        }
    }

    class NewExpressionActionListener
    implements ActionListener {
        NewExpressionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnView v = new ColumnView(ViewBuilder.this.design);
            v.setExpression("");
            v.setName("");
            v.setDesign(ViewBuilder.this.view.getDesign());
            v.setContainer(ViewBuilder.this.view);
            ViewBuilder.this.columnViewList.add(new ColumnElement(v, v.getAlias(), false));
            ViewBuilder.this.selectedColumnsTable.updateUI();
            ViewBuilder.this.expressionList.add(new ColumnAlias(v, v.getAlias()));
        }
    }

    class AddColumnsActionListener
    implements ActionListener {
        AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ViewBuilder.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = ViewBuilder.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    ColumnView v;
                    ColumnAlias col = (ColumnAlias)selectedObjects[i];
                    ContainedObject ob = col.getCol();
                    if (ob instanceof Column) {
                        v = new ColumnView(ViewBuilder.this.design);
                        v.setReferencedColumn((Column)ob);
                        v.setName(((Column)ob).getName());
                        v.setDesign(ViewBuilder.this.view.getDesign());
                        v.setTable((Table)ob.getContainer());
                        v.setContainer(ViewBuilder.this.view);
                        v.setTableAlias(col.getTableAlias());
                        v.setDataType(((Column)ob).getDataType().toString());
                        ViewBuilder.this.columnViewList.add(new ColumnElement(v, v.getAlias(), false));
                        ViewBuilder.this.selectedColumnsTable.updateUI();
                        continue;
                    }
                    if (!(ob instanceof ColumnView)) continue;
                    v = new ColumnView(ViewBuilder.this.design);
                    v.setReferencedColumn(((ColumnView)ob).getReferencedColumn());
                    v.setName(ob.getName());
                    v.setDesign(ViewBuilder.this.view.getDesign());
                    v.setReferencedColumnView(ob);
                    v.setView((TableView)ob.getContainer());
                    v.setContainer(ViewBuilder.this.view);
                    v.setTableAlias(col.getTableAlias());
                    ViewBuilder.this.columnViewList.add(new ColumnElement(v, v.getAlias(), false));
                    ViewBuilder.this.selectedColumnsTable.updateUI();
                }
            }
        }
    }

    class SelectedTablesTable
    extends JTable {
        SelectedTablesTable() {
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (!ViewBuilder.this.defineDDLChBox.isSelected()) {
                if (col == 1) {
                    return new TextCellEditor();
                }
                return super.getCellEditor();
            }
            return null;
        }
    }

    class SelectedTablesModel
    extends AbstractTableModel {
        SelectedTablesModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ViewBuilder.this.containerList.size();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return Messages.getString("ViewBuilder.Tables");
            }
            if (col == 1) {
                return Messages.getString("ViewBuilder.Alias");
            }
            return "";
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ContainerElement container = (ContainerElement)ViewBuilder.this.containerList.get(row);
            if (col == 0) {
                return container.getContainerObject();
            }
            if (col == 1) {
                return container.getContainerAlias();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object newValue, int row, int col) {
            ContainerElement container = (ContainerElement)ViewBuilder.this.containerList.get(row);
            if (col == 0) {
                container.setContainer((ContainerObject)newValue);
            }
            if (col == 1) {
                String oldValue = container.getContainerAlias();
                container.setContainerAlias((String)newValue);
                ViewBuilder.this.checkModelsForValues(container, oldValue, (String)newValue);
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }
    }

    class SelectedTablesHandler
    implements ListSelectionListener {
        SelectedTablesHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ViewBuilder.this.selectedTablesTable.getSelectedRow() > -1) {
                ViewBuilder.this.bnRemoveTables.setEnabled(true);
            } else {
                ViewBuilder.this.bnRemoveTables.setEnabled(false);
            }
        }
    }

    class ComboCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        ComboCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cbox.setModel(new DefaultComboBoxModel<String>(new String[]{"ASC", "DESC"}));
            return this.cbox;
        }
    }

    class ExpressionCellEditor
    extends DefaultCellEditor {
        JTextField tfield;

        ExpressionCellEditor() {
            super(new JTextField());
            this.tfield = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof ColumnView) {
                ColumnView cv = (ColumnView)value;
                if (!cv.getExpression().equalsIgnoreCase("")) {
                    this.tfield.setText(cv.getExpression());
                } else {
                    this.tfield.setText(cv.getName());
                }
            } else {
                this.tfield.setText(value == null ? "" : "" + value.toString());
            }
            this.tfield.setBorder(null);
            return this.tfield;
        }
    }

    class TextCellEditor
    extends DefaultCellEditor {
        JTextField tfield;

        TextCellEditor() {
            super(new JTextField());
            this.tfield = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof ColumnView && ((ColumnView)value).getTableAlias().equalsIgnoreCase(ViewBuilder.this.view.getName())) {
                this.tfield.setText(((ColumnView)value).getExpression());
            } else {
                this.tfield.setText(value == null ? "" : "" + value.toString());
            }
            this.tfield.setBorder(null);
            return this.tfield;
        }
    }

    class SelectedOrderByColumnsTable
    extends JTable {
        SelectedOrderByColumnsTable() {
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (!ViewBuilder.this.defineDDLChBox.isSelected()) {
                if (col == 0) {
                    return new TextCellEditor();
                }
                return new ComboCellEditor();
            }
            return null;
        }
    }

    class SelectedOrderByColumnsModel
    extends AbstractTableModel {
        SelectedOrderByColumnsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ViewBuilder.this.orderByList.size();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return Messages.getString("ViewBuilder.ColumnsExpression");
            }
            if (col == 1) {
                return Messages.getString("ViewBuilder.Sort");
            }
            return "";
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            OrderByElement elem = (OrderByElement)ViewBuilder.this.orderByList.get(row);
            if (col == 0) {
                return elem.getContainedObject();
            }
            if (col == 1) {
                return elem.getSort();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            OrderByElement elem = (OrderByElement)ViewBuilder.this.orderByList.get(row);
            if (col == 0) {
                if (value instanceof ColumnView) {
                    elem.setContainedObject((ColumnView)value);
                } else {
                    ColumnView cv = (ColumnView)elem.getContainedObject();
                    cv.setExpression((String)value);
                    cv.setName((String)value);
                }
            } else if (col == 1) {
                elem.setSort((String)value);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            OrderByElement elem = (OrderByElement)ViewBuilder.this.orderByList.get(row);
            return col != 0 || ((ColumnView)elem.getContainedObject()).getTable() == null && ((ColumnView)elem.getContainedObject()).getView() == null;
        }
    }

    class SelectedOrderByColumnsHandler
    implements ListSelectionListener {
        SelectedOrderByColumnsHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ViewBuilder.this.selectedOrderByColumnsTable.getSelectedRow() > -1) {
                ViewBuilder.this.bnRemoveOrderByColumns.setEnabled(true);
            } else {
                ViewBuilder.this.bnRemoveOrderByColumns.setEnabled(false);
            }
        }
    }

    class CheckBoxTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckBoxTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(0);
            this.setSelected((Boolean)value);
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(2);
            if (value instanceof ColumnView && ((ColumnView)value).getTableAlias().equalsIgnoreCase(ViewBuilder.this.view.getName())) {
                this.setText(((ColumnView)value).getExpression());
            } else {
                this.setText(value == null ? "" : "" + value.toString());
            }
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(ViewBuilder.this.allTablesList.getSelectionBackground());
                this.setForeground(Color.WHITE);
            } else {
                this.setBackground(ViewBuilder.this.allTablesList.getBackground());
                this.setForeground(ViewBuilder.this.allTablesList.getForeground());
            }
            return this;
        }
    }

    class CheckBoxEditor
    extends DefaultCellEditor {
        JCheckBox cbox;

        CheckBoxEditor() {
            super(new JCheckBox());
            this.cbox = (JCheckBox)this.getComponent();
            this.cbox.setHorizontalAlignment(0);
        }
    }

    class SelectedColumnsModel
    extends AbstractTableModel {
        SelectedColumnsModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return ViewBuilder.this.columnViewList.size();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return Messages.getString("ViewBuilder.ColumnsExpression");
            }
            if (col == 1) {
                return Messages.getString("ViewBuilder.Alias");
            }
            if (col == 2) {
                return Messages.getString("ViewBuilder.GroupBy");
            }
            return "";
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            ColumnElement value;
            return column != 0 || (value = (ColumnElement)ViewBuilder.this.columnViewList.get(row)).getColumnView().getTable() == null && value.getColumnView().getView() == null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ColumnElement object = (ColumnElement)ViewBuilder.this.columnViewList.get(row);
            if (col == 0) {
                if (value instanceof ColumnView) {
                    object.setColumnView((ColumnView)value);
                } else {
                    ColumnView v = object.getColumnView();
                    v.setExpression((String)value);
                    v.setName((String)value);
                    ViewBuilder.this.checkOrderByModel();
                }
            } else if (col == 1) {
                object.setAlias((String)value);
            } else if (col == 2) {
                object.setGroupBy((Boolean)value);
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            ColumnElement object = (ColumnElement)ViewBuilder.this.columnViewList.get(row);
            if (col == 0) {
                return ViewBuilder.this.getValue(object.getColumnView());
            }
            if (col == 1) {
                return object.getAlias();
            }
            if (col == 2) {
                return object.getGroupBy();
            }
            return new Integer(row * col);
        }
    }

    class SelectedColumnsHandler
    implements ListSelectionListener {
        SelectedColumnsHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ViewBuilder.this.selectedColumnsTable.getSelectedRow() > -1) {
                ViewBuilder.this.bnRemoveColumns.setEnabled(true);
            } else {
                ViewBuilder.this.bnRemoveColumns.setEnabled(false);
            }
        }
    }

    class AllListTablesSelectionHandler
    implements ListSelectionListener {
        AllListTablesSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (ViewBuilder.this.allTablesList.getSelectedIndex() == -1) {
                    ViewBuilder.this.bnAddTables.setEnabled(false);
                } else {
                    ViewBuilder.this.bnAddTables.setEnabled(true);
                }
            }
        }
    }

    class RemoveTablesActionListener
    implements ActionListener {
        RemoveTablesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ViewBuilder.this.containerList.size() > 0) {
                ArrayList list = new ArrayList();
                int[] selectedRows = ViewBuilder.this.selectedTablesTable.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    list.add(ViewBuilder.this.containerList.get(selectedRows[i]));
                }
                for (ContainerElement elem : list) {
                    Object obj;
                    Enumeration enumeration;
                    Object obj22;
                    Enumeration enumeration2;
                    ContainedObject col;
                    ContainerObject ob = elem.getContainerObject();
                    if (ob instanceof Table) {
                        for (int k = 0; k < ob.getElements().length; ++k) {
                            col = (Column)ob.getElements()[k];
                            enumeration2 = ViewBuilder.this.allColumnsModel.elements();
                            while (enumeration2.hasMoreElements()) {
                                obj22 = (ColumnAlias)enumeration2.nextElement();
                                if (((ColumnAlias)obj22).getCol() != col || !elem.getContainerAlias().equalsIgnoreCase(((ColumnAlias)obj22).getTableAlias())) continue;
                                ViewBuilder.this.allColumnsModel.removeElement(obj22);
                            }
                            for (Object obj22 : ViewBuilder.this.columnViewList) {
                                if (((ColumnElement)obj22).getColumnView().getReferencedColumn() != col || ((ColumnElement)obj22).getColumnView().getView() != null && ((ColumnElement)obj22).getColumnView().getView() != ViewBuilder.this.view || ((ColumnElement)obj22).getColumnView().getContainer() != ob && ((ColumnElement)obj22).getColumnView().getContainer() != ViewBuilder.this.view) continue;
                                ViewBuilder.this.columnViewList.remove(obj22);
                                ViewBuilder.this.selectedColumnsTable.updateUI();
                                break;
                            }
                            enumeration = ViewBuilder.this.allColumnsOrderByModel.elements();
                            while (enumeration.hasMoreElements()) {
                                obj = (ColumnAlias)enumeration.nextElement();
                                if (((ColumnAlias)obj).getCol() != col || !elem.getContainerAlias().equalsIgnoreCase(((ColumnAlias)obj).getTableAlias())) continue;
                                ViewBuilder.this.allColumnsOrderByModel.removeElement(obj);
                            }
                            for (OrderByElement element : ViewBuilder.this.orderByList) {
                                obj = (ColumnView)element.getContainedObject();
                                if (((AbstractViewElement)obj).getReferencedColumn() != col || ((AbstractViewElement)obj).getView() != null && ((AbstractViewElement)obj).getView() != ViewBuilder.this.view || ((ContainedObject)obj).getContainer() != ob && ((ContainedObject)obj).getContainer() != ViewBuilder.this.view) continue;
                                ViewBuilder.this.orderByList.remove(element);
                                ViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                            }
                        }
                    } else if (ob instanceof TableView) {
                        for (int j = 0; j < ((TableView)ob).getColumns().length; ++j) {
                            col = (ColumnView)((TableView)ob).getColumns()[j];
                            enumeration2 = ViewBuilder.this.allColumnsModel.elements();
                            while (enumeration2.hasMoreElements()) {
                                obj22 = (ColumnAlias)enumeration2.nextElement();
                                if (((ColumnAlias)obj22).getCol() != col || !elem.getContainerAlias().equalsIgnoreCase(((ColumnAlias)obj22).getTableAlias())) continue;
                                ViewBuilder.this.allColumnsModel.removeElement(obj22);
                            }
                            for (ColumnElement clmView : ViewBuilder.this.columnViewList) {
                                if (clmView.getColumnView().getReferencedColumn() != ((AbstractViewElement)col).getReferencedColumn() || !elem.getContainerAlias().equalsIgnoreCase(clmView.getColumnView().getTableAlias())) continue;
                                ViewBuilder.this.columnViewList.remove(clmView);
                                ViewBuilder.this.selectedColumnsTable.updateUI();
                                break;
                            }
                            enumeration = ViewBuilder.this.allColumnsOrderByModel.elements();
                            while (enumeration.hasMoreElements()) {
                                obj = (ColumnAlias)enumeration.nextElement();
                                if (((ColumnAlias)obj).getCol() != col || !elem.getContainerAlias().equalsIgnoreCase(((ColumnAlias)obj).getTableAlias())) continue;
                                ViewBuilder.this.allColumnsOrderByModel.removeElement(obj);
                            }
                            for (OrderByElement element : ViewBuilder.this.orderByList) {
                                if (((ColumnView)element.getContainedObject()).getReferencedColumn() != ((AbstractViewElement)col).getReferencedColumn() || !elem.getContainerAlias().equalsIgnoreCase(((ColumnView)element.getContainedObject()).getTableAlias())) continue;
                                ViewBuilder.this.orderByList.remove(element);
                                ViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                            }
                        }
                    }
                    ViewBuilder.this.containerList.remove(elem);
                    ViewBuilder.this.selectedTablesTable.updateUI();
                }
            }
        }
    }

    class AddTablesActionListener
    implements ActionListener {
        AddTablesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ViewBuilder.this.allTablesModel.isEmpty()) {
                Object[] selectedObjects = ViewBuilder.this.allTablesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    ContainedObject col;
                    int j;
                    ContainerObject ob = (ContainerObject)selectedObjects[i];
                    String alias = this.generateAlias(ob);
                    ViewBuilder.this.containerList.add(new ContainerElement(ob, alias));
                    ViewBuilder.this.selectedTablesTable.updateUI();
                    if (ob instanceof Table) {
                        for (j = 0; j < ob.getElements().length; ++j) {
                            col = (Column)ob.getElements()[j];
                            ViewBuilder.this.allColumnsModel.addElement(new ColumnAlias(col, alias));
                            ViewBuilder.this.allColumnsOrderByModel.addElement(new ColumnAlias(col, alias));
                        }
                        continue;
                    }
                    if (!(ob instanceof TableView)) continue;
                    for (j = 0; j < ((TableView)ob).getColumns().length; ++j) {
                        col = (ColumnView)((TableView)ob).getColumns()[j];
                        ViewBuilder.this.allColumnsModel.addElement(new ColumnAlias(col, alias));
                        ViewBuilder.this.allColumnsOrderByModel.addElement(new ColumnAlias(col, alias));
                    }
                }
            }
        }

        private String generateAlias(ContainerObject ob) {
            ArrayList<String> list = new ArrayList<String>();
            Iterator it = ViewBuilder.this.containerList.iterator();
            while (it.hasNext()) {
                list.add(((ContainerElement)it.next()).getContainerAlias());
            }
            if (!list.contains(ob.getName())) {
                return ob.getName();
            }
            StringBuffer buffer = new StringBuffer(ob.getName());
            String newName = ob.getName();
            buffer.append("v");
            int length = buffer.length();
            for (int i = 1; i <= list.size(); ++i) {
                buffer.setLength(length);
                buffer.append(i);
                newName = buffer.toString();
                if (list.contains(newName)) continue;
                return newName;
            }
            return null;
        }
    }
}

