/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.engineering;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolderRecursive;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.engineering.Messages;

public class StaticLogicalDesign
extends DesignObject {
    LogicalDesign design;
    DesignObjectCollection entities;
    DesignObjectCollection relations;
    DesignObjectCollection inheritances;
    DesignObjectCollection candkeys;

    public StaticLogicalDesign(LogicalDesign design) {
        super(design);
        this.setDesign(design.getDesign());
        this.setName(Messages.getString("StaticLogicalDesign.LogicalModel"));
        this.design = design;
        this.loadEntities();
        this.loadRelations();
        this.loadCandkeys();
    }

    private void loadElements(DesignObjectCollection col, Iterator it) {
        while (it.hasNext()) {
            DesignObject object = (DesignObject)it.next();
            col.add(new DesignObjectPlaceHolder((DesignPart)this.design, object));
        }
    }

    private void loadContainerElements(DesignObjectCollection col, Iterator it) {
        while (it.hasNext()) {
            DesignObject object = (DesignObject)it.next();
            col.add(new ContainerObjectPlaceHolderRecursive(this.design, object, true));
        }
    }

    private void loadEntities() {
        this.entities = new DesignObjectCollection();
        this.entities.setName(Messages.getString("StaticLogicalDesign.Entities"));
        this.entities.setParent(this);
        this.entities.setElementDescriptor(Entity.class);
        this.loadContainerElements(this.entities, this.design.getEntitySet().iterator());
    }

    private void loadRelations() {
        this.relations = new DesignObjectCollection();
        this.relations.setName(Messages.getString("StaticLogicalDesign.Relations"));
        this.relations.setParent(this);
        this.relations.setElementDescriptor(Relation.class);
        this.loadElements(this.relations, this.design.getRelationSet().iterator());
    }

    private void loadCandkeys() {
        this.candkeys = new DesignObjectCollection();
        this.candkeys.setName(Messages.getString("StaticLogicalDesign.CandidateKeys"));
        this.candkeys.setParent(this);
        this.candkeys.setElementDescriptor(CandidateKey.class);
        this.loadElements(this.candkeys, this.design.getGlobalCandidateKeySet().iterator());
    }

    @Override
    public int getNumberOfChildren() {
        return 3;
    }

    @Override
    public void setShouldEngineer(boolean value) {
        super.setShouldEngineer(value);
        this.propagateShouldEngineer(value);
    }

    public void propagateShouldEngineer(boolean selected) {
        int k = this.getNumberOfChildren();
        for (int i = 0; i < k; ++i) {
            ModelObject object = this.getChild(i);
            if (object instanceof DesignObject) {
                DesignObject dp = (DesignObject)object;
                dp.setShouldEngineer(selected);
                continue;
            }
            if (!(object instanceof DesignObjectCollection)) continue;
            DesignObjectCollection col = (DesignObjectCollection)object;
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof DesignObject)) continue;
                DesignObject dp = (DesignObject)obj;
                dp.setShouldEngineer(selected);
            }
        }
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.entities;
            }
            case 1: {
                return this.candkeys;
            }
            case 2: {
                return this.relations;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.entities) {
            return 0;
        }
        if (child == this.candkeys) {
            return 1;
        }
        if (child == this.relations) {
            return 2;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getObjectTypeName() {
        return null;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return false;
    }

    @Override
    public String getIDPrefix() {
        return null;
    }

    @Override
    public void showPropertyDialog() {
    }
}

