/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.engineeringcompare;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareTreeRenderer;
import oracle.dbtools.crest.swingui.engineeringcompare.EngineeringCompareDialog;
import oracle.dbtools.crest.swingui.engineeringcompare.Messages;

public class CompareCheckEditor
extends CompareTreeRenderer
implements TreeCellEditor,
ActionListener {
    private Set listeners = new HashSet();
    protected CellEditorListener list;

    public CompareCheckEditor(boolean showCheckbox) {
        super(showCheckbox);
        this.cbox.addActionListener(this);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        Component comp = this.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
        return comp;
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        this.enableEngineerButton();
        return this.node;
    }

    private void enableEngineerButton() {
        if (this.node instanceof ModelIdObjectSelection) {
            boolean gen = this.node.checkSelected();
            String str = "checkSelected() is " + String.valueOf(gen);
            String eng = Messages.getString("EngineeringCompareDialog.Engineer");
            Container top = this.getParentDialog(this.panel);
            if (top != null && top instanceof EngineeringCompareDialog) {
                EngineeringCompareDialog dial = (EngineeringCompareDialog)top;
                dial.enableButton(eng, gen);
            }
        }
    }

    private Container getParentDialog(Container cont) {
        if (cont instanceof EngineeringCompareDialog) {
            return cont;
        }
        Container par = cont.getParent();
        if (par == null) {
            return cont;
        }
        return this.getParentDialog(par);
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        MouseEvent e;
        JTree tree;
        TreePath selPath;
        Object obj = event.getSource();
        if (obj instanceof JTree && event instanceof MouseEvent && (selPath = (tree = (JTree)obj).getPathForLocation((e = (MouseEvent)event).getX(), e.getY())) != null) {
            this.node = (EngineeringObjectSelection)selPath.getLastPathComponent();
        }
        if (this.node != null) {
            return this.node.isEditable();
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireEditingStopped() {
        CellEditorListener[] ls = this.listeners.toArray(new CellEditorListener[0]);
        for (int i = 0; i < ls.length; ++i) {
            try {
                ls[i].editingStopped(new ChangeEvent(this));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] ls = this.listeners.toArray(new CellEditorListener[0]);
        for (int i = 0; i < ls.length; ++i) {
            try {
                ls[i].editingCanceled(new ChangeEvent(this));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.node.setSelected(this.cbox.isSelected());
    }
}

