/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.printing.Messages;
import oracle.dbtools.crest.swingui.printing.PrintPreviewModel;
import oracle.dbtools.crest.swingui.printing.UnicodeFontMapper;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PDFPrinter {
    private static UnicodeFontMapper unicodeMapper = new UnicodeFontMapper();
    private PrintPreviewModel model;
    private PrinterJob prnJob;
    private boolean printToPDF;
    private static File lastFolder = null;
    private static final Logger LOGGER = new Logger(PDFPrinter.class);

    public PDFPrinter(PrinterJob prnJob, PrintPreviewModel model, boolean printToPDF) {
        this.prnJob = prnJob;
        this.model = model;
        this.printToPDF = printToPDF;
    }

    private boolean diagramToPDF(String pdfFile, OutputStream outputStream) {
        Document document = new Document();
        try {
            int pn = this.model.getNumberOfPages();
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PageFormat pageFormat = (PageFormat)this.model.getPageFormat().clone();
            float width = (float)pageFormat.getWidth();
            float height = (float)pageFormat.getHeight();
            if (pageFormat.getOrientation() == 0) {
                width = (float)pageFormat.getHeight();
                height = (float)pageFormat.getWidth();
            }
            document.setPageSize(new Rectangle(width, height));
            for (int i = 0; i < pn; ++i) {
                document.newPage();
                PdfGraphics2D g2d = new PdfGraphics2D(cb, width, height, (FontMapper)unicodeMapper);
                this.model.print((Graphics)g2d, null, i);
                g2d.dispose();
            }
            outputStream.flush();
            document.close();
            outputStream.close();
            return true;
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
    }

    public void print() {
        try {
            Diagram diagram = (Diagram)this.model.getObjectToPrint();
            File mergedPDF = File.createTempFile("Merged", ".pdf");
            mergedPDF.deleteOnExit();
            FileOutputStream output = new FileOutputStream(mergedPDF.getAbsolutePath());
            if (this.diagramToPDF(mergedPDF.getAbsolutePath(), output)) {
                if (this.printToPDF) {
                    this.savePDF(diagram.getAppView(), mergedPDF, diagram.getDesignPartView().getName());
                } else {
                    PDDocument doc = PDDocument.load((File)mergedPDF);
                    this.prnJob.setJobName(diagram.getDesignPartView().getName());
                    doc.silentPrint(this.prnJob);
                    doc.close();
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("SVGPrinter.export", e);
            MessageDialogs.showErrorMessage("Error occures while printing diagram.", true);
        }
    }

    private void savePDF(ApplicationView appView, File pdfFile, String diagramName) {
        try {
            File newFile;
            URLFilter filter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".pdf") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("SVGExporter.PDFFiles");
                }
            };
            URLChooser fileChooser = DialogUtil.newURLChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(filter);
            if (lastFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String lastDir = appView.getSettings().getDefaultSavePath();
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = appView.getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            fileChooser.setFileNameURL(diagramName + ".pdf");
            int status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("SVGExporter.SaveAsPDF"));
            if (status == 0 && (newFile = new File(fileChooser.getSelectedURL().getPath())) != null) {
                int length;
                int result;
                lastFolder = newFile.getParentFile();
                FileOpenHistory.getInstance().updateFileHistory(lastFolder.toURI().toURL());
                if (newFile.exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("SVGExporter.FileExists"), newFile.getAbsolutePath()), Messages.getString("SVGExporter.Warning"), 0, 3, null)) == 1) {
                    return;
                }
                FileInputStream inStream = new FileInputStream(pdfFile);
                FileOutputStream outStream = new FileOutputStream(newFile);
                byte[] buffer = new byte[1024];
                while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                    ((OutputStream)outStream).write(buffer, 0, length);
                }
                ((InputStream)inStream).close();
                ((OutputStream)outStream).close();
                Desktop.getDesktop().open(newFile);
            }
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("SVGExporter.ErrorSavingPDF"), t.getMessage()}, Messages.getString("SVGExporter.Error"), 0);
        }
    }
}

