/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.process;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.TVLegend;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.process.ControllerProcess;
import oracle.dbtools.crest.swingui.process.TVAgent;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.swingui.process.TVInfoStore;
import oracle.dbtools.crest.swingui.process.TVProcess;

public class DPVProcess
extends DesignPartView {
    private static final Dimension TOPVIEW_SIZE = new Dimension(280, 320);
    private ControllerProcess controller;
    private JPopupMenu menu;
    private JMenuItem miPaste;
    private JCheckBoxMenuItem miAutoRoute;
    private JCheckBoxMenuItem miGoToParent;
    private JCheckBoxMenuItem miShowGrid;
    private JCheckBoxMenuItem miShowPageGrid;
    private JMenu detailsMenu;
    private JCheckBoxMenuItem miAllDetails;
    private JCheckBoxMenuItem miNameOnly;
    private JCheckBoxMenuItem miShowLegend;
    private JCheckBoxMenuItem miShowLabels;
    private DataFlowDesign parentDFD;
    public static final String TOOLBAR_NAME = "Process Model";

    public DPVProcess(ApplicationView applicationView, DesignPart desPart) {
        super(applicationView, desPart);
        this.controller = new ControllerProcess(applicationView);
        this.controller.setName("Process");
        this.controller.setDesignPartView(this);
        ((DataFlowDesign)desPart).getProcessModel().addDesignPartListener(this);
    }

    @Override
    public TopView createViewFor(DesignObject object) {
        return this.createTopViewFor(object);
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    private boolean canCreateViewForGlobalObject(DesignObject object) {
        return this.getApplicationView().getCurrentDPV() == this && !ApplicationView.loading;
    }

    public TopView createViewSynonim(DesignObject object) {
        AbstractProcessObject po = (AbstractProcessObject)object;
        TopView tv = po.getFirstViewForDPV(this);
        if (tv == null) {
            if (object instanceof ExternalAgent) {
                tv = new TVAgent(this.getApplicationView(), this);
            } else if (object instanceof InfoStore) {
                tv = new TVInfoStore(this.getApplicationView(), this);
            } else if (object instanceof Flow) {
                tv = new TVFlow(this.getApplicationView(), this);
            } else if (object instanceof Process) {
                tv = new TVProcess(this.getApplicationView(), this);
            }
        }
        if (tv != null) {
            tv.setModel(object);
            this.modelToView.put(object, tv);
            this.add(tv);
            ((DataFlowDesign)this.getDesignPart()).registerLocalObject(tv);
        }
        return tv;
    }

    @Override
    public void registerForTreemodel(TopView tv) {
        ((DataFlowDesign)this.getDesignPart()).registerLocalObject(tv);
    }

    @Override
    public void unregisterFromTreemodel(TopView tv) {
        if (tv != null) {
            ((DataFlowDesign)this.getDesignPart()).unRegisterLocalObject(tv);
            this.unregisterTopView(tv);
        }
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart desPart) {
        return new DPVProcess(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    public TopView createTopViewFor(DesignObject object) {
        TopView view = null;
        if (object instanceof Process) {
            TVProcess tv = new TVProcess(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
        } else {
            if (object instanceof Note) {
                TVNote tvv = new TVNote(this.getApplicationView(), this);
                tvv.setModel(object);
                return tvv;
            }
            if (object instanceof Legend) {
                TVLegend tv = new TVLegend(this.getApplicationView(), this);
                tv.setModel(object);
                return tv;
            }
            if (object instanceof ExternalAgent && this.canCreateViewForGlobalObject(object)) {
                TVAgent tvv = new TVAgent(this.getApplicationView(), this);
                tvv.setModel(object);
                ((DataFlowDesign)this.getDesignPart()).registerLocalObject(tvv);
                return tvv;
            }
            if (object instanceof InfoStore && this.canCreateViewForGlobalObject(object)) {
                TVInfoStore tvv = new TVInfoStore(this.getApplicationView(), this);
                tvv.setModel(object);
                ((DataFlowDesign)this.getDesignPart()).registerLocalObject(tvv);
                return tvv;
            }
            if (object instanceof Flow) {
                TVFlow tvf = new TVFlow(this.getApplicationView(), this);
                tvf.setModel(object);
                view = tvf;
            } else if (object instanceof DiagramView) {
                TVDiagramView tv = new TVDiagramView(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
            } else if (object instanceof Label) {
                TVLabel tv = new TVLabel(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
            } else {
                return null;
            }
        }
        view.setSize(new Dimension(TOPVIEW_SIZE));
        this.registerForTreemodel(view);
        this.setDirty(true);
        return view;
    }

    @Override
    public TopView createTopViewForGlobal(DesignObject object) {
        TopView view = null;
        if (object instanceof Process) {
            TVProcess tv = new TVProcess(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
        } else {
            if (object instanceof Note) {
                TVNote tvv = new TVNote(this.getApplicationView(), this);
                tvv.setModel(object);
                return tvv;
            }
            if (object instanceof ExternalAgent) {
                TVAgent tvv = new TVAgent(this.getApplicationView(), this);
                tvv.setModel(object);
                ((DataFlowDesign)this.getDesignPart()).registerLocalObject(tvv);
                return tvv;
            }
            if (object instanceof InfoStore) {
                TVInfoStore tvv = new TVInfoStore(this.getApplicationView(), this);
                tvv.setModel(object);
                ((DataFlowDesign)this.getDesignPart()).registerLocalObject(tvv);
                return tvv;
            }
            if (object instanceof Flow) {
                TVFlow tvf = new TVFlow(this.getApplicationView(), this);
                tvf.setModel(object);
                view = tvf;
            } else if (object instanceof DiagramView) {
                TVDiagramView tv = new TVDiagramView(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
            } else if (object instanceof Label) {
                TVLabel tv = new TVLabel(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
            } else {
                return null;
            }
        }
        view.setSize(new Dimension(TOPVIEW_SIZE));
        this.registerForTreemodel(view);
        return view;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.addUndoRedo(this.menu);
            this.menu.addSeparator();
            DesignPart dp = this.getDesignPart();
            this.parentDFD = null;
            if (dp instanceof DataFlowDesign) {
                DataFlowDesign dfd = (DataFlowDesign)dp;
                this.parentDFD = dfd.getParentDataFlowdesign();
                if (this.parentDFD != null) {
                    this.miGoToParent = new JCheckBoxMenuItem(MI_GO_TO_PARENT);
                    this.miGoToParent.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            TopView tv;
                            DPVProcess.this.parentDFD.setMainViewVisible(true);
                            Process process = ((DataFlowDesign)DPVProcess.this.getDesignPart()).getProcess();
                            if (process != null && (tv = process.getFirstViewForDPV(DPVProcess.this.parentDFD.getMainView())) != null) {
                                ((ContainerView)tv).setCurrentSelectionToContainer();
                            }
                        }
                    });
                    this.menu.add(this.miGoToParent);
                    this.menu.addSeparator();
                }
            }
            this.miAutoRoute = new JCheckBoxMenuItem(MI_AUTO_ROUTE);
            this.miAutoRoute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DPVProcess.this.setAutoRoute(!DPVProcess.this.isAutoRoute());
                    DPVProcess.this.getWorkSpace().updateSettings();
                }
            });
            this.menu.add(this.miAutoRoute);
            this.menu.addSeparator();
            this.miPaste = this.menu.add(new AbstractAction(MI_PASTE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DPVProcess.this.getController().paste(DPVProcess.this.pt);
                }
            });
            this.menu.addSeparator();
            this.menu.add(this.getStraightenLinesItem());
            this.menu.addSeparator();
            this.menu.add(this.getDetailsMenu());
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(MI_RESIZE_OBJECTS_TO_VISIBLE){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    DPVProcess.this.startAutoLayoutEdit(DesignPartView.MI_RESIZE_OBJECTS_TO_VISIBLE + " of " + DPVProcess.this.getName());
                    try {
                        DPVProcess.this.resizeProcesses();
                        DPVProcess.this.resizeAgents();
                        DPVProcess.this.resizeStores();
                        if (!DPVProcess.this.isAutoRoute()) {
                            DPVProcess.this.straightenLines(false);
                        }
                    }
                    finally {
                        DPVProcess.this.stopAutoLayoutEdit();
                    }
                }
            });
            this.menu.addSeparator();
        }
        this.menu.add(this.getGoToDiagramMenu());
        this.menu.addSeparator();
        this.menu.add(this.getShowMenu());
        this.menu.addSeparator();
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(MI_PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVProcess.this.getDesignPart().showPropertyDialog();
            }
        });
        if (this.isEditable()) {
            this.miAutoRoute.setSelected(this.isAutoRoute());
            this.miPaste.setEnabled(this.canPaste());
            this.miAllDetails.setSelected(this.showAllDetails());
            this.miNameOnly.setSelected(this.isShowNamesOnly());
        }
        return this.menu;
    }

    public JMenu getShowMenu() {
        JMenu showMenu = new JMenu(MenuUtils.getMnemonicStr(MI_SHOW));
        showMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_SHOW));
        this.miShowGrid = new JCheckBoxMenuItem(MI_SHOW_GRID);
        this.miShowGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVProcess.this.setShowGrid(!DPVProcess.this.showGrid());
            }
        });
        showMenu.add(this.miShowGrid);
        showMenu.addSeparator();
        this.miShowPageGrid = new JCheckBoxMenuItem(MI_SHOW_PAGE_GRID);
        this.miShowPageGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVProcess.this.setShowPageGrid(!DPVProcess.this.showPageGrid());
            }
        });
        showMenu.add(this.miShowPageGrid);
        showMenu.addSeparator();
        this.miShowLabels = new JCheckBoxMenuItem(MI_SHOW_LABELS);
        this.miShowLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVProcess.this.setShowLabels(!DPVProcess.this.showLabels());
            }
        });
        showMenu.add(this.miShowLabels);
        showMenu.addSeparator();
        this.miShowLegend = new JCheckBoxMenuItem(MI_SHOW_LEGEND);
        this.miShowLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVProcess.this.setShowLegend(!DPVProcess.this.showLegend());
            }
        });
        showMenu.add(this.miShowLegend);
        this.miShowGrid.setSelected(this.showGrid());
        this.miShowPageGrid.setSelected(this.showPageGrid());
        this.miShowLabels.setSelected(this.showLabels());
        this.miShowLegend.setSelected(this.showLegend());
        return showMenu;
    }

    @Override
    public JMenu getDetailsMenu() {
        this.detailsMenu = new JMenu(MenuUtils.getMnemonicStr(MI_DETAILS));
        this.detailsMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_DETAILS));
        this.miAllDetails = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ALL_DETAILS));
        this.miAllDetails.setMnemonic(MenuUtils.getMnemonicKey(MI_ALL_DETAILS));
        this.miNameOnly = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_NAMES_ONLY));
        this.miNameOnly.setMnemonic(MenuUtils.getMnemonicKey(MI_NAMES_ONLY));
        this.miAllDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVProcess.this.setShowAllDetails(true);
                DPVProcess.this.setShowNamesOnly(false);
                DPVProcess.this.setShowElements(false);
                DPVProcess.this.setShowDatatype(false);
                DPVProcess.this.setShowKeys(false);
                DPVProcess.this.getWorkSpace().invalidate();
                DPVProcess.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miAllDetails);
        this.detailsMenu.addSeparator();
        this.miNameOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVProcess.this.setShowNamesOnly(true);
                DPVProcess.this.setShowAllDetails(false);
                DPVProcess.this.setShowNamesOnly(true);
                DPVProcess.this.setShowElements(false);
                DPVProcess.this.setShowDatatype(false);
                DPVProcess.this.setShowKeys(false);
                DPVProcess.this.getWorkSpace().invalidate();
                DPVProcess.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miNameOnly);
        this.miAllDetails.setSelected(this.showAllDetails());
        this.miNameOnly.setSelected(this.isShowNamesOnly());
        return this.detailsMenu;
    }

    @Override
    public boolean isStorable() {
        return false;
    }

    @Override
    public String getToolbarName() {
        return TOOLBAR_NAME;
    }

    public void resizeProcesses() {
        List processes = (List)this.getTVProcesses();
        for (TopView topView : processes) {
            if (topView == null) continue;
            this.resizeProcesses(topView);
        }
    }

    public Collection getTVProcesses() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVProcess)) continue;
            col.add(tv);
        }
        return col;
    }

    public void resizeProcesses(TopView topView) {
        Dimension dim = this.getProcessSize(topView, (Process)topView.getModel());
        if (topView.getCellView() != null) {
            Point pos = topView.getCellView().getBounds().getBounds().getLocation();
            topView.getCellView().setNewBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        } else {
            Point pos = topView.getLocation();
            topView.setBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        }
    }

    private Dimension getProcessSize(TopView tv, Process process) {
        int colTextHeight;
        int w = 35;
        int h = 25;
        String title = process.getName();
        Font titleFont = tv.getFontObject(EditableFonts.FO_TITLE).getFont();
        FontMetrics fm = this.getFontMetrics(titleFont);
        int titleLength = fm.stringWidth(title);
        h = colTextHeight = fm.getHeight();
        h = Math.max(colTextHeight, titleFont.getSize());
        return new Dimension(w * 2 + titleLength, h += 6);
    }

    public void resizeAgents() {
        List agents = (List)this.getTVAgents();
        for (TopView topView : agents) {
            if (topView == null) continue;
            this.resizeAgents(topView);
        }
    }

    public Collection getTVAgents() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVAgent)) continue;
            col.add(tv);
        }
        return col;
    }

    public void resizeAgents(TopView topView) {
        Dimension dim = this.getAgentSize(topView, (ExternalAgent)topView.getModel());
        if (topView.getCellView() != null) {
            Point pos = topView.getCellView().getBounds().getBounds().getLocation();
            topView.getCellView().setNewBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        } else {
            Point pos = topView.getLocation();
            topView.setBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        }
    }

    private Dimension getAgentSize(TopView tv, ExternalAgent agent) {
        int colTextHeight;
        int w = 35;
        int h = 25;
        String title = agent.getName();
        Font titleFont = tv.getFontObject(EditableFonts.FO_TITLE).getFont();
        FontMetrics fm = this.getFontMetrics(titleFont);
        int titleLength = fm.stringWidth(title);
        h = colTextHeight = fm.getHeight();
        h = Math.max(colTextHeight, titleFont.getSize());
        return new Dimension(w * 2 + titleLength, h += 6);
    }

    public void resizeStores() {
        List stores = (List)this.getTVStores();
        for (TopView topView : stores) {
            if (topView == null) continue;
            this.resizeStores(topView);
        }
    }

    public Collection getTVStores() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVInfoStore)) continue;
            col.add(tv);
        }
        return col;
    }

    public void resizeStores(TopView topView) {
        Dimension dim = this.getStoreSize(topView, (InfoStore)topView.getModel());
        if (topView.getCellView() != null) {
            Point pos = topView.getCellView().getBounds().getBounds().getLocation();
            topView.getCellView().setNewBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        } else {
            Point pos = topView.getLocation();
            topView.setBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        }
    }

    private Dimension getStoreSize(TopView tv, InfoStore store) {
        int colTextHeight;
        int w = 35;
        int h = 25;
        String title = store.getName();
        String StoreNbr = "D" + String.valueOf(store.getDesignObjectSet().getIndexOf(store) + 1);
        Font titleFont = tv.getFontObject(EditableFonts.FO_TITLE).getFont();
        FontMetrics fm = this.getFontMetrics(titleFont);
        int titleLength = fm.stringWidth(StoreNbr + title);
        h = colTextHeight = fm.getHeight();
        h = Math.max(colTextHeight, titleFont.getSize());
        return new Dimension(w * 2 + titleLength, h += 6);
    }
}

