/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.process;

import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.process.ControllerProcess;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;

public class ProcessModelController
implements Controller {
    public static final int SELECT_ACTION_ID = Ide.findOrCreateCmdID((String)"ProcessModelController.Select");
    public static final int NEW_PROCESS_ACTION_ID = Ide.findOrCreateCmdID((String)"ProcessModelController.NewProcess");
    public static final int NEW_AGENT_ACTION_ID = Ide.findOrCreateCmdID((String)"ProcessModelController.NewAgent");
    public static final int NEW_INFO_STORE_ACTION_ID = Ide.findOrCreateCmdID((String)"ProcessModelController.NewInfoStore");
    public static final int NEW_FLOW_ACTION_ID = Ide.findOrCreateCmdID((String)"ProcessModelController.NewFlow");
    public static final int NEW_NOTE_ACTION_ID = Ide.findOrCreateCmdID((String)"ProcessModelController.NewNote");
    public static final int DELETE_ACTION_ID = Ide.findOrCreateCmdID((String)"ProcessModelController.Delete");
    public static final int ZOOM_IN_ACTION_ID = Ide.findOrCreateCmdID((String)"ProcessModelController.ZoomIn");
    public static final int ZOOM_OUT_ACTION_ID = Ide.findOrCreateCmdID((String)"ProcessModelController.ZoomOut");
    public static final int FIT_SCREEN_ACTION_ID = Ide.findOrCreateCmdID((String)"ProcessModelController.FitScreen");
    public static final int DEFAULT_SIZE_ACTION_ID = Ide.findOrCreateCmdID((String)"ProcessModelController.DefaultSize");
    public static final int FIND_ACTION_ID = Ide.findOrCreateCmdID((String)"ProcessModelController.Find");

    private boolean isKnownCommand(IdeAction action) {
        int commandId = action.getCommandId();
        return commandId == SELECT_ACTION_ID || commandId == NEW_PROCESS_ACTION_ID || commandId == NEW_AGENT_ACTION_ID || commandId == NEW_INFO_STORE_ACTION_ID || commandId == NEW_FLOW_ACTION_ID || commandId == NEW_NOTE_ACTION_ID || commandId == DELETE_ACTION_ID || commandId == ZOOM_IN_ACTION_ID || commandId == ZOOM_OUT_ACTION_ID || commandId == FIT_SCREEN_ACTION_ID || commandId == DEFAULT_SIZE_ACTION_ID || commandId == FIND_ACTION_ID;
    }

    public MDBAction getAction(int commandId) {
        if (ApplicationView.getInstance().getCurrentDPV() instanceof DPVProcess) {
            ControllerProcess controller = (ControllerProcess)ApplicationView.getInstance().getCurrentDPV().getController();
            if (commandId == SELECT_ACTION_ID) {
                return controller.getSelectAction();
            }
            if (commandId == NEW_PROCESS_ACTION_ID) {
                return controller.getNewProcessAction();
            }
            if (commandId == NEW_AGENT_ACTION_ID) {
                return controller.getNewAgentAction();
            }
            if (commandId == NEW_INFO_STORE_ACTION_ID) {
                return controller.getNewInfoStoreAction();
            }
            if (commandId == NEW_FLOW_ACTION_ID) {
                return controller.getNewFlowAction();
            }
            if (commandId == NEW_NOTE_ACTION_ID) {
                return controller.getNewNoteAction();
            }
            if (commandId == DELETE_ACTION_ID) {
                return controller.getDeleteAction();
            }
            if (commandId == ZOOM_IN_ACTION_ID) {
                return controller.getZoomInAction();
            }
            if (commandId == ZOOM_OUT_ACTION_ID) {
                return controller.getZoomOutAction();
            }
            if (commandId == FIT_SCREEN_ACTION_ID) {
                return controller.getFitScreenAction();
            }
            if (commandId == DEFAULT_SIZE_ACTION_ID) {
                return controller.getDefaultSizeAction();
            }
            if (commandId == FIND_ACTION_ID) {
                return controller.getFindAction();
            }
        }
        return null;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        MDBAction mdbAction;
        if (this.isKnownCommand(action) && (mdbAction = this.getAction(action.getCommandId())) != null) {
            mdbAction.actionPerformed(null);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        MDBAction mdbAction;
        if (this.isKnownCommand(action) && (mdbAction = this.getAction(action.getCommandId())) != null) {
            action.setEnabled(mdbAction.isEnabled());
            return true;
        }
        return false;
    }
}

