/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.relational.ControllerRelational;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.Messages;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;

public class DPVRelationalSubView
extends DPVRelational {
    private AbstractController controller;
    DesignObjectCollection tvTables = new DesignObjectCollection(true);
    DesignObjectCollection tvViews = new DesignObjectCollection(true);
    DesignObjectCollection tvFKAss = new DesignObjectCollection(true);
    DesignObjectCollection tvTypeSubst = new DesignObjectCollection(true);

    public DPVRelationalSubView(ApplicationView appView, DesignPart desPart) {
        super(appView, desPart);
        ((RelationalDesign)desPart).getTableSet().addSetListener(this.tvTables);
        ((RelationalDesign)desPart).getTableViewSet().addSetListener(this.tvViews);
        ((RelationalDesign)desPart).getFKIndexAssociationSet().addSetListener(this.tvFKAss);
        ((RelationalDesign)desPart).getTypeSubstitutionSet().addSetListener(this.tvTypeSubst);
        this.controller = new ControllerRelational(appView);
        this.controller.setName("Relational_SubView");
        this.controller.setDesignPartView(this);
        this.tvTables.setElementDescriptor(Table.class);
        this.tvTables.setName(Messages.getString("DPVRelationalSubView.Tables"));
        this.tvViews.setElementDescriptor(TableView.class);
        this.tvViews.setName(Messages.getString("DPVRelationalSubView.Views"));
        this.tvFKAss.setElementDescriptor(FKIndexAssociation.class);
        this.tvFKAss.setName(Messages.getString("DPVRelationalSubView.FKRelations"));
        this.tvTypeSubst.setElementDescriptor(TypeSubstitution.class);
        this.tvTypeSubst.setName(Messages.getString("DPVRelationalSubView.TypeSubstitutions"));
    }

    @Override
    public void clearDPV() {
        ((RelationalDesign)this.getDesignPart()).getTableSet().removeSetListener(this.tvTables);
        ((RelationalDesign)this.getDesignPart()).getTableViewSet().removeSetListener(this.tvViews);
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().removeSetListener(this.tvFKAss);
        ((RelationalDesign)this.getDesignPart()).getTypeSubstitutionSet().removeSetListener(this.tvTypeSubst);
        super.clearDPV();
    }

    @Override
    public void sortCollections() {
        this.tvTables.sort();
        this.tvViews.sort();
        this.tvFKAss.sort();
        this.tvTypeSubst.sort();
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject object) {
        if (DesignObjectEdit.UNDOABLE_ADD) {
            return;
        }
        if (ApplicationView.loading || !this.isCurrentDPV()) {
            return;
        }
        TopView view = this.getViewFor(object);
        if (view == null) {
            this.addViewFor(object);
        }
    }

    @Override
    public TopView createViewFor(DesignObject object) {
        if (ApplicationView.loading || !this.isCurrentDPV()) {
            return null;
        }
        return this.createTopViewFor(object);
    }

    @Override
    public void setPlaceHolder(PlaceHolder host) {
        super.setPlaceHolder(host);
        this.tvTables.setParent(this.getPlaceHolder());
        this.tvViews.setParent(this.getPlaceHolder());
        this.tvFKAss.setParent(this.getPlaceHolder());
        this.tvTypeSubst.setParent(this.getPlaceHolder());
        this.getDisplays().setParent(this.getPlaceHolder());
    }

    @Override
    public int getNumberOfChildren() {
        return 4;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.tvTables;
            }
            case 1: {
                return this.tvViews;
            }
            case 2: {
                return this.tvFKAss;
            }
            case 3: {
                return this.getDisplays();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.tvTables) {
            return 0;
        }
        if (child == this.tvViews) {
            return 1;
        }
        if (child == this.tvFKAss) {
            return 2;
        }
        if (child == this.getDisplays()) {
            return 3;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    @Override
    public boolean isMainDiagram() {
        return false;
    }

    @Override
    public void registerForTreemodel(TopView tv) {
        DesignObjectPlaceHolder tvph = new DesignObjectPlaceHolder(tv.getModel().getDesignPart(), tv.getModel());
        tvph.setTopView(tv);
        if (tv instanceof TVTable && !this.tvTables.containsPlaceHolderFor(tv.getModel())) {
            this.tvTables.add(tvph);
        } else if (tv instanceof TVView && !this.tvViews.containsPlaceHolderFor(tv.getModel())) {
            this.tvViews.add(tvph);
        } else if (tv instanceof TVFKRelation && !this.tvFKAss.containsPlaceHolderFor(tv.getModel())) {
            this.tvFKAss.add(tvph);
        } else if (tv instanceof TVTypeSubstitution && !this.tvTypeSubst.containsPlaceHolderFor(tv.getModel())) {
            this.tvTypeSubst.add(tvph);
        }
        if (this.getViewFor(tv.getModel()) == null) {
            this.modelToView.put(tv.getModel(), tv);
        }
    }

    @Override
    public void unregisterFromTreemodel(TopView tv) {
        if (tv != null) {
            this.unregisterTopView(tv);
            DesignObject object = tv.getModel();
            TopView firstv = this.getFirstViewFor(object);
            if (firstv == null) {
                if (tv instanceof TVTable) {
                    this.tvTables.removePlaceHolderFor(object);
                }
                if (tv instanceof TVView) {
                    this.tvViews.removePlaceHolderFor(object);
                }
                if (tv instanceof TVFKRelation) {
                    this.tvFKAss.removePlaceHolderFor(object);
                }
                if (tv instanceof TVTypeSubstitution) {
                    this.tvTypeSubst.removePlaceHolderFor(object);
                }
            }
        }
    }

    @Override
    public Collection getTVTables() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVTable)) continue;
            col.add(tv);
        }
        return col;
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart desPart) {
        return new DPVRelationalSubView(this.getApplicationView(), this.getDesignPart());
    }

    public XtdMapping getDeletedMapping(String designPartID) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this.getPlaceHolder(), designPartID);
        if (list.size() > 0) {
            XtdMapping mapping = (XtdMapping)list.get(0);
            return mapping;
        }
        return null;
    }

    @Override
    protected void showPropertiesDialog() {
        if (!this.getPlaceHolder().isDialogVisible()) {
            ModelPropertiesDialogEx dialog = new ModelPropertiesDialogEx(this.getDesign().getAppView(), this.getPlaceHolder());
            dialog.initProperties(this.getPlaceHolder());
            dialog.show();
        }
    }
}

