/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.DenormalizerSplitTable;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.relational.Messages;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class SplitTableWizard
extends CustomDialog {
    private static final String FIRST_PAGE = "FIRST_PAGE";
    private static final String SECOND_PAGE = "SECOND_PAGE";
    private static final String THIRD_PAGE = "THIRD_PAGE";
    private static final String MOVE_LEFT = Messages.getString("SplitTableWizard.MoveL");
    private static final String MOVE_RIGHT = Messages.getString("SplitTableWizard.MoveR");
    private static final String COPY_RIGHT = Messages.getString("SplitTableWizard.CopyR");
    private DenormalizerSplitTable denormalizer;
    private JDialog dialog;
    protected JButton bnBack;
    protected JButton bnNext;
    protected JButton bnFinish;
    protected JButton bnCancel;
    protected JButton bnHelp;
    private CardLayout cardLayout = new CardLayout();
    private int taskNbr = 1;
    private JPanel pnMain;
    private JPanel firstPanel;
    private JPanel secondPanel;
    private JPanel thirdPanel;
    private JTextField tfName;
    private JTextArea taComments;
    private Border border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createLineBorder(Color.GRAY, 1));
    private JList sourceFKList;
    private JList destinationFKList;
    private JList sourceColumnsList;
    private JList destinationColumnsList;
    private int width = 0;
    private static final Logger LOGGER = new Logger(DenormalizerSplitTable.class);

    public SplitTableWizard(ApplicationView appView, DenormalizerSplitTable denormalizer) {
        super(appView);
        this.denormalizer = denormalizer;
        this.add((Component)this.initMainPanel(), "Center");
        this.add((Component)this.initBottomPanel(), "South");
        this.handleButtons();
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SplitTableWizard.SplitTableWizard"));
            this.dialog.setContentPane(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "f1_splittable_html";
    }

    protected JPanel initMainPanel() {
        this.pnMain = new JPanel(this.cardLayout);
        this.secondPanel = this.initSecondPanel();
        this.firstPanel = this.initFirstPanel();
        this.thirdPanel = this.initThirdPanel();
        this.pnMain.add((Component)this.firstPanel, FIRST_PAGE);
        this.pnMain.add((Component)this.secondPanel, SECOND_PAGE);
        this.pnMain.add((Component)this.thirdPanel, THIRD_PAGE);
        return this.pnMain;
    }

    private String getProperName(String name) {
        TableSet tableSet = this.getApplicationView().getCurrentDesign().getRelationalDesign().getTableSet();
        int sufix = 1;
        while (tableSet.getByName(name + "_" + sufix) != null) {
            ++sufix;
        }
        return name + "_" + sufix;
    }

    private JPanel initFirstPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel pnName = new JPanel(new FlowLayout(0));
        pnName.setBorder(BorderFactory.createTitledBorder(Messages.getString("SplitTableWizard.SpecifyNameNewTable")));
        pnName.add(new JLabel(Messages.getString("SplitTableWizard.TableName")));
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(new Dimension(this.width - 100, this.tfName.getPreferredSize().height));
        this.tfName.setText(this.getProperName(this.denormalizer.getBaseTable().getName()));
        this.tfName.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                SplitTableWizard.this.bnNext.setEnabled(!"".equalsIgnoreCase(SplitTableWizard.this.tfName.getText()));
            }
        });
        pnName.add(this.tfName);
        JPanel jp1 = new JPanel();
        jp1.add(pnName);
        jpanel.add((Component)jp1, "North");
        JPanel pnComments = new JPanel();
        pnComments.setPreferredSize(new Dimension(pnName.getPreferredSize().width, 275));
        pnComments.setBorder(BorderFactory.createTitledBorder(Messages.getString("SplitTableWizard.AddCommentsNewTable")));
        this.taComments = new JTextArea();
        this.taComments.setPreferredSize(new Dimension(pnComments.getPreferredSize().width - 25, pnComments.getPreferredSize().height - 40));
        pnComments.add(new JScrollPane(this.taComments));
        JPanel jp2 = new JPanel();
        jp2.add(pnComments);
        jpanel.add((Component)jp2, "Center");
        return jpanel;
    }

    private JPanel initSecondPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel pnFKColumns = new JPanel(new BorderLayout());
        pnFKColumns.setBorder(BorderFactory.createTitledBorder(Messages.getString("SplitTableWizard.ForeignKeysAddedNewTable")));
        JButton bnMoveRight = new JButton(MOVE_RIGHT);
        JButton bnCopyRight = new JButton(COPY_RIGHT);
        JButton bnMoveLeft = new JButton(MOVE_LEFT);
        DefaultListModel lmSource = new DefaultListModel();
        DefaultListModel lmDestination = new DefaultListModel();
        this.sourceFKList = new JList(lmSource);
        this.destinationFKList = new JList(lmDestination);
        this.addFKs(this.sourceFKList, this.denormalizer.getBaseTable());
        bnMoveRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplitTableWizard.this.transfer(SplitTableWizard.this.sourceFKList, SplitTableWizard.this.destinationFKList, true, true);
            }
        });
        bnCopyRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplitTableWizard.this.transfer(SplitTableWizard.this.sourceFKList, SplitTableWizard.this.destinationFKList, false, true);
            }
        });
        bnMoveLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplitTableWizard.this.transfer(SplitTableWizard.this.destinationFKList, SplitTableWizard.this.sourceFKList, true, false);
            }
        });
        JLabel sourceLabel = new JLabel();
        JLabel destinationLabel = new JLabel();
        sourceLabel.setText(Messages.getString("SplitTableWizard.SourceForeignKeys"));
        destinationLabel.setText(Messages.getString("SplitTableWizard.TargetForeignKeys"));
        sourceLabel.setHorizontalAlignment(0);
        destinationLabel.setHorizontalAlignment(0);
        JPanel pnLeft = new JPanel(new BorderLayout());
        pnLeft.setBorder(this.border);
        pnLeft.add((Component)sourceLabel, "North");
        JScrollPane sp = new JScrollPane(this.sourceFKList);
        sp.setPreferredSize(new Dimension(220, 299));
        pnLeft.add(sp);
        pnFKColumns.add((Component)pnLeft, "West");
        JPanel pnRight = new JPanel(new BorderLayout());
        pnRight.setBorder(this.border);
        pnRight.add((Component)destinationLabel, "North");
        sp = new JScrollPane(this.destinationFKList);
        sp.setPreferredSize(new Dimension(220, 299));
        pnRight.add(sp);
        pnFKColumns.add((Component)pnRight, "East");
        JPanel pnCenter = new JPanel(new GridLayout(0, 1));
        JPanel pnButtons = new JPanel(new GridLayout(0, 1));
        pnButtons.add(bnMoveRight);
        pnButtons.add(bnCopyRight);
        pnButtons.add(bnMoveLeft);
        pnCenter.add(new JPanel());
        pnCenter.add(pnButtons);
        pnCenter.add(new JPanel());
        pnFKColumns.add((Component)pnCenter, "Center");
        JPanel jp1 = new JPanel();
        jp1.add(pnFKColumns);
        jpanel.add(jp1);
        this.width = pnFKColumns.getPreferredSize().width;
        return jpanel;
    }

    private JPanel initThirdPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel pnFKColumns = new JPanel(new BorderLayout());
        pnFKColumns.setBorder(BorderFactory.createTitledBorder(Messages.getString("SplitTableWizard.NonKeyColumnsNewTable")));
        JButton bnMoveRight = new JButton(MOVE_RIGHT);
        JButton bnCopyRight = new JButton(COPY_RIGHT);
        JButton bnMoveLeft = new JButton(MOVE_LEFT);
        DefaultListModel lmSource = new DefaultListModel();
        DefaultListModel lmDestination = new DefaultListModel();
        this.sourceColumnsList = new JList(lmSource);
        this.destinationColumnsList = new JList(lmDestination);
        this.addColumns(this.sourceColumnsList, this.denormalizer.getBaseTable());
        bnMoveRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplitTableWizard.this.transfer(SplitTableWizard.this.sourceColumnsList, SplitTableWizard.this.destinationColumnsList, true, true);
            }
        });
        bnCopyRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplitTableWizard.this.transfer(SplitTableWizard.this.sourceColumnsList, SplitTableWizard.this.destinationColumnsList, false, true);
            }
        });
        bnMoveLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplitTableWizard.this.transfer(SplitTableWizard.this.destinationColumnsList, SplitTableWizard.this.sourceColumnsList, true, false);
            }
        });
        JLabel sourceLabel = new JLabel();
        JLabel destinationLabel = new JLabel();
        sourceLabel.setText(Messages.getString("SplitTableWizard.SourceColumns"));
        destinationLabel.setText(Messages.getString("SplitTableWizard.TargetColumns"));
        sourceLabel.setHorizontalAlignment(0);
        destinationLabel.setHorizontalAlignment(0);
        JPanel pnLeft = new JPanel(new BorderLayout());
        pnLeft.setBorder(this.border);
        pnLeft.add((Component)sourceLabel, "North");
        JScrollPane sp = new JScrollPane(this.sourceColumnsList);
        sp.setPreferredSize(new Dimension(220, 299));
        pnLeft.add(sp);
        pnFKColumns.add((Component)pnLeft, "West");
        JPanel pnRight = new JPanel(new BorderLayout());
        pnRight.setBorder(this.border);
        pnRight.add((Component)destinationLabel, "North");
        sp = new JScrollPane(this.destinationColumnsList);
        sp.setPreferredSize(new Dimension(220, 299));
        pnRight.add(sp);
        pnFKColumns.add((Component)pnRight, "East");
        JPanel pnCenter = new JPanel(new GridLayout(0, 1));
        JPanel pnButtons = new JPanel(new GridLayout(0, 1));
        pnButtons.add(bnMoveRight);
        pnButtons.add(bnCopyRight);
        pnButtons.add(bnMoveLeft);
        pnCenter.add(new JPanel());
        pnCenter.add(pnButtons);
        pnCenter.add(new JPanel());
        pnFKColumns.add((Component)pnCenter, "Center");
        JPanel jp1 = new JPanel();
        jp1.add(pnFKColumns);
        jpanel.add(jp1);
        return jpanel;
    }

    private void transfer(JList from, JList to, boolean move, boolean fromSource) {
        Object[] columns = from.getSelectedValues();
        for (int i = 0; i < columns.length; ++i) {
            if (fromSource) {
                DesignObject object = (DesignObject)columns[i];
                if (!this.containsObject((DefaultListModel)to.getModel(), object)) {
                    MCObject mcObject = new MCObject(object, move);
                    ((DefaultListModel)to.getModel()).addElement(mcObject);
                }
                if (!move) continue;
                ((DefaultListModel)from.getModel()).removeElement(columns[i]);
                continue;
            }
            MCObject mcObject = (MCObject)columns[i];
            if (!((DefaultListModel)to.getModel()).contains(mcObject.getDesignObject())) {
                ((DefaultListModel)to.getModel()).addElement(mcObject.getDesignObject());
            }
            if (!move) continue;
            ((DefaultListModel)from.getModel()).removeElement(mcObject);
        }
    }

    private boolean containsObject(DefaultListModel list, DesignObject object) {
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            MCObject mcObject = (MCObject)list.get(i);
            if (mcObject.getDesignObject() != object) continue;
            return true;
        }
        return false;
    }

    private void addColumns(JList jlist, Table table) {
        DefaultListModel listModel = (DefaultListModel)jlist.getModel();
        Column[] columns = (Column[])table.getElements();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].isFKElement() || columns[i].isPKElement()) continue;
            listModel.addElement(columns[i]);
        }
    }

    private void addFKs(JList jlist, Table table) {
        DefaultListModel listModel = (DefaultListModel)jlist.getModel();
        FKIndexAssociation[] fks = table.getFKAssociations();
        for (int i = 0; i < fks.length; ++i) {
            listModel.addElement(fks[i]);
        }
    }

    protected JPanel initBottomPanel() {
        JPanel jpanel = new JPanel(new FlowLayout(2));
        this.bnBack = new JButton(Messages.getString("SplitTableWizard.Back"));
        this.bnBack.setMnemonic(66);
        this.bnBack.addActionListener(new BackAction());
        this.bnNext = new JButton(Messages.getString("SplitTableWizard.Next"));
        this.bnNext.setMnemonic(78);
        this.bnNext.addActionListener(new NextAction());
        this.bnFinish = new JButton(Messages.getString("SplitTableWizard.Finish"));
        this.bnFinish.setMnemonic(70);
        this.bnFinish.addActionListener(new FinishAction());
        this.bnCancel = new JButton(Messages.getString("SplitTableWizard.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnHelp = new JButton(Messages.getString("SplitTableWizard.Help"));
        this.bnHelp.setMnemonic(72);
        this.bnHelp.addActionListener(new HelpAction());
        this.bnBack.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnNext.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnFinish.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jpanel.add(this.bnBack);
        jpanel.add(this.bnNext);
        jpanel.add(this.bnFinish);
        jpanel.add(this.bnCancel);
        jpanel.add(this.bnHelp);
        return jpanel;
    }

    private void handleButtons() {
        switch (this.taskNbr) {
            case 1: {
                this.bnBack.setEnabled(false);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 2: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(true);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 3: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(false);
                this.bnFinish.setEnabled(true);
                this.bnCancel.setEnabled(true);
            }
        }
    }

    private void processMappings(Table source, Table split, List oldMappings, List newMappings) {
        boolean dirty = false;
        ArrayList list = new ArrayList(oldMappings);
        list.addAll(newMappings);
        for (XtdMapping mapping : list) {
            if (mapping.isDeleted()) continue;
            Entity ent = (Entity)mapping.getLogicalObject();
            Table table = null;
            if (mapping.getRelationalObject() == source) {
                table = source;
            } else if (mapping.getRelationalObject() == split) {
                CandidateKey pkey;
                table = split;
                Index pk = (Index)split.getPK();
                if (pk != null) {
                    if (!mapping.getIndexes().contains(pk.getObjectID())) {
                        mapping.getIndexes().add(pk.getObjectID());
                        dirty = true;
                    }
                    for (Column col : pk.getElementsCollection()) {
                        if (mapping.getColumns().contains(col.getObjectID())) continue;
                        mapping.getColumns().add(col.getObjectID());
                        dirty = true;
                    }
                }
                if ((pkey = (CandidateKey)ent.getPK()) != null && !mapping.getKeys().contains(pkey.getObjectID())) {
                    mapping.getKeys().add(pkey.getObjectID());
                    dirty = true;
                }
            }
            if (table == null) continue;
            for (Attribute attr : ent.getElementsCollection()) {
                if (attr.getEngColumn(source.getRelationalModel(), table) != null || mapping.getAttributes().contains(attr.getObjectID())) continue;
                dirty = true;
                mapping.getAttributes().add(attr.getObjectID());
            }
            Iterator ite = ent.getKeySet().iterator();
            while (ite.hasNext()) {
                CandidateKey key = (CandidateKey)ite.next();
                if (key.getEngIndex(source.getRelationalModel(), table) != null || mapping.getKeys().contains(key.getObjectID())) continue;
                dirty = true;
                mapping.getKeys().add(key.getObjectID());
            }
        }
        if (dirty) {
            source.getRelationalModel().getRMExtendedMap().setDirty(true);
        }
    }

    private int showErrorForInvalid(List list) {
        String[] str = new String[list.size()];
        Iterator it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            Index ind = (Index)it.next();
            str[i] = ind.isUnique() ? ind.getName() + " (UK)" : ind.getName();
            ++i;
        }
        JList<String> jlist = new JList<String>(str);
        JScrollPane sp = new JScrollPane(jlist);
        return JOptionPane.showConfirmDialog(this.getDialog(), new Object[]{sp}, Messages.getString("SplitTableWizard.InconsInRemainingUK_ind"), 2, 0);
    }

    private void verifySplit(Object[] columns, Object[] foreignKeys, Table originalTable, Map moved, Map copied, List listCopyToNew, List listMoveToNew, List listInvalid, Map indexColumns) {
        MCObject mcObject;
        int i;
        for (i = 0; i < columns.length; ++i) {
            mcObject = (MCObject)columns[i];
            Column column = (Column)mcObject.getDesignObject();
            if (mcObject.isMove()) {
                moved.put(column.getObjectID(), column);
                continue;
            }
            copied.put(column.getObjectID(), column);
        }
        for (i = 0; i < foreignKeys.length; ++i) {
            mcObject = (MCObject)foreignKeys[i];
            FKIndexAssociation fk = (FKIndexAssociation)mcObject.getDesignObject();
            for (Column column : fk.getLocalFKIndex().getElementsCollection()) {
                if (mcObject.isMove()) {
                    moved.put(column.getObjectID(), column);
                    continue;
                }
                copied.put(column.getObjectID(), column);
            }
        }
        Iterator it = originalTable.getKeySet().iterator();
        while (it.hasNext()) {
            Index ind = (Index)it.next();
            if (ind.isPK() || ind.isFK()) continue;
            boolean move = false;
            boolean copy = false;
            boolean remain = false;
            ArrayList<String> colsIDs = new ArrayList<String>();
            for (Column col : ind.getElementsCollection()) {
                colsIDs.add(col.getObjectID());
                if (moved.get(col.getObjectID()) != null) {
                    move = true;
                    continue;
                }
                if (copied.get(col.getObjectID()) != null) {
                    copy = true;
                    continue;
                }
                remain = true;
            }
            indexColumns.put(ind.getObjectID(), colsIDs);
            if (move && (copy || remain)) {
                listInvalid.add(ind);
                continue;
            }
            if (move) {
                listMoveToNew.add(ind);
                continue;
            }
            if (!copy) continue;
            listCopyToNew.add(ind);
        }
    }

    public void initColumns(Object[] columns, Table originalTable, Table destination, Map moved, Map copied) {
        for (int i = 0; i < columns.length; ++i) {
            MCObject mcObject = (MCObject)columns[i];
            Column column = (Column)mcObject.getDesignObject();
            Column newColumn = null;
            if (!column.isFKElement()) {
                if (mcObject.isMove()) {
                    originalTable.remove(column);
                    destination.add(column);
                    moved.put(column.getObjectID(), column);
                } else {
                    newColumn = destination.createColumn();
                }
            }
            if (newColumn == null) continue;
            column.copy(newColumn);
            newColumn.setGeneratorID(column.getGeneratorID());
            copied.put(column.getObjectID(), newColumn);
            for (XtdMapping mapping : column.getMappingsToAttributes()) {
                DesignObject obj;
                if (mapping.isDeleted() || (obj = mapping.getLogicalObject()) == null || !(obj instanceof Attribute)) continue;
                originalTable.getRelationalModel().getRMExtendedMap().createMapping(obj, newColumn);
            }
        }
    }

    public void processIndexes(Table originalTable, Table destination, Map moved, Map copied, List listToMove, List listToCopy, Map indexColumns) {
        ArrayList list = new ArrayList(listToCopy);
        list.addAll(listToMove);
        for (Index ind : list) {
            boolean move = !listToCopy.contains(ind);
            ArrayList<Column> cols = new ArrayList<Column>();
            List ids = (List)indexColumns.get(ind.getObjectID());
            if (ids == null) continue;
            for (String old : ids) {
                Column col = null;
                col = move ? (Column)moved.get(old) : (Column)copied.get(old);
                if (col == null) continue;
                cols.add(col);
            }
            if (cols.size() != ids.size()) continue;
            Index nind = null;
            if (move) {
                nind = ind;
                originalTable.moveIndexToTable(ind, destination);
                if (ind.isUnique()) {
                    // empty if block
                }
            } else {
                nind = destination.createIndex();
                ind.copy(nind);
                if (ind.isUnique()) {
                    List mappings = ind.getMappingsToKeys();
                    for (XtdMapping mapping : mappings) {
                        DesignObject obj;
                        if (mapping.isDeleted() || (obj = mapping.getLogicalObject()) == null || !(obj instanceof CandidateKey)) continue;
                        originalTable.getRelationalModel().getRMExtendedMap().createMapping(obj, nind);
                    }
                }
            }
            nind.getElementsCollection().clear();
            for (Column col : cols) {
                nind.add(col);
            }
        }
    }

    public void initForeignKeys(Object[] foreignKeys, Table originalTable, Table destination, Map moved, Map copied) {
        for (int i = 0; i < foreignKeys.length; ++i) {
            Column[] cols;
            MCObject mcObject = (MCObject)foreignKeys[i];
            FKIndexAssociation fk = (FKIndexAssociation)mcObject.getDesignObject();
            ArrayList<Column> list = new ArrayList<Column>();
            for (Column column : cols = fk.getColumns()) {
                if (mcObject.isMove()) {
                    originalTable.remove(column);
                    destination.add(column);
                    moved.put(column.getObjectID(), column);
                    list.add(column);
                    continue;
                }
                Column newColumn = destination.createColumn();
                column.copy(newColumn);
                newColumn.setGeneratorID(column.getGeneratorID());
                copied.put(column.getObjectID(), newColumn);
                for (XtdMapping mapping : column.getMappingsToAttributes()) {
                    DesignObject obj;
                    if (mapping.isDeleted() || !((obj = mapping.getLogicalObject()) instanceof Attribute)) continue;
                    originalTable.getRelationalModel().getRMExtendedMap().createMapping(obj, newColumn);
                }
                list.add(newColumn);
            }
            if (list.size() <= 0 || list.size() != cols.length) continue;
            FKIndexAssociation newAssociation = null;
            newAssociation = destination.addForeignKey((Index)fk.getKeyObject(), list);
            newAssociation.getLocalFKIndex().setGeneratorID(fk.getGeneratorID());
            fk.copy(newAssociation);
            for (XtdMapping mapping : fk.getMappingsToRelations()) {
                DesignObject obj;
                if (mapping.isDeleted() || !((obj = mapping.getLogicalObject()) instanceof Relation)) continue;
                originalTable.getRelationalModel().getRMExtendedMap().createMapping(obj, newAssociation);
            }
            newAssociation.resetEdgeParams();
            if (!mcObject.isMove()) continue;
            Object[] views = fk.getAllViews().toArray();
            for (int j = views.length - 1; j >= 0; --j) {
                TopView topView = (TopView)views[j];
                fk.removeTopView(topView);
            }
            fk.remove();
        }
    }

    public class MCObject {
        private boolean move;
        private DesignObject designObject;

        public MCObject(DesignObject designObject, boolean move) {
            this.designObject = designObject;
            this.move = move;
        }

        public DesignObject getDesignObject() {
            return this.designObject;
        }

        public boolean isMove() {
            return this.move;
        }

        public String toString() {
            return this.designObject.toString();
        }
    }

    private class HelpAction
    implements ActionListener {
        private HelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SplitTableWizard.this.showHelp();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SplitTableWizard.this.close();
        }
    }

    private class FinishAction
    implements ActionListener {
        private FinishAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Table originalTable = SplitTableWizard.this.denormalizer.getOriginalTable();
            boolean propagate = originalTable.getDesign().isPropagatePKChahges();
            try {
                HashMap moved = new HashMap();
                HashMap copied = new HashMap();
                HashMap indexColumns = new HashMap();
                ArrayList listCopyToNew = new ArrayList();
                ArrayList listMoveToNew = new ArrayList();
                ArrayList listInvalid = new ArrayList();
                originalTable.getDesign().setPropagatePKChahges(false);
                SplitTableWizard.this.verifySplit(((DefaultListModel)SplitTableWizard.this.destinationColumnsList.getModel()).toArray(), ((DefaultListModel)SplitTableWizard.this.destinationFKList.getModel()).toArray(), originalTable, moved, copied, listCopyToNew, listMoveToNew, listInvalid, indexColumns);
                if (listInvalid.size() > 0) {
                    SplitTableWizard.this.showErrorForInvalid(listInvalid);
                    return;
                }
                SplitTableWizard.this.denormalizer.makeSplitTable(SplitTableWizard.this.tfName.getText());
                Table splitTable = SplitTableWizard.this.denormalizer.getSplitTable();
                splitTable.setComment(SplitTableWizard.this.taComments.getText());
                ArrayList<XtdMapping> newmappings = new ArrayList<XtdMapping>();
                ArrayList<XtdMapping> oldmappings = new ArrayList<XtdMapping>();
                for (XtdMapping mapping : originalTable.getMappingsToEntities()) {
                    if (mapping.isDeleted()) continue;
                    oldmappings.add(mapping);
                    DesignObject obj = mapping.getLogicalObject();
                    if (!(obj instanceof Entity)) continue;
                    XtdMapping m = originalTable.getRelationalModel().getRMExtendedMap().createMapping(obj, splitTable);
                    newmappings.add(m);
                }
                SplitTableWizard.this.initColumns(((DefaultListModel)SplitTableWizard.this.destinationColumnsList.getModel()).toArray(), originalTable, splitTable, moved, copied);
                SplitTableWizard.this.initForeignKeys(((DefaultListModel)SplitTableWizard.this.destinationFKList.getModel()).toArray(), originalTable, splitTable, moved, copied);
                SplitTableWizard.this.processIndexes(originalTable, splitTable, moved, copied, listMoveToNew, listCopyToNew, indexColumns);
                SplitTableWizard.this.processMappings(originalTable, splitTable, oldmappings, newmappings);
                TVTable sourceView = (TVTable)originalTable.getTopView();
                TVTable destinationView = (TVTable)splitTable.getTopView();
                int x = sourceView.getCellView().getBounds().getBounds().x + 30;
                int y = sourceView.getCellView().getBounds().getBounds().y + 30;
                int w = sourceView.getCellView().getBounds().getBounds().width;
                int h = sourceView.getCellView().getBounds().getBounds().height;
                destinationView.getCellView().setNewBounds(new Rectangle(x, y, w, h));
            }
            catch (Exception ex) {
                LOGGER.error(Messages.getString("SplitTableWizard.UnableToSplitTable"), ex);
            }
            finally {
                originalTable.getDesign().setPropagatePKChahges(propagate);
            }
            SplitTableWizard.this.close();
        }
    }

    private class NextAction
    implements ActionListener {
        private NextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SplitTableWizard.this.taskNbr++;
            SplitTableWizard.this.handleButtons();
            switch (SplitTableWizard.this.taskNbr) {
                case 2: {
                    SplitTableWizard.this.cardLayout.show(SplitTableWizard.this.pnMain, SplitTableWizard.SECOND_PAGE);
                    break;
                }
                case 3: {
                    SplitTableWizard.this.cardLayout.show(SplitTableWizard.this.pnMain, SplitTableWizard.THIRD_PAGE);
                }
            }
        }
    }

    private class BackAction
    implements ActionListener {
        private BackAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SplitTableWizard.this.taskNbr--;
            SplitTableWizard.this.handleButtons();
            switch (SplitTableWizard.this.taskNbr) {
                case 1: {
                    SplitTableWizard.this.cardLayout.show(SplitTableWizard.this.pnMain, SplitTableWizard.FIRST_PAGE);
                    break;
                }
                case 2: {
                    SplitTableWizard.this.cardLayout.show(SplitTableWizard.this.pnMain, SplitTableWizard.SECOND_PAGE);
                }
            }
        }
    }
}

