/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.search.Messages;
import oracle.dbtools.crest.swingui.search.PropertyObject;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class ApplyPropertiesValuesDialog
extends CustomDialog {
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";
    private static final String EMPTY_STR = "empty string";
    protected JDialog dialog;
    private JPanel mainPanel;
    public Window parentWindow;
    protected boolean result = false;
    protected JPanel buttonsPanel;
    public JButton btnApply;
    public JButton btnClose;
    public JButton btnHelp;
    private JTable propertiesTable;
    private TableRowSorter<PropertiesListModel> sorter;
    private List propertiesList = new ArrayList();
    private List allPropertiesList = new ArrayList();
    private JScrollPane propertiesPane;
    private ModelIDObject currentModel;
    private List objects;
    private Iterator setsIt = null;
    private ApplicationView appView;
    GUIConfiguration configuration;
    private JPopupMenu menuStringTypeProperty;
    private JPopupMenu menuBooleanTypeProperty;
    private JMenuItem miEmptyString = new JMenuItem("empty string");
    private JMenuItem miTrue = new JMenuItem("true");
    private JMenuItem miFalse = new JMenuItem("false");
    private static final Logger LOGGER = new Logger(ApplyPropertiesValuesDialog.class);

    public ApplyPropertiesValuesDialog(ApplicationView appView, List objects, List allPropertiesList, ModelIDObject currentModel) {
        super(appView);
        this.appView = appView;
        this.objects = objects;
        this.currentModel = currentModel;
        this.allPropertiesList = allPropertiesList;
        this.configuration = GUIConfiguration.getInstance();
        this.initUI();
        this.filterProperties();
    }

    private void initUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(570, 500));
        PropertiesListModel model = new PropertiesListModel();
        this.propertiesTable = new JTable(model);
        this.propertiesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.propertiesTable.setSelectionMode(0);
        this.propertiesTable.getTableHeader().setReorderingAllowed(false);
        TableColumn col0 = this.propertiesTable.getColumnModel().getColumn(0);
        col0.setMinWidth(80);
        col0.setPreferredWidth(180);
        TableColumn col1 = this.propertiesTable.getColumnModel().getColumn(1);
        col1.setMinWidth(80);
        col1.setPreferredWidth(135);
        TableColumn col2 = this.propertiesTable.getColumnModel().getColumn(2);
        col2.setMinWidth(80);
        col2.setPreferredWidth(135);
        TableColumn col3 = this.propertiesTable.getColumnModel().getColumn(3);
        col3.setCellRenderer(new ButtonColumnCellRenderer());
        col3.setCellEditor(new ButtonColumnCellEditor());
        col3.setMinWidth(20);
        col3.setMaxWidth(20);
        col3.setPreferredWidth(20);
        TableColumn col4 = this.propertiesTable.getColumnModel().getColumn(4);
        col4.setMinWidth(100);
        col4.setMaxWidth(100);
        col4.setPreferredWidth(100);
        TableColumn col5 = this.propertiesTable.getColumnModel().getColumn(5);
        this.propertiesTable.getColumnModel().removeColumn(col5);
        this.sorter = new TableRowSorter<PropertiesListModel>(model);
        this.sorter.setSortsOnUpdates(true);
        this.menuStringTypeProperty = new JPopupMenu();
        this.menuStringTypeProperty.add(this.miEmptyString);
        this.miEmptyString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ApplyPropertiesValuesDialog.this.propertiesTable.convertRowIndexToModel(ApplyPropertiesValuesDialog.this.propertiesTable.getSelectedRow());
                ApplyPropertiesValuesDialog.this.propertiesTable.setValueAt(ApplyPropertiesValuesDialog.EMPTY_STR, row, 2);
                ApplyPropertiesValuesDialog.this.propertiesTable.updateUI();
            }
        });
        this.menuBooleanTypeProperty = new JPopupMenu();
        this.menuBooleanTypeProperty.add(this.miTrue);
        this.menuBooleanTypeProperty.add(this.miFalse);
        this.miTrue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ApplyPropertiesValuesDialog.this.propertiesTable.convertRowIndexToModel(ApplyPropertiesValuesDialog.this.propertiesTable.getSelectedRow());
                ApplyPropertiesValuesDialog.this.propertiesTable.setValueAt(ApplyPropertiesValuesDialog.TRUE_STR, row, 2);
                ApplyPropertiesValuesDialog.this.propertiesTable.updateUI();
            }
        });
        this.miFalse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ApplyPropertiesValuesDialog.this.propertiesTable.convertRowIndexToModel(ApplyPropertiesValuesDialog.this.propertiesTable.getSelectedRow());
                ApplyPropertiesValuesDialog.this.propertiesTable.setValueAt(ApplyPropertiesValuesDialog.FALSE_STR, row, 2);
                ApplyPropertiesValuesDialog.this.propertiesTable.updateUI();
            }
        });
        this.propertiesPane = new JScrollPane(this.propertiesTable);
        this.mainPanel.add((Component)this.propertiesPane, "Center");
        this.initButtonsPanel();
        this.add((Component)this.mainPanel, "Center");
    }

    private void initButtonsPanel() {
        this.buttonsPanel = new JPanel(new FlowLayout(1));
        this.btnApply = new JButton(Messages.getString("ApplyPropertiesValuesDialog.Apply"));
        this.btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnApply.addActionListener(new ApplyAction());
        this.btnApply.setMnemonic(65);
        this.buttonsPanel.add(this.btnApply);
        this.btnClose = new JButton(Messages.getString("ReportsGenerationDialog.Close"));
        this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnClose.addActionListener(new CloseAction());
        this.btnClose.setMnemonic(67);
        this.buttonsPanel.add(this.btnClose);
        this.btnHelp = new JButton(this.getHelpAction());
        this.btnHelp.setMnemonic(72);
        this.btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonsPanel.add(this.btnHelp);
        this.mainPanel.add((Component)this.buttonsPanel, "South");
    }

    private void filterProperties() {
        this.propertiesList.clear();
        Iterator it = this.allPropertiesList.iterator();
        while (it.hasNext()) {
            try {
                PropertyObject po = (PropertyObject)it.next();
                ClassDescription.PropertyDescription pd = po.getPropertyDescription();
                Method m = pd.setter;
                String className = pd.className;
                if (ReportConstants.isPropertyInNonUpdatableList(po.getName()) || !po.isProperty() || m == null) continue;
                PObject pObject = null;
                if (className.indexOf("java.lang.String") > -1 || className.indexOf("java.lang.Integer") > -1 || className.indexOf("java.lang.Boolean") > -1 || className.indexOf("boolean") > -1 || className.indexOf("float") > -1 || className.indexOf("short") > -1 || className.indexOf("long") > -1 || className.indexOf("double") > -1 || className.indexOf("int") > -1) {
                    pObject = new PObject(po, "", "Y", false);
                    this.propertiesList.add(pObject);
                } else {
                    Class<?> aClass = Class.forName(className);
                    if (!(!ModelIDObject.class.isAssignableFrom(aClass) || className.equals(ModelIDObject.class.getName()) || className.equals(DesignObject.class.getName()) || className.equals(RelationalObjectProxy.class.getName()) || className.equals(StorageObject.class.getName()))) {
                        if (this.currentModel instanceof DesignPart) {
                            this.setsIt = ((DesignPart)this.currentModel).getSearchableSets().iterator();
                        } else if (this.currentModel instanceof StorageDesign) {
                            this.setsIt = ((StorageDesign)this.currentModel).getSearchableSets().iterator();
                        }
                        boolean add = false;
                        while (this.setsIt.hasNext()) {
                            SearchSet ss = (SearchSet)this.setsIt.next();
                            Class clazz = ss.getClazz();
                            if (!aClass.isAssignableFrom(clazz)) continue;
                            add = true;
                            break;
                        }
                        if (add) {
                            pObject = new PObject(po, "", "Y", true);
                            this.propertiesList.add(pObject);
                        }
                    }
                }
                if (pObject == null) continue;
                this.getObjectsCommonValue(pObject);
            }
            catch (Exception e) {
                LOGGER.error("Exception in ApplyPropertiesValuesDialog.filterProperties() ", e);
            }
        }
        this.propertiesTable.updateUI();
        this.propertiesTable.updateUI();
    }

    private void getObjectsCommonValue(PObject pObject) {
        PropertyObject po = pObject.getPropertyObject();
        ClassDescription.PropertyDescription pd = po.getPropertyDescription();
        Method m = pd.getter;
        String className = pd.className;
        String previousValue = "";
        String currentvalue = "";
        boolean hasMatch = false;
        int counter = 0;
        for (SearchResultObject ro : this.objects) {
            block19: {
                try {
                    ModelIDObject obj = (ModelIDObject)ro.getObj();
                    Object object = m.invoke((Object)obj, new Object[0]);
                    if (className.indexOf("java.lang.String") > -1) {
                        if (object != null) {
                            currentvalue = (String)object;
                        }
                    } else if (className.indexOf("java.lang.Integer") > -1) {
                        if (object != null) {
                            currentvalue = ((Integer)object).toString();
                        }
                    } else if (className.indexOf("java.lang.Boolean") > -1) {
                        if (object != null) {
                            currentvalue = ((Boolean)object).toString();
                        }
                    } else if (className.indexOf("boolean") > -1 || className.indexOf("float") > -1 || className.indexOf("short") > -1 || className.indexOf("long") > -1 || className.indexOf("double") > -1 || className.indexOf("int") > -1) {
                        if (object != null) {
                            currentvalue = object.toString();
                        }
                    } else if (className.indexOf("java.util.Map") <= -1 && object != null) {
                        currentvalue = ((ModelObject)object).getName();
                    }
                    if (counter == 0) {
                        previousValue = currentvalue;
                    }
                    if (!currentvalue.equals("") && currentvalue.equals(previousValue)) {
                        previousValue = currentvalue;
                        hasMatch = true;
                        break block19;
                    }
                    hasMatch = false;
                    break;
                }
                catch (Exception e1) {
                    LOGGER.error("Exception in ApplyPropertiesValuesDialog.getObjectsCommonValue() ", e1);
                }
            }
            ++counter;
        }
        if (hasMatch) {
            pObject.setOldValue(previousValue);
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ApplyPropertiesValuesDialog.SetCommonProperties"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "MODIFY_PROPERTIES_VALUES_DIALOG";
    }

    public boolean showDialog() {
        this.parentWindow = this.getDialog();
        CommonUtil.centerOnScreen(this.parentWindow);
        this.getDialog().setVisible(true);
        return this.result;
    }

    public DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.getSize() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                if (((ModelIDObject)list.get(i)).getName().compareTo(((ModelIDObject)list.get(i - 1)).getName()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private static boolean match(String string, String regex) {
        if ("*".equalsIgnoreCase(regex)) {
            return true;
        }
        if (regex.indexOf(42) > -1) {
            regex = regex.replaceAll("\\*", "\\.*");
        }
        Pattern p = null;
        try {
            p = Pattern.compile(regex, 2);
            Matcher m = p.matcher(string);
            return m.find();
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }

    public class FilteredJList
    extends JList {
        private FilterField filterField;
        private int DEFAULT_FIELD_WIDTH = 20;

        public FilteredJList() {
            this.setModel((ListModel)new FilterModel());
            this.filterField = new FilterField(this.DEFAULT_FIELD_WIDTH);
        }

        public void setModel(ListModel m) {
            if (!(m instanceof FilterModel)) {
                throw new IllegalArgumentException();
            }
            super.setModel(m);
        }

        public void addItem(Object o) {
            ((FilterModel)this.getModel()).addElement(o);
        }

        public JTextField getFilterField() {
            return this.filterField;
        }

        class FilterModel
        extends DefaultListModel {
            ArrayList items = new ArrayList();
            ArrayList filterItems = new ArrayList();

            @Override
            public Object getElementAt(int index) {
                if (index < this.filterItems.size()) {
                    return this.filterItems.get(index);
                }
                return null;
            }

            @Override
            public int getSize() {
                return this.filterItems.size();
            }

            public void addElement(Object o) {
                this.items.add(o);
                this.refilter();
            }

            private void refilter() {
                this.filterItems.clear();
                String term = FilteredJList.this.getFilterField().getText();
                for (int i = 0; i < this.items.size(); ++i) {
                    if (!ApplyPropertiesValuesDialog.match(this.items.get(i).toString(), term)) continue;
                    this.filterItems.add(this.items.get(i));
                }
                this.fireContentsChanged(this, 0, this.getSize());
                ApplyPropertiesValuesDialog.this.sort(this);
            }
        }

        class FilterField
        extends JTextField
        implements DocumentListener {
            public FilterField(int width) {
                super(width);
                this.getDocument().addDocumentListener(this);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ((FilterModel)FilteredJList.this.getModel()).refilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ((FilterModel)FilteredJList.this.getModel()).refilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ((FilterModel)FilteredJList.this.getModel()).refilter();
            }
        }
    }

    public class SelectObjectDialog
    extends CustomDialog {
        protected JDialog soDialog;
        private JPanel soMainPanel;
        private JPanel soObjectsPanel;
        private JPanel soButtonsPanel;
        private JButton soBtnOk;
        private JButton soBtnClose;
        private Window soParentWindow;
        private JScrollPane availableObjectsSP;
        protected boolean soResult;
        private String className;
        private JTextField objectsFilter;
        private FilteredJList availableObjectsList;

        public SelectObjectDialog(ApplicationView appView, String className) {
            super(appView);
            this.soResult = false;
            this.availableObjectsList = new FilteredJList();
            this.className = className;
            this.initObjectsList();
            this.loadObjects();
            this.initSOButtonsPanel();
        }

        private void initObjectsList() {
            this.soMainPanel = new JPanel(new BorderLayout());
            this.soMainPanel.setPreferredSize(new Dimension(300, 500));
            this.availableObjectsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (SelectObjectDialog.this.availableObjectsList.getSelectedIndex() == -1) {
                        SelectObjectDialog.this.soBtnOk.setEnabled(false);
                    } else {
                        SelectObjectDialog.this.soBtnOk.setEnabled(true);
                    }
                }
            });
            JScrollPane pane = new JScrollPane(this.availableObjectsList, 22, 31);
            this.soMainPanel.add((Component)pane, "Center");
            this.soMainPanel.add((Component)this.availableObjectsList.getFilterField(), "North");
            this.add((Component)this.soMainPanel, "Center");
        }

        private void loadObjects() {
            try {
                Class<?> obj = Class.forName(this.className);
                if (ApplyPropertiesValuesDialog.this.currentModel instanceof DesignPart) {
                    ApplyPropertiesValuesDialog.this.setsIt = ((DesignPart)ApplyPropertiesValuesDialog.this.currentModel).getSearchableSets().iterator();
                } else if (ApplyPropertiesValuesDialog.this.currentModel instanceof StorageDesign) {
                    ApplyPropertiesValuesDialog.this.setsIt = ((StorageDesign)ApplyPropertiesValuesDialog.this.currentModel).getSearchableSets().iterator();
                }
                ArrayList collection = new ArrayList();
                while (ApplyPropertiesValuesDialog.this.setsIt.hasNext()) {
                    SearchSet ss = (SearchSet)ApplyPropertiesValuesDialog.this.setsIt.next();
                    Class clazz = ss.getClazz();
                    if (!obj.isAssignableFrom(clazz)) continue;
                    ((ElementSet)((Object)ss.getSet())).addAllElementsTo(collection);
                    break;
                }
                this.availableObjectsList.addItem(" ");
                Iterator it = collection.iterator();
                while (it.hasNext()) {
                    this.availableObjectsList.addItem(it.next());
                }
                ApplyPropertiesValuesDialog.this.sort((DefaultListModel)this.availableObjectsList.getModel());
            }
            catch (Exception e) {
                LOGGER.error("Exception in ApplyPropertiesValuesDialog.loadObjects() ", e);
            }
        }

        private void initSOButtonsPanel() {
            this.soButtonsPanel = new JPanel(new FlowLayout(1));
            this.soBtnOk = new JButton(Messages.getString("ApplyPropertiesValuesDialog.OK"));
            this.soBtnOk.setEnabled(false);
            this.soBtnOk.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.soBtnOk.addActionListener(new OKAction());
            this.soBtnOk.setMnemonic(79);
            this.soButtonsPanel.add(this.soBtnOk);
            this.soBtnClose = new JButton(Messages.getString("ReportsGenerationDialog.Close"));
            this.soBtnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.soBtnClose.addActionListener(new SoCloseAction());
            this.soBtnClose.setMnemonic(67);
            this.soButtonsPanel.add(this.soBtnClose);
            this.soMainPanel.add((Component)this.soButtonsPanel, "South");
        }

        @Override
        protected Window getDialog() {
            if (this.soDialog == null) {
                this.soDialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ApplyPropertiesValuesDialog.SelectObject"));
                this.soDialog.setDefaultCloseOperation(2);
                this.soDialog.getContentPane().add(this);
                this.setDefaultActions(this.soDialog);
                this.soDialog.pack();
                this.soDialog.setModal(true);
                this.soDialog.setResizable(false);
            }
            return this.soDialog;
        }

        @Override
        protected void close() {
            this.getDialog().dispose();
        }

        @Override
        protected String getHelpIndex() {
            return null;
        }

        public boolean showDialog() {
            this.soParentWindow = this.getDialog();
            CommonUtil.centerOnScreen(this.soParentWindow);
            this.getDialog().setVisible(true);
            return this.soResult;
        }

        private class OKAction
        implements ActionListener {
            private OKAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplyPropertiesValuesDialog.this.propertiesTable.setValueAt(SelectObjectDialog.this.availableObjectsList.getSelectedValue(), ApplyPropertiesValuesDialog.this.propertiesTable.getSelectedRow(), 2);
                SelectObjectDialog.this.close();
            }
        }

        private class SoCloseAction
        implements ActionListener {
            private SoCloseAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectObjectDialog.this.close();
            }
        }
    }

    class PObject {
        private PropertyObject propertyObject;
        private Object oldValue = "";
        private Object newValue = "";
        private String extraValue = "";
        private boolean objectType;

        public PObject(PropertyObject po, Object newValue, String extraValue, boolean objectType) {
            this.propertyObject = po;
            this.extraValue = extraValue;
            this.objectType = objectType;
        }

        public PropertyObject getPropertyObject() {
            return this.propertyObject;
        }

        public void setPropertyObject(PropertyObject propertyObject) {
            this.propertyObject = propertyObject;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public void setOldValue(Object oldValue) {
            this.oldValue = oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public void setNewValue(Object newValue) {
            this.newValue = newValue;
        }

        public String getExtraValue() {
            return this.extraValue;
        }

        public void setExtraValue(String extraValue) {
            this.extraValue = extraValue;
        }

        public boolean isObjectType() {
            return this.objectType;
        }
    }

    class ButtonColumnCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JButton button;

        public ButtonColumnCellEditor() {
            this.button = new JButton(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ApplyPropertiesValuesDialog.this.propertiesTable.convertRowIndexToModel(ApplyPropertiesValuesDialog.this.propertiesTable.getEditingRow());
                    PObject t = (PObject)ApplyPropertiesValuesDialog.this.propertiesList.get(row);
                    PropertyObject po = t.getPropertyObject();
                    ClassDescription.PropertyDescription pd = po.getPropertyDescription();
                    ButtonColumnCellEditor.this.fireEditingStopped();
                    String value = (String)ApplyPropertiesValuesDialog.this.propertiesTable.getModel().getValueAt(row, 5);
                    String type = (String)ApplyPropertiesValuesDialog.this.propertiesTable.getModel().getValueAt(row, 4);
                    if (!(type.equals("Integer") || type.equals("float") || type.equals("short") || type.equals("long") || type.equals("double") || type.equals("int"))) {
                        if (type.equals("String")) {
                            ApplyPropertiesValuesDialog.this.menuStringTypeProperty.show(ApplyPropertiesValuesDialog.this, ButtonColumnCellEditor.this.button.getX(), ButtonColumnCellEditor.this.button.getY() + ButtonColumnCellEditor.this.button.getHeight());
                        } else if (type.equals("Boolean") || type.equals("boolean")) {
                            ApplyPropertiesValuesDialog.this.menuBooleanTypeProperty.show(ApplyPropertiesValuesDialog.this, ButtonColumnCellEditor.this.button.getX(), ButtonColumnCellEditor.this.button.getY() + ButtonColumnCellEditor.this.button.getHeight());
                        } else {
                            SelectObjectDialog d = new SelectObjectDialog(ApplyPropertiesValuesDialog.this.appView, pd.className);
                            d.showDialog();
                        }
                    }
                    ((AbstractTableModel)ApplyPropertiesValuesDialog.this.propertiesTable.getModel()).fireTableCellUpdated(row, 2);
                    ((AbstractTableModel)ApplyPropertiesValuesDialog.this.propertiesTable.getModel()).fireTableCellUpdated(row, 5);
                }
            });
            this.button.setFocusable(false);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.button;
        }
    }

    class ButtonColumnCellRenderer
    implements TableCellRenderer {
        private final JButton button = new JButton();

        public ButtonColumnCellRenderer() {
            this.button.setFocusable(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String type = (String)table.getValueAt(row, 4);
            PObject t = (PObject)ApplyPropertiesValuesDialog.this.propertiesList.get(row);
            if (t.isObjectType()) {
                this.button.setText("...");
                this.button.setIcon(null);
                this.button.setEnabled(true);
                this.button.setForeground(table.getForeground());
                this.button.setBackground(UIManager.getColor("Button.background"));
            } else if (type.equals("String")) {
                this.button.setIcon(GUIConfiguration.getInstance().getIcon("NEW_ASSOCIATION_B2A", 16));
                this.button.setText("");
                this.button.setEnabled(true);
                this.button.setForeground(table.getForeground());
                this.button.setBackground(UIManager.getColor("Button.background"));
            } else if (type.equals("Boolean") || type.equals("boolean")) {
                this.button.setIcon(GUIConfiguration.getInstance().getIcon("NEW_ASSOCIATION_B2A", 16));
                this.button.setText("");
                this.button.setEnabled(true);
                this.button.setForeground(table.getForeground());
                this.button.setBackground(UIManager.getColor("Button.background"));
            } else {
                this.button.setText("");
                this.button.setIcon(null);
                this.button.setEnabled(false);
                this.button.setForeground(Color.WHITE);
                this.button.setBackground(Color.WHITE);
            }
            return this.button;
        }
    }

    private class PropertiesListModel
    extends DefaultTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("ApplyPropertiesValuesDialog.PropertyName"), Messages.getString("ApplyPropertiesValuesDialog.OldPropertyValue"), Messages.getString("ApplyPropertiesValuesDialog.NewPropertyValue"), "", Messages.getString("ApplyPropertiesValuesDialog.PropertyType"), "hidden column"};

        private PropertiesListModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            PObject t = (PObject)ApplyPropertiesValuesDialog.this.propertiesList.get(rowIndex);
            String type = (String)this.getValueAt(rowIndex, 4);
            if (columnIndex == 2) {
                return !t.isObjectType();
            }
            if (columnIndex == 3) {
                return t.isObjectType() || type.equals("String") || type.equals("boolean") || type.equals("Boolean");
            }
            if (columnIndex == 5) {
                return false;
            }
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public int getRowCount() {
            return ApplyPropertiesValuesDialog.this.propertiesList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            PObject t = (PObject)ApplyPropertiesValuesDialog.this.propertiesList.get(row);
            PropertyObject po = t.getPropertyObject();
            String defaultValue = po.getPropertyDescription().defaultValue;
            String type = (String)this.getValueAt(row, 4);
            if (col == 2) {
                if (type.equals("String")) {
                    if (defaultValue.equals("")) {
                        t.setNewValue(value);
                    } else if ((defaultValue.equals("NO") || defaultValue.equals("YES")) && !((String)value).trim().equals("")) {
                        if (((String)value).equals("NO") || ((String)value).equals("YES")) {
                            t.setNewValue(value);
                        } else {
                            JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), "Valid values are: YES / NO in any case.", Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                        }
                    }
                } else if (type.equals("Integer")) {
                    try {
                        Integer.valueOf((String)value);
                        t.setNewValue(value);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueMustBeNumeric"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                    }
                } else if (type.equalsIgnoreCase("boolean")) {
                    String v = ((String)value).toLowerCase();
                    if (!v.trim().equals("")) {
                        if (v.equals(ApplyPropertiesValuesDialog.TRUE_STR) || v.equals(ApplyPropertiesValuesDialog.FALSE_STR)) {
                            t.setNewValue(v);
                        } else {
                            JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueNotBoolean"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                        }
                    }
                } else if (type.equals("float")) {
                    try {
                        Float.parseFloat((String)value);
                        t.setNewValue(value);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueMustBeNumeric"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                    }
                } else if (type.equals("short")) {
                    try {
                        Short.parseShort((String)value);
                        t.setNewValue(value);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueMustBeNumeric"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                    }
                } else if (type.equals("long")) {
                    try {
                        Long.parseLong((String)value);
                        t.setNewValue(value);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueMustBeNumeric"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                    }
                } else if (type.equals("double")) {
                    try {
                        Float f = new Float((String)value);
                        double i = f.doubleValue();
                        t.setNewValue(value);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueMustBeNumeric"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                    }
                } else if (type.equals("int")) {
                    try {
                        Integer.parseInt((String)value);
                        t.setNewValue(value);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.ValueMustBeNumeric"), Messages.getString("ApplyPropertiesValuesDialog.Error"), 0);
                    }
                } else {
                    t.setNewValue(value);
                }
            } else if (col == 5) {
                t.setExtraValue((String)value);
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            PObject t = (PObject)ApplyPropertiesValuesDialog.this.propertiesList.get(rowIndex);
            PropertyObject po = t.getPropertyObject();
            ClassDescription.PropertyDescription pd = po.getPropertyDescription();
            String className = pd.className;
            if (columnIndex == 0) {
                return ReportUtils.getDisplayName(po.getPropertyDescription().name);
            }
            if (columnIndex == 1) {
                return t.getOldValue();
            }
            if (columnIndex == 2) {
                return t.getNewValue();
            }
            if (columnIndex == 4) {
                if (className.lastIndexOf(".") > -1) {
                    return className.substring(className.lastIndexOf(".") + 1, className.length());
                }
                return className;
            }
            if (columnIndex == 5) {
                return t.getExtraValue();
            }
            return "";
        }
    }

    protected class ApplyAction
    implements ActionListener {
        protected ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (PObject t : ApplyPropertiesValuesDialog.this.propertiesList) {
                PropertyObject po = t.getPropertyObject();
                ClassDescription.PropertyDescription pd = po.getPropertyDescription();
                String className = pd.className;
                Method m = pd.setter;
                Object value = t.getNewValue();
                boolean go = false;
                if (!t.isObjectType()) {
                    if (t.getExtraValue().equals("Y")) {
                        if (className.equals("java.lang.String")) {
                            if (!((String)value).trim().equals("") || value.equals(ApplyPropertiesValuesDialog.EMPTY_STR)) {
                                go = true;
                            }
                        } else {
                            go = !((String)value).trim().equals("");
                        }
                    } else if (t.getExtraValue().equals("N")) {
                        go = true;
                    }
                } else if (value != null) {
                    if ("".equals(value)) {
                        go = false;
                    } else if (" ".equals(value)) {
                        value = null;
                        go = true;
                    } else if (!"".equals(value)) {
                        go = true;
                    }
                }
                if (!go) continue;
                for (SearchResultObject ro : ApplyPropertiesValuesDialog.this.objects) {
                    try {
                        Object obj = ro.getObj();
                        if (className.equals("java.lang.String")) {
                            if (value.equals(ApplyPropertiesValuesDialog.EMPTY_STR)) {
                                m.invoke(obj, "");
                                continue;
                            }
                            m.invoke(obj, value);
                            continue;
                        }
                        if (value != null && (value.equals(ApplyPropertiesValuesDialog.TRUE_STR) || value.equals(ApplyPropertiesValuesDialog.FALSE_STR))) {
                            m.invoke(obj, Boolean.parseBoolean((String)value));
                        } else {
                            m.invoke(obj, value);
                            MDTransformer.setRelatedProperty(obj, pd);
                        }
                        ((ModelIDObject)obj).setDirty(true);
                    }
                    catch (Exception e1) {
                        LOGGER.error("Exception in ModifyPropertiesValuesDialog.ApplyAction() ", e1);
                    }
                }
                if (className.equals("java.lang.String")) {
                    if (value.equals(ApplyPropertiesValuesDialog.EMPTY_STR)) {
                        t.setOldValue("");
                    } else {
                        t.setOldValue(value);
                    }
                } else {
                    t.setOldValue(value);
                }
                t.setNewValue("");
                ApplyPropertiesValuesDialog.this.propertiesTable.updateUI();
            }
            JOptionPane.showMessageDialog(ApplyPropertiesValuesDialog.this.getDialog(), Messages.getString("ApplyPropertiesValuesDialog.Completed"), Messages.getString("ApplyPropertiesValuesDialog.Information"), 1);
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ApplyPropertiesValuesDialog.this.close();
        }
    }
}

