/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.fcp.Icons;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DesignSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.search.ApplyPropertiesValuesDialog;
import oracle.dbtools.crest.swingui.search.JComboHtmlItem;
import oracle.dbtools.crest.swingui.search.Messages;
import oracle.dbtools.crest.swingui.search.ModifiedFlowLayout;
import oracle.dbtools.crest.swingui.search.SavedSearch;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.swingui.wizards.reports.SearchResultsReportsGenerationDialog;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;
import oracle.ide.controls.Toolbar;

public class GlobalSearchPanel
extends JPanel {
    private static final String NEW_SEARCH = "<New Search>";
    Icon refreshIcon = Icons.getRefreshIcon();
    private JMenuItem miSave = new JMenuItem(Messages.getString("GlobalSearchPanel.Save"), Icons.getSaveIcon());
    private JMenuItem miClear = new JMenuItem(Messages.getString("GlobalSearchPanel.Clear"));
    private JMenuItem miDelete = new JMenuItem(Messages.getString("GlobalSearchPanel.Delete"), Icons.getDeleteIcon());
    private JCheckBox cbCaseSensitive;
    private JCheckBox cbStopOnFirst;
    private JCheckBox cbUseRegex;
    private JComboBox cmbFilterObject;
    private JComboBox cmbFilterModel;
    private JButton btnPrintReport;
    private JButton btnSetProperties;
    private JButton btnRefresh;
    private JComboBox cmbSavedSearches;
    private JButton btnSavedSearches;
    private List resultList;
    private JTable resultsTable;
    private JScrollPane resultPane;
    private JPanel mainPanel;
    private DefaultListModel diagramsPerObjectListModel;
    private JList diagramsPerObjectList;
    private JScrollPane diagramsPerObjectPane;
    private SearchResultObject selectedObject;
    private MetaDataManager metaDataManager;
    private JTextField globalSearchPattern;
    protected Toolbar toolbar1;
    private List allFoundResults = new ArrayList();
    private List allFoundObjectTypes = new ArrayList();
    private JPopupMenu menu;
    private DefaultComboBoxModel cmbSavedSearchModel;
    private ApplicationView appView;
    private Settings settings;
    private HashMap extraParams = new HashMap();
    private FilterObjectItemListener filterObjectItemListener;
    private Object selectedModel;
    private SavedSearchEditor savedSearchEditor;
    private static final Logger LOGGER = new Logger(GlobalSearchPanel.class);
    static final String VIEW_ID = "SearchPanel";

    public GlobalSearchPanel() {
        this.setLayout(new BorderLayout());
    }

    public void createGUI() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.appView = ApplicationView.getInstance();
        this.settings = this.appView.getSettings();
        this.metaDataManager = this.appView.getXMLTransformationManager().getMetaDataManager();
        this.initToolbar();
        this.initResultsPanel();
        this.cbCaseSensitive = new JCheckBox(Messages.getString("SearchPanel.CaseSensitive"));
        this.add((Component)this.mainPanel, "Center");
    }

    private void initToolbar() {
        this.btnRefresh = new JButton(this.refreshIcon);
        this.btnRefresh.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btnRefresh.setPreferredSize(new Dimension(20, 20));
        this.btnRefresh.setToolTipText(Messages.getString("GlobalSearchPanel.Refresh"));
        this.btnRefresh.addActionListener(new RefreshAction());
        this.btnRefresh.setMnemonic(70);
        this.btnRefresh.setEnabled(true);
        JLabel lblFilterDesign = new JLabel(Messages.getString("GlobalSearchPanel.DesignsFilter"));
        lblFilterDesign.setPreferredSize(new Dimension(60, 20));
        lblFilterDesign.setMinimumSize(new Dimension(60, 20));
        this.cmbFilterModel = new JComboBox();
        this.cmbFilterModel.setToolTipText(Messages.getString("GlobalSearchPanel.FilterModel"));
        this.cmbFilterModel.setPreferredSize(new Dimension(180, 20));
        this.cmbFilterModel.setMinimumSize(new Dimension(180, 20));
        this.cmbFilterModel.addItemListener(new FilterDesignItemListener());
        this.cmbFilterModel.setRenderer(new ComboBoxRenderer());
        JLabel lblFilterObject = new JLabel(Messages.getString("GlobalSearchPanel.Object"));
        lblFilterObject.setPreferredSize(new Dimension(60, 20));
        lblFilterObject.setMinimumSize(new Dimension(60, 20));
        this.cmbFilterObject = new JComboBox();
        this.cmbFilterObject.setToolTipText(Messages.getString("GlobalSearchPanel.FilterObjectType"));
        this.cmbFilterObject.setRenderer(new CmbFilterObjectRenderer());
        this.cmbFilterObject.setPreferredSize(new Dimension(180, 20));
        this.cmbFilterObject.setMinimumSize(new Dimension(180, 20));
        this.filterObjectItemListener = new FilterObjectItemListener();
        JLabel lblEmptySpace = new JLabel("");
        lblEmptySpace.setPreferredSize(new Dimension(20, 20));
        JLabel lblEmptySpace1 = new JLabel("");
        lblEmptySpace1.setPreferredSize(new Dimension(20, 20));
        JLabel lblEmptySpace2 = new JLabel("");
        lblEmptySpace2.setPreferredSize(new Dimension(40, 20));
        JLabel lblEmptySpace3 = new JLabel("");
        lblEmptySpace3.setPreferredSize(new Dimension(20, 20));
        JLabel lblEmptySpace4 = new JLabel("");
        lblEmptySpace4.setPreferredSize(new Dimension(40, 20));
        JPanel jpPrintReport = new JPanel();
        this.btnPrintReport = new JButton(Messages.getString("GlobalSearchPanel.Report"));
        jpPrintReport.add(this.btnPrintReport);
        this.btnPrintReport.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btnPrintReport.setPreferredSize(new Dimension(100, 20));
        this.btnPrintReport.addActionListener(new PrintReportAction());
        this.btnPrintReport.setMnemonic(80);
        this.btnPrintReport.setEnabled(false);
        this.btnPrintReport.setToolTipText(Messages.getString("GlobalSearchPanel.ApplyFilterToUseReporting"));
        JPanel jpSetProperties = new JPanel();
        this.btnSetProperties = new JButton(Messages.getString("GlobalSearchPanel.Properties"));
        jpSetProperties.add(this.btnSetProperties);
        this.btnSetProperties.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btnSetProperties.setPreferredSize(new Dimension(100, 20));
        this.btnSetProperties.addActionListener(new ChangePropertiesAction());
        this.btnSetProperties.setMnemonic(67);
        this.btnSetProperties.setEnabled(false);
        this.btnSetProperties.setToolTipText(Messages.getString("GlobalSearchPanel.ApplyFilterToUseSetProperties"));
        JLabel lblSavedSearches = new JLabel(Messages.getString("GlobalSearchPanel.SavedSearches"));
        lblSavedSearches.setPreferredSize(new Dimension(100, 20));
        lblSavedSearches.setMinimumSize(new Dimension(100, 20));
        this.cmbSavedSearches = new JComboBox();
        this.cmbSavedSearches.setToolTipText(Messages.getString("GlobalSearchPanel.SelectSavedSearch"));
        this.cmbSavedSearchModel = new DefaultComboBoxModel<Object>(this.getSavedSearches().toArray());
        this.cmbSavedSearches.setModel(this.cmbSavedSearchModel);
        this.cmbSavedSearches.setEditable(true);
        this.cmbSavedSearches.setPreferredSize(new Dimension(150, 20));
        this.cmbSavedSearches.setMinimumSize(new Dimension(180, 20));
        this.cmbSavedSearches.setRenderer(new SavedSearchRenderer());
        this.savedSearchEditor = new SavedSearchEditor(this.getSavedSearches());
        this.cmbSavedSearches.setEditor(this.savedSearchEditor);
        this.miDelete.setEnabled(false);
        this.miSave.setEnabled(false);
        this.miClear.setEnabled(false);
        this.cmbSavedSearches.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object currentItem = GlobalSearchPanel.this.cmbSavedSearches.getEditor().getItem();
                    if (currentItem instanceof SavedSearch) {
                        SavedSearch ss = (SavedSearch)currentItem;
                        GlobalSearchPanel.this.globalSearchPattern.setText(ss.getPattern());
                        GlobalSearchPanel.this.cbStopOnFirst.setSelected(ss.isStopOnFirst());
                        for (DesignPart currentModel : GlobalSearchPanel.this.getAllModels()) {
                            if (!currentModel.getObjectID().equals(ss.getDesignID())) continue;
                            GlobalSearchPanel.this.cmbFilterModel.setSelectedItem(currentModel);
                            break;
                        }
                        for (int index = 0; index < GlobalSearchPanel.this.cmbFilterObject.getItemCount(); ++index) {
                            Object current = GlobalSearchPanel.this.cmbFilterObject.getItemAt(index);
                            String objType = "";
                            String objModel = "";
                            if (current instanceof JComboHtmlItem) {
                                objType = ((JComboHtmlItem)current).getRawText();
                                objModel = ((SearchSet)((JComboHtmlItem)current).getObject()).getModel().getObjectID();
                            } else {
                                objType = "ALL";
                            }
                            if (!objType.equals(ss.getObject()) || !objModel.equals(ss.getModelID())) continue;
                            GlobalSearchPanel.this.cmbFilterObject.setSelectedItem(current);
                            break;
                        }
                        GlobalSearchPanel.this.miDelete.setEnabled(true);
                        GlobalSearchPanel.this.miSave.setEnabled(true);
                        GlobalSearchPanel.this.miClear.setEnabled(true);
                    } else {
                        if (currentItem.equals(GlobalSearchPanel.NEW_SEARCH)) {
                            GlobalSearchPanel.this.miClear.doClick();
                            GlobalSearchPanel.this.miSave.setEnabled(false);
                            GlobalSearchPanel.this.miClear.setEnabled(false);
                        } else {
                            GlobalSearchPanel.this.miSave.setEnabled(true);
                            GlobalSearchPanel.this.miClear.setEnabled(true);
                        }
                        GlobalSearchPanel.this.miDelete.setEnabled(false);
                    }
                }
            }
        });
        this.miSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean found = false;
                Object currentItem = GlobalSearchPanel.this.cmbSavedSearches.getEditor().getItem();
                ArrayList allSavedSearches = GlobalSearchPanel.this.appView.getSavedSearches();
                Iterator allSavedSearchesIt = allSavedSearches.iterator();
                Object selectedModel = GlobalSearchPanel.this.cmbFilterModel.getSelectedItem();
                Object selectedObjType = GlobalSearchPanel.this.cmbFilterObject.getSelectedItem();
                String selectedObjTypeModel = "";
                if (!selectedModel.equals("ALL")) {
                    selectedModel = ((ModelIDObject)GlobalSearchPanel.this.cmbFilterModel.getSelectedItem()).getObjectID();
                }
                if (!selectedObjType.equals("ALL")) {
                    selectedObjType = ((SearchSet)((JComboHtmlItem)GlobalSearchPanel.this.cmbFilterObject.getSelectedItem()).getObject()).getTypeName();
                    selectedObjTypeModel = ((SearchSet)((JComboHtmlItem)GlobalSearchPanel.this.cmbFilterObject.getSelectedItem()).getObject()).getModel().getObjectID();
                }
                if (currentItem instanceof SavedSearch) {
                    SavedSearch ss = (SavedSearch)currentItem;
                    while (allSavedSearchesIt.hasNext()) {
                        SavedSearch currentSS = (SavedSearch)allSavedSearchesIt.next();
                        if (!currentSS.getSsId().equals(ss.getSsId())) continue;
                        int choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), "Are you sure you want to overwrite saved search?", Messages.getString("GlobalSearchPanel.Overwrite"), 0, 3);
                        if (choice == 0) {
                            ss.setSsName(GlobalSearchPanel.this.savedSearchEditor.getTextFeild().getText());
                            ss.setDesignID((String)selectedModel);
                            ss.setObject((String)selectedObjType);
                            ss.setPattern(GlobalSearchPanel.this.globalSearchPattern.getText());
                            ss.setCaseSensitive(GlobalSearchPanel.this.cbCaseSensitive.isSelected());
                            ss.setStopOnFirst(GlobalSearchPanel.this.cbStopOnFirst.isSelected());
                        }
                        break;
                    }
                } else {
                    SavedSearch tempSs = new SavedSearch(null, (String)currentItem, (String)selectedModel, selectedObjTypeModel, (String)selectedObjType, GlobalSearchPanel.this.globalSearchPattern.getText(), GlobalSearchPanel.this.cbCaseSensitive.isSelected(), false, Collections.EMPTY_LIST, GlobalSearchPanel.this.cbStopOnFirst.isSelected(), false);
                    allSavedSearches.add(tempSs);
                    GlobalSearchPanel.this.cmbSavedSearchModel.addElement(tempSs);
                    GlobalSearchPanel.this.savedSearchEditor.addItem(tempSs);
                    GlobalSearchPanel.this.cmbSavedSearches.setSelectedItem(currentItem);
                }
            }
        });
        this.miClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GlobalSearchPanel.this.globalSearchPattern.setText("");
                GlobalSearchPanel.this.cmbFilterModel.setSelectedItem("ALL");
                GlobalSearchPanel.this.cmbFilterObject.setSelectedItem("ALL");
                GlobalSearchPanel.this.cmbSavedSearches.setSelectedItem(GlobalSearchPanel.NEW_SEARCH);
                GlobalSearchPanel.this.resultsTable.updateUI();
            }
        });
        this.miDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SavedSearch currentSelectedSS = (SavedSearch)GlobalSearchPanel.this.cmbSavedSearches.getEditor().getItem();
                SavedSearch ss = null;
                Iterator allSavedSearchesIt = GlobalSearchPanel.this.appView.getSavedSearches().iterator();
                while (allSavedSearchesIt.hasNext() && !(ss = (SavedSearch)allSavedSearchesIt.next()).getSsId().equals(currentSelectedSS.getSsId())) {
                }
                int choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), "Are you sure you want to delete saved search?", Messages.getString("GlobalSearchPanel.Delete"), 0, 3);
                if (choice == 0) {
                    GlobalSearchPanel.this.appView.getSavedSearches().remove(ss);
                    GlobalSearchPanel.this.cmbSavedSearchModel.removeElement(ss);
                }
            }
        });
        this.menu = new JPopupMenu();
        this.menu.add(this.miSave);
        this.menu.add(this.miClear);
        this.menu.addSeparator();
        this.menu.add(this.miDelete);
        JPanel jpSavedSearches = new JPanel();
        this.btnSavedSearches = new JButton(Messages.getString("GlobalSearchPanel.More"));
        this.btnSavedSearches.setToolTipText(Messages.getString("GlobalSearchPanel.ClickForOptions"));
        jpSavedSearches.add(this.btnSavedSearches);
        this.btnSavedSearches.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btnSavedSearches.setPreferredSize(new Dimension(50, 20));
        this.btnSavedSearches.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GlobalSearchPanel.this.menu.show(e.getComponent(), 0, 20);
            }
        });
        this.cbStopOnFirst = new JCheckBox(Messages.getString("GlobalSearchPanel.StopOnFirst"));
        this.cbStopOnFirst.setToolTipText(Messages.getString("SearchPanel.StopOnFirstTooltip"));
        this.cbStopOnFirst.setSelected(true);
        this.cbStopOnFirst.addActionListener(new StopOnFirstListener());
        this.cbUseRegex = new JCheckBox(Messages.getString("GlobalSearchPanel.UseRegEx"));
        this.cbUseRegex.setToolTipText(Messages.getString("GlobalSearchPanel.UseRegularExpression"));
        this.cbUseRegex.setSelected(false);
        this.cbUseRegex.addActionListener(new UseRegExListener());
        this.toolbar1 = new Toolbar();
        this.toolbar1.setLayout((LayoutManager)new ModifiedFlowLayout(0));
        this.toolbar1.setFloatable(false);
        this.toolbar1.setRollover(true);
        if (Extension.isDataModeler()) {
            this.toolbar1.add((Component)this.btnRefresh, 0);
            this.toolbar1.add((Component)this.toolbar1.newSeparator(), 1);
            this.toolbar1.add((Component)lblFilterDesign, 2);
            this.toolbar1.add((Component)this.cmbFilterModel, 3);
            this.toolbar1.add((Component)this.toolbar1.newSeparator(), 4);
            this.toolbar1.add((Component)lblFilterObject, 5);
            this.toolbar1.add((Component)this.cmbFilterObject, 6);
            this.toolbar1.add((Component)this.toolbar1.newSeparator(), 7);
            this.toolbar1.add((Component)lblSavedSearches, 8);
            this.toolbar1.add((Component)this.cmbSavedSearches, 9);
            this.toolbar1.add((Component)jpSavedSearches, 10);
            this.toolbar1.add((Component)this.toolbar1.newSeparator(), 11);
            this.toolbar1.add((Component)jpPrintReport, 12);
            this.toolbar1.add((Component)this.toolbar1.newSeparator(), 13);
            this.toolbar1.add((Component)jpSetProperties, 14);
            this.toolbar1.add((Component)this.toolbar1.newSeparator(), 15);
            this.toolbar1.add((Component)this.cbStopOnFirst, 16);
            this.toolbar1.add((Component)this.cbUseRegex, 17);
        } else {
            this.toolbar1.add((Component)this.btnRefresh, 0);
            this.toolbar1.add((Component)this.toolbar1.newSeparator(), 1);
            this.toolbar1.add((Component)this.appView.getGlobalSearch().getGUI(), 2);
            this.toolbar1.add((Component)this.toolbar1.newSeparator(), 3);
            this.toolbar1.add((Component)lblFilterDesign, 4);
            this.toolbar1.add((Component)this.cmbFilterModel, 5);
            this.toolbar1.add((Component)this.toolbar1.newSeparator(), 6);
            this.toolbar1.add((Component)lblFilterObject, 7);
            this.toolbar1.add((Component)this.cmbFilterObject, 8);
            this.toolbar1.add((Component)this.toolbar1.newSeparator(), 9);
            this.toolbar1.add((Component)lblSavedSearches, 10);
            this.toolbar1.add((Component)this.cmbSavedSearches, 11);
            this.toolbar1.add((Component)jpSavedSearches, 12);
            this.toolbar1.add((Component)this.toolbar1.newSeparator(), 13);
            this.toolbar1.add((Component)jpPrintReport, 14);
            this.toolbar1.add((Component)this.toolbar1.newSeparator(), 15);
            this.toolbar1.add((Component)jpSetProperties, 16);
            this.toolbar1.add((Component)this.toolbar1.newSeparator(), 17);
            this.toolbar1.add((Component)this.cbStopOnFirst, 18);
            this.toolbar1.add((Component)this.cbUseRegex, 19);
        }
        this.add((Component)this.toolbar1, "North");
    }

    private void initResultsPanel() {
        JPanel resultsPanel = new JPanel(new GridBagLayout());
        this.resultList = new ArrayList();
        this.resultsTable = new JTable(new ResultListModel());
        JTableHeader header = this.resultsTable.getTableHeader();
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        tips.setToolTip(this.resultsTable.getColumnModel().getColumn(4), Messages.getString("GlobalSearchPanel.MoveOverCellToSeeFullContent"));
        header.addMouseMotionListener(tips);
        TableColumn col0 = this.resultsTable.getColumnModel().getColumn(0);
        col0.setPreferredWidth(250);
        col0.setMinWidth(20);
        TableColumn col1 = this.resultsTable.getColumnModel().getColumn(1);
        col1.setPreferredWidth(200);
        col1.setMinWidth(20);
        TableColumn col2 = this.resultsTable.getColumnModel().getColumn(2);
        col2.setPreferredWidth(150);
        col2.setMinWidth(20);
        TableColumn col3 = this.resultsTable.getColumnModel().getColumn(3);
        col3.setPreferredWidth(100);
        col3.setMinWidth(20);
        TableColumn col4 = this.resultsTable.getColumnModel().getColumn(4);
        col4.setCellRenderer(new ContentRenderer());
        col4.setPreferredWidth(350);
        col4.setMinWidth(20);
        TableColumn col5 = this.resultsTable.getColumnModel().getColumn(5);
        this.resultsTable.getColumnModel().removeColumn(col5);
        this.resultsTable.setSelectionMode(0);
        this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (GlobalSearchPanel.this.resultsTable.getSelectedRow() == -1) {
                    GlobalSearchPanel.this.diagramsPerObjectListModel.clear();
                } else {
                    GlobalSearchPanel.this.selectedObject = (SearchResultObject)GlobalSearchPanel.this.resultList.get(GlobalSearchPanel.this.resultsTable.convertRowIndexToModel(GlobalSearchPanel.this.resultsTable.getSelectedRow()));
                    GlobalSearchPanel.this.getDiagrams(GlobalSearchPanel.this.selectedObject.getObj());
                }
            }
        });
        this.resultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GlobalSearchPanel.this.selectedObject = (SearchResultObject)GlobalSearchPanel.this.resultList.get(GlobalSearchPanel.this.resultsTable.convertRowIndexToModel(GlobalSearchPanel.this.resultsTable.getSelectedRow()));
                    ((ModelIDObject)GlobalSearchPanel.this.selectedObject.getObj()).showPropertyDialog();
                }
            }
        });
        this.resultPane = new JScrollPane(this.resultsTable);
        JPanel diagramsPanel = new JPanel(new GridBagLayout());
        diagramsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SearchPanel.Diagrams")));
        this.diagramsPerObjectListModel = new DefaultListModel();
        this.diagramsPerObjectList = new JList(this.diagramsPerObjectListModel);
        this.diagramsPerObjectList.addMouseListener(this.diagramDblClickMouseAdapter());
        this.diagramsPerObjectPane = new JScrollPane(this.diagramsPerObjectList);
        diagramsPanel.add((Component)this.diagramsPerObjectPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        resultsPanel.add((Component)this.resultPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 200));
        resultsPanel.add((Component)diagramsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 1, new Insets(5, 5, 5, 5), 0, 100));
        this.mainPanel.add((Component)resultsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void runSearch(boolean enterKeyUsed) {
        this.resultsTable.getSelectionModel().clearSelection();
        this.resultsTable.setAutoCreateRowSorter(false);
        this.resultsTable.setRowSorter(null);
        this.resultList.clear();
        this.resultsTable.updateUI();
        this.diagramsPerObjectListModel.clear();
        if (enterKeyUsed) {
            this.search();
        } else if (this.settings.isSearchAsUType() && this.globalSearchPattern.getText().length() >= this.settings.getSearchAsUTypeStart()) {
            this.search();
        }
    }

    private void search() {
        this.allFoundResults = this.createResultList();
        if (this.allFoundResults.size() > 0) {
            for (Object obj : this.allFoundResults) {
                this.resultList.add(obj);
            }
            this.resultsTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.resultsTable, 0);
            this.resultsTable.setRowSelectionInterval(0, 0);
            this.resultsTable.updateUI();
            this.getDiagrams(((SearchResultObject)this.resultList.get(this.resultsTable.convertRowIndexToModel(this.resultsTable.getSelectedRow()))).getObj());
            this.cmbFilterObject.removeItemListener(this.filterObjectItemListener);
            this.cmbFilterObject.removeAllItems();
            this.cmbFilterObject.addItem("ALL");
            Collections.sort(this.allFoundObjectTypes, new ReportUtils.SearchSetsComparator());
            for (SearchSet ss : this.allFoundObjectTypes) {
                this.cmbFilterObject.addItem(new JComboHtmlItem(ss.getTypeName(), "<html><nobr><b>" + ss.getTypeName() + "</b>" + " " + "<i>" + ss.getModel().getName() + "</i>" + "</nobr></html>", ss));
            }
            this.cmbFilterObject.addItemListener(this.filterObjectItemListener);
        }
    }

    private List createResultList() {
        this.allFoundObjectTypes.clear();
        ArrayList collection = new ArrayList();
        ArrayList rList = new ArrayList();
        for (DesignPart currentModel : this.getAllModels()) {
            Iterator setsIt = null;
            setsIt = currentModel instanceof RelationalDesign ? ((RelationalDesign)currentModel).getSearchableSets(true).iterator() : (currentModel instanceof LogicalDesign ? ((LogicalDesign)currentModel).getSearchableSets(true).iterator() : (currentModel instanceof DataTypesDesign ? ((DataTypesDesign)currentModel).getSearchableSets(true).iterator() : currentModel.getSearchableSets().iterator()));
            while (setsIt.hasNext()) {
                SearchSet ss = (SearchSet)setsIt.next();
                ((ElementSet)((Object)ss.getSet())).addAllElementsTo(collection);
                String type = ss.getTypeName();
                List results = ReportUtils.doSimpleSearch(collection, ss.getClazz(), type, this.metaDataManager, this.globalSearchPattern.getText(), this.cbCaseSensitive.isSelected(), this.cbStopOnFirst.isSelected(), this.cbUseRegex.isSelected(), false);
                if (results.size() > 0) {
                    rList.addAll(results);
                    if (!this.allFoundObjectTypes.contains(ss)) {
                        this.allFoundObjectTypes.add(ss);
                    }
                }
                collection.clear();
            }
        }
        Collections.sort(rList, new ReportUtils.ResultObjectsComparator());
        return rList;
    }

    private void getDiagrams(Object obj) {
        this.diagramsPerObjectListModel.clear();
        if (obj instanceof DesignObject) {
            DesignObject object = (DesignObject)obj;
            Iterator it = null;
            if (object instanceof Table || object instanceof TableView || object instanceof Entity || object instanceof EntityView || object instanceof FKIndexAssociation || object instanceof Cube || object instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension || object instanceof Level || object instanceof StructuredType) {
                it = object.getAffectedDPVs().iterator();
            } else if (object instanceof Index || object instanceof CandidateKey) {
                it = ((DesignObject)((KeyObject)object).getContainerObject()).getAffectedDPVs().iterator();
            } else if (object instanceof Column || object instanceof Attribute) {
                it = ((DesignObject)((ContainedObject)object).getContainer()).getAffectedDPVs().iterator();
            } else if (object instanceof TypeElement) {
                it = ((TypeElement)object).getStructuredType().getAffectedDPVs().iterator();
            } else if (object instanceof Relation) {
                it = ((Relation)object).getSourceEntity().getAffectedDPVs().iterator();
            }
            if (it != null) {
                while (it.hasNext()) {
                    DesignPartView dpv = (DesignPartView)it.next();
                    this.diagramsPerObjectListModel.addElement(dpv);
                }
            }
        }
    }

    public List getAllModels() {
        ArrayList<DesignPart> allModels = new ArrayList<DesignPart>();
        Object selectedDesign = this.cmbFilterModel.getSelectedItem();
        Iterator allDesignsIt = this.getLoadedDesigns().iterator();
        while (allDesignsIt.hasNext()) {
            Design d = (Design)allDesignsIt.next();
            if (!selectedDesign.equals("ALL") && !selectedDesign.equals(d)) continue;
            Iterator it = d.getRelationalDesigns().iterator();
            while (it.hasNext()) {
                RelationalDesign rd = (RelationalDesign)it.next();
                allModels.add(rd);
            }
            it = d.getMultidimensionalDesigns().iterator();
            while (it.hasNext()) {
                MultidimensionalDesign md = (MultidimensionalDesign)it.next();
                allModels.add(md);
            }
            it = d.getProcessModel().getDataFlowDesigns().iterator();
            while (it.hasNext()) {
                DataFlowDesign dfd = (DataFlowDesign)it.next();
                if (!dfd.isTopLevel()) continue;
                allModels.add(dfd);
            }
            allModels.add(d.getLogicalDesign());
            allModels.add(d.getDataTypesDesign());
            allModels.add(d.getProcessModel());
            allModels.add(d.getBusinessInfoDesign());
        }
        return allModels;
    }

    public DesignSet getLoadedDesigns() {
        return this.appView.getDesigns();
    }

    protected MouseListener diagramDblClickMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DesignPartView selectedDiagram = (DesignPartView)GlobalSearchPanel.this.diagramsPerObjectList.getSelectedValue();
                    new Thread(new ShowDiagramAndSelectRunner(selectedDiagram, (DesignObject)GlobalSearchPanel.this.selectedObject.getObj())).start();
                    Object obj = GlobalSearchPanel.this.selectedObject.getObj();
                    TopView tv = null;
                    tv = obj instanceof Column || obj instanceof Attribute ? ((ContainedObject)obj).getContainer().getTopView() : (obj instanceof Index || obj instanceof CandidateKey ? ((KeyObject)obj).getContainerObject().getTopView() : (obj instanceof TypeElement ? ((TypeElement)obj).getStructuredType().getTopView() : ((DesignObject)obj).getTopView()));
                    selectedDiagram.setCurrentSelection(tv.getSelectableObject(), tv);
                }
            }
        };
    }

    public void reloadOpenDesigns() {
        this.cmbFilterModel.removeAllItems();
        this.cmbFilterModel.addItem("ALL");
        Iterator designsIt = this.getLoadedDesigns().iterator();
        while (designsIt.hasNext()) {
            Design d = (Design)designsIt.next();
            this.cmbFilterModel.addItem(d);
            this.cmbFilterModel.addItem(d.getLogicalDesign());
            this.cmbFilterModel.addItem(d.getDataTypesDesign());
            this.cmbFilterModel.addItem(d.getProcessModel());
            this.cmbFilterModel.addItem(d.getBusinessInfoDesign());
            Iterator it = d.getRelationalDesigns().iterator();
            while (it.hasNext()) {
                RelationalDesign rd = (RelationalDesign)it.next();
                this.cmbFilterModel.addItem(rd);
                StorageDesign[] storageDesigns = rd.getStorageDesignFactory().getOpenStorageDesigns();
                for (int i = 0; i < storageDesigns.length; ++i) {
                    StorageDesign sd = storageDesigns[i];
                    if (!sd.isOpen()) continue;
                    this.cmbFilterModel.addItem(sd);
                }
            }
            it = d.getMultidimensionalDesigns().iterator();
            while (it.hasNext()) {
                MultidimensionalDesign md = (MultidimensionalDesign)it.next();
                this.cmbFilterModel.addItem(md);
            }
            it = d.getProcessModel().getDataFlowDesigns().iterator();
            while (it.hasNext()) {
                DataFlowDesign dfd = (DataFlowDesign)it.next();
                this.cmbFilterModel.addItem(dfd);
            }
        }
    }

    public void resetItems(JTextField searchBox) {
        this.cmbFilterObject.removeAllItems();
        this.cmbFilterObject.addItem("ALL");
        if (searchBox.getText().trim().equals("")) {
            this.cmbFilterModel.removeAllItems();
            this.cmbFilterModel.addItem("ALL");
        } else {
            this.reloadOpenDesigns();
        }
        this.resultsTable.getSelectionModel().clearSelection();
        this.resultsTable.setAutoCreateRowSorter(false);
        this.resultsTable.setRowSorter(null);
        this.resultList.clear();
        this.resultsTable.updateUI();
        this.globalSearchPattern = searchBox;
        this.diagramsPerObjectListModel.clear();
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private void reloadObjectsCombo(Object selectedModel) {
        ArrayList<SearchSet> tempList = new ArrayList<SearchSet>();
        for (SearchSet ss : this.allFoundObjectTypes) {
            if (ss.getModel() != selectedModel && !selectedModel.equals("ALL")) continue;
            tempList.add(ss);
        }
        this.cmbFilterObject.removeItemListener(this.filterObjectItemListener);
        this.cmbFilterObject.removeAllItems();
        this.cmbFilterObject.addItem("ALL");
        Collections.sort(tempList, new ReportUtils.SearchSetsComparator());
        for (SearchSet ss : tempList) {
            this.cmbFilterObject.addItem(new JComboHtmlItem(ss.getTypeName(), "<html><nobr><b>" + ss.getTypeName() + "</b>" + " " + "<i>" + ss.getModel().getName() + "</i>" + "</nobr></html>", ss));
        }
        this.cmbFilterObject.addItemListener(this.filterObjectItemListener);
        this.cmbFilterObject.setSelectedIndex(0);
    }

    private List getSavedSearches() {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(0, NEW_SEARCH);
        for (SavedSearch ss : this.appView.getSavedSearches()) {
            l.add(ss);
        }
        Collections.sort(l, ModelObjectSet.TOSTRING_COMPARATOR);
        return l;
    }

    class CmbFilterObjectRenderer
    extends JLabel
    implements ListCellRenderer {
        public CmbFilterObjectRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof JComboHtmlItem) {
                this.setText(((JComboHtmlItem)value).getHtmlText());
            } else {
                this.setText((String)value);
            }
            return this;
        }
    }

    private class UseRegExListener
    implements ActionListener {
        private UseRegExListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GlobalSearchPanel.this.runSearch(false);
        }
    }

    private class StopOnFirstListener
    implements ActionListener {
        private StopOnFirstListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GlobalSearchPanel.this.runSearch(false);
        }
    }

    private class RefreshAction
    implements ActionListener {
        private RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GlobalSearchPanel.this.runSearch(false);
            GlobalSearchPanel.this.resultsTable.scrollRectToVisible(new Rectangle(GlobalSearchPanel.this.resultsTable.getCellRect(1, 1, true)));
        }
    }

    class SavedSearchEditor
    implements ComboBoxEditor {
        List savedSearches;
        String selectedSSID;
        JTextField textFeild;

        public SavedSearchEditor(List savedSearches) {
            this.savedSearches = savedSearches;
            this.textFeild = new JTextField();
        }

        @Override
        public Component getEditorComponent() {
            return this.textFeild;
        }

        @Override
        public void setItem(Object anObject) {
            String text = "";
            if (anObject instanceof SavedSearch) {
                text = ((SavedSearch)anObject).getSsName();
                this.selectedSSID = ((SavedSearch)anObject).getSsId();
            } else {
                this.selectedSSID = "";
                text = (String)anObject;
            }
            this.textFeild.setText(text);
        }

        @Override
        public Object getItem() {
            for (Object obj : this.savedSearches) {
                if (!(obj instanceof SavedSearch) || !((SavedSearch)obj).getSsId().equals(this.selectedSSID)) continue;
                return obj;
            }
            return this.textFeild.getText();
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.textFeild.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.textFeild.removeActionListener(l);
        }

        public JTextField getTextFeild() {
            return this.textFeild;
        }

        public void addItem(SavedSearch ss) {
            this.savedSearches.add(ss);
        }
    }

    class SavedSearchRenderer
    extends JLabel
    implements ListCellRenderer {
        SavedSearchRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = "";
            text = value instanceof SavedSearch ? ((SavedSearch)value).ssName : (String)value;
            this.setFont(list.getFont());
            this.setText(text);
            this.setOpaque(true);
            return this;
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        ComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = "";
            text = value instanceof Design ? ((Design)value).getName() : (value instanceof DesignPart ? ((DesignPart)value).getDesign().getName() + " / " + ((DesignPart)value).getName() : (value instanceof StorageDesign ? ((StorageDesign)value).getDesign().getName() + " / " + ((StorageDesign)value).getPhysicalDesign().getName() + " / " + ((StorageDesign)value).getName() : (String)value));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setText(text);
            this.setOpaque(true);
            return this;
        }
    }

    private class FilterDesignItemListener
    implements ItemListener {
        private FilterDesignItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                GlobalSearchPanel.this.resultList.clear();
                GlobalSearchPanel.this.resultsTable.getSelectionModel().clearSelection();
                GlobalSearchPanel.this.resultsTable.setAutoCreateRowSorter(false);
                GlobalSearchPanel.this.resultsTable.setRowSorter(null);
                GlobalSearchPanel.this.resultsTable.updateUI();
                Object selected = GlobalSearchPanel.this.cmbFilterModel.getSelectedItem();
                for (SearchResultObject ro : GlobalSearchPanel.this.allFoundResults) {
                    Object obj = ro.getObj();
                    if (selected instanceof Design) {
                        if ((Design)selected != ((ModelIDObject)obj).getDesign()) continue;
                        GlobalSearchPanel.this.resultList.add(ro);
                        continue;
                    }
                    if (selected instanceof DesignPart) {
                        if (!(obj instanceof DesignObject)) continue;
                        if ((DesignPart)selected == ((DesignObject)obj).getDesignPart()) {
                            GlobalSearchPanel.this.resultList.add(ro);
                            continue;
                        }
                        if (!(obj instanceof InfoStore) || (DesignPart)selected != ((InfoStore)obj).getTopView().getDesignPartView().getDesignPart()) continue;
                        GlobalSearchPanel.this.resultList.add(ro);
                        continue;
                    }
                    if (selected instanceof StorageDesign) {
                        if (!(obj instanceof StorageObject) || (StorageDesign)selected != ((StorageObject)ro.getObj()).getStorageDesign()) continue;
                        GlobalSearchPanel.this.resultList.add(ro);
                        continue;
                    }
                    GlobalSearchPanel.this.resultList.add(ro);
                }
                if (GlobalSearchPanel.this.resultList.size() > 0) {
                    GlobalSearchPanel.this.resultsTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(GlobalSearchPanel.this.resultsTable, 0);
                    GlobalSearchPanel.this.resultsTable.setRowSelectionInterval(0, 0);
                }
                GlobalSearchPanel.this.reloadObjectsCombo(selected);
                GlobalSearchPanel.this.btnPrintReport.setEnabled(false);
                GlobalSearchPanel.this.btnPrintReport.setToolTipText(Messages.getString("GlobalSearchPanel.ApplyFilterToUseReporting"));
                GlobalSearchPanel.this.btnSetProperties.setEnabled(false);
                GlobalSearchPanel.this.btnSetProperties.setToolTipText(Messages.getString("GlobalSearchPanel.ApplyFilterToUseSetProperties"));
                GlobalSearchPanel.this.resultsTable.updateUI();
            }
        }
    }

    private class FilterObjectItemListener
    implements ItemListener {
        private FilterObjectItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                GlobalSearchPanel.this.resultList.clear();
                GlobalSearchPanel.this.resultsTable.getSelectionModel().clearSelection();
                GlobalSearchPanel.this.resultsTable.setAutoCreateRowSorter(false);
                GlobalSearchPanel.this.resultsTable.setRowSorter(null);
                GlobalSearchPanel.this.resultsTable.updateUI();
                Object selected = GlobalSearchPanel.this.cmbFilterObject.getSelectedItem();
                SearchSet selectedSS = null;
                GlobalSearchPanel.this.selectedModel = GlobalSearchPanel.this.cmbFilterModel.getSelectedItem();
                if (selected instanceof JComboHtmlItem) {
                    selectedSS = (SearchSet)((JComboHtmlItem)selected).getObject();
                }
                for (SearchResultObject ro : GlobalSearchPanel.this.allFoundResults) {
                    Object obj = ro.getObj();
                    if ((selectedSS == null || selectedSS.getClazz() != ro.getClazz()) && !selected.equals("ALL")) continue;
                    if (GlobalSearchPanel.this.selectedModel instanceof Design) {
                        if ((Design)GlobalSearchPanel.this.selectedModel != ((ModelIDObject)obj).getDesign()) continue;
                        GlobalSearchPanel.this.resultList.add(ro);
                        continue;
                    }
                    if (GlobalSearchPanel.this.selectedModel instanceof DesignPart) {
                        if (!(obj instanceof DesignObject) || (DesignPart)GlobalSearchPanel.this.selectedModel != ((DesignObject)obj).getDesignPart()) continue;
                        GlobalSearchPanel.this.resultList.add(ro);
                        continue;
                    }
                    if (GlobalSearchPanel.this.selectedModel instanceof StorageDesign) {
                        if (!(obj instanceof StorageObject) || (StorageDesign)GlobalSearchPanel.this.selectedModel != ((StorageObject)ro.getObj()).getStorageDesign()) continue;
                        GlobalSearchPanel.this.resultList.add(ro);
                        continue;
                    }
                    GlobalSearchPanel.this.resultList.add(ro);
                }
                if (GlobalSearchPanel.this.resultList.size() > 0) {
                    GlobalSearchPanel.this.resultsTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(GlobalSearchPanel.this.resultsTable, 0);
                    GlobalSearchPanel.this.resultsTable.setRowSelectionInterval(0, 0);
                    if (GlobalSearchPanel.this.selectedModel.equals("ALL")) {
                        GlobalSearchPanel.this.btnPrintReport.setEnabled(false);
                        GlobalSearchPanel.this.btnPrintReport.setToolTipText(Messages.getString("GlobalSearchPanel.ApplyFilterToUseReporting"));
                        GlobalSearchPanel.this.btnSetProperties.setEnabled(false);
                        GlobalSearchPanel.this.btnSetProperties.setToolTipText(Messages.getString("GlobalSearchPanel.ApplyFilterToUseSetProperties"));
                    } else if (GlobalSearchPanel.this.selectedObject.equals("ALL")) {
                        GlobalSearchPanel.this.btnPrintReport.setEnabled(false);
                        GlobalSearchPanel.this.btnPrintReport.setToolTipText(Messages.getString("GlobalSearchPanel.ApplyFilterToUseReporting"));
                        GlobalSearchPanel.this.btnSetProperties.setEnabled(false);
                        GlobalSearchPanel.this.btnSetProperties.setToolTipText(Messages.getString("GlobalSearchPanel.ApplyFilterToUseSetProperties"));
                    } else {
                        GlobalSearchPanel.this.btnPrintReport.setEnabled(true);
                        GlobalSearchPanel.this.btnPrintReport.setToolTipText(Messages.getString("GlobalSearchPanel.GenerateReport"));
                        GlobalSearchPanel.this.btnSetProperties.setEnabled(true);
                        GlobalSearchPanel.this.btnSetProperties.setToolTipText(Messages.getString("GlobalSearchPanel.ApplyPropertiesValues"));
                    }
                }
                GlobalSearchPanel.this.resultsTable.updateUI();
            }
        }
    }

    private class ChangePropertiesAction
    implements ActionListener {
        private ChangePropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                List propertiesList = new ArrayList();
                Iterator it = GlobalSearchPanel.this.resultList.iterator();
                if (it.hasNext()) {
                    SearchResultObject ro = (SearchResultObject)it.next();
                    propertiesList = ReportUtils.getSearchablePropertyObjects(ro.getClazz(), GlobalSearchPanel.this.metaDataManager);
                }
                ApplyPropertiesValuesDialog dialog = new ApplyPropertiesValuesDialog(GlobalSearchPanel.this.appView, GlobalSearchPanel.this.resultList, propertiesList, (ModelIDObject)GlobalSearchPanel.this.selectedModel);
                dialog.showDialog();
            }
            catch (Exception error) {
                LOGGER.error("Error in opening ModifyPropertiesValuesDialog ", error);
            }
        }
    }

    private class PrintReportAction
    implements ActionListener {
        private PrintReportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GlobalSearchPanel.this.extraParams.put("filterModel", GlobalSearchPanel.this.cmbFilterModel.getSelectedItem());
                GlobalSearchPanel.this.extraParams.put("filterObject", ((JComboHtmlItem)GlobalSearchPanel.this.cmbFilterObject.getSelectedItem()).getObject());
                GlobalSearchPanel.this.extraParams.put("pattern", GlobalSearchPanel.this.globalSearchPattern.getText());
                GlobalSearchPanel.this.extraParams.put("metadata_manager", GlobalSearchPanel.this.metaDataManager);
                GlobalSearchPanel.this.extraParams.put("model", GlobalSearchPanel.this.selectedModel);
                Object selected = GlobalSearchPanel.this.cmbFilterObject.getSelectedItem();
                SearchSet selectedSS = (SearchSet)((JComboHtmlItem)selected).getObject();
                SearchResultsReportsGenerationDialog reportsDialog = new SearchResultsReportsGenerationDialog(GlobalSearchPanel.this.appView, selectedSS.getClazz(), GlobalSearchPanel.this.resultList, GlobalSearchPanel.this.extraParams);
                reportsDialog.showDialog();
            }
            catch (Exception error) {
                LOGGER.error("Error in global search reports generation", error);
            }
        }
    }

    class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        TableColumn curCol;
        Map tips = new HashMap();

        ColumnHeaderToolTips() {
        }

        public void setToolTip(TableColumn col, String tooltip) {
            if (tooltip == null) {
                this.tips.remove(col);
            } else {
                this.tips.put(col, tooltip);
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            JTableHeader header = (JTableHeader)evt.getSource();
            JTable table = header.getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            TableColumn col = null;
            if (vColIndex >= 0) {
                col = colModel.getColumn(vColIndex);
            }
            if (col != this.curCol) {
                header.setToolTipText((String)this.tips.get(col));
                this.curCol = col;
            }
        }
    }

    class ContentRenderer
    extends DefaultTableCellRenderer {
        ContentRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tip = ((SearchResultObject)GlobalSearchPanel.this.resultList.get(table.convertRowIndexToModel(row))).getFullContent();
            if (tip != null && !tip.equals("")) {
                this.setToolTipText("<html><pre>" + tip + "</pre></html>");
            } else {
                this.setToolTipText(null);
            }
            FontMetrics fm = table.getFontMetrics(table.getFont());
            String first = text = value == null ? "" : value.toString();
            String dots = "";
            int columnWidth = table.getColumnModel().getColumn(column).getWidth();
            int textWidth = 0;
            for (int i = 0; i < text.length(); ++i) {
                if ((textWidth += fm.charWidth(text.charAt(i))) <= columnWidth) continue;
                first = text.substring(0, i - 1);
                dots = "...";
                break;
            }
            this.setText("<html>" + first + dots + "</html>");
            return this;
        }
    }

    private class ShowDiagramAndSelectRunner
    implements Runnable {
        DesignPartViewPlaceHolder dpvph;
        private ProgressDialog monitor;
        DesignPart designPart;
        DesignPartView dpv;
        DesignObject dobj;

        public ShowDiagramAndSelectRunner(DesignPartView dpv, DesignObject dobj) {
            if (dpv.isMainDiagram() || dpv.getMasterDPV() != null && dpv.getMasterDPV().isMainDiagram()) {
                this.designPart = dpv.getDesignPart();
            } else if (dpv.isMasterDPV()) {
                this.dpvph = (DesignPartViewPlaceHolder)dpv.getPlaceHolder();
            } else if (dpv.getMasterDPV() != null) {
                this.dpvph = (DesignPartViewPlaceHolder)dpv.getMasterDPV().getPlaceHolder();
            }
            this.dpv = dpv;
            this.dobj = dobj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String name = "";
            if (this.designPart != null) {
                name = this.designPart.getName();
            } else if (this.dpvph != null) {
                name = this.dpvph.getName();
            }
            this.monitor = new ProgressDialog(GlobalSearchPanel.this.appView, MessageFormat.format(Messages.getString("SearchPanel.ShowDiagram"), name), 0, 100);
            this.monitor.setProgress(5);
            this.monitor.setNote(MessageFormat.format(Messages.getString("SearchPanel.ShowDiagram"), name));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.monitor.setProgress(10);
            this.monitor.setNote(MessageFormat.format(Messages.getString("SearchPanel.ShowDiagram"), name));
            try {
                if (this.designPart != null) {
                    this.designPart.setMainViewVisible(true, this.monitor);
                } else if (this.dpvph != null) {
                    this.dpvph.setVisible(true, this.monitor, this.dobj);
                }
                if (this.dpv != null && this.dpv.getDesignPart().isLoaded()) {
                    DesignPartView mdpv;
                    DesignPartView.NamedTabbedPane pane;
                    if (this.dpv.isMasterDPV()) {
                        pane = this.dpv.getTabbedPane();
                        mdpv = this.dpv;
                    } else {
                        pane = this.dpv.getMasterDPV().getTabbedPane();
                        mdpv = this.dpv.getMasterDPV();
                    }
                    if (!this.dpv.activateEditor()) {
                        if (mdpv == this.dpv.getDesignPart().getMainView()) {
                            this.dpv.getDesignPart().setMainViewVisible(true);
                        } else {
                            mdpv.getPlaceHolder().setVisible(true);
                        }
                    }
                    if (pane.indexOfComponent(this.dpv) > -1 && pane.indexOfComponent(mdpv) > -1) {
                        pane.setSelectedComponent(mdpv);
                        pane.setSelectedComponent(this.dpv);
                        ContainerView cv = (ContainerView)this.dobj.getFirstViewForDPV(this.dpv);
                        if (cv != null) {
                            cv.setCurrentSelectionToContainer();
                            if (cv.getCellView() != null) {
                                this.dpv.getWorkSpace().scrollCellToVisible(cv.getCellView().getCell());
                            }
                        }
                    }
                }
            }
            finally {
                this.monitor.close();
            }
        }
    }

    class DesignsComparator
    implements Comparator {
        DesignsComparator() {
        }

        public int compare(Object one, Object two) {
            Design s1 = (Design)one;
            Design s2 = (Design)two;
            return s1.getName().compareTo(s2.getName());
        }
    }

    class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object one, Object two) {
            String s1 = (String)one;
            String s2 = (String)two;
            return s1.compareTo(s2);
        }
    }

    private class ResultListModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{"Design / Model", Messages.getString("SearchPanel.Name"), Messages.getString("SearchPanel.Property"), Messages.getString("SearchPanel.Type"), Messages.getString("SearchPanel.Content"), "hidden column"};

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getRowCount() {
            return GlobalSearchPanel.this.resultList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SearchResultObject ro = (SearchResultObject)GlobalSearchPanel.this.resultList.get(rowIndex);
            ModelIDObject obj = (ModelIDObject)ro.getObj();
            if (columnIndex == 0) {
                if (obj instanceof DesignObject) {
                    return obj.getDesign().getName() + " / " + ((DesignObject)obj).getDesignPart().getName();
                }
                if (obj instanceof StorageObject) {
                    return obj.getDesign().getName() + " / " + ((StorageObject)obj).getStorageDesign().getPhysicalDesign().getName() + " / " + ((StorageObject)obj).getStorageDesign().getName();
                }
                if (obj instanceof DesignPart) {
                    return obj.getDesign().getName() + " / " + ((DesignPart)obj).getName();
                }
            } else {
                if (columnIndex == 1) {
                    return obj.getLongName();
                }
                if (columnIndex == 2) {
                    return ReportUtils.getDisplayName(ro.getPdName());
                }
                if (columnIndex == 3) {
                    return ro.getTypeName();
                }
                if (columnIndex == 4) {
                    return ro.getShortContent();
                }
                if (columnIndex == 5) {
                    return ro.getFullContent();
                }
            }
            return "";
        }
    }
}

