/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.search;

import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.dbtools.crest.swingui.GUIConfiguration;

class JIconTextField
extends JTextField {
    private Icon icon;
    private Insets dummyInsets;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();

    public JIconTextField(boolean hasBorders, boolean hasIcon) {
        if (hasIcon) {
            this.icon = this.configuration.getIcon("SEARCH_ICON", 16);
        }
        if (hasBorders) {
            Border border = UIManager.getBorder("TextField.border");
            JTextField dummy = new JTextField();
            this.dummyInsets = border.getBorderInsets(dummy);
        } else {
            if (hasIcon) {
                this.setBorder(BorderFactory.createEmptyBorder(1, 25, 1, 1));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            this.dummyInsets = new Insets(0, 0, 0, 0);
        }
        this.setMargin(new Insets(2, 2, 2, 2));
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.icon != null) {
            int iconHeight = this.icon.getIconHeight();
            int x = this.dummyInsets.left + 5;
            int y = (this.getHeight() - iconHeight) / 2;
            this.icon.paintIcon(this, g, x, y);
        }
    }
}

