/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.search;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.search.PropertyObject;
import oracle.dbtools.crest.swingui.search.SavedSearch;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SavedSearchPersistence {
    public static final String SS_FILE_NAME = "saved_search.xml";
    private ApplicationView appView;
    private static final Logger LOGGER = new Logger(SavedSearchPersistence.class);

    public SavedSearchPersistence(ApplicationView appView) {
        this.appView = appView;
    }

    public void saveSearches() {
        Iterator it0 = this.appView.getSavedSearches().iterator();
        StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
        buffer.append("\n");
        buffer.append("<").append("saved_searches").append(">");
        while (it0.hasNext()) {
            SavedSearch ss = (SavedSearch)it0.next();
            buffer.append("\n");
            buffer.append("\t").append("<").append("ssearch").append(' ');
            buffer.append("id=\"").append(ss.getSsId()).append("\"").append(' ');
            buffer.append("name=\"").append(StringUtilities.encodeAttributeValue(ss.getSsName())).append("\"").append(' ');
            buffer.append("advanced_mode=\"").append(ss.isAdvancedMode()).append("\"").append(' ');
            buffer.append("pattern=\"").append(StringUtilities.encodeAttributeValue(ss.getPattern())).append("\"").append(' ');
            buffer.append("design=\"").append(ss.getDesignID()).append("\"").append(' ');
            buffer.append("model=\"").append(ss.getModelID()).append("\"").append(' ');
            buffer.append("obj_type=\"").append(ss.getObject()).append("\"").append(' ');
            buffer.append("stop_on_first=\"").append(ss.isStopOnFirst()).append("\"").append(' ');
            buffer.append("or_mode=\"").append(ss.isOrMode()).append("\"").append(' ');
            buffer.append("case_sensitive=\"").append(ss.isCaseSensitive()).append("\"").append(">");
            List properties = ss.getProperties();
            if (properties != null && properties.size() > 0) {
                buffer.append("\n");
                buffer.append("\t").append("\t").append("<").append("properties_list").append(">");
                for (PropertyObject po : properties) {
                    buffer.append("\n");
                    buffer.append("\t").append("\t").append("\t").append("<").append("property").append(' ');
                    buffer.append("name=\"").append(po.getName()).append("\"").append(' ');
                    buffer.append("not=\"").append(po.isNot()).append("\"").append(' ');
                    buffer.append("pattern=\"").append(po.getSearchPattern()).append("\"").append(' ');
                    buffer.append("case_sensitive=\"").append(po.isCaseSensitive()).append("\"").append(' ');
                    buffer.append("/>");
                }
                buffer.append("\n");
                buffer.append("\t").append("\t").append("</").append("properties_list").append(">");
            }
            buffer.append("\n");
            buffer.append("\t").append("</").append("ssearch").append(">");
        }
        buffer.append("\n");
        buffer.append("</").append("saved_searches").append(">");
        this.saveData(buffer);
    }

    private void saveData(StringBuffer buffer) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(XMLTransformationManager.getDefaultSystemTypesPath(), SS_FILE_NAME));
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(buffer.toString());
            osw.close();
        }
        catch (Exception e) {
            LOGGER.error("Unable to save searches: ", e);
        }
    }

    public void loadSavedSearches(Settings settings) {
        try {
            File file = new File(XMLTransformationManager.getDefaultSystemTypesPath(settings), SS_FILE_NAME);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                this.loadData(doc);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load saved searches: ", e);
        }
    }

    private void loadData(Document doc) {
        ArrayList<SavedSearch> loadedSearches = new ArrayList<SavedSearch>();
        NodeList nodes1 = doc.getElementsByTagName("ssearch");
        int nodesLength1 = nodes1.getLength();
        for (int i = 0; i < nodesLength1; ++i) {
            Element elm = (Element)nodes1.item(i);
            ArrayList<PropertyObject> properties = new ArrayList<PropertyObject>();
            NodeList nodes2 = elm.getElementsByTagName("property");
            int nodesLength2 = nodes2.getLength();
            for (int j = 0; j < nodesLength2; ++j) {
                Element elm2 = (Element)nodes2.item(j);
                PropertyObject po = new PropertyObject(elm2.getAttribute(StringUtilities.decodeAttributeValue("name")), elm2.getAttribute(StringUtilities.decodeAttributeValue("pattern")), Boolean.valueOf(elm2.getAttribute(StringUtilities.decodeAttributeValue("case_sensitive"))), Boolean.valueOf(elm2.getAttribute(StringUtilities.decodeAttributeValue("not"))));
                properties.add(po);
            }
            SavedSearch ss = new SavedSearch(elm.getAttribute(StringUtilities.decodeAttributeValue("id")), StringUtilities.decodeAttributeValue(elm.getAttribute(StringUtilities.decodeAttributeValue("name"))), elm.getAttribute(StringUtilities.decodeAttributeValue("design")), elm.getAttribute(StringUtilities.decodeAttributeValue("model")), elm.getAttribute(StringUtilities.decodeAttributeValue("obj_type")), StringUtilities.decodeAttributeValue(elm.getAttribute(StringUtilities.decodeAttributeValue("pattern"))), Boolean.valueOf(elm.getAttribute(StringUtilities.decodeAttributeValue("case_sensitive"))), Boolean.valueOf(elm.getAttribute(StringUtilities.decodeAttributeValue("advanced_mode"))), properties, Boolean.valueOf(elm.getAttribute(StringUtilities.decodeAttributeValue("stop_on_first"))), Boolean.valueOf(elm.getAttribute(StringUtilities.decodeAttributeValue("or_mode"))));
            loadedSearches.add(ss);
        }
        this.appView.getSavedSearches().clear();
        this.appView.getSavedSearches().addAll(loadedSearches);
    }
}

