/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.fcp.AbstractPinnablePanel;
import oracle.dbtools.crest.fcp.Icons;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.search.ApplyPropertiesValuesDialog;
import oracle.dbtools.crest.swingui.search.JComboHtmlItem;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.swingui.search.Messages;
import oracle.dbtools.crest.swingui.search.PropertyObject;
import oracle.dbtools.crest.swingui.search.SavedSearch;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.swingui.wizards.reports.SearchResultsReportsGenerationDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;

public class SearchPanel
extends AbstractPinnablePanel {
    private static final String SEARCH = "Search";
    private static final String NEW_SEARCH = "<New Search>";
    Icon refreshIcon = Icons.getRefreshIcon();
    private JMenuItem miSave = new JMenuItem(Messages.getString("SearchPanel.Save"), Icons.getSaveIcon());
    private JMenuItem miClear = new JMenuItem(Messages.getString("SearchPanel.Clear"));
    private JMenuItem miDelete = new JMenuItem(Messages.getString("SearchPanel.Delete"), Icons.getDeleteIcon());
    private JTabbedPane tpane;
    private JComboBox cmbAdvancedModeFilter = new JComboBox();
    private JComboBox cmbSimpleModeFilter;
    private JComboBox cmbSavedSearches;
    private JButton btnSavedSearches;
    private JCheckBox cbCaseSensitive;
    private JCheckBox cbStopOnFirst;
    private JCheckBox cbUseRegex;
    private JRadioButton rbOR;
    private JRadioButton rbAND;
    private ButtonGroup group;
    private List resultList;
    private List propertiesList = new ArrayList();
    private JTable resultsTable;
    private JScrollPane resultPane;
    private JScrollPane propertiesPane;
    private JPanel propertiesPanel;
    private JPanel mainPanel;
    private JPanel searchPropertiesTabPanel;
    private JRadioButton rbSimple;
    private JRadioButton rbAdvanced;
    private JSearchTextField simpleSearchBox;
    private JButton btnFind;
    private DefaultListModel diagramsPerObjectListModel;
    private JList diagramsPerObjectList;
    private JScrollPane diagramsPerObjectPane;
    private SearchResultObject selectedObject;
    private ModelIDObject currentModel;
    private MetaDataManager metaDataManager;
    private boolean advancedMode;
    private JButton btnPrintReport;
    private JButton btnSetProperties;
    private JButton btnRefresh;
    private List allFoundResults = new ArrayList();
    private DefaultComboBoxModel cmbSavedSearchModel;
    private JPopupMenu menu;
    private ApplicationView appView;
    private List foundObjectTypes = new ArrayList();
    private HashMap extraParams = new HashMap();
    private DocumentListener simpleSearchDocumentListener;
    private SimpleSearchEnterKeyListener simpleSearchEnterKeyListener;
    GUIConfiguration configuration;
    private SavedSearchEditor savedSearchEditor;
    private Settings settings;
    private SimpleModeFilterItemListener simpleModeFilterItemListener;
    private Map propertiesMap = new HashMap();
    private Map currentAdvancedSearchPropertiesMap = new HashMap();
    private JButton btnAddProperty;
    private boolean isAutomaticallyAddedProperty = false;
    private PropertyObject automaticallyLoadedPropertyObject;
    private static final Logger LOGGER = new Logger(SearchPanel.class);
    static final String VIEW_ID = "SearchPanel";

    public SearchPanel() {
        super("DM_SEARCH.SearchPanel");
    }

    public void createGUI() {
        this.appView = ApplicationView.getInstance();
        this.settings = this.appView.getSettings();
        this.metaDataManager = this.appView.getXMLTransformationManager().getMetaDataManager();
        this.configuration = GUIConfiguration.getInstance();
        this.initToolbar();
        this.simpleModeFilterItemListener = new SimpleModeFilterItemListener();
        this.tpane = new JTabbedPane();
        this.initSearchPanel();
        this.initSearchOptionsTab();
        this.initResultsTab();
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.add((Component)this.tpane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.mainPanel, "Center");
    }

    private void initSearchPanel() {
        this.btnRefresh = new JButton(this.refreshIcon);
        this.btnRefresh.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btnRefresh.setPreferredSize(new Dimension(20, 20));
        this.btnRefresh.setToolTipText(Messages.getString("SearchPanel.Refresh"));
        this.btnRefresh.addActionListener(new RefreshAction());
        this.btnRefresh.setMnemonic(70);
        this.btnRefresh.setEnabled(true);
        this.simpleSearchBox = new JSearchTextField(false, true, "");
        this.simpleSearchBox.setPreferredSize(new Dimension(200, 20));
        this.simpleSearchDocumentListener = new SimpleSearchDocumentListener();
        this.simpleSearchEnterKeyListener = new SimpleSearchEnterKeyListener();
        this.simpleSearchBox.getDocument().addDocumentListener(this.simpleSearchDocumentListener);
        this.simpleSearchBox.addKeyListener(this.simpleSearchEnterKeyListener);
        this.cbCaseSensitive = new JCheckBox(Messages.getString("SearchPanel.CaseSensitive"));
        this.cbCaseSensitive.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SearchPanel.this.runSearch(false);
            }
        });
        JLabel lblSimpleModeFilter = new JLabel(Messages.getString("SearchPanel.Filter"));
        lblSimpleModeFilter.setPreferredSize(new Dimension(40, 20));
        this.cmbSimpleModeFilter = new JComboBox();
        this.cmbSimpleModeFilter.setToolTipText(Messages.getString("GlobalSearchPanel.FilterObjectType"));
        this.cmbSimpleModeFilter.setRenderer(new CmbSimpleModeFilterRenderer());
        this.cmbSimpleModeFilter.setPreferredSize(new Dimension(150, 20));
        this.cmbSimpleModeFilter.setMaximumRowCount(12);
        this.cmbAdvancedModeFilter.setRenderer(new CmbAdvancedModeFilterRenderer());
        this.cmbAdvancedModeFilter.setMaximumRowCount(12);
        JLabel lblSavedSearches = new JLabel(Messages.getString("SearchPanel.SavedSearches"));
        lblSavedSearches.setPreferredSize(new Dimension(100, 20));
        lblSavedSearches.setMinimumSize(new Dimension(100, 20));
        this.cmbSavedSearches = new JComboBox<Object>(this.getSavedSearches().toArray());
        this.cmbSavedSearches.setToolTipText(Messages.getString("GlobalSearchPanel.SelectSavedSearch"));
        this.cmbSavedSearchModel = new DefaultComboBoxModel<Object>(this.getSavedSearches().toArray());
        this.cmbSavedSearches.setModel(this.cmbSavedSearchModel);
        this.cmbSavedSearches.setEditable(true);
        this.cmbSavedSearches.setPreferredSize(new Dimension(150, 20));
        this.cmbSavedSearches.setMinimumSize(new Dimension(180, 20));
        this.cmbSavedSearches.setRenderer(new SavedSearchRenderer());
        this.savedSearchEditor = new SavedSearchEditor(this.getSavedSearches());
        this.cmbSavedSearches.setEditor(this.savedSearchEditor);
        this.miDelete.setEnabled(false);
        this.miSave.setEnabled(false);
        this.miClear.setEnabled(false);
        this.cmbSavedSearches.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        Object currentItem = SearchPanel.this.cmbSavedSearches.getEditor().getItem();
                        if (currentItem instanceof SavedSearch) {
                            SavedSearch ss = (SavedSearch)currentItem;
                            SearchPanel.this.rbAdvanced.setSelected(ss.isAdvancedMode());
                            SearchPanel.this.rbSimple.setSelected(!ss.isAdvancedMode());
                            if (SearchPanel.this.advancedMode) {
                                boolean objTypefound = false;
                                for (int index = 0; index < SearchPanel.this.cmbAdvancedModeFilter.getItemCount(); ++index) {
                                    Object current = SearchPanel.this.cmbAdvancedModeFilter.getItemAt(index);
                                    String objType = "";
                                    objType = current instanceof JComboHtmlItem ? ((JComboHtmlItem)current).getRawText() : "ALL";
                                    if (!objType.equals(ss.getObject())) continue;
                                    SearchPanel.this.cmbAdvancedModeFilter.setSelectedItem(current);
                                    objTypefound = true;
                                    break;
                                }
                                if (objTypefound) {
                                    SearchPanel.this.currentAdvancedSearchPropertiesMap.clear();
                                    SearchPanel.this.propertiesPanel.removeAll();
                                    SearchPanel.this.propertiesPanel.validate();
                                    SearchPanel.this.propertiesPanel.repaint();
                                    SearchPanel.this.tpane.setSelectedIndex(0);
                                    for (PropertyObject po : ss.getProperties()) {
                                        SearchPanel.this.automaticallyLoadedPropertyObject = po;
                                        SearchPanel.this.isAutomaticallyAddedProperty = true;
                                        SearchPanel.this.btnAddProperty.doClick();
                                    }
                                }
                                SearchPanel.this.rbOR.setSelected(ss.isOrMode());
                                SearchPanel.this.rbAND.setSelected(!ss.isOrMode());
                                SearchPanel.this.resultList.clear();
                                SearchPanel.this.resultsTable.updateUI();
                                SearchPanel.this.cbStopOnFirst.setSelected(ss.isStopOnFirst());
                                SearchPanel.this.isAutomaticallyAddedProperty = false;
                            } else {
                                SearchPanel.this.simpleSearchBox.setText(ss.getPattern());
                                SearchPanel.this.cbStopOnFirst.setSelected(ss.isStopOnFirst());
                                for (int index = 0; index < SearchPanel.this.cmbSimpleModeFilter.getItemCount(); ++index) {
                                    Object current = SearchPanel.this.cmbSimpleModeFilter.getItemAt(index);
                                    String objType = "";
                                    objType = current instanceof JComboHtmlItem ? ((JComboHtmlItem)current).getRawText() : "ALL";
                                    if (!objType.equals(ss.getObject())) continue;
                                    SearchPanel.this.cmbSimpleModeFilter.setSelectedItem(current);
                                    break;
                                }
                            }
                            SearchPanel.this.miDelete.setEnabled(true);
                            SearchPanel.this.miSave.setEnabled(true);
                            SearchPanel.this.miClear.setEnabled(true);
                        } else {
                            if (currentItem.equals(SearchPanel.NEW_SEARCH)) {
                                SearchPanel.this.miClear.doClick();
                                SearchPanel.this.miSave.setEnabled(false);
                                SearchPanel.this.miClear.setEnabled(false);
                                if (SearchPanel.this.advancedMode) {
                                    SearchPanel.this.tpane.setSelectedIndex(0);
                                    SearchPanel.this.resultList.clear();
                                    SearchPanel.this.resultsTable.updateUI();
                                }
                            } else {
                                SearchPanel.this.miSave.setEnabled(true);
                                SearchPanel.this.miClear.setEnabled(true);
                            }
                            SearchPanel.this.miDelete.setEnabled(false);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Saved search selection ", ex);
                    }
                }
            }
        });
        this.miSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean found = false;
                Object currentItem = SearchPanel.this.cmbSavedSearches.getEditor().getItem();
                ArrayList allSavedSearches = SearchPanel.this.appView.getSavedSearches();
                Iterator allSavedSearchesIt = allSavedSearches.iterator();
                String selectedModel = SearchPanel.this.currentModel.getObjectID();
                String selectedObjType = "";
                selectedObjType = SearchPanel.this.advancedMode ? ((SearchSet)((JComboHtmlItem)SearchPanel.this.cmbAdvancedModeFilter.getSelectedItem()).getObject()).getTypeName() : (SearchPanel.this.cmbSimpleModeFilter.getSelectedItem().equals("ALL") ? "ALL" : ((SearchSet)((JComboHtmlItem)SearchPanel.this.cmbSimpleModeFilter.getSelectedItem()).getObject()).getTypeName());
                String selectedObjTypeModel = "";
                if (currentItem instanceof SavedSearch) {
                    SavedSearch ss = (SavedSearch)currentItem;
                    while (allSavedSearchesIt.hasNext()) {
                        SavedSearch currentSS = (SavedSearch)allSavedSearchesIt.next();
                        if (!currentSS.getSsId().equals(ss.getSsId())) continue;
                        int choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), "Are you sure you want to overwrite saved search?", Messages.getString("GlobalSearchPanel.Overwrite"), 0, 3);
                        if (choice == 0) {
                            ss.setSsName(SearchPanel.this.savedSearchEditor.getTextFeild().getText());
                            ss.setObject(selectedObjType);
                            ss.setStopOnFirst(SearchPanel.this.cbStopOnFirst.isSelected());
                            ss.setOrMode(SearchPanel.this.rbOR.isSelected());
                            if (SearchPanel.this.advancedMode) {
                                ss.getProperties().clear();
                                for (Map.Entry e : SearchPanel.this.currentAdvancedSearchPropertiesMap.entrySet()) {
                                    PropertyObject po = (PropertyObject)e.getValue();
                                    ss.getProperties().add(po);
                                }
                            } else {
                                ss.setPattern(SearchPanel.this.simpleSearchBox.getText());
                                ss.setCaseSensitive(SearchPanel.this.cbCaseSensitive.isSelected());
                            }
                        }
                        break;
                    }
                } else {
                    ArrayList<PropertyObject> properties = new ArrayList<PropertyObject>();
                    if (SearchPanel.this.advancedMode) {
                        for (Map.Entry e : SearchPanel.this.currentAdvancedSearchPropertiesMap.entrySet()) {
                            PropertyObject po = (PropertyObject)e.getValue();
                            properties.add(po);
                        }
                    }
                    SavedSearch tempSs = new SavedSearch(null, (String)currentItem, selectedModel, selectedObjTypeModel, selectedObjType, SearchPanel.this.simpleSearchBox.getText(), SearchPanel.this.cbCaseSensitive.isSelected(), SearchPanel.this.advancedMode, properties, SearchPanel.this.cbStopOnFirst.isSelected(), SearchPanel.this.rbOR.isSelected());
                    allSavedSearches.add(tempSs);
                    SearchPanel.this.cmbSavedSearchModel.addElement(tempSs);
                    SearchPanel.this.savedSearchEditor.addItem(tempSs);
                    SearchPanel.this.cmbSavedSearches.setSelectedItem(tempSs);
                }
            }
        });
        this.miClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (SearchPanel.this.advancedMode) {
                    if (SearchPanel.this.cmbAdvancedModeFilter.getItemCount() > 0) {
                        SearchPanel.this.cmbAdvancedModeFilter.setSelectedIndex(0);
                        SearchPanel.this.rbOR.setSelected(true);
                        SearchPanel.this.currentAdvancedSearchPropertiesMap.clear();
                        SearchPanel.this.propertiesPanel.removeAll();
                        SearchPanel.this.propertiesPanel.validate();
                        SearchPanel.this.propertiesPanel.repaint();
                    }
                } else {
                    SearchPanel.this.simpleSearchBox.setText("");
                    SearchPanel.this.cmbSimpleModeFilter.setSelectedItem("ALL");
                }
                SearchPanel.this.cmbSavedSearches.setSelectedItem(SearchPanel.NEW_SEARCH);
                SearchPanel.this.resultsTable.updateUI();
            }
        });
        this.miDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SavedSearch currentSelectedSS = (SavedSearch)SearchPanel.this.cmbSavedSearches.getEditor().getItem();
                SavedSearch ss = null;
                Iterator allSavedSearchesIt = SearchPanel.this.appView.getSavedSearches().iterator();
                while (allSavedSearchesIt.hasNext() && !(ss = (SavedSearch)allSavedSearchesIt.next()).getSsId().equals(currentSelectedSS.getSsId())) {
                }
                int choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), "Are you sure you want to delete saved search?", Messages.getString("GlobalSearchPanel.Delete"), 0, 3);
                if (choice == 0) {
                    SearchPanel.this.appView.getSavedSearches().remove(ss);
                    SearchPanel.this.cmbSavedSearchModel.removeElement(ss);
                }
            }
        });
        this.menu = new JPopupMenu();
        this.menu.add(this.miSave);
        this.menu.add(this.miClear);
        this.menu.addSeparator();
        this.menu.add(this.miDelete);
        JPanel jpSavedSearches = new JPanel();
        this.btnSavedSearches = new JButton(Messages.getString("SearchPanel.More"));
        this.btnSavedSearches.setToolTipText(Messages.getString("GlobalSearchPanel.ClickForOptions"));
        jpSavedSearches.add(this.btnSavedSearches);
        this.btnSavedSearches.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btnSavedSearches.setPreferredSize(new Dimension(50, 20));
        this.btnSavedSearches.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SearchPanel.this.menu.show(e.getComponent(), 0, 20);
            }
        });
        JPanel jpPrintReport = new JPanel();
        this.btnPrintReport = new JButton(Messages.getString("SearchPanel.Report"));
        jpPrintReport.add(this.btnPrintReport);
        this.btnPrintReport.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btnPrintReport.setPreferredSize(new Dimension(100, 20));
        this.btnPrintReport.addActionListener(new PrintReportAction());
        this.btnPrintReport.setMnemonic(80);
        this.btnPrintReport.setEnabled(false);
        this.btnPrintReport.setToolTipText(Messages.getString("SearchPanel.FilterObjTypeToUseReporting"));
        JPanel jpSetProperties = new JPanel();
        this.btnSetProperties = new JButton(Messages.getString("SearchPanel.Properties"));
        jpSetProperties.add(this.btnSetProperties);
        this.btnSetProperties.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btnSetProperties.setPreferredSize(new Dimension(100, 20));
        this.btnSetProperties.addActionListener(new ChangePropertiesAction());
        this.btnSetProperties.setMnemonic(67);
        this.btnSetProperties.setEnabled(false);
        this.btnSetProperties.setToolTipText(Messages.getString("SearchPanel.FilterObjTypeToUseSetProperties"));
        this.rbSimple = new JRadioButton(Messages.getString("SearchPanel.Simple"));
        this.rbSimple.setToolTipText(Messages.getString("SearchPanel.SimpleModeSearch"));
        this.rbSimple.setSelected(true);
        this.rbAdvanced = new JRadioButton(Messages.getString("SearchPanel.Advanced"));
        this.rbAdvanced.setToolTipText(Messages.getString("SearchPanel.AdvancedModeSearch"));
        this.rbSimple.addItemListener(new AdvancedSimpleListener());
        this.rbAdvanced.addItemListener(new AdvancedSimpleListener());
        this.group = new ButtonGroup();
        this.group.add(this.rbSimple);
        this.group.add(this.rbAdvanced);
        this.cbStopOnFirst = new JCheckBox(Messages.getString("SearchPanel.StopOnFirst"));
        this.cbStopOnFirst.setToolTipText(Messages.getString("SearchPanel.StopOnFirstTooltip"));
        this.cbStopOnFirst.setSelected(true);
        this.cbStopOnFirst.addActionListener(new StopOnFirstListener());
        this.cbUseRegex = new JCheckBox(Messages.getString("SearchPanel.UseRegEx"));
        this.cbUseRegex.setToolTipText(Messages.getString("SearchPanel.UseRegularExpression"));
        this.cbUseRegex.setSelected(false);
        this.cbUseRegex.addActionListener(new UseRegExListener());
        this._toolbar.add((Component)this.btnRefresh, 2);
        this._toolbar.add((Component)this._toolbar.newSeparator(), 3);
        this._toolbar.add((Component)this.simpleSearchBox, 4);
        this._toolbar.add((Component)this.cbCaseSensitive, 5);
        this._toolbar.add((Component)this._toolbar.newSeparator(), 6);
        this._toolbar.add((Component)lblSimpleModeFilter, 7);
        this._toolbar.add((Component)this.cmbSimpleModeFilter, 8);
        this._toolbar.add((Component)this._toolbar.newSeparator(), 9);
        this._toolbar.add((Component)lblSavedSearches, 10);
        this._toolbar.add((Component)this.cmbSavedSearches, 11);
        this._toolbar.add((Component)jpSavedSearches, 12);
        this._toolbar.add((Component)this._toolbar.newSeparator(), 13);
        this._toolbar.add((Component)jpPrintReport, 14);
        this._toolbar.add((Component)this._toolbar.newSeparator(), 15);
        this._toolbar.add((Component)jpSetProperties, 16);
        this._toolbar.add((Component)this._toolbar.newSeparator(), 17);
        this._toolbar.add((Component)this.rbSimple, 18);
        this._toolbar.add((Component)this.rbAdvanced, 19);
        this._toolbar.add((Component)this._toolbar.newSeparator(), 20);
        this._toolbar.add((Component)this.cbStopOnFirst, 21);
        this._toolbar.add((Component)this.cbUseRegex, 22);
    }

    private void initSearchOptionsTab() {
        this.searchPropertiesTabPanel = new JPanel(new GridBagLayout());
        JPanel objTypePanel = new JPanel(new BorderLayout());
        JLabel lblObjType = new JLabel(Messages.getString("SearchPanel.ObjectType"));
        lblObjType.setPreferredSize(new Dimension(100, 20));
        this.cmbAdvancedModeFilter.setToolTipText(Messages.getString("GlobalSearchPanel.FilterObjectType"));
        this.cmbAdvancedModeFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SearchSet selectedSS = (SearchSet)((JComboHtmlItem)SearchPanel.this.cmbAdvancedModeFilter.getSelectedItem()).getObject();
                    SearchPanel.this.propertiesList.clear();
                    SearchPanel.this.propertiesList.addAll(ReportUtils.getSearchablePropertyObjects(selectedSS.getClazz(), SearchPanel.this.metaDataManager));
                    SearchPanel.this.currentAdvancedSearchPropertiesMap.clear();
                    SearchPanel.this.propertiesPanel.removeAll();
                    SearchPanel.this.propertiesPanel.validate();
                    SearchPanel.this.propertiesPanel.repaint();
                }
            }
        });
        this.cmbAdvancedModeFilter.setPreferredSize(new Dimension(150, 20));
        objTypePanel.add((Component)lblObjType, "West");
        objTypePanel.add((Component)this.cmbAdvancedModeFilter, "Center");
        this.btnFind = new JButton(Messages.getString("SearchPanel.Find"));
        this.btnFind.setToolTipText(Messages.getString("SearchPanel.StartSearch"));
        this.btnFind.setMnemonic(70);
        this.btnFind.addActionListener(new FindAdvancedAction());
        this.btnAddProperty = new JButton(Messages.getString("SearchPanel.AddProperty"));
        this.btnAddProperty.setToolTipText(Messages.getString("SearchPanel.AddSearchableProperty"));
        this.btnAddProperty.setMnemonic(80);
        this.btnAddProperty.addActionListener(new AddPropertyAction());
        JLabel lblEmptySpace = new JLabel("");
        lblEmptySpace.setPreferredSize(new Dimension(20, 20));
        JPanel jp0 = new JPanel(new BorderLayout());
        jp0.add((Component)objTypePanel, "West");
        jp0.add((Component)lblEmptySpace, "Center");
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.add((Component)this.btnAddProperty, "West");
        buttonsPanel.add((Component)new JLabel("   "), "Center");
        buttonsPanel.add((Component)this.btnFind, "East");
        jp0.add((Component)buttonsPanel, "East");
        JPanel searchPanelANDOR = new JPanel(new FlowLayout(1));
        this.rbAND = new JRadioButton(Messages.getString("SearchPanel.And"));
        this.rbOR = new JRadioButton(Messages.getString("SearchPanel.Or"));
        this.rbOR.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbOR);
        group.add(this.rbAND);
        searchPanelANDOR.add(this.rbOR);
        searchPanelANDOR.add(this.rbAND);
        this.propertiesPanel = new JPanel();
        this.propertiesPanel.setLayout(new BoxLayout(this.propertiesPanel, 1));
        this.propertiesPane = new JScrollPane(this.propertiesPanel);
        this.propertiesPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("SearchPanel.SearchableProperties")));
        JPanel jp = new JPanel(new GridBagLayout());
        jp.add((Component)jp0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jp.add((Component)searchPanelANDOR, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel northPanel = new JPanel(new GridBagLayout());
        JPanel southPanel = new JPanel(new GridBagLayout());
        northPanel.add((Component)jp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        southPanel.add((Component)this.propertiesPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.searchPropertiesTabPanel.add((Component)northPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.searchPropertiesTabPanel.add((Component)southPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initResultsTab() {
        JPanel resultsPanel = new JPanel(new GridBagLayout());
        this.resultList = new ArrayList();
        this.resultsTable = new JTable(new ResultListModel());
        JTableHeader header = this.resultsTable.getTableHeader();
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        tips.setToolTip(this.resultsTable.getColumnModel().getColumn(3), Messages.getString("SearchPanel.MoveOverCellToSeeFullContent"));
        header.addMouseMotionListener(tips);
        TableColumn col0 = this.resultsTable.getColumnModel().getColumn(0);
        col0.setPreferredWidth(200);
        col0.setMinWidth(20);
        TableColumn col1 = this.resultsTable.getColumnModel().getColumn(1);
        col1.setPreferredWidth(150);
        col1.setMinWidth(20);
        TableColumn col2 = this.resultsTable.getColumnModel().getColumn(2);
        col2.setPreferredWidth(150);
        col2.setMinWidth(20);
        TableColumn col3 = this.resultsTable.getColumnModel().getColumn(3);
        col3.setCellRenderer(new ContentRenderer());
        col3.setPreferredWidth(400);
        col3.setMinWidth(20);
        TableColumn col4 = this.resultsTable.getColumnModel().getColumn(4);
        this.resultsTable.getColumnModel().removeColumn(col4);
        this.resultsTable.setSelectionMode(0);
        this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SearchPanel.this.resultsTable.getSelectedRow() == -1) {
                    SearchPanel.this.diagramsPerObjectListModel.clear();
                } else {
                    SearchPanel.this.selectedObject = (SearchResultObject)SearchPanel.this.resultList.get(SearchPanel.this.resultsTable.convertRowIndexToModel(SearchPanel.this.resultsTable.getSelectedRow()));
                    if (SearchPanel.this.selectedObject.getObj() instanceof DesignObject) {
                        SearchPanel.this.getDiagrams((DesignObject)SearchPanel.this.selectedObject.getObj());
                    }
                }
            }
        });
        this.resultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SearchPanel.this.selectedObject = (SearchResultObject)SearchPanel.this.resultList.get(SearchPanel.this.resultsTable.convertRowIndexToModel(SearchPanel.this.resultsTable.getSelectedRow()));
                    ((ModelIDObject)SearchPanel.this.selectedObject.getObj()).showPropertyDialog();
                }
            }
        });
        this.resultPane = new JScrollPane(this.resultsTable);
        JPanel diagramsPanel = new JPanel(new GridBagLayout());
        diagramsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SearchPanel.Diagrams")));
        this.diagramsPerObjectListModel = new DefaultListModel();
        this.diagramsPerObjectList = new JList(this.diagramsPerObjectListModel);
        this.diagramsPerObjectList.addMouseListener(this.diagramDblClickMouseAdapter());
        this.diagramsPerObjectPane = new JScrollPane(this.diagramsPerObjectList);
        diagramsPanel.add((Component)this.diagramsPerObjectPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        resultsPanel.add((Component)this.resultPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 200));
        resultsPanel.add((Component)diagramsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 1, new Insets(5, 5, 5, 5), 0, 100));
        this.tpane.addTab(Messages.getString("SearchPanel.Results"), resultsPanel);
    }

    private void runSearch(boolean enterKeyUsed) {
        this.resultsTable.getSelectionModel().clearSelection();
        this.resultsTable.setAutoCreateRowSorter(false);
        this.resultsTable.setRowSorter(null);
        this.resultList.clear();
        this.resultsTable.updateUI();
        this.diagramsPerObjectListModel.clear();
        if (enterKeyUsed) {
            this.search();
        } else if (this.settings.isSearchAsUType() && this.simpleSearchBox.getText().length() >= this.settings.getSearchAsUTypeStart()) {
            this.search();
        }
    }

    private void search() {
        try {
            this.allFoundResults = this.createResultList();
            if (this.allFoundResults.size() > 0) {
                for (Object obj : this.allFoundResults) {
                    this.resultList.add(obj);
                }
                if (this.tpane.getTabCount() > 1) {
                    this.tpane.setSelectedIndex(1);
                } else {
                    this.tpane.setSelectedIndex(0);
                }
                this.resultsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.resultsTable, 0);
                this.resultsTable.setRowSelectionInterval(0, 0);
                this.resultsTable.updateUI();
                Object selected = ((SearchResultObject)this.resultList.get(this.resultsTable.convertRowIndexToModel(this.resultsTable.getSelectedRow()))).getObj();
                if (selected instanceof DesignObject) {
                    this.getDiagrams((DesignObject)selected);
                }
                if (this.advancedMode) {
                    this.btnPrintReport.setEnabled(true);
                    this.btnPrintReport.setToolTipText(Messages.getString("SearchPanel.GenerateReport"));
                    this.btnSetProperties.setEnabled(true);
                    this.btnSetProperties.setToolTipText(Messages.getString("SearchPanel.ApplyPropertiesValues"));
                } else {
                    this.cmbSimpleModeFilter.removeItemListener(this.simpleModeFilterItemListener);
                    this.cmbSimpleModeFilter.removeAllItems();
                    this.cmbSimpleModeFilter.addItem("ALL");
                    Collections.sort(this.foundObjectTypes, new ReportUtils.SearchSetsComparator());
                    for (SearchSet ss : this.foundObjectTypes) {
                        this.cmbSimpleModeFilter.addItem(new JComboHtmlItem(ss.getTypeName(), "<html><nobr><b>" + ss.getTypeName() + "</b>" + " " + "<i>" + ss.getModel().getName() + "</i>" + "</nobr></html>", ss));
                    }
                    this.cmbSimpleModeFilter.addItemListener(this.simpleModeFilterItemListener);
                }
            } else if (this.advancedMode) {
                JOptionPane.showMessageDialog(this.appView.getFrame(), Messages.getString("SearchPanel.NoDataFound"), Messages.getString("SearchPanel.AdvancedModeSearch"), 1);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in model level search search()", e);
        }
    }

    private void switchAdvancedAndSimplePanels() {
        this.resultsTable.getSelectionModel().clearSelection();
        this.resultsTable.setAutoCreateRowSorter(false);
        this.resultsTable.setRowSorter(null);
        this.resultList.clear();
        this.resultsTable.updateUI();
        this.simpleSearchBox.getDocument().removeDocumentListener(this.simpleSearchDocumentListener);
        this.simpleSearchBox.removeKeyListener(this.simpleSearchEnterKeyListener);
        this.btnPrintReport.setEnabled(false);
        this.btnPrintReport.setToolTipText(Messages.getString("SearchPanel.FilterObjTypeToUseReporting"));
        this.btnSetProperties.setEnabled(false);
        this.btnSetProperties.setToolTipText(Messages.getString("SearchPanel.FilterObjTypeToUseSetProperties"));
        if (this.advancedMode) {
            this.simpleSearchBox.setText("");
            this.simpleSearchBox.setEnabled(false);
            this.cmbSimpleModeFilter.setEnabled(false);
            this.cbCaseSensitive.setSelected(false);
            this.cbCaseSensitive.setEnabled(false);
            this.tpane.insertTab(Messages.getString("SearchPanel.SearchOptions"), null, this.searchPropertiesTabPanel, "", 0);
            this.tpane.setSelectedComponent(this.searchPropertiesTabPanel);
            this.rbOR.setSelected(true);
            this.cmbAdvancedModeFilter.setSelectedIndex(-1);
            this.cmbAdvancedModeFilter.setSelectedIndex(0);
            this.cmbSimpleModeFilter.removeItemListener(this.simpleModeFilterItemListener);
        } else {
            this.simpleSearchBox.setText("");
            this.simpleSearchBox.setEnabled(true);
            this.cmbSimpleModeFilter.setEnabled(true);
            this.cbCaseSensitive.setSelected(false);
            this.cbCaseSensitive.setEnabled(true);
            this.tpane.remove(this.searchPropertiesTabPanel);
            this.cmbSimpleModeFilter.setSelectedItem("ALL");
            this.cmbSimpleModeFilter.addItemListener(this.simpleModeFilterItemListener);
            this.simpleSearchBox.getDocument().addDocumentListener(this.simpleSearchDocumentListener);
            this.simpleSearchBox.addKeyListener(this.simpleSearchEnterKeyListener);
        }
    }

    private List createResultList() {
        this.foundObjectTypes.clear();
        ArrayList collection = new ArrayList();
        ArrayList<SearchResultObject> rList = new ArrayList<SearchResultObject>();
        Iterator setsIt = null;
        if (this.currentModel instanceof DesignPart) {
            setsIt = ((DesignPart)this.currentModel).getSearchableSets().iterator();
        } else if (this.currentModel instanceof StorageDesign) {
            setsIt = ((StorageDesign)this.currentModel).getSearchableSets().iterator();
        }
        if (this.advancedMode) {
            SearchSet currentSS = (SearchSet)((JComboHtmlItem)this.cmbAdvancedModeFilter.getSelectedItem()).getObject();
            ((ElementSet)((Object)currentSS.getSet())).addAllElementsTo(collection);
            Iterator objectsIt = collection.iterator();
            if (this.rbOR.isSelected()) {
                while (objectsIt.hasNext()) {
                    ModelIDObject obj = (ModelIDObject)objectsIt.next();
                    for (Map.Entry e : this.currentAdvancedSearchPropertiesMap.entrySet()) {
                        PropertyObject po = (PropertyObject)e.getValue();
                        SearchResultObject resObject = ReportUtils.search(obj, obj.getClass(), currentSS.getTypeName(), po, po.getSearchPattern(), po.isCaseSensitive(), this.cbUseRegex.isSelected(), po.isNot(), true);
                        if (resObject == null) continue;
                        rList.add(resObject);
                    }
                }
            } else if (this.rbAND.isSelected()) {
                while (objectsIt.hasNext()) {
                    boolean addObjectToResultList = false;
                    String resultObjectTypes = "";
                    String summaryContent = "";
                    ModelIDObject obj = (ModelIDObject)objectsIt.next();
                    Iterator pIt = this.currentAdvancedSearchPropertiesMap.entrySet().iterator();
                    String value = null;
                    String sPattern = "";
                    boolean cs = false;
                    while (pIt.hasNext()) {
                        Map.Entry e = pIt.next();
                        PropertyObject po = (PropertyObject)e.getValue();
                        sPattern = po.getSearchPattern();
                        cs = po.isCaseSensitive();
                        Method method = null;
                        String name = "";
                        String className = "";
                        ClassDescription.PropertyDescription pd = po.getPropertyDescription();
                        method = pd.getter;
                        name = pd.name;
                        className = pd.className;
                        value = ReportUtils.getValue(obj, method, className);
                        int idx = ReportUtils.match(value, sPattern, po.isCaseSensitive(), this.cbUseRegex.isSelected(), po.isNot(), true);
                        if (idx > -1) {
                            addObjectToResultList = true;
                            resultObjectTypes = resultObjectTypes + name + ",";
                            summaryContent = summaryContent + "<br><br><b><i>[" + name + "]</i></b><br>" + value;
                            continue;
                        }
                        addObjectToResultList = false;
                        break;
                    }
                    if (!addObjectToResultList) continue;
                    resultObjectTypes = resultObjectTypes.substring(0, resultObjectTypes.lastIndexOf(","));
                    if (summaryContent.length() >= 8) {
                        summaryContent = summaryContent.substring(8, summaryContent.length());
                    }
                    SearchResultObject ro = new SearchResultObject(obj, obj.getClass(), resultObjectTypes, obj.getObjectTypeName(), ReportUtils.getContentToShow(sPattern, value, cs, 0, this.cbUseRegex.isSelected()), summaryContent);
                    rList.add(ro);
                }
            }
        } else {
            while (setsIt.hasNext()) {
                SearchSet ss = (SearchSet)setsIt.next();
                ((ElementSet)((Object)ss.getSet())).addAllElementsTo(collection);
                String type = ss.getTypeName();
                List results = ReportUtils.doSimpleSearch(collection, ss.getClazz(), type, this.metaDataManager, this.simpleSearchBox.getText(), this.cbCaseSensitive.isSelected(), this.cbStopOnFirst.isSelected(), this.cbUseRegex.isSelected(), false);
                if (results.size() > 0) {
                    rList.addAll(results);
                    if (!this.foundObjectTypes.contains(ss)) {
                        this.foundObjectTypes.add(ss);
                    }
                }
                collection.clear();
            }
        }
        if (rList.size() > 0) {
            this.updateLastSearchResultsList(rList);
            Collections.sort(rList, new ReportUtils.ResultObjectsComparator());
        }
        return rList;
    }

    private void getDiagrams(DesignObject object) {
        this.diagramsPerObjectListModel.clear();
        Iterator it = null;
        if (object instanceof Table || object instanceof TableView || object instanceof Entity || object instanceof EntityView || object instanceof FKIndexAssociation || object instanceof Cube || object instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension || object instanceof Level || object instanceof StructuredType) {
            it = object.getAffectedDPVs().iterator();
        } else if (object instanceof Index || object instanceof CandidateKey) {
            it = ((DesignObject)((KeyObject)object).getContainerObject()).getAffectedDPVs().iterator();
        } else if (object instanceof Column || object instanceof Attribute) {
            if (((ContainedObject)object).getContainer() != null) {
                it = ((DesignObject)((ContainedObject)object).getContainer()).getAffectedDPVs().iterator();
            }
        } else if (object instanceof TypeElement) {
            it = ((TypeElement)object).getStructuredType().getAffectedDPVs().iterator();
        } else if (object instanceof Relation) {
            it = ((Relation)object).getSourceEntity().getAffectedDPVs().iterator();
        }
        if (it != null) {
            while (it.hasNext()) {
                DesignPartView dpv = (DesignPartView)it.next();
                this.diagramsPerObjectListModel.addElement(dpv);
            }
        }
    }

    protected MouseListener diagramDblClickMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DesignPartView selectedDiagram = (DesignPartView)SearchPanel.this.diagramsPerObjectList.getSelectedValue();
                    Object obj = SearchPanel.this.selectedObject.getObj();
                    if (obj instanceof Column || obj instanceof Attribute) {
                        obj = ((ContainedObject)obj).getContainer();
                    } else if (obj instanceof Index || obj instanceof CandidateKey) {
                        obj = ((KeyObject)obj).getContainerObject();
                    } else if (obj instanceof TypeElement) {
                        obj = ((TypeElement)obj).getStructuredType();
                    }
                    new Thread(new ShowDiagramAndSelectRunner(selectedDiagram, (DesignObject)obj)).start();
                    TopView tv = null;
                    tv = obj instanceof Column || obj instanceof Attribute ? ((ContainedObject)obj).getContainer().getTopView() : (obj instanceof Index || obj instanceof CandidateKey ? ((KeyObject)obj).getContainerObject().getTopView() : (obj instanceof TypeElement ? ((TypeElement)obj).getStructuredType().getTopView() : ((DesignObject)obj).getTopView()));
                }
            }
        };
    }

    public void resetItems(ModelIDObject currentModel) {
        this.currentModel = currentModel;
        this.cmbAdvancedModeFilter.removeAllItems();
        this.cmbSimpleModeFilter.removeAllItems();
        this.cmbSimpleModeFilter.addItem("ALL");
        this.getModelObjectTypes(currentModel);
        ArrayList allobjects = new ArrayList();
        allobjects.addAll(this.foundObjectTypes);
        Collections.sort(allobjects, new ReportUtils.SearchSetsComparator());
        for (SearchSet ss : allobjects) {
            this.cmbAdvancedModeFilter.addItem(new JComboHtmlItem(ss.getTypeName(), ss.getTypeName(), ss));
        }
        this.advancedMode = false;
        this.diagramsPerObjectListModel.clear();
        this.resultList.clear();
        this.propertiesList.clear();
    }

    public void clearOnCloseDesign() {
        this.currentModel = null;
        this.metaDataManager = null;
        this.cmbAdvancedModeFilter.removeAllItems();
        this.cmbSimpleModeFilter.removeAllItems();
        this.diagramsPerObjectListModel.clear();
        this.resultList.clear();
        this.propertiesList.clear();
        this.currentModel = null;
    }

    private void getModelObjectTypes(ModelIDObject model) {
        ArrayList tempList = new ArrayList();
        if (model instanceof RelationalDesign) {
            tempList.addAll(((RelationalDesign)this.currentModel).getSearchableSets());
        } else if (model instanceof LogicalDesign) {
            tempList.addAll(((LogicalDesign)this.currentModel).getSearchableSets());
        } else if (model instanceof MultidimensionalDesign) {
            tempList.addAll(((MultidimensionalDesign)this.currentModel).getSearchableSets());
        } else if (model instanceof ProcessModel) {
            tempList.addAll(((ProcessModel)this.currentModel).getSearchableSets());
        } else if (model instanceof DataTypesDesign) {
            tempList.addAll(((DataTypesDesign)this.currentModel).getSearchableSets());
        } else if (model instanceof BusinessInfoDesign) {
            tempList.addAll(((BusinessInfoDesign)this.currentModel).getSearchableSets());
        } else if (model instanceof DataFlowDesign) {
            tempList.addAll(((DataFlowDesign)this.currentModel).getSearchableSets());
        } else if (model instanceof StorageDesign) {
            tempList.addAll(((StorageDesign)this.currentModel).getSearchableSets());
        }
        Iterator setsIt = tempList.iterator();
        while (setsIt.hasNext()) {
            ArrayList collection = new ArrayList();
            SearchSet ss = (SearchSet)setsIt.next();
            ((ElementSet)((Object)ss.getSet())).addAllElementsTo(collection);
            String type = ss.getTypeName();
            List results = ReportUtils.doSimpleSearch(collection, ss.getClazz(), type, this.metaDataManager, "*", this.cbCaseSensitive.isSelected(), this.cbStopOnFirst.isSelected(), this.cbUseRegex.isSelected(), false);
            if (results.size() <= 0 || this.foundObjectTypes.contains(ss)) continue;
            this.foundObjectTypes.add(ss);
        }
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    public ModelIDObject getCurrentModel() {
        return this.currentModel;
    }

    private boolean hasNoArgument(Method method) {
        return method.getParameterTypes().length == 0;
    }

    private List getSavedSearches() {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(0, NEW_SEARCH);
        for (SavedSearch ss : this.appView.getSavedSearches()) {
            l.add(ss);
        }
        Collections.sort(l, ModelObjectSet.TOSTRING_COMPARATOR);
        return l;
    }

    private SavedSearch getSavedSearch(String name) {
        SavedSearch ss = null;
        for (SavedSearch current : this.appView.getSavedSearches()) {
            if (!current.getSsName().equals(name)) continue;
            ss = current;
            break;
        }
        return ss;
    }

    private void updateLastSearchResultsList(List allResultsList) {
        List lsr = null;
        if (this.currentModel instanceof DesignPart) {
            lsr = ((DesignPart)this.currentModel).getLastSearchResult();
        } else if (this.currentModel instanceof StorageDesign) {
            lsr = ((StorageDesign)this.currentModel).getLastSearchResult();
        }
        ArrayList<Object> objectsList = new ArrayList<Object>();
        Iterator it = allResultsList.iterator();
        while (it.hasNext()) {
            Object obj = ((SearchResultObject)it.next()).getObj();
            if (objectsList.contains(obj)) continue;
            objectsList.add(obj);
        }
        lsr.clear();
        lsr.addAll(objectsList);
    }

    class PropertyComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public PropertyComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(ReportUtils.getDisplayName(((PropertyObject)value).getName()));
            return this;
        }
    }

    private class AddPropertyAction
    implements ActionListener {
        private AddPropertyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel jp = new JPanel(new FlowLayout(0));
            jp.setAlignmentX(0.0f);
            jp.setPreferredSize(new Dimension(700, 30));
            jp.setMaximumSize(new Dimension(700, 30));
            jp.setMinimumSize(new Dimension(700, 30));
            final JComboBox<Object> cbProperty = new JComboBox<Object>(SearchPanel.this.propertiesList.toArray());
            cbProperty.setRenderer(new PropertyComboBoxRenderer());
            cbProperty.setPreferredSize(new Dimension(200, 20));
            cbProperty.putClientProperty("id", SearchPanel.this.currentAdvancedSearchPropertiesMap.size() + 1);
            cbProperty.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        PropertyObject newPO = (PropertyObject)e.getItem();
                        Integer key = (Integer)cbProperty.getClientProperty("id");
                        SearchPanel.this.currentAdvancedSearchPropertiesMap.put(key, newPO);
                    }
                }
            });
            final JCheckBox cbNot = new JCheckBox(Messages.getString("SearchPanel.Not"));
            cbNot.putClientProperty("id", SearchPanel.this.currentAdvancedSearchPropertiesMap.size() + 1);
            cbNot.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JCheckBox cb = (JCheckBox)e.getItem();
                    Integer key = (Integer)cbNot.getClientProperty("id");
                    PropertyObject po = (PropertyObject)SearchPanel.this.currentAdvancedSearchPropertiesMap.get(key);
                    po.setNot(cb.isSelected());
                }
            });
            JTextField tfPattern = new JTextField();
            tfPattern.setPreferredSize(new Dimension(300, 20));
            tfPattern.getDocument().putProperty("id", SearchPanel.this.currentAdvancedSearchPropertiesMap.size() + 1);
            tfPattern.getDocument().putProperty("parent", tfPattern);
            tfPattern.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update(e);
                }

                private void update(DocumentEvent e) {
                    Integer key = (Integer)e.getDocument().getProperty("id");
                    PropertyObject po = (PropertyObject)SearchPanel.this.currentAdvancedSearchPropertiesMap.get(key);
                    JTextField textField = (JTextField)e.getDocument().getProperty("parent");
                    po.setSearchPattern(textField.getText());
                }
            });
            final JCheckBox cbCS = new JCheckBox(Messages.getString("SearchPanel.CaseSensitive"));
            cbCS.putClientProperty("id", SearchPanel.this.currentAdvancedSearchPropertiesMap.size() + 1);
            cbCS.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JCheckBox cb = (JCheckBox)e.getItem();
                    Integer key = (Integer)cbCS.getClientProperty("id");
                    PropertyObject po = (PropertyObject)SearchPanel.this.currentAdvancedSearchPropertiesMap.get(key);
                    po.setCaseSensitive(cb.isSelected());
                }
            });
            final JButton btnRemove = new JButton(GUIConfiguration.getInstance().getIcon("REMOVE_ICON", 16));
            btnRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
            btnRemove.setToolTipText(Messages.getString("SearchPanel.RemoveProperty"));
            btnRemove.putClientProperty("id", SearchPanel.this.currentAdvancedSearchPropertiesMap.size() + 1);
            btnRemove.putClientProperty("panel", jp);
            btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Integer key = (Integer)btnRemove.getClientProperty("id");
                    JPanel jp = (JPanel)btnRemove.getClientProperty("panel");
                    SearchPanel.this.currentAdvancedSearchPropertiesMap.remove(key);
                    SearchPanel.this.propertiesPanel.remove(jp);
                    SearchPanel.this.propertiesPanel.validate();
                    SearchPanel.this.propertiesPanel.repaint();
                }
            });
            btnRemove.setMnemonic(82);
            jp.add(cbProperty);
            jp.add(cbNot);
            jp.add(tfPattern);
            jp.add(cbCS);
            jp.add(btnRemove);
            SearchPanel.this.currentAdvancedSearchPropertiesMap.put(new Integer(SearchPanel.this.currentAdvancedSearchPropertiesMap.size() + 1), ((PropertyObject)cbProperty.getSelectedItem()).copy());
            if (SearchPanel.this.isAutomaticallyAddedProperty) {
                for (int index = 0; index < cbProperty.getItemCount(); ++index) {
                    PropertyObject currentPO = (PropertyObject)cbProperty.getItemAt(index);
                    if (!currentPO.getName().equals(SearchPanel.this.automaticallyLoadedPropertyObject.getName())) continue;
                    cbProperty.setSelectedItem(currentPO);
                    break;
                }
                cbNot.setSelected(SearchPanel.this.automaticallyLoadedPropertyObject.isNot());
                cbCS.setSelected(SearchPanel.this.automaticallyLoadedPropertyObject.isCaseSensitive());
                tfPattern.setText(SearchPanel.this.automaticallyLoadedPropertyObject.getSearchPattern());
            }
            SearchPanel.this.propertiesPanel.add(jp);
            SearchPanel.this.propertiesPanel.validate();
            SearchPanel.this.propertiesPanel.repaint();
        }
    }

    class SavedSearchEditor
    implements ComboBoxEditor {
        List savedSearches;
        String selectedSSID;
        JTextField textFeild;

        public SavedSearchEditor(List savedSearches) {
            this.savedSearches = savedSearches;
            this.textFeild = new JTextField();
        }

        @Override
        public Component getEditorComponent() {
            return this.textFeild;
        }

        @Override
        public void setItem(Object anObject) {
            String text = "";
            if (anObject instanceof SavedSearch) {
                text = ((SavedSearch)anObject).getSsName();
                this.selectedSSID = ((SavedSearch)anObject).getSsId();
            } else {
                this.selectedSSID = "";
                text = (String)anObject;
            }
            this.textFeild.setText(text);
        }

        @Override
        public Object getItem() {
            for (Object obj : this.savedSearches) {
                if (!(obj instanceof SavedSearch) || !((SavedSearch)obj).getSsId().equals(this.selectedSSID)) continue;
                return obj;
            }
            return this.textFeild.getText();
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.textFeild.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.textFeild.removeActionListener(l);
        }

        public JTextField getTextFeild() {
            return this.textFeild;
        }

        public void addItem(SavedSearch ss) {
            this.savedSearches.add(ss);
        }
    }

    class SavedSearchRenderer
    extends JLabel
    implements ListCellRenderer {
        SavedSearchRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = "";
            text = value instanceof SavedSearch ? ((SavedSearch)value).ssName : (String)value;
            this.setFont(list.getFont());
            this.setText(text);
            this.setOpaque(true);
            return this;
        }
    }

    class AdvancedModePatternCellEditor
    extends DefaultCellEditor {
        public AdvancedModePatternCellEditor(JTextField textField) {
            super(textField);
            super.setClickCountToStart(1);
        }
    }

    class CmbAdvancedModeFilterRenderer
    extends JLabel
    implements ListCellRenderer {
        public CmbAdvancedModeFilterRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof JComboHtmlItem) {
                this.setText(((SearchSet)((JComboHtmlItem)value).getObject()).getTypeName());
            } else {
                this.setText((String)value);
            }
            return this;
        }
    }

    class CmbSimpleModeFilterRenderer
    extends JLabel
    implements ListCellRenderer {
        public CmbSimpleModeFilterRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof JComboHtmlItem) {
                this.setText(((JComboHtmlItem)value).getHtmlText());
            } else {
                this.setText((String)value);
            }
            return this;
        }
    }

    private class ChangePropertiesAction
    implements ActionListener {
        private ChangePropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ApplyPropertiesValuesDialog dialog = new ApplyPropertiesValuesDialog(SearchPanel.this.appView, SearchPanel.this.resultList, SearchPanel.this.propertiesList, SearchPanel.this.currentModel);
                dialog.showDialog();
            }
            catch (Exception error) {
                LOGGER.error("Error in opening SearchResultsModifyPropertiesValuesDialog ", error);
            }
        }
    }

    private class UseRegExListener
    implements ActionListener {
        private UseRegExListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPanel.this.runSearch(false);
        }
    }

    private class StopOnFirstListener
    implements ActionListener {
        private StopOnFirstListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPanel.this.runSearch(false);
        }
    }

    private class SimpleSearchEnterKeyListener
    extends KeyAdapter {
        private SimpleSearchEnterKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                SearchPanel.this.runSearch(true);
            }
        }
    }

    private class SimpleSearchDocumentListener
    implements DocumentListener {
        private SimpleSearchDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SearchPanel.this.runSearch(false);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SearchPanel.this.runSearch(false);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SearchPanel.this.runSearch(false);
        }
    }

    class SavedSearchesComparator
    implements Comparator {
        SavedSearchesComparator() {
        }

        public int compare(Object one, Object two) {
            SavedSearch s1 = (SavedSearch)one;
            SavedSearch s2 = (SavedSearch)two;
            return s1.getSsName().compareTo(s2.getSsName());
        }
    }

    private class SimpleModeFilterItemListener
    implements ItemListener {
        private SimpleModeFilterItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                SearchPanel.this.resultList.clear();
                SearchPanel.this.resultsTable.getSelectionModel().clearSelection();
                SearchPanel.this.resultsTable.setAutoCreateRowSorter(false);
                SearchPanel.this.resultsTable.setRowSorter(null);
                SearchPanel.this.resultsTable.updateUI();
                Object selected = SearchPanel.this.cmbSimpleModeFilter.getSelectedItem();
                SearchSet selectedSS = null;
                SearchPanel.this.propertiesList.clear();
                if (selected instanceof JComboHtmlItem) {
                    selectedSS = (SearchSet)((JComboHtmlItem)selected).getObject();
                    SearchPanel.this.propertiesList.addAll(ReportUtils.getSearchablePropertyObjects(selectedSS.getClazz(), SearchPanel.this.metaDataManager));
                }
                for (SearchResultObject ro : SearchPanel.this.allFoundResults) {
                    if ((selectedSS == null || selectedSS.getClazz() != ro.getClazz()) && !selected.equals("ALL")) continue;
                    SearchPanel.this.resultList.add(ro);
                }
                if (SearchPanel.this.resultList.size() > 0) {
                    SearchPanel.this.resultsTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(SearchPanel.this.resultsTable, 0);
                    SearchPanel.this.resultsTable.setRowSelectionInterval(0, 0);
                    if (selected.equals("ALL")) {
                        SearchPanel.this.btnPrintReport.setEnabled(false);
                        SearchPanel.this.btnPrintReport.setToolTipText(Messages.getString("SearchPanel.FilterObjTypeToUseReporting"));
                        SearchPanel.this.btnSetProperties.setEnabled(false);
                        SearchPanel.this.btnSetProperties.setToolTipText(Messages.getString("SearchPanel.FilterObjTypeToUseSetProperties"));
                    } else {
                        SearchPanel.this.btnPrintReport.setEnabled(true);
                        SearchPanel.this.btnPrintReport.setToolTipText(Messages.getString("SearchPanel.GenerateReport"));
                        SearchPanel.this.btnSetProperties.setEnabled(true);
                        SearchPanel.this.btnSetProperties.setToolTipText(Messages.getString("SearchPanel.ApplyPropertiesValues"));
                    }
                    SearchPanel.this.updateLastSearchResultsList(SearchPanel.this.resultList);
                }
                SearchPanel.this.resultsTable.updateUI();
            }
        }
    }

    private class RefreshAction
    implements ActionListener {
        private RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPanel.this.runSearch(false);
            SearchPanel.this.resultsTable.scrollRectToVisible(new Rectangle(SearchPanel.this.resultsTable.getCellRect(1, 1, true)));
        }
    }

    private class PrintReportAction
    implements ActionListener {
        private PrintReportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                SearchResultsReportsGenerationDialog reportsDialog;
                SearchPanel.this.extraParams.put("pattern", SearchPanel.this.simpleSearchBox.getText());
                if (SearchPanel.this.advancedMode) {
                    SearchPanel.this.extraParams.put("filterObject", ((JComboHtmlItem)SearchPanel.this.cmbAdvancedModeFilter.getSelectedItem()).getObject());
                    SearchPanel.this.extraParams.put("metadata_manager", SearchPanel.this.metaDataManager);
                    SearchPanel.this.extraParams.put("model", SearchPanel.this.currentModel);
                    Class clz = ((SearchSet)((JComboHtmlItem)SearchPanel.this.cmbAdvancedModeFilter.getSelectedItem()).getObject()).getClazz();
                    reportsDialog = new SearchResultsReportsGenerationDialog(SearchPanel.this.appView, clz, SearchPanel.this.resultList, SearchPanel.this.extraParams);
                } else {
                    Object selected = SearchPanel.this.cmbSimpleModeFilter.getSelectedItem();
                    Object smObject = "";
                    smObject = selected instanceof JComboHtmlItem ? ((JComboHtmlItem)selected).getObject() : "ALL";
                    SearchPanel.this.extraParams.put("filterObject", smObject);
                    SearchPanel.this.extraParams.put("metadata_manager", SearchPanel.this.metaDataManager);
                    SearchPanel.this.extraParams.put("model", SearchPanel.this.currentModel);
                    Class clz = null;
                    if (!SearchPanel.this.cmbSimpleModeFilter.getSelectedItem().equals("ALL")) {
                        clz = ((SearchSet)((JComboHtmlItem)SearchPanel.this.cmbSimpleModeFilter.getSelectedItem()).getObject()).getClazz();
                    }
                    reportsDialog = new SearchResultsReportsGenerationDialog(SearchPanel.this.appView, clz, SearchPanel.this.resultList, SearchPanel.this.extraParams);
                }
                reportsDialog.showDialog();
            }
            catch (Exception error) {
                LOGGER.error("Error in model level search reports generation", error);
            }
        }
    }

    class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        TableColumn curCol;
        Map tips = new HashMap();

        ColumnHeaderToolTips() {
        }

        public void setToolTip(TableColumn col, String tooltip) {
            if (tooltip == null) {
                this.tips.remove(col);
            } else {
                this.tips.put(col, tooltip);
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            JTableHeader header = (JTableHeader)evt.getSource();
            JTable table = header.getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            TableColumn col = null;
            if (vColIndex >= 0) {
                col = colModel.getColumn(vColIndex);
            }
            if (col != this.curCol) {
                header.setToolTipText((String)this.tips.get(col));
                this.curCol = col;
            }
        }
    }

    class AdvancedModeCSColumnRenderer
    extends JCheckBox
    implements TableCellRenderer {
        Color foreground;
        Color background;
        JCheckBox jcb = new JCheckBox();

        public AdvancedModeCSColumnRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Boolean use = (Boolean)table.getModel().getValueAt(row, 0);
            this.foreground = table.getForeground();
            this.background = table.getBackground();
            String tooltipTxt = use != false ? Messages.getString("SearchPanel.SelectChecboxToEnableCS") : Messages.getString("SearchPanel.SelectChecboxToEnableCS1");
            this.jcb.setForeground(this.foreground);
            this.jcb.setBackground(this.background);
            this.jcb.setToolTipText(tooltipTxt);
            this.jcb.setHorizontalAlignment(0);
            this.jcb.setSelected((Boolean)value);
            return this.jcb;
        }
    }

    class AdvancedModePatternColumnRenderer
    extends JSearchTextField
    implements TableCellRenderer {
        JTable table;
        Boolean use;

        public AdvancedModePatternColumnRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.table = table;
            this.use = (Boolean)table.getModel().getValueAt(row, 0);
            String tooltipTxt = this.use != false ? Messages.getString("SearchPanel.ClickToEdit") : Messages.getString("SearchPanel.SelectChecboxToEnableSearchText");
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
            this.setToolTipText(tooltipTxt);
            this.setText((String)value);
            return this;
        }
    }

    class AdvancedModePatternColumnHeaderRenderer
    implements TableCellRenderer {
        AdvancedModePatternColumnHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = new JLabel(Messages.getString("SearchPanel.SearchPattern"));
            DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer();
            Component c = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setOpaque(true);
            label.setFont(c.getFont());
            label.setForeground(c.getForeground());
            label.setBorder(((JComponent)c).getBorder());
            label.setIcon(SearchPanel.this.configuration.getIcon("SEARCH_ICON", 16));
            return label;
        }
    }

    class AdvancedModePropertyColumnRenderer
    extends DefaultTableCellRenderer {
        public AdvancedModePropertyColumnRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setForeground(Color.BLACK);
            return this;
        }
    }

    class AdvancedModeNotColumnRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public AdvancedModeNotColumnRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JCheckBox jcb = new JCheckBox();
            Boolean use = (Boolean)table.getModel().getValueAt(row, 0);
            if (use.booleanValue()) {
                jcb.setToolTipText("Select the checkbox to exclude search text for that property");
            } else {
                jcb.setToolTipText("Select the checkbox in 'Use' column to enable 'Not' checkbox for that property");
            }
            jcb.setForeground(table.getForeground());
            jcb.setBackground(table.getBackground());
            jcb.setHorizontalAlignment(0);
            jcb.setSelected((Boolean)value);
            return jcb;
        }
    }

    class AdvancedModeUseColumnRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public AdvancedModeUseColumnRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JCheckBox jcb = new JCheckBox();
            jcb.setForeground(table.getForeground());
            jcb.setBackground(table.getBackground());
            jcb.setToolTipText(Messages.getString("SearchPanel.SelectChecboxToEnableFields"));
            jcb.setHorizontalAlignment(0);
            jcb.setSelected((Boolean)value);
            return jcb;
        }
    }

    class ContentRenderer
    extends DefaultTableCellRenderer {
        ContentRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tip = ((SearchResultObject)SearchPanel.this.resultList.get(table.convertRowIndexToModel(row))).getFullContent();
            if (tip != null && !tip.equals("")) {
                this.setToolTipText("<html><pre>" + tip + "</pre></html>");
            } else {
                this.setToolTipText(null);
            }
            FontMetrics fm = table.getFontMetrics(table.getFont());
            String first = text = value == null ? "" : value.toString();
            String dots = "";
            int columnWidth = table.getColumnModel().getColumn(column).getWidth();
            int textWidth = 0;
            for (int i = 0; i < text.length(); ++i) {
                if ((textWidth += fm.charWidth(text.charAt(i))) <= columnWidth) continue;
                first = text.substring(0, i - 1);
                dots = "...";
                break;
            }
            this.setText("<html>" + first + dots + "</html>");
            return this;
        }
    }

    private class ShowDiagramAndSelectRunner
    implements Runnable {
        DesignPartViewPlaceHolder dpvph;
        private ProgressDialog monitor;
        DesignPart designPart;
        DesignPartView dpv;
        DesignObject dobj;

        public ShowDiagramAndSelectRunner(DesignPartView dpv, DesignObject dobj) {
            if (dpv.isMainDiagram() || dpv.getMasterDPV() != null && dpv.getMasterDPV().isMainDiagram()) {
                this.designPart = dpv.getDesignPart();
            } else if (dpv.isMasterDPV()) {
                this.dpvph = (DesignPartViewPlaceHolder)dpv.getPlaceHolder();
            } else if (dpv.getMasterDPV() != null) {
                this.dpvph = (DesignPartViewPlaceHolder)dpv.getMasterDPV().getPlaceHolder();
            }
            this.dpv = dpv;
            this.dobj = dobj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String name = "";
            if (this.designPart != null) {
                name = this.designPart.getName();
            } else if (this.dpvph != null) {
                name = this.dpvph.getName();
            }
            this.monitor = new ProgressDialog(SearchPanel.this.appView, MessageFormat.format(Messages.getString("SearchPanel.ShowDiagram"), name), 0, 100);
            this.monitor.setProgress(5);
            this.monitor.setNote(MessageFormat.format(Messages.getString("SearchPanel.ShowDiagram"), name));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.monitor.setProgress(10);
            this.monitor.setNote(MessageFormat.format(Messages.getString("SearchPanel.ShowDiagram"), name));
            try {
                if (this.designPart != null) {
                    this.designPart.setMainViewVisible(true, this.monitor);
                } else if (this.dpvph != null) {
                    this.dpvph.setVisible(true, this.monitor, this.dobj);
                }
                if (this.dpv != null && this.dpv.getDesignPart().isLoaded()) {
                    DesignPartView mdpv;
                    DesignPartView.NamedTabbedPane pane;
                    if (this.dpv.isMasterDPV()) {
                        pane = this.dpv.getTabbedPane();
                        mdpv = this.dpv;
                    } else {
                        pane = this.dpv.getMasterDPV().getTabbedPane();
                        mdpv = this.dpv.getMasterDPV();
                    }
                    if (!this.dpv.activateEditor()) {
                        if (mdpv == this.dpv.getDesignPart().getMainView()) {
                            this.dpv.getDesignPart().setMainViewVisible(true);
                        } else {
                            mdpv.getPlaceHolder().setVisible(true);
                        }
                    }
                    if (pane.indexOfComponent(this.dpv) > -1 && pane.indexOfComponent(mdpv) > -1) {
                        pane.setSelectedComponent(mdpv);
                        pane.setSelectedComponent(this.dpv);
                        ContainerView cv = (ContainerView)this.dobj.getFirstViewForDPV(this.dpv);
                        if (cv != null) {
                            cv.setCurrentSelectionToContainer();
                            if (cv.getCellView() != null) {
                                this.dpv.getWorkSpace().scrollCellToVisible(cv.getCellView().getCell());
                            }
                        }
                    }
                }
            }
            finally {
                this.monitor.close();
            }
        }
    }

    class PropertyObjectsComparator
    implements Comparator {
        PropertyObjectsComparator() {
        }

        public int compare(Object one, Object two) {
            PropertyObject s1 = (PropertyObject)one;
            PropertyObject s2 = (PropertyObject)two;
            String name1 = "";
            String name2 = "";
            name1 = s1.getPropertyDescription().name;
            name2 = s2.getPropertyDescription().name;
            return name1.compareTo(name2);
        }
    }

    private class ResultListModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SearchPanel.Name"), Messages.getString("SearchPanel.Property"), Messages.getString("SearchPanel.Type"), Messages.getString("SearchPanel.Content"), "hidden column"};

        private ResultListModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getRowCount() {
            return SearchPanel.this.resultList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SearchResultObject ro = (SearchResultObject)SearchPanel.this.resultList.get(rowIndex);
            ModelIDObject obj = (ModelIDObject)ro.getObj();
            if (columnIndex == 0) {
                if (obj instanceof DesignObject) {
                    return ((ModelIDObject)ro.getObj()).getLongName();
                }
                if (obj instanceof StorageObject) {
                    return ((StorageObject)obj).getStorageDesign().getName() + " / " + ((ModelIDObject)ro.getObj()).getLongName();
                }
                if (obj instanceof DesignPart) {
                    return obj.getDesign().getName() + " / " + ((DesignPart)obj).getName();
                }
            } else {
                if (columnIndex == 1) {
                    return ReportUtils.getDisplayName(ro.getPdName());
                }
                if (columnIndex == 2) {
                    return ro.getTypeName();
                }
                if (columnIndex == 3) {
                    return ro.getShortContent();
                }
                if (columnIndex == 4) {
                    return ro.getFullContent();
                }
            }
            return "";
        }
    }

    private class AdvancedSimpleListener
    implements ItemListener {
        private AdvancedSimpleListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                SearchPanel.this.advancedMode = !SearchPanel.this.advancedMode;
                SearchPanel.this.switchAdvancedAndSimplePanels();
            }
        }
    }

    private class FindAdvancedAction
    implements ActionListener {
        private FindAdvancedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Iterator pIt = SearchPanel.this.propertiesList.iterator();
            SearchPanel.this.runSearch(true);
        }
    }
}

