/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.storage.distincttype;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeSetDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.storage.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DistinctTypesDialogDB2
extends JDialog {
    protected JPanel general;
    protected AbstractStorageDesignDB2 storageDesign;
    private DefaultListModel allDomainsModel;
    private DefaultListModel selectedDomainsModel;
    private JList allDomainsList;
    private JList selectedDomainsList;
    private JButton bnAdd;
    private JButton bnRemove;

    public DistinctTypesDialogDB2(ApplicationView view, AbstractStorageDesignDB2 storageDesign) {
        super(view.getFrame());
        this.storageDesign = storageDesign;
        this.storageDesign.setDtDialogVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                DistinctTypesDialogDB2.this.storageDesign.setDtDialogVisible(false);
            }
        });
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.general = new JPanel(new SpringLayout());
        this.getContentPane().add(this.general);
        this.initGeneralView();
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)this.general, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(Messages.getString("DistinctTypesDialogDB2.OK"));
        bnOK.addActionListener(new OKAction());
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setMnemonic(79);
        bottomPanel.add(bnOK);
        JButton bnApply = new JButton(Messages.getString("DistinctTypesDialogDB2.Apply"));
        bnApply.addActionListener(new ApplyAction());
        bnApply.setCursor(Cursor.getPredefinedCursor(12));
        bnApply.setMnemonic(65);
        bottomPanel.add(bnApply);
        JButton bnCancel = new JButton(Messages.getString("DistinctTypesDialogDB2.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        bottomPanel.add(bnCancel);
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jpanel.add((Component)bottomPanel, "South");
        this.getContentPane().add(jpanel);
        this.pack();
        this.setSize(new Dimension(434, 270));
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    public String getCaption() {
        return Messages.getString("DistinctTypesDialogDB2.DistinctTypes");
    }

    protected void initGeneralView() {
        this.initAllDomainsList();
        this.initDistinctTypesList();
        this.initButtons();
    }

    private void initAllDomainsList() {
        JLabel label = new JLabel(Messages.getString("DistinctTypesDialogDB2.Domains"));
        this.general.add(label);
        this.allDomainsModel = new DefaultListModel();
        this.allDomainsList = new JList(this.allDomainsModel);
        ListSelectionModel listSelectionModel = this.allDomainsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allDomainsList);
        sp.setPreferredSize(new Dimension(144, 180));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(sp);
        CommonUtil.setLabelConstraints(this.getGeneralLayout(), label, 12, 4);
        CommonUtil.setObjectConstraints(this.getGeneralLayout(), sp, 10, 22);
    }

    private void initDistinctTypesList() {
        JLabel label = new JLabel(Messages.getString("DistinctTypesDialogDB2.DistinctTypes1"));
        this.general.add(label);
        this.selectedDomainsModel = new DefaultListModel();
        this.selectedDomainsList = new JList(this.selectedDomainsModel);
        ListSelectionModel listSelectionModel = this.selectedDomainsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedDomainsList);
        sp.setPreferredSize(new Dimension(145, 180));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(sp);
        CommonUtil.setLabelConstraints(this.getGeneralLayout(), label, 274, 4);
        CommonUtil.setObjectConstraints(this.getGeneralLayout(), sp, 272, 22);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("DistinctTypesDialogDB2.Add"));
        this.bnAdd.addActionListener(new AddDomainsActionListener());
        this.bnAdd.setEnabled(false);
        this.bnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.general.add(this.bnAdd);
        CommonUtil.setObjectConstraints(this.getGeneralLayout(), this.bnAdd, 162, 85);
        this.bnRemove = new JButton(Messages.getString("DistinctTypesDialogDB2.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveDomainsActionListener());
        this.bnRemove.setPreferredSize(this.bnAdd.getPreferredSize());
        this.general.add(this.bnRemove);
        CommonUtil.setObjectConstraints(this.getGeneralLayout(), this.bnRemove, 162, 115);
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    public void initProperties() {
        Iterator domains = this.storageDesign.getDesign().getDomainSet().iterator();
        DistinctTypeSetDB2 types = this.storageDesign.getDistinctTypeSet();
        while (domains.hasNext()) {
            Domain dom = (Domain)domains.next();
            if (types.getDistinctType(dom) != null) {
                this.selectedDomainsModel.addElement(dom);
                continue;
            }
            if ("Unknown".equalsIgnoreCase(dom.getName())) continue;
            this.allDomainsModel.addElement(dom);
        }
    }

    protected void setProperties() {
        Object[] selectedDomains = this.selectedDomainsModel.toArray();
        this.storageDesign.getDistinctTypeSet().removeAll();
        DistinctTypeDB2 type = null;
        for (int i = 0; i < selectedDomains.length; ++i) {
            Domain dom = (Domain)selectedDomains[i];
            type = this.storageDesign.getDistinctTypeSet().createDistinctType();
            type.setName(dom.getName());
            type.setDomain(dom.getName());
            type.setImplementedDomain(dom);
            type.setDirty(true);
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DistinctTypesDialogDB2.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DistinctTypesDialogDB2.this.setProperties();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DistinctTypesDialogDB2.this.setProperties();
            DistinctTypesDialogDB2.this.dispose();
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (DistinctTypesDialogDB2.this.selectedDomainsList.getSelectedIndex() == -1) {
                    DistinctTypesDialogDB2.this.bnRemove.setEnabled(false);
                } else {
                    DistinctTypesDialogDB2.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (DistinctTypesDialogDB2.this.allDomainsList.getSelectedIndex() == -1) {
                    DistinctTypesDialogDB2.this.bnAdd.setEnabled(false);
                } else {
                    DistinctTypesDialogDB2.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveDomainsActionListener
    implements ActionListener {
        private RemoveDomainsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DistinctTypesDialogDB2.this.selectedDomainsModel.isEmpty()) {
                Object[] selectedObjects = DistinctTypesDialogDB2.this.selectedDomainsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (DistinctTypesDialogDB2.this.allDomainsModel.contains(ob)) continue;
                    DistinctTypesDialogDB2.this.allDomainsModel.addElement(ob);
                    DistinctTypesDialogDB2.this.selectedDomainsModel.removeElement(ob);
                }
            }
        }
    }

    private class AddDomainsActionListener
    implements ActionListener {
        private AddDomainsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DistinctTypesDialogDB2.this.allDomainsModel.isEmpty()) {
                Object[] selectedObjects = DistinctTypesDialogDB2.this.allDomainsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (DistinctTypesDialogDB2.this.selectedDomainsModel.contains(ob)) continue;
                    DistinctTypesDialogDB2.this.selectedDomainsModel.addElement(ob);
                    DistinctTypesDialogDB2.this.allDomainsModel.removeElement(ob);
                }
            }
        }
    }
}

