/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.storage.usertype;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.storage.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserDefinedTypesDialogSqlServer
extends JPanel {
    private static final String EMPTY_VALUE = "";
    protected static final int FIELD_WIDTH = 15;
    private static final int DEFAULT_COMBO_MAX_ROW_COUNT = 8;
    private ApplicationView view;
    private StorageDesignSqlServer storageDesign;
    private JDialog dialog;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnApply;
    private JButton btnOK;
    private JButton btnCancel;
    private JPanel general;
    private JPanel addPanel;
    private JPanel listPanel;
    private JPanel propPanel;
    private JPanel buttonPanel;
    private DefaultListModel allTypesModel;
    private JList allTypesList;
    private JPanel typesButtonsPanel;
    private JTextField tfName;
    private JComboBox cbDomain;
    private JComboBox cbNullType;
    private JComboBox cbOwner;

    public UserDefinedTypesDialogSqlServer(ApplicationView view, StorageDesignSqlServer storageDesign) {
        this.view = view;
        this.storageDesign = storageDesign;
        this.storageDesign.setDtDialogVisible(true);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.view.getFrame(), Messages.getString("UserDefinedTypesDialogSqlServer.UserDefinedTypes"));
            this.dialog.setDefaultCloseOperation(2);
            this.general = new JPanel();
            this.general.setLayout(new BorderLayout());
            this.dialog.getContentPane().add(this.general);
            this.addPanel = new JPanel(new BorderLayout());
            this.addPanel.setPreferredSize(new Dimension(180, 200));
            this.addPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserDefinedTypesDialogSqlServer.ChooseUserDefinedType")));
            this.propPanel = new JPanel(new SpringLayout());
            this.propPanel.setPreferredSize(new Dimension(280, 200));
            this.propPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserDefinedTypesDialogSqlServer.UserDefinedTypeProperties")));
            this.initAddPanel();
            this.initPropPanel();
            this.buttonPanel = this.getButtonPanel();
            this.general.add((Component)this.addPanel, "West");
            this.general.add((Component)this.propPanel, "Center");
            this.general.add((Component)this.buttonPanel, "South");
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    UserDefinedTypesDialogSqlServer.this.close(UserDefinedTypesDialogSqlServer.this.dialog);
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    UserDefinedTypesDialogSqlServer.this.storageDesign.setDtDialogVisible(false);
                }
            });
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        CommonUtil.centerOnScreen(this.dialog);
        this.dialog.setVisible(true);
    }

    private void initAddPanel() {
        this.initAddSubPanels();
        this.initTypesPanel();
        this.initTypesButtons();
    }

    private void initAddSubPanels() {
        this.typesButtonsPanel = new JPanel();
        this.typesButtonsPanel.setAlignmentX(0.5f);
        this.listPanel = new JPanel(new BorderLayout());
        this.listPanel.setAlignmentX(0.5f);
        this.addPanel.add((Component)this.typesButtonsPanel, "South");
        this.addPanel.add(this.listPanel);
    }

    private void initTypesPanel() {
        this.allTypesModel = new DefaultListModel();
        this.allTypesList = new JList(this.allTypesModel);
        Iterator typeSet = this.storageDesign.getUserDefinedTypeSet().iterator();
        while (typeSet.hasNext()) {
            UserDefinedTypeSqlServer t = (UserDefinedTypeSqlServer)typeSet.next();
            this.allTypesModel.addElement(t);
        }
        this.allTypesList.setSelectionMode(0);
        this.allTypesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserDefinedTypesDialogSqlServer.this.allTypesList.getSelectedValue() != null) {
                    UserDefinedTypesDialogSqlServer.this.clear();
                    UserDefinedTypeSqlServer selectedType = (UserDefinedTypeSqlServer)UserDefinedTypesDialogSqlServer.this.allTypesList.getSelectedValue();
                    UserDefinedTypesDialogSqlServer.this.tfName.setText(selectedType.getName());
                    UserDefinedTypesDialogSqlServer.this.cbDomain.setSelectedItem(selectedType.getDomainObj());
                    UserDefinedTypesDialogSqlServer.this.cbNullType.setSelectedItem(selectedType.getNullType());
                    UserDefinedTypesDialogSqlServer.this.cbOwner.setSelectedItem(selectedType.getOwner());
                    UserDefinedTypesDialogSqlServer.this.enableCombos(true);
                    UserDefinedTypesDialogSqlServer.this.btnRemove.setEnabled(true);
                } else {
                    UserDefinedTypesDialogSqlServer.this.enableCombos(false);
                    UserDefinedTypesDialogSqlServer.this.btnRemove.setEnabled(false);
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.allTypesList);
        this.listPanel.add(sp);
    }

    protected void initTypesButtons() {
        this.btnAdd = new JButton(Messages.getString("UserDefinedTypesDialogSqlServer.Add"));
        this.btnAdd.setPreferredSize(new Dimension(80, 25));
        this.btnAdd.setMnemonic(65);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String id = UserDefinedTypesDialogSqlServer.this.storageDesign.getAppView().getIDGenerator().createNewID();
                while (UserDefinedTypesDialogSqlServer.this.storageDesign.getUserDefinedTypeSet().containsId(id)) {
                    id = UserDefinedTypesDialogSqlServer.this.storageDesign.getAppView().getIDGenerator().createNewID();
                }
                UserDefinedTypeSqlServer type = UserDefinedTypesDialogSqlServer.this.storageDesign.getUserDefinedTypeSet().createType();
                type.setName(id);
                type.setDomain("BigNumber");
                UserDefinedTypesDialogSqlServer.this.allTypesModel.addElement(type);
                UserDefinedTypesDialogSqlServer.this.allTypesList.setSelectedValue(type, true);
                UserDefinedTypesDialogSqlServer.this.enableCombos(true);
            }
        });
        this.typesButtonsPanel.add(this.btnAdd);
        this.btnRemove = new JButton(Messages.getString("UserDefinedTypesDialogSqlServer.Remove"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserDefinedTypeSqlServer type = (UserDefinedTypeSqlServer)UserDefinedTypesDialogSqlServer.this.allTypesList.getSelectedValue();
                if (type != null) {
                    UserDefinedTypesDialogSqlServer.this.allTypesModel.removeElement(type);
                }
                UserDefinedTypesDialogSqlServer.this.clear();
                UserDefinedTypesDialogSqlServer.this.enableCombos(false);
            }
        });
        this.btnRemove.setMnemonic(82);
        this.btnRemove.setEnabled(false);
        this.btnRemove.setPreferredSize(this.btnAdd.getPreferredSize());
        this.typesButtonsPanel.add(this.btnRemove);
    }

    private void initPropPanel() {
        this.initName();
        this.initDomain();
        this.initNullType();
        this.initOwner();
        this.fillCombos();
        this.enableCombos(false);
    }

    private void initName() {
        JLabel lbName = new JLabel(Messages.getString("UserDefinedTypesDialogSqlServer.Name"));
        this.propPanel.add(lbName);
        this.tfName = new JTextField(EMPTY_VALUE, 15);
        this.propPanel.add(this.tfName);
        this.setLabelConstraints((SpringLayout)this.propPanel.getLayout(), lbName, 10);
        this.setObjectConstraints((SpringLayout)this.propPanel.getLayout(), this.tfName, 10);
    }

    private void initDomain() {
        JLabel domainLabel = new JLabel(Messages.getString("UserDefinedTypesDialogSqlServer.Domain"));
        domainLabel.setPreferredSize(this.tfName.getPreferredSize());
        this.propPanel.add(domainLabel);
        this.cbDomain = new JComboBox();
        this.cbDomain.setPreferredSize(this.tfName.getPreferredSize());
        this.propPanel.add(this.cbDomain);
        this.setBG(this.cbDomain);
        this.cbDomain.setPreferredSize(this.tfName.getPreferredSize());
        this.cbDomain.setMaximumRowCount(8);
        this.setLabelConstraints((SpringLayout)this.propPanel.getLayout(), domainLabel, 50);
        this.setObjectConstraints((SpringLayout)this.propPanel.getLayout(), this.cbDomain, 50);
    }

    private void initNullType() {
        JLabel nullLabel = new JLabel(Messages.getString("UserDefinedTypesDialogSqlServer.NullType"));
        nullLabel.setPreferredSize(this.tfName.getPreferredSize());
        this.propPanel.add(nullLabel);
        this.cbNullType = new JComboBox();
        this.cbNullType.setPreferredSize(this.tfName.getPreferredSize());
        this.propPanel.add(this.cbNullType);
        this.setBG(this.cbNullType);
        this.cbNullType.setPreferredSize(this.tfName.getPreferredSize());
        this.cbNullType.setMaximumRowCount(8);
        this.setLabelConstraints((SpringLayout)this.propPanel.getLayout(), nullLabel, 90);
        this.setObjectConstraints((SpringLayout)this.propPanel.getLayout(), this.cbNullType, 90);
    }

    private void initOwner() {
        JLabel ownerLabel = new JLabel(Messages.getString("UserDefinedTypesDialogSqlServer.Owner"));
        ownerLabel.setPreferredSize(this.tfName.getPreferredSize());
        this.propPanel.add(ownerLabel);
        this.cbOwner = new JComboBox();
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.propPanel.add(this.cbOwner);
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.cbOwner.setMaximumRowCount(8);
        this.setLabelConstraints((SpringLayout)this.propPanel.getLayout(), ownerLabel, 130);
        this.setObjectConstraints((SpringLayout)this.propPanel.getLayout(), this.cbOwner, 130);
    }

    protected void setProperties() {
        UserDefinedTypeSqlServer type = (UserDefinedTypeSqlServer)this.allTypesList.getSelectedValue();
        this.allTypesModel.removeElement(type);
        if (type != null) {
            type.setName(this.tfName.getText());
            type.setDomain((String)this.cbDomain.getSelectedItem());
            type.setNullType((String)this.cbNullType.getSelectedItem());
            type.setOwner((UserSqlServer)this.cbOwner.getSelectedItem());
            type.setDirty(true);
        }
        this.allTypesModel.addElement(type);
        this.storageDesign.getUserDefinedTypeSet().removeAll();
        Object[] types = this.allTypesModel.toArray();
        for (int i = 0; i < types.length; ++i) {
            UserDefinedTypeSqlServer ob = (UserDefinedTypeSqlServer)types[i];
            if (ob == null) continue;
            this.storageDesign.getUserDefinedTypeSet().add(ob);
        }
        this.refreshTypesList();
        this.clear();
        this.enableCombos(false);
    }

    protected void enableCombos(boolean b) {
        this.tfName.setEnabled(b);
        this.cbDomain.setEnabled(b);
        this.cbNullType.setEnabled(b);
        this.cbOwner.setEnabled(b);
    }

    protected void fillCombos() {
        Iterator it = this.storageDesign.getDesign().getDomainSet().iterator();
        while (it.hasNext()) {
            Domain domain = (Domain)it.next();
            if ("Unknown".equalsIgnoreCase(domain.getName())) continue;
            this.cbDomain.addItem(domain.getName());
        }
        for (int i = 0; i < UserDefinedTypeSqlServer.NULL_STATES.length; ++i) {
            this.cbNullType.addItem(UserDefinedTypeSqlServer.NULL_STATES[i]);
        }
        it = this.storageDesign.getUserSet().iterator();
        while (it.hasNext()) {
            this.cbOwner.addItem(it.next());
        }
    }

    protected void refreshTypesList() {
        this.allTypesModel.clear();
        Iterator it = this.storageDesign.getUserDefinedTypeSet().iterator();
        while (it.hasNext()) {
            this.allTypesModel.addElement(it.next());
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.btnOK = new JButton(Messages.getString("UserDefinedTypesDialogSqlServer.OK"));
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserDefinedTypesDialogSqlServer.this.setProperties();
                    UserDefinedTypesDialogSqlServer.this.close(UserDefinedTypesDialogSqlServer.this.dialog);
                }
            });
            this.btnApply = new JButton(Messages.getString("UserDefinedTypesDialogSqlServer.Apply"));
            this.btnApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserDefinedTypesDialogSqlServer.this.setProperties();
                }
            });
            this.btnApply.setPreferredSize(new Dimension(80, 25));
            this.btnApply.setMnemonic(80);
            this.btnOK.setPreferredSize(new Dimension(80, 25));
            this.btnOK.setCursor(Cursor.getPredefinedCursor(12));
            this.btnOK.setMnemonic(83);
            this.btnCancel = new JButton(Messages.getString("UserDefinedTypesDialogSqlServer.Cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserDefinedTypesDialogSqlServer.this.close(UserDefinedTypesDialogSqlServer.this.dialog);
                }
            });
            this.btnCancel.setPreferredSize(this.btnOK.getPreferredSize());
            this.btnCancel.setMnemonic(67);
            this.btnCancel.setCursor(Cursor.getPredefinedCursor(12));
            this.buttonPanel.add(this.btnOK);
            this.buttonPanel.add(this.btnApply);
            this.buttonPanel.add(this.btnCancel);
        }
        return this.buttonPanel;
    }

    protected SpringLayout getPanelLayout(JPanel panel) {
        return (SpringLayout)panel.getLayout();
    }

    public void setBG(Component c) {
        c.setBackground(Color.WHITE);
        if (!c.getFont().isPlain()) {
            c.setFont(new Font(c.getFont().getName(), 0, c.getFont().getSize()));
        }
    }

    public void close(JDialog dialog) {
        dialog.dispose();
    }

    private void clear() {
        this.tfName.setText(EMPTY_VALUE);
    }

    protected void setLabelConstraints(SpringLayout layout, JLabel label, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(label);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(SpringLayout layout, Component c, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(c);
        labelCons.setX(Spring.constant(80));
        labelCons.setY(Spring.constant(y));
    }
}

