/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.transformations;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.transformations.ApplyCustomTransformation;
import oracle.dbtools.crest.swingui.transformations.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class CustomTransformationsScriptsDialog
extends CustomDialog {
    private static final long serialVersionUID = 8085236653946186628L;
    private static final Logger LOGGER = new Logger(CustomTransformationsScriptsDialog.class);
    private JDialog dialog;
    private JPanel mainPanel;
    public JButton bnClose;
    public JButton bnApply;
    private DefaultListModel availableTransformationScriptsModel;
    private JList availableTransformationScriptsList;
    private JScrollPane availableTransformationScriptsSP;
    private DefaultListModel selectedTransformationScriptsModel;
    private JList selectedTransformationScriptsList;
    private JScrollPane selectedTransformationScriptsSP;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnMoveUp;
    private JButton btnMoveDown;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private ApplicationView appView;
    private String type;
    private DesignPart dp;

    public CustomTransformationsScriptsDialog(ApplicationView appView, DesignPart dp, String type) {
        super(appView);
        this.appView = appView;
        this.type = type;
        this.dp = dp;
        this.init();
    }

    private void init() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel northPanel = new JPanel(new BorderLayout());
        JPanel allScriptspanel = new JPanel(new BorderLayout());
        JPanel jpB = new JPanel(new GridLayout(14, 1));
        this.availableTransformationScriptsModel = new DefaultListModel();
        this.availableTransformationScriptsList = new JList(this.availableTransformationScriptsModel);
        for (DRCustomScript cs : this.appView.getCustomDesignRules()) {
            if (!cs.getPurpose().equals("transformation") || !cs.getObject().equals(this.type)) continue;
            this.availableTransformationScriptsModel.addElement(cs.getName());
        }
        this.availableTransformationScriptsSP = new JScrollPane(this.availableTransformationScriptsList);
        this.availableTransformationScriptsSP.setPreferredSize(new Dimension(270, 500));
        this.availableTransformationScriptsSP.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomTransformationsScriptsDialog.AvailableScripts")));
        this.availableTransformationScriptsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (CustomTransformationsScriptsDialog.this.availableTransformationScriptsList.getSelectedIndex() == -1) {
                    CustomTransformationsScriptsDialog.this.btnAdd.setEnabled(false);
                } else {
                    CustomTransformationsScriptsDialog.this.btnAdd.setEnabled(true);
                }
            }
        });
        JPanel selected = new JPanel(new BorderLayout());
        selected.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomTransformationsScriptsDialog.SelectedScripts")));
        selected.add((Component)this.createCustomTransformationsToolbarPanel(), "North");
        this.selectedTransformationScriptsModel = new DefaultListModel();
        this.selectedTransformationScriptsList = new JList(this.selectedTransformationScriptsModel);
        this.selectedTransformationScriptsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.getSelectedIndex() == -1) {
                    CustomTransformationsScriptsDialog.this.btnRemove.setEnabled(false);
                    CustomTransformationsScriptsDialog.this.btnMoveDown.setEnabled(false);
                    CustomTransformationsScriptsDialog.this.btnMoveUp.setEnabled(false);
                } else {
                    CustomTransformationsScriptsDialog.this.btnRemove.setEnabled(true);
                    if (CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.size() > 1) {
                        CustomTransformationsScriptsDialog.this.btnMoveDown.setEnabled(true);
                        CustomTransformationsScriptsDialog.this.btnMoveUp.setEnabled(true);
                    }
                }
            }
        });
        this.selectedTransformationScriptsSP = new JScrollPane(this.selectedTransformationScriptsList);
        this.selectedTransformationScriptsSP.setPreferredSize(new Dimension(270, 500));
        selected.add((Component)this.selectedTransformationScriptsSP, "South");
        this.btnAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.btnAdd.addActionListener(new AddActionListener());
        this.btnAdd.setEnabled(false);
        this.btnAdd.setToolTipText(Messages.getString("CustomTransformationsScriptsDialog.Add"));
        this.btnAdd.setPreferredSize(new Dimension(32, 32));
        this.btnRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.btnRemove.addActionListener(new RemoveActionListener());
        this.btnRemove.setEnabled(false);
        this.btnRemove.setToolTipText(Messages.getString("CustomTransformationsScriptsDialog.Remove"));
        this.btnRemove.setPreferredSize(new Dimension(32, 32));
        jpB.add(new JPanel());
        jpB.add(new JPanel());
        jpB.add(new JPanel());
        jpB.add(new JPanel());
        jpB.add(new JPanel());
        jpB.add(new JPanel());
        jpB.add(this.btnAdd);
        jpB.add(this.btnRemove);
        jpB.add(new JPanel());
        jpB.add(new JPanel());
        jpB.add(new JPanel());
        jpB.add(new JPanel());
        jpB.add(new JPanel());
        jpB.add(new JPanel());
        allScriptspanel.add((Component)this.availableTransformationScriptsSP, "West");
        allScriptspanel.add((Component)jpB, "East");
        northPanel.add((Component)allScriptspanel, "West");
        northPanel.add((Component)selected, "East");
        this.mainPanel.add((Component)northPanel, "North");
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        this.bnApply = new JButton(Messages.getString("CustomTransformationsScriptsDialog.Apply"));
        this.bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnApply.addActionListener(new ApplyAction());
        this.bnApply.setEnabled(false);
        btnPanel.add(this.bnApply);
        this.bnClose = new JButton(this.closeAction());
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.setMnemonic(67);
        btnPanel.add(this.bnClose);
        this.mainPanel.add((Component)btnPanel, "South");
    }

    protected JPanel createCustomTransformationsToolbarPanel() {
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        this.btnMoveUp = new JButton(this.configuration.getIcon("MOVE_UP_ICON", 16));
        this.btnMoveUp.setEnabled(false);
        this.btnMoveUp.setToolTipText(Messages.getString("CustomTransformationsScriptsDialog.MoveUp"));
        this.btnMoveUp.addActionListener(new MoveUpAction());
        this.btnMoveDown = new JButton(this.configuration.getIcon("MOVE_DOWN_ICON", 16));
        this.btnMoveDown.setEnabled(false);
        this.btnMoveDown.setToolTipText(Messages.getString("CustomTransformationsScriptsDialog.MoveDown"));
        this.btnMoveDown.addActionListener(new MoveDownAction());
        toolBar.add(this.btnMoveUp);
        toolBar.add(this.btnMoveDown);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(270, 35));
        buttonGeneral.add(toolBar);
        return buttonGeneral;
    }

    public Action closeAction() {
        AbstractAction action = new AbstractAction(Messages.getString("CustomTransformationsScriptsDialog.Close")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomTransformationsScriptsDialog.this.canClose()) {
                    CustomTransformationsScriptsDialog.this.close();
                }
            }
        };
        return action;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("CustomTransformationsScriptsDialog.CustomTransformationScripts"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.setSize(600, 630);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.getContentPane().add(this.mainPanel);
            CommonUtil.centerOnScreen(this.dialog);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "DESIGN_RULES_DIALOG";
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    public DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                if (list.get(i).toString().compareTo(list.get(i - 1).toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private boolean engineExist(DRCustomScript cs) {
        for (String engineName : this.appView.getScriptEngines()) {
            if (!engineName.equals(cs.getEngineName())) continue;
            return true;
        }
        return false;
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<DRCustomScript> selectedScripts = new ArrayList<DRCustomScript>();
            int size = CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.getModel().getSize();
            block2: for (int i = 0; i < size; ++i) {
                String name = (String)CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.getModel().getElementAt(i);
                for (DRCustomScript cs : CustomTransformationsScriptsDialog.this.appView.getCustomDesignRules()) {
                    if (!cs.getName().equals(name)) continue;
                    selectedScripts.add(cs);
                    continue block2;
                }
            }
            boolean go = true;
            for (DRCustomScript cs : selectedScripts) {
                if (CustomTransformationsScriptsDialog.this.engineExist(cs)) continue;
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("CustomTransformationsScriptsDialog.CannotApply"), cs.getName()), Messages.getString("CustomTransformationsScriptsDialog.CustomTransformationScripts"), 0);
                go = false;
                break;
            }
            if (go) {
                try {
                    ApplyCustomTransformation act = new ApplyCustomTransformation(CustomTransformationsScriptsDialog.this.type, CustomTransformationsScriptsDialog.this.dp, selectedScripts);
                    boolean hasErr = act.runTransformation();
                    if (!hasErr) {
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CustomTransformationsScriptsDialog.Finished"), Messages.getString("CustomTransformationsScriptsDialog.CustomTransformationScripts"), 1);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Error during execution of custom transformation script : ", ex);
                }
            }
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.getSelectedIndices();
            if (selected.length > 0) {
                for (int i = selected.length - 1; i >= 0; --i) {
                    int pos = selected[i];
                    if (pos >= CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.getSize() - 1) continue;
                    Object obj = CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.getElementAt(pos);
                    CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.remove(pos);
                    CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.add(pos + 1, obj);
                    selected[i] = pos + 1;
                }
                CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.updateUI();
                CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.setSelectedIndices(selected);
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.getSelectedIndices();
            if (selected.length > 0) {
                for (int i = 0; i < selected.length; ++i) {
                    int pos = selected[i];
                    if (pos <= 0) continue;
                    Object obj = CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.getElementAt(pos);
                    CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.remove(pos);
                    CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.add(pos - 1, obj);
                    selected[i] = pos - 1;
                }
                CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.updateUI();
                CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.setSelectedIndices(selected);
            }
        }
    }

    private class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                String cs = (String)selected[i];
                if (CustomTransformationsScriptsDialog.this.availableTransformationScriptsModel.contains(cs)) continue;
                CustomTransformationsScriptsDialog.this.availableTransformationScriptsModel.addElement(cs);
                CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.removeElement(selected[i]);
            }
            CustomTransformationsScriptsDialog.this.sort(CustomTransformationsScriptsDialog.this.availableTransformationScriptsModel);
            CustomTransformationsScriptsDialog.this.bnApply.setEnabled(CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.size() > 0);
        }
    }

    private class AddActionListener
    implements ActionListener {
        private AddActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = CustomTransformationsScriptsDialog.this.availableTransformationScriptsList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                String cs = (String)selected[i];
                if (CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.contains(cs)) continue;
                CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.addElement(cs);
                CustomTransformationsScriptsDialog.this.availableTransformationScriptsModel.removeElement(selected[i]);
            }
            CustomTransformationsScriptsDialog.this.sort(CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel);
            CustomTransformationsScriptsDialog.this.bnApply.setEnabled(true);
        }
    }
}

