/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.cwddesigner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.exceptions.EmptyFieldException;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class CWDOptionDialog
extends JDialog {
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    public static final int NOT_IMPORT = 0;
    public static final int USE_DESIGN_NAME = 1;
    public static final int USE_CUSTOM = 2;
    private static int action = 1;
    private int result = 0;
    private JPanel generalPanel;
    private JTextField tfCustomPrefix;
    private AbstractButton radioNotImport;
    private JRadioButton radioUseDesign;
    private JRadioButton radioPrefix;
    private String customPrefix;
    private List modelArray = new ArrayList();
    private ButtonGroup searchGroup;
    private ApplicationView view;

    public CWDOptionDialog(ApplicationView view) {
        super(view.getFrame());
        this.setTitle(Messages.getString("CWDOptionDialog.OptionDialog"));
        this.setDefaultCloseOperation(2);
        this.view = view;
        this.getContentPane().add((Component)this.initMainPanel(), "Center");
        this.getContentPane().add((Component)this.initBottomPanel(), "South");
        this.disablePrefix();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
        this.setModal(true);
    }

    private void disablePrefix() {
        this.tfCustomPrefix.setEnabled(false);
    }

    private void enablePrefix() {
        this.tfCustomPrefix.setEnabled(true);
    }

    private JPanel initMainPanel() {
        this.generalPanel = new JPanel();
        this.generalPanel.setLayout(new SpringLayout());
        this.generalPanel.setPreferredSize(new Dimension(300, 150));
        JLabel label = new JLabel(Messages.getString("CWDOptionDialog.ChooseActionDuplicateName"));
        this.generalPanel.add(label);
        this.radioNotImport = new JRadioButton(Messages.getString("CWDOptionDialog.DoNotImportObjects"));
        this.radioNotImport.setSelected(true);
        this.radioNotImport.addActionListener(new PrefixListener());
        this.modelArray.add(this.radioNotImport.getModel());
        this.radioUseDesign = new JRadioButton(Messages.getString("CWDOptionDialog.UseDesignNameForPrefix"));
        this.radioUseDesign.addActionListener(new PrefixListener());
        this.modelArray.add(this.radioUseDesign.getModel());
        this.radioPrefix = new JRadioButton(Messages.getString("CWDOptionDialog.UseCustomPrefix"));
        this.radioPrefix.addActionListener(new PrefixListener());
        this.modelArray.add(this.radioPrefix.getModel());
        SpringLayout.Constraints labelCons = ((SpringLayout)this.generalPanel.getLayout()).getConstraints(label);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(10));
        this.generalPanel.add(this.radioNotImport);
        labelCons = ((SpringLayout)this.generalPanel.getLayout()).getConstraints(this.radioNotImport);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(45));
        this.generalPanel.add(this.radioUseDesign);
        labelCons = ((SpringLayout)this.generalPanel.getLayout()).getConstraints(this.radioUseDesign);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(65));
        this.generalPanel.add(this.radioPrefix);
        labelCons = ((SpringLayout)this.generalPanel.getLayout()).getConstraints(this.radioPrefix);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(85));
        this.searchGroup = new ButtonGroup();
        this.searchGroup.add(this.radioNotImport);
        this.searchGroup.add(this.radioUseDesign);
        this.searchGroup.add(this.radioPrefix);
        JLabel lbCustomPrefix = new JLabel(Messages.getString("CWDOptionDialog.Prefix"));
        lbCustomPrefix.setPreferredSize(new Dimension(80, 20));
        this.generalPanel.add(lbCustomPrefix);
        labelCons = ((SpringLayout)this.generalPanel.getLayout()).getConstraints(lbCustomPrefix);
        labelCons.setX(Spring.constant(40));
        labelCons.setY(Spring.constant(115));
        this.tfCustomPrefix = new JTextField();
        this.tfCustomPrefix.setPreferredSize(new Dimension(150, 20));
        this.generalPanel.add(this.tfCustomPrefix);
        labelCons = ((SpringLayout)this.generalPanel.getLayout()).getConstraints(this.tfCustomPrefix);
        labelCons.setX(Spring.constant(90));
        labelCons.setY(Spring.constant(115));
        return this.generalPanel;
    }

    protected JPanel newRow(JLabel lbName, Component field) {
        JPanel newRow = new JPanel();
        newRow.add(lbName);
        newRow.add(field);
        return newRow;
    }

    protected JPanel initBottomPanel() {
        JPanel jpanel = new JPanel();
        JButton bnOK = new JButton(Messages.getString("CWDOptionDialog.OK"));
        bnOK.setMnemonic(79);
        bnOK.addActionListener(new OKAction());
        JButton bnCancel = new JButton(Messages.getString("CWDOptionDialog.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        Dimension dim = new Dimension(80, 25);
        bnOK.setPreferredSize(dim);
        bnCancel.setPreferredSize(dim);
        jpanel.add(bnOK);
        jpanel.add(bnCancel);
        return jpanel;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }

    public void initProperties(String customPrefix) {
        this.customPrefix = customPrefix;
        this.searchGroup.setSelected((ButtonModel)this.modelArray.get(this.view.getSettings().getRenameStrategy()), true);
        this.tfCustomPrefix.setText(customPrefix);
        this.tfCustomPrefix.setEnabled(this.radioPrefix.isSelected());
    }

    private void saveProperties() throws EmptyFieldException {
        if (this.radioPrefix.isSelected()) {
            if (!this.isEmpty(this.tfCustomPrefix.getText())) {
                this.customPrefix = this.tfCustomPrefix.getText();
                action = 2;
            }
            this.view.getSettings().setRenameStrategy(this.modelArray.indexOf(this.radioPrefix.getModel()));
        } else if (this.radioUseDesign.isSelected()) {
            action = 1;
            this.view.getSettings().setRenameStrategy(this.modelArray.indexOf(this.radioUseDesign.getModel()));
        } else if (this.radioNotImport.isSelected()) {
            action = 0;
            this.view.getSettings().setRenameStrategy(this.modelArray.indexOf(this.radioNotImport.getModel()));
        }
    }

    private boolean isEmpty(String string) {
        return "".equalsIgnoreCase(string);
    }

    public static int getAction() {
        return action;
    }

    public String getCustomPrefix() {
        return this.customPrefix;
    }

    public void setCustomPrefix(String customPrefix) {
        this.customPrefix = customPrefix;
    }

    public Design getDesign() {
        return this.view.getCurrentDesign();
    }

    public class PrefixListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (CWDOptionDialog.this.radioPrefix.isSelected()) {
                CWDOptionDialog.this.enablePrefix();
            } else {
                CWDOptionDialog.this.disablePrefix();
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CWDOptionDialog.this.result = 0;
            CWDOptionDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                CWDOptionDialog.this.saveProperties();
                CWDOptionDialog.this.result = 1;
                CWDOptionDialog.this.dispose();
            }
            catch (EmptyFieldException exp) {
                JOptionPane.showMessageDialog(CWDOptionDialog.this, exp.getMessage(), Messages.getString("CWDOptionDialog.Error"), 0);
            }
        }
    }
}

