/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.connection;

import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionDialog;
import oracle.dbtools.raptor.connections.ConnectionPropertiesUpdater;
import oracle.dbtools.raptor.connections.ImportExportPanel;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.migration.CMConnectionsReader;
import oracle.jdevimpl.db.adapter.CMHelper;

public class FCPConnectionDialog {
    private static List<Class<? extends ConnectionPropertiesUpdater>> s_updaters = new CopyOnWriteArrayList<Class<? extends ConnectionPropertiesUpdater>>();
    private static final Logger LOGGER = new Logger(FCPConnectionDialog.class);

    public static ConnectionInfo showConnectionDialog() {
        return FCPConnectionDialog.showConnectionDialog(null, false);
    }

    public static ConnectionInfo showConnectionDialog(boolean oracleOnly) {
        return FCPConnectionDialog.showConnectionDialog(null, oracleOnly);
    }

    public static ConnectionInfo showConnectionDialog(String connName, boolean oracleOnly) {
        if (oracleOnly) {
            DBConfig.getInstance().setThirdPartyPath(new URLPath());
        } else {
            DBConfig.getInstance().setThirdPartyPath(ApplicationView.getInstance().getSettings().getJDBCDriversPath());
        }
        ConnectionInfo ci = ConnectionDialog.launch((DatabaseConnections)DatabaseConnections.getInstance(), (String)connName);
        if (ci != null) {
            try {
                Connection connection = ci.getConnection();
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("FCPConnectionDialog.showConnectionDialog()", e);
            }
        }
        return ci;
    }

    public static void testConnection(Properties cd) {
        FCPConnectionDialog.testConnection(cd, true);
    }

    public static void testConnection(final Properties cd, boolean oracleOnly) {
        try {
            if (cd != null) {
                if (oracleOnly) {
                    DBConfig.getInstance().setThirdPartyPath(new URLPath());
                } else {
                    DBConfig.getInstance().setThirdPartyPath(ApplicationView.getInstance().getSettings().getJDBCDriversPath());
                }
                ConnectRunnable pr = new ConnectRunnable(){

                    protected Object doWork() throws Exception {
                        DatabaseConnections.getInstance().testConnection(cd);
                        return null;
                    }
                };
                pr.setTitle(Messages.getString("FCPConnectionDialog.TestingConnection"));
                pr.start(true);
                if (!pr.isCanceled()) {
                    MessageDialogs.showMessage(ApplicationView.frame, Messages.getString("FCPConnectionDialog.ConnectionSuccessfull"));
                }
            }
        }
        catch (Exception ex) {
            MessageDialogs.showErrorMessage(ApplicationView.frame, ex.getMessage());
        }
    }

    public static boolean importConnections() {
        String title = ConnectionArb.getString((String)"IMPORT_TITLE");
        ImportExportPanel comp = new ImportExportPanel("IdeConnections");
        comp.setMode("IMPORT");
        Component defComp = comp.getDefaultFocus();
        VetoableChangeListener l = null;
        boolean ok = OnePageWizardDialogFactory.runDialog((Component)comp, (Component)defComp, (String)title, (int)7, l);
        if (ok) {
            Object[] vals = comp.getSelectedValues();
            HashSet<String> names = new HashSet<String>();
            for (Object o : vals) {
                names.add((String)o);
            }
            FCPConnectionDialog.doImport(comp.getSelectedURL(), names, comp.oldCM);
        }
        return true;
    }

    public static boolean exportConnections() {
        String title = ConnectionArb.getString((String)"EXPORT_TITLE");
        final ImportExportPanel comp = new ImportExportPanel("IdeConnections");
        comp.setMode("EXPORT");
        Component defComp = comp.getDefaultFocus();
        VetoableChangeListener l = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                if ("closed".equals(pce.getPropertyName()) && Boolean.TRUE.equals(pce.getNewValue())) {
                    URL file = comp.getSelectedURL();
                    if (URLFileSystem.isDirectoryPath((URL)file)) {
                        MessageDialog.error((Component)comp, (Object)ConnectionArb.format((String)"IMPEXP_NEED_FILE_ERROR", (Object[])new Object[]{URLFileSystem.getPlatformPathName((URL)file)}), (String)ConnectionArb.getString((String)"IMPEXP_BAD_FILE_TITLE"), null);
                        throw new PropertyVetoException("no", pce);
                    }
                    if (!ImportExportPanel.XML_FILTER.accept(file)) {
                        MessageDialog.error((Component)comp, (Object)ConnectionArb.format((String)"IMPEXP_BAD_FILE_ERROR", (Object[])new Object[]{URLFileSystem.getPlatformPathName((URL)file)}), (String)ConnectionArb.getString((String)"IMPEXP_BAD_FILE_TITLE"), null);
                        throw new PropertyVetoException("bogus", pce);
                    }
                    if (URLFileSystem.exists((URL)file) && !MessageDialog.confirm((Component)comp, (Object)ConnectionArb.format((String)"IMPEXP_EXISTING_FILE_WARNING", (Object[])new Object[]{URLFileSystem.getPlatformPathName((URL)file)}), (String)ConnectionArb.getString((String)"IMPEXP_EXISTING_FILE_TITLE"), null, (boolean)true)) {
                        throw new PropertyVetoException("no", pce);
                    }
                    OutputStream os = null;
                    try {
                        os = URLFileSystem.openOutputStream((URL)file);
                        os.close();
                    }
                    catch (IOException ex) {
                        String msg = ex.getLocalizedMessage().replace('\n', ' ');
                        MessageDialog.error((Component)comp, (Object)ConnectionArb.format((String)"IMPEXP_ERROR_CREATING_FILE", (Object[])new Object[]{msg}), (String)ConnectionArb.getString((String)"IMPEXP_EXISTING_FILE_TITLE"), null);
                        throw new PropertyVetoException("bogus", pce);
                    }
                }
            }
        };
        boolean ok = OnePageWizardDialogFactory.runDialog((Component)comp, (Component)defComp, (String)title, (int)7, (VetoableChangeListener)l);
        if (ok) {
            Object[] vals = comp.getSelectedValues();
            HashSet<String> names = new HashSet<String>();
            for (Object o : vals) {
                names.add((String)o);
            }
            FCPConnectionDialog.doExport(comp.getSelectedURL(), names);
        }
        return true;
    }

    private static boolean doImport(URL file, Set<String> selNames, boolean oldCMImport) {
        DatabaseConnections connStore = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
        if (selNames.size() > 0) {
            String[] existingNames = null;
            existingNames = connStore == null || connStore.listConnections() == null ? new String[]{} : connStore.listConnections().toArray(new String[connStore.listConnections().size()]);
            try {
                HashMap<String, Properties> conns = new HashMap<String, Properties>();
                if (oldCMImport) {
                    CMConnectionsReader cr = new CMConnectionsReader(file.getFile(), true);
                    List l = cr.read();
                    for (Properties p : l) {
                        String name = p.getProperty("ConnectionName");
                        if (!selNames.contains(name)) continue;
                        conns.put(name, FCPConnectionDialog.convertProps(p));
                    }
                } else {
                    DatabaseConnections importManager = DatabaseConnections.getPrivateInstance((URL)file);
                    for (String name : importManager.listConnections()) {
                        if (!selNames.contains(name)) continue;
                        conns.put(name, importManager.getProperties(name));
                    }
                }
                for (String name : selNames) {
                    Properties props = (Properties)conns.get(name);
                    if (props == null) continue;
                    boolean okToAdd = true;
                    boolean isPreExisting = FCPConnectionDialog._isStringInArray(name, existingNames);
                    if (isPreExisting) {
                        int answer = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), ConnectionArb.format((String)"CONFIRM_REPLACE_CTN", (Object[])new Object[]{name}), ConnectionArb.getString((String)"IMPEXP_IMPORT_WARNING_TITLE"), 0);
                        boolean bl = okToAdd = answer != 1;
                    }
                    if (!okToAdd) continue;
                    if (isPreExisting) {
                        connStore.updateConnection(name, name, props);
                        continue;
                    }
                    connStore.addConnection(name, props);
                }
            }
            catch (Exception ex) {
                ExceptionDialog.showExceptionDialog((Window)null, (Exception)ex, (String)ConnectionArb.getString((String)"IMPEXP_EXPORT_FAILURE"));
            }
        }
        return true;
    }

    public static void registerPropertiesUpdater(Class<? extends ConnectionPropertiesUpdater> updater) {
        s_updaters.add(updater);
    }

    private static List<ConnectionPropertiesUpdater> getUpdaters(String storeID) {
        ArrayList<ConnectionPropertiesUpdater> l = new ArrayList<ConnectionPropertiesUpdater>();
        for (Class<? extends ConnectionPropertiesUpdater> cls : s_updaters) {
            try {
                ConnectionPropertiesUpdater updater = cls.newInstance();
                updater.setConnectionStore(storeID);
                l.add(updater);
            }
            catch (Exception e) {
                LOGGER.warn(e.getLocalizedMessage());
            }
        }
        return l;
    }

    private static boolean doExport(URL file, Set<String> selNames) {
        DatabaseConnections connStore = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
        List<ConnectionPropertiesUpdater> updaters = FCPConnectionDialog.getUpdaters(connStore.getStoreName());
        if (selNames.size() > 0) {
            try {
                File f = new File(file.getFile());
                if (f.exists()) {
                    try {
                        f.delete();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                DatabaseConnections exportManager = DatabaseConnections.getPrivateInstance((URL)file);
                String fileName = URLFileSystem.getPlatformPathName((URL)file);
                for (String connName : connStore.listConnections()) {
                    if (!selNames.contains(connName)) continue;
                    Properties props = connStore.getProperties(connName);
                    for (ConnectionPropertiesUpdater updater : updaters) {
                        updater.processForExport(connName, props);
                    }
                    exportManager.addConnection(connName, props);
                }
                exportManager.saveConnections();
                MessageDialog.information(null, (Object)ConnectionArb.format((String)"IMPEXP_EXPORT_SUCCESS_TEXT", (Object[])new Object[]{fileName}), (String)ConnectionArb.getString((String)"IMPEXP_EXPORT_SUCCESS_TITLE"), null);
            }
            catch (Exception ex) {
                ExceptionDialog.showExceptionDialog((Window)null, (Exception)ex, (String)ConnectionArb.getString((String)"IMPEXP_EXPORT_FAILURE"));
            }
        }
        return true;
    }

    private static Properties convertProps(Properties p) {
        Properties p2 = ((DatabaseProvider)CMHelper.createReferenceFromDescriptor((Properties)p)).getProperties();
        if ("oraJDBC".equals(p2.getProperty("subtype"))) {
            String pwd = p2.getProperty("password");
            String prompt = p2.getProperty("SavePassword");
            if (!ModelUtil.hasLength((String)pwd) && prompt == null) {
                p2.setProperty("SavePassword", Boolean.FALSE.toString());
            }
        }
        return p2;
    }

    private static boolean _isStringInArray(String stringToFind, String[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!stringToFind.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    public static abstract class ConnectRunnable
    extends ProgressRunnable {
        boolean m_canceled;

        protected void doCancel() {
            super.doCancel();
            this.m_canceled = true;
        }

        public boolean isCanceled() {
            return this.m_canceled;
        }
    }
}

