/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.sqlserver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.swingui.wizards.metadata.DBMExtractionWizard;

public class DBMExtractionWizardSqlServer
extends AbstractDBMExtractionWizardImpl {
    private static DBMExtractionWizardSqlServer impl;
    protected JTable tbLogins;
    protected JTable tbUsers;
    protected JTable tbRoles;
    protected JTable tbRules;
    protected JTable tbDefaults;
    protected JTable tbProcedures;
    protected JTable tbDatatypes;
    protected List logins = new ArrayList();
    protected List users = new ArrayList();
    protected List roles = new ArrayList();
    protected List rules = new ArrayList();
    protected List defaults = new ArrayList();
    protected List procedures = new ArrayList();
    protected List datatypes = new ArrayList();
    protected List databases = new ArrayList();

    private DBMExtractionWizardSqlServer(DBMExtractionWizard wizard) {
        super(wizard);
    }

    public static AbstractDBMExtractionWizardImpl getInstance(DBMExtractionWizard wizard) {
        if (impl == null) {
            impl = new DBMExtractionWizardSqlServer(wizard);
        }
        return impl;
    }

    public static void clearInstance() {
        impl = null;
    }

    @Override
    protected void selectAll(JTable table, List<DBObject> objects, boolean selected) {
        for (DBObject object : objects) {
            object.setSelected(selected);
        }
    }

    @Override
    public JPanel getSecondTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.lsSchemas = new ArrayList();
        this.tbSchemas = new SchemaTable();
        this.tbSchemas.setModel(new SchemasModel());
        this.tbSchemas.setAutoCreateRowSorter(true);
        TableColumn column = this.tbSchemas.getColumnModel().getColumn(1);
        column.setPreferredWidth(300);
        JScrollPane sp = new JScrollPane(this.tbSchemas);
        jpanel.add((Component)sp, "Center");
        JPanel pn1 = new JPanel(new FlowLayout(0));
        JButton bnSelectAll = DBMExtractionWizardSqlServer.createSelectAllButton();
        bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBMExtractionWizardSqlServer.this.checkAll(DBMExtractionWizardSqlServer.this.tbSchemas, DBMExtractionWizardSqlServer.this.lsSchemas, true);
            }
        });
        JButton bnDeselectAll = DBMExtractionWizardSqlServer.createDeselectAllButton();
        bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBMExtractionWizardSqlServer.this.checkAll(DBMExtractionWizardSqlServer.this.tbSchemas, DBMExtractionWizardSqlServer.this.lsSchemas, false);
            }
        });
        this.chAllSelected = new JCheckBox(Messages.getString("DBMExtractionWizardSqlServer.AllSelected"));
        this.chAllSelected.setSelected(AbstractDBMExtractionHandler.isAllSelected());
        this.chAllSelected.setToolTipText(Messages.getString("DBMExtractionWizardSqlServer.DefaultSelectionStatus"));
        this.chAllSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDBMExtractionHandler.setAllSelected(DBMExtractionWizardSqlServer.this.chAllSelected.isSelected());
            }
        });
        pn1.add(this.createFilterPanel(this.secondTabFilterText, this.tbSchemas, bnSelectAll, bnDeselectAll));
        pn1.add(this.chAllSelected);
        jpanel.add((Component)pn1, "South");
        return jpanel;
    }

    @Override
    public JPanel getThirdTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)this.getTabbedPane(), "Center");
        this.addTabs();
        JPanel pn1 = new JPanel(new FlowLayout(0));
        JButton bnSelectAll = DBMExtractionWizardSqlServer.createSelectAllButton();
        bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBMExtractionWizardSqlServer.this.checkAll(DBMExtractionWizardSqlServer.this.getCurrentTable(), DBMExtractionWizardSqlServer.this.getCurrentList(), true);
            }
        });
        JButton bnDeselectAll = DBMExtractionWizardSqlServer.createDeselectAllButton();
        bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBMExtractionWizardSqlServer.this.checkAll(DBMExtractionWizardSqlServer.this.getCurrentTable(), DBMExtractionWizardSqlServer.this.getCurrentList(), false);
            }
        });
        pn1.add(this.createFilterPanel(this.thirdTabFilterText, this.tbTables, bnSelectAll, bnDeselectAll));
        jpanel.add((Component)pn1, "South");
        return jpanel;
    }

    @Override
    protected List getCurrentList() {
        int tab = this.getTabbedPane().getSelectedIndex();
        switch (tab) {
            case 0: {
                return this.lsTables;
            }
            case 1: {
                return this.lsViews;
            }
            case 2: {
                return this.logins;
            }
            case 3: {
                return this.users;
            }
            case 4: {
                return this.roles;
            }
            case 5: {
                return this.rules;
            }
            case 6: {
                return this.defaults;
            }
            case 7: {
                return this.procedures;
            }
        }
        return this.datatypes;
    }

    @Override
    protected void addTabs() {
        if (this.tbTables == null) {
            this.tbTables = this.addTab(this.tbTables, this.lsTables, Messages.getString("DBMExtractionWizardSqlServer.Tables"));
            this.tbViews = this.addTab(this.tbViews, this.lsViews, Messages.getString("DBMExtractionWizardSqlServer.Views"));
            this.tbLogins = this.addLoginTab(this.tbLogins, this.logins, Messages.getString("DBMExtractionWizardSqlServer.Logins"));
            this.tbUsers = this.addUserTab(this.tbUsers, this.users, Messages.getString("DBMExtractionWizardSqlServer.Users"));
            this.tbRoles = this.addUserTab(this.tbRoles, this.roles, Messages.getString("DBMExtractionWizardSqlServer.Roles"));
            this.tbRules = this.addTab(this.tbRules, this.rules, Messages.getString("DBMExtractionWizardSqlServer.Rules"));
            this.tbDefaults = this.addTab(this.tbDefaults, this.defaults, Messages.getString("DBMExtractionWizardSqlServer.Defaults"));
            this.tbProcedures = this.addTab(this.tbProcedures, this.procedures, Messages.getString("DBMExtractionWizardSqlServer.Procedures"));
            this.tbDatatypes = this.addTab(this.tbDatatypes, this.datatypes, Messages.getString("DBMExtractionWizardSqlServer.Datatypes"));
        }
    }

    @Override
    protected JTable addTab(JTable table, List list, String name) {
        table = new JTable(new ObjectModel(list));
        table.setAutoCreateRowSorter(true);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(60);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(60);
        column = table.getColumnModel().getColumn(3);
        column.setPreferredWidth(200);
        JScrollPane sp = new JScrollPane(table);
        this.getTabbedPane().addTab(name, sp);
        return table;
    }

    protected JTable addLoginTab(JTable table, List list, String name) {
        table = new JTable(new LoginModel(list));
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(300);
        JScrollPane sp = new JScrollPane(table);
        this.getTabbedPane().addTab(name, sp);
        return table;
    }

    protected JTable addUserTab(JTable table, List list, String name) {
        table = new JTable(new UserModel(list));
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(60);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(250);
        JScrollPane sp = new JScrollPane(table);
        this.getTabbedPane().addTab(name, sp);
        return table;
    }

    @Override
    protected void updateTables() {
        this.tbTables.updateUI();
        this.tbViews.updateUI();
        this.tbLogins.updateUI();
        this.tbUsers.updateUI();
        this.tbRoles.updateUI();
        this.tbRules.updateUI();
        this.tbDefaults.updateUI();
        this.tbProcedures.updateUI();
        this.tbDatatypes.updateUI();
    }

    @Override
    protected void clearAll() {
        this.lsTables.clear();
        this.lsViews.clear();
        this.logins.clear();
        this.users.clear();
        this.roles.clear();
        this.rules.clear();
        this.defaults.clear();
        this.procedures.clear();
        this.datatypes.clear();
    }

    @Override
    protected void initSpecificObjects(List dbObjects) {
        this.clearAll();
        for (DBObject dbo : dbObjects) {
            String type = dbo.getType();
            if (type.equalsIgnoreCase("TABLE")) {
                this.lsTables.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("VIEW")) {
                this.lsViews.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("LOGIN")) {
                this.logins.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("USER")) {
                this.users.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("ROLE")) {
                this.roles.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("RULE")) {
                this.rules.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("DEFAULT")) {
                this.defaults.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("PROCEDURE")) {
                this.procedures.add(dbo);
                continue;
            }
            if (!type.equalsIgnoreCase("DATATYPE")) continue;
            this.datatypes.add(dbo);
        }
    }

    @Override
    public List getSelectedObjects() {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dbo : this.lsSchemas) {
            if (dbo.isSelected() && dbo.getType().equalsIgnoreCase("DATABASE")) {
                DBObjectSqlServer dboSqlServer = new DBObjectSqlServer(dbo.isSelected(), dbo.getName(), dbo.getType());
                list.add(dboSqlServer);
            }
            if (!dbo.isSelected() || !dbo.getType().equalsIgnoreCase("SCHEMA")) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsTables) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsViews) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.logins) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.users) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.roles) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.rules) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.defaults) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.procedures) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.datatypes) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        return list;
    }

    class PlainLabelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        PlainLabelCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(2);
            this.setText(value == null ? "" : "  " + value.toString());
            this.setFont(this.getFont().deriveFont(0));
            return this;
        }
    }

    class BoldLabelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        BoldLabelCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(2);
            this.setText(value == null ? "" : "  " + value.toString());
            this.setFont(this.getFont().deriveFont(1));
            return this;
        }
    }

    class UserModel
    extends AbstractTableModel {
        List list;

        public UserModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DBMExtractionWizardSqlServer.Selected");
            }
            if (column == 1) {
                return Messages.getString("DBMExtractionWizardSqlServer.Database");
            }
            if (column == 2) {
                return Messages.getString("DBMExtractionWizardSqlServer.ObjectName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)this.list.get(row);
            switch (col) {
                case 0: {
                    return dbo.isSelected();
                }
                case 1: {
                    return dbo.getDb();
                }
                case 2: {
                    return dbo.getName();
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                DBObjectSqlServer dbo = (DBObjectSqlServer)this.list.get(rowIndex);
                DBMExtractionWizardSqlServer.this.setSelected(dbo, (Boolean)aValue);
            }
        }
    }

    class LoginModel
    extends AbstractTableModel {
        List list;

        public LoginModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DBMExtractionWizardSqlServer.Selected");
            }
            if (column == 1) {
                return Messages.getString("DBMExtractionWizardSqlServer.LoginName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)this.list.get(row);
            switch (col) {
                case 0: {
                    return dbo.isSelected();
                }
                case 1: {
                    return dbo.getName();
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                DBObjectSqlServer dbo = (DBObjectSqlServer)this.list.get(rowIndex);
                DBMExtractionWizardSqlServer.this.setSelected(dbo, (Boolean)aValue);
            }
        }
    }

    class ObjectModel
    extends AbstractTableModel {
        List list;

        public ObjectModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DBMExtractionWizardSqlServer.Selected");
            }
            if (column == 1) {
                return Messages.getString("DBMExtractionWizardSqlServer.Database");
            }
            if (column == 2) {
                return Messages.getString("DBMExtractionWizardSqlServer.User");
            }
            if (column == 3) {
                return Messages.getString("DBMExtractionWizardSqlServer.ObjectName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)this.list.get(row);
            switch (col) {
                case 0: {
                    return dbo.isSelected();
                }
                case 1: {
                    return dbo.getDb();
                }
                case 2: {
                    return dbo.getSchema();
                }
                case 3: {
                    return dbo.getName();
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                DBObjectSqlServer dbo = (DBObjectSqlServer)this.list.get(rowIndex);
                DBMExtractionWizardSqlServer.this.setSelected(dbo, (Boolean)aValue);
            }
        }
    }

    class SchemasModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return DBMExtractionWizardSqlServer.this.lsSchemas.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DBMExtractionWizardSqlServer.Selected");
            }
            if (column == 1) {
                return Messages.getString("DBMExtractionWizardSqlServer.Name");
            }
            if (column == 2) {
                return Messages.getString("DBMExtractionWizardSqlServer.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DBObject dbo = (DBObject)DBMExtractionWizardSqlServer.this.lsSchemas.get(row);
            switch (col) {
                case 0: {
                    return dbo.isSelected();
                }
                case 1: {
                    return dbo.getName();
                }
                case 2: {
                    return dbo.getType();
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                DBObject dbo = (DBObject)DBMExtractionWizardSqlServer.this.lsSchemas.get(rowIndex);
                DBMExtractionWizardSqlServer.this.setSelected(dbo, (Boolean)aValue);
                boolean selected = (Boolean)aValue;
                if (dbo.getType().equalsIgnoreCase("Database")) {
                    this.setSelectedUsers(selected, (String)this.getValueAt(rowIndex, 1));
                    DBMExtractionWizardSqlServer.this.tbSchemas.repaint();
                } else {
                    DBUserSqlServer dbUser = (DBUserSqlServer)dbo;
                    if (!selected) {
                        this.selectDb(dbUser.getDb(), false);
                        DBMExtractionWizardSqlServer.this.tbSchemas.repaint();
                    } else if (this.allSelectedUsersForDB(dbUser.getDb())) {
                        this.selectDb(dbUser.getDb(), true);
                        DBMExtractionWizardSqlServer.this.tbSchemas.repaint();
                    }
                }
            }
        }

        private boolean allSelectedUsersForDB(String db) {
            for (DBObject dbo : DBMExtractionWizardSqlServer.this.lsSchemas) {
                if (!(dbo instanceof DBUserSqlServer) || !((DBUserSqlServer)dbo).getDb().equalsIgnoreCase(db) || dbo.isSelected()) continue;
                return false;
            }
            return true;
        }

        private void selectDb(String db, boolean select) {
            for (DBObject dbo : DBMExtractionWizardSqlServer.this.lsSchemas) {
                if (!dbo.getType().equalsIgnoreCase("Database") || !dbo.getName().equalsIgnoreCase(db)) continue;
                DBMExtractionWizardSqlServer.this.setSelected(dbo, select);
            }
        }

        private void setSelectedUsers(boolean select, String db) {
            for (DBObject dbo : DBMExtractionWizardSqlServer.this.lsSchemas) {
                if (!(dbo instanceof DBUserSqlServer) || !((DBUserSqlServer)dbo).getDb().equalsIgnoreCase(db)) continue;
                DBMExtractionWizardSqlServer.this.setSelected(dbo, select);
            }
        }
    }

    class SchemaTable
    extends JTable {
        SchemaTable() {
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 1) {
                if (((String)this.getValueAt(row, 2)).equalsIgnoreCase("Database")) {
                    return new BoldLabelCellRenderer();
                }
                return new PlainLabelCellRenderer();
            }
            return super.getCellRenderer(row, col);
        }
    }
}

