/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.ReportColumn;
import oracle.dbtools.crest.swingui.wizards.reports.ReportSection;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomReportTemplatesPersistence {
    public static final String RT_FILE_NAME = "custom_report_templates.xml";
    private ApplicationView appView;
    private static final Logger LOGGER = new Logger(CustomReportTemplatesPersistence.class);

    public CustomReportTemplatesPersistence(ApplicationView appView) {
        this.appView = appView;
    }

    public void saveReportTemplates() {
        StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
        buffer.append("\n");
        buffer.append("<").append("data").append(' ');
        buffer.append("version=\"").append("1.0").append("\"");
        buffer.append(">");
        buffer.append("\n");
        buffer.append("<").append("custom_report_templates").append(">");
        for (CustomReportTemplate crt : this.appView.getCustomReportTemplates()) {
            buffer.append("\n");
            buffer.append("\t").append("<").append("custom_report_template").append(' ');
            buffer.append("id=\"").append(crt.getReportTemplateId()).append("\"").append(' ');
            buffer.append("name=\"").append(StringUtilities.encodeAttributeValue(crt.getName())).append("\"").append(' ');
            buffer.append("description=\"").append(StringUtilities.encodeAttributeValue(crt.getDescription())).append("\"").append(' ');
            buffer.append("class=\"").append(crt.getClazz().getName()).append("\"").append(' ');
            buffer.append(">");
            buffer.append("\n");
            buffer.append("\t").append("<").append("sections").append(">");
            for (ReportSection rs : crt.getReportSections()) {
                buffer.append("\n");
                buffer.append("\t\t").append("<").append("section").append(" ");
                buffer.append("propertyName=\"").append(rs.getPropertyName()).append("\"").append(' ');
                buffer.append("type=\"").append(rs.getType()).append("\"").append(' ');
                buffer.append("customName=\"").append(rs.getCustomName()).append("\"").append(' ');
                buffer.append("level=\"").append(rs.getLevel()).append("\"").append(" ");
                buffer.append("class=\"").append(rs.getElementClassName()).append("\"").append(">");
                buffer.append("\n");
                buffer.append("\t\t").append("<").append("columns").append(">");
                for (ReportColumn rc : rs.getReportColumns()) {
                    buffer.append("\n");
                    buffer.append("\t\t\t\t").append("<").append("column").append(" ");
                    buffer.append("name=\"").append(rc.getPropertyName()).append("\"").append(' ');
                    buffer.append("customName=\"").append(rc.getColumnName()).append("\"").append(' ');
                    buffer.append("width=\"").append(rc.getColumnSize()).append("\"").append(' ');
                    buffer.append("order=\"").append(rc.getColumnOrder()).append("\"").append(' ');
                    buffer.append("massUpdatable=\"").append(rc.isMassUpdatable()).append("\"").append(' ');
                    buffer.append("dynamic=\"").append(rc.isDynamicProperty()).append("\"").append("/>");
                }
                buffer.append("\n");
                buffer.append("\t\t").append("</").append("columns").append(">");
                buffer.append("\n");
                buffer.append("\t\t").append("</").append("section").append(">");
            }
            buffer.append("\n");
            buffer.append("\t").append("</").append("sections").append(">");
            buffer.append("\n");
            buffer.append("\t").append("</").append("custom_report_template").append(">");
        }
        buffer.append("\n");
        buffer.append("</").append("custom_report_templates").append(">");
        buffer.append("\n");
        buffer.append("<").append("boolean_values").append(">");
        buffer.append("\n");
        buffer.append("<").append("str_true").append(">");
        for (String value : this.appView.getCRTBooleanTList()) {
            buffer.append("\n");
            buffer.append("\t").append("\t").append("\t").append("<").append("value").append(' ');
            buffer.append("v=\"").append(value).append("\"").append(' ');
            buffer.append("/>");
        }
        buffer.append("\n");
        buffer.append("</").append("str_true").append(">");
        buffer.append("\n");
        buffer.append("<").append("str_false").append(">");
        for (String value : this.appView.getCRTBooleanFList()) {
            buffer.append("\n");
            buffer.append("\t").append("\t").append("\t").append("<").append("value").append(' ');
            buffer.append("v=\"").append(value).append("\"").append(' ');
            buffer.append("/>");
        }
        buffer.append("\n");
        buffer.append("</").append("str_false").append(">");
        buffer.append("\n");
        buffer.append("</").append("boolean_values").append(">");
        buffer.append("\n");
        buffer.append("</").append("data").append(">");
        this.writeToFile(buffer);
    }

    private void writeToFile(StringBuffer buffer) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(XMLTransformationManager.getDefaultSystemTypesPath(), RT_FILE_NAME));
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(buffer.toString());
            osw.close();
        }
        catch (Exception e) {
            LOGGER.error("Unable to save custom report templates: ", e);
        }
    }

    public void loadCustomReportTemplates(ApplicationView appView) {
        try {
            File file = new File(XMLTransformationManager.getDefaultSystemTypesPath(appView.getSettings()), RT_FILE_NAME);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                this.loadData(doc);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load custom report templates: ", e);
        }
    }

    private void loadData(Document doc) {
        ArrayList<CustomReportTemplate> loadedCustomReportTemplates = new ArrayList<CustomReportTemplate>();
        ArrayList<String> ctrTValues = new ArrayList<String>();
        ArrayList<String> ctrFValues = new ArrayList<String>();
        try {
            String value;
            Element e;
            NodeList nodes1;
            ClassDescription cd;
            CustomReportTemplate crt;
            Class<?> clazz;
            String className;
            String crtName;
            Element elm;
            int i;
            Element dataElement = (Element)doc.getElementsByTagName("data").item(0);
            String fileVersion = dataElement.getAttribute("version");
            NodeList nodes = doc.getElementsByTagName("custom_report_template");
            int nodesLength0 = nodes.getLength();
            MetaDataManager metaDataManager = this.appView.getXMLTransformationManager().getMetaDataManager();
            if (fileVersion.equals("1.0")) {
                for (i = 0; i < nodesLength0; ++i) {
                    elm = (Element)nodes.item(i);
                    crtName = elm.getAttribute("name");
                    className = elm.getAttribute("class");
                    if (!className.equals("")) {
                        clazz = Class.forName(className);
                        if (clazz == null) continue;
                        crt = new CustomReportTemplate(StringUtilities.decodeAttributeValue(elm.getAttribute("name")), clazz, StringUtilities.decodeAttributeValue(elm.getAttribute("description")), elm.getAttribute("id"));
                        cd = metaDataManager.getClassDescription(className);
                        NodeList nodes12 = elm.getElementsByTagName("sections");
                        int nodesLength = nodes12.getLength();
                        for (int j = 0; j < nodesLength; ++j) {
                            Element e2 = (Element)nodes12.item(j);
                            NodeList elements = e2.getElementsByTagName("section");
                            int elementsLength = elements.getLength();
                            for (int k = 0; k < elementsLength; ++k) {
                                Element e1 = (Element)elements.item(k);
                                String sPropertyName = e1.getAttribute("propertyName");
                                String sPropertyType = e1.getAttribute("type");
                                String sCustomName = e1.getAttribute("customName");
                                int sLevel = Integer.parseInt(e1.getAttribute("level"));
                                Object element = null;
                                element = sPropertyType.equals("collection") ? cd.getCollectionDescriptionByName(sPropertyName) : (sPropertyType.equals("roPropertiesList") ? cd.getROPropertyDescriptionByName(sPropertyName) : metaDataManager.getClassDescription(className));
                                ReportSection rs = new ReportSection(element, sPropertyName, sCustomName, sLevel, sPropertyType);
                                crt.getReportSections().add(rs);
                                NodeList nodes2 = e1.getElementsByTagName("columns");
                                int nodesLength2 = nodes2.getLength();
                                for (int c = 0; c < nodesLength2; ++c) {
                                    Element e22 = (Element)nodes2.item(c);
                                    NodeList elements2 = e22.getElementsByTagName("column");
                                    int elementsLength2 = elements2.getLength();
                                    for (int d = 0; d < elementsLength2; ++d) {
                                        Element e3 = (Element)elements2.item(d);
                                        String cName = e3.getAttribute("name");
                                        String cCustomName = e3.getAttribute("customName");
                                        String cOrder = e3.getAttribute("order");
                                        double cSize = Double.parseDouble(e3.getAttribute("width"));
                                        boolean cMassUpdatable = Boolean.valueOf(e3.getAttribute("massUpdatable"));
                                        boolean isDynamicProperty = Boolean.valueOf(e3.getAttribute("dynamic"));
                                        ReportColumn rColumn = new ReportColumn(cName, cCustomName, cSize, "", cOrder, cMassUpdatable, isDynamicProperty);
                                        rs.getReportColumns().add(rColumn);
                                    }
                                }
                            }
                        }
                        loadedCustomReportTemplates.add(crt);
                        continue;
                    }
                    LOGGER.error("Class name not found for custom report template " + crtName + ". Template can not be loaded.");
                }
            } else if (fileVersion.equals("")) {
                for (i = 0; i < nodesLength0; ++i) {
                    elm = (Element)nodes.item(i);
                    crtName = elm.getAttribute("name");
                    className = elm.getAttribute("class");
                    if (className.equals("") || (clazz = Class.forName(className)) == null) continue;
                    crt = new CustomReportTemplate(StringUtilities.decodeAttributeValue(elm.getAttribute("name")), clazz, StringUtilities.decodeAttributeValue(elm.getAttribute("description")), elm.getAttribute("id"));
                    cd = metaDataManager.getClassDescription(className);
                    ClassDescription element = metaDataManager.getClassDescription(className);
                    String sPropertyName = element.getXmlName();
                    ReportSection rs = new ReportSection(element, sPropertyName, "", 0, "");
                    crt.getReportSections().add(rs);
                    NodeList nodes13 = elm.getElementsByTagName("properties");
                    int nodesLength = nodes13.getLength();
                    for (int j = 0; j < nodesLength; ++j) {
                        Element e3 = (Element)nodes13.item(j);
                        NodeList elements = e3.getElementsByTagName("property");
                        int elementsLength = elements.getLength();
                        for (int k = 0; k < elementsLength; ++k) {
                            Element e1 = (Element)elements.item(k);
                            String cName = e1.getAttribute("name");
                            String cCustomName = e1.getAttribute("customName");
                            String cOrder = e1.getAttribute("order");
                            int cSize = Integer.parseInt(e1.getAttribute("width"));
                            boolean cMassUpdatable = Boolean.valueOf(e1.getAttribute("massUpdatable"));
                            boolean isDynamicProperty = Boolean.valueOf(e1.getAttribute("dynamic"));
                            ReportColumn rColumn = new ReportColumn(cName, cCustomName, cSize, "", cOrder, cMassUpdatable, isDynamicProperty);
                            rs.getReportColumns().add(rColumn);
                        }
                    }
                    loadedCustomReportTemplates.add(crt);
                }
            }
            this.appView.getCustomReportTemplates().clear();
            this.appView.getCustomReportTemplates().addAll(loadedCustomReportTemplates);
            nodes = doc.getElementsByTagName("str_true");
            nodesLength0 = nodes.getLength();
            for (i = 0; i < nodesLength0; ++i) {
                elm = (Element)nodes.item(i);
                nodes1 = elm.getElementsByTagName("value");
                int nodesLength = nodes1.getLength();
                for (int j = 0; j < nodesLength; ++j) {
                    e = (Element)nodes1.item(j);
                    value = e.getAttribute("v");
                    ctrTValues.add(value);
                }
            }
            this.appView.getCRTBooleanTList().clear();
            this.appView.getCRTBooleanTList().addAll(ctrTValues);
            nodes = doc.getElementsByTagName("str_false");
            nodesLength0 = nodes.getLength();
            for (i = 0; i < nodesLength0; ++i) {
                elm = (Element)nodes.item(i);
                nodes1 = elm.getElementsByTagName("value");
                int nodesLength = nodes1.getLength();
                for (int j = 0; j < nodesLength; ++j) {
                    e = (Element)nodes1.item(j);
                    value = e.getAttribute("v");
                    ctrFValues.add(value);
                }
            }
            this.appView.getCRTBooleanFList().clear();
            this.appView.getCRTBooleanFList().addAll(ctrFValues);
        }
        catch (Exception e) {
            LOGGER.error("Unable to load custom report templates: ", e);
        }
    }
}

