/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.exports.reports.DifferentVersionException;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class DeleteDesignsDialog
extends JDialog {
    private static final String KEY_ESCAPE = "ESCAPE";
    private JTable jtable;
    private JTable desTable;
    private List elmList;
    private List desList;
    private List allDesigns;
    private Connection connection;
    private JButton bnDelete;
    private static final Logger LOGGER = new Logger(DeleteDesignsDialog.class);
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DeleteDesignsDialog.this.dispose();
        }
    };

    public DeleteDesignsDialog(Frame owner, Connection connection) {
        super(owner, "Select Design and Repository Version");
        this.connection = connection;
        this.getContentPane().add((Component)this.init(), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setSize(new Dimension(800, 350));
        CommonUtil.centerOnScreen(this);
        this.setModal(true);
    }

    private JPanel init() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.desList = new ArrayList();
        this.desTable = new JTable(new DesignTableModel());
        this.desTable.setSelectionMode(0);
        this.desTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = DeleteDesignsDialog.this.desTable.getSelectedRow();
                if (row != -1 && DeleteDesignsDialog.this.desList.size() > 0 && row < DeleteDesignsDialog.this.desList.size()) {
                    DesignDescriptor desObj = (DesignDescriptor)DeleteDesignsDialog.this.desList.get(row);
                    DeleteDesignsDialog.this.loadVersions(desObj);
                }
            }
        });
        JScrollPane spd = new JScrollPane(this.desTable);
        this.elmList = new ArrayList();
        this.jtable = new JTable(new ElementTableModel());
        this.jtable.getColumnModel().getColumn(1).setPreferredWidth(120);
        this.jtable.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.jtable.getColumnModel().getColumn(3).setPreferredWidth(120);
        JScrollPane sp = new JScrollPane(this.jtable);
        JSplitPane splitPane = new JSplitPane(1, spd, sp);
        splitPane.setDividerLocation(220);
        jpanel.add(splitPane);
        return jpanel;
    }

    public JPanel getBottomPanel() {
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        this.bnDelete = new JButton(Messages.getString("DeleteDesignsDialog.DeleteSelected"));
        this.bnDelete.setMnemonic(68);
        this.bnDelete.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnDelete.setEnabled(false);
        this.bnDelete.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteDesignsDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    DeleteDesignsDialog.this.deleteSelectedDesigns();
                }
                finally {
                    DeleteDesignsDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                DeleteDesignsDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(this.bnDelete);
        bottomPanel.add(this.bnDelete);
        JButton bnCancel = new JButton(Messages.getString("Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteDesignsDialog.this.dispose();
            }
        });
        bottomPanel.add(bnCancel);
        return bottomPanel;
    }

    private void loadDesignNames() {
        for (DesignDescriptor next : this.allDesigns) {
            DesignDescriptor desObj = this.getDesign(this.desList, next.getID());
            if (desObj != null) continue;
            this.desList.add(next);
        }
        Collections.sort(this.desList);
        this.desTable.updateUI();
        if (this.desList.size() > 0) {
            this.desTable.setRowSelectionInterval(0, 0);
        }
    }

    private DesignDescriptor getDesign(List list, String id) {
        for (DesignDescriptor desObj : list) {
            if (!id.equalsIgnoreCase(desObj.getID())) continue;
            return desObj;
        }
        return null;
    }

    private List getDesigns(List list, String id) {
        ArrayList<DesignDescriptor> result = new ArrayList<DesignDescriptor>();
        for (DesignDescriptor desObj : list) {
            if (!id.equalsIgnoreCase(desObj.getID())) continue;
            result.add(desObj);
        }
        return result;
    }

    private void enableDelete() {
        boolean enable = false;
        for (DesignDescriptor desObj : this.allDesigns) {
            if (!desObj.isSelected()) continue;
            enable = true;
            break;
        }
        this.bnDelete.setEnabled(enable);
    }

    private boolean loadDesigns() {
        boolean result;
        block10: {
            result = false;
            try {
                this.allDesigns = new ArrayList();
                if (this.connection == null) break block10;
                try {
                    float vers = SchemaFactory.schemaVersion(this.connection);
                    if (vers != 0.0f) {
                        String query = "SELECT Design_ID, Design_OVID, Design_Name, to_char(Date_Published, 'DD.MM.YYYY HH24:MI'), Version_Comments FROM DMRS_Designs ORDER BY Design_ID, Date_Published ASC";
                        try {
                            Statement stmt = this.connection.createStatement();
                            ResultSet rset = stmt.executeQuery(query);
                            while (rset.next()) {
                                String id = rset.getString(1);
                                String ovid = rset.getString(2);
                                String name = rset.getString(3);
                                String date = rset.getString(4);
                                String comments = rset.getString(5);
                                DesignDescriptor desObj = new DesignDescriptor(name, id);
                                desObj.setOvid(ovid);
                                desObj.setDate(date);
                                if (comments != null) {
                                    desObj.setComments(comments);
                                }
                                this.allDesigns.add(desObj);
                            }
                            stmt.close();
                            this.loadDesignNames();
                            result = true;
                        }
                        catch (SQLException e) {}
                        break block10;
                    }
                    MessageDialogs.showMessage(Messages.getString("DeleteDesignsDialog.ReportingRepositoryNotExisting"));
                }
                catch (DifferentVersionException dve) {
                    MessageDialogs.showWarningMessage(Messages.getString("DeleteDesignsDialog.DBSchemaOutOfDate"));
                }
                catch (Exception e) {
                    LOGGER.error("DeleteDesignsDialog.loadDesigns", e);
                    MessageDialogs.showErrorMessage(Messages.getString("DeleteDesignsDialog.UnableToLoadDesigns"), true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedDesigns() {
        block10: {
            try {
                if (this.connection == null) break block10;
                boolean autoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                float version = SchemaFactory.schemaVersion(this.connection);
                try {
                    for (DesignDescriptor next : this.allDesigns) {
                        if (!next.isSelected()) continue;
                        String ovid = next.getOvid();
                        for (String tbName : SchemaFactory.getTableNames(version)) {
                            String query = "DELETE FROM " + tbName + " WHERE Design_OVID='" + ovid + "'";
                            PreparedStatement stmt = this.connection.prepareStatement(query);
                            stmt.executeUpdate();
                            stmt.close();
                        }
                    }
                    this.connection.commit();
                    MessageDialogs.showMessage(Messages.getString("DeleteDesignsDialog.SelectedDesignAreDeleted"));
                }
                catch (Exception e) {
                    if (this.connection != null) {
                        this.connection.rollback();
                    }
                    LOGGER.error("DeleteDesignsDialog.deleteSelectedDesigns", e);
                    MessageDialogs.showErrorMessage(Messages.getString("DeleteDesignsDialog.UnableToDeleteSelectedDesigns"), true);
                }
                finally {
                    this.connection.setAutoCommit(autoCommit);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadVersions(DesignDescriptor desObj) {
        this.elmList.clear();
        try {
            this.elmList.addAll(this.getDesigns(this.allDesigns, desObj.getID()));
            Collections.sort(this.elmList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jtable.updateUI();
    }

    public static void showDialog(Frame owner, Connection connection) {
        DeleteDesignsDialog dialog = new DeleteDesignsDialog(owner, connection);
        if (dialog.loadDesigns()) {
            dialog.setVisible(true);
        } else {
            dialog.dispose();
        }
    }

    private class ElementTableModel
    extends AbstractTableModel {
        private ElementTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return DeleteDesignsDialog.this.elmList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DeleteDesignsDialog.Selected");
            }
            if (column == 1) {
                return Messages.getString("DeleteDesignsDialog.Date");
            }
            if (column == 2) {
                return Messages.getString("DeleteDesignsDialog.Name");
            }
            if (column == 3) {
                return Messages.getString("DeleteDesignsDialog.Comments");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignDescriptor version = (DesignDescriptor)DeleteDesignsDialog.this.elmList.get(row);
            if (col == 0) {
                return version.isSelected();
            }
            if (col == 1) {
                return version.getDate();
            }
            if (col == 2) {
                return version.getName();
            }
            if (col == 3) {
                return version.getComments();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (col == 0) {
                DesignDescriptor version = (DesignDescriptor)DeleteDesignsDialog.this.elmList.get(row);
                version.setSelected((Boolean)aValue);
                DeleteDesignsDialog.this.enableDelete();
            }
        }
    }

    private class DesignTableModel
    extends AbstractTableModel {
        private DesignTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return DeleteDesignsDialog.this.desList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DeleteDesignsDialog.DesignName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignDescriptor desObj = (DesignDescriptor)DeleteDesignsDialog.this.desList.get(row);
            if (col == 0) {
                return desObj.getName();
            }
            return new Integer(row * col);
        }
    }

    public class DesignDescriptor
    implements Comparable {
        private String name;
        private String id;
        private String ovid;
        private String comments = "";
        private String date;
        private boolean selected = false;

        public DesignDescriptor(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public String getID() {
            return this.id;
        }

        public String getOvid() {
            return this.ovid;
        }

        public void setOvid(String ovid) {
            this.ovid = ovid;
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String comments) {
            this.comments = comments;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public int compareTo(Object o) {
            return this.getName().compareToIgnoreCase(((DesignDescriptor)o).getName());
        }
    }
}

