/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultComboBoxModel;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.search.PropertyObject;
import oracle.dbtools.crest.swingui.search.SearchConstants;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportColumn;
import oracle.dbtools.crest.util.logging.Logger;

public class ReportUtils {
    private static final Logger LOGGER;
    private static final List bValues;

    public static String getDisplayName(String xmlName) {
        Map<String, String> s = SearchConstants.PROPERTIES_DISPLAY_NAMES_MAP;
        String displayString = s.get(xmlName);
        return displayString != null ? displayString : xmlName;
    }

    public static List getSearchableProperties(List collection, MetaDataManager metaDataManager) {
        List<Object> list;
        block1: {
            list = new ArrayList();
            Iterator objectsIt = collection.iterator();
            if (objectsIt == null) break block1;
            ArrayList checkList = new ArrayList();
            if (objectsIt.hasNext()) {
                ModelIDObject obj = (ModelIDObject)objectsIt.next();
                Class<?> classObj = obj.getClass();
                ClassDescription cd = metaDataManager.getClassDescription(classObj.getName());
                list = cd.getSearchablePropertyObjectsList();
            }
        }
        return list;
    }

    public static List getSearchablePropertyObjects(Class cls, MetaDataManager metaDataManager) {
        List<Object> list = new ArrayList();
        if (cls != null) {
            ClassDescription cd = metaDataManager.getClassDescription(cls.getName());
            list = cd.getSearchablePropertyObjectsList();
        }
        return list;
    }

    public static List getSearchablePropertyDescriptions(Class cls, MetaDataManager metaDataManager) {
        List<Object> list = new ArrayList();
        ClassDescription cd = metaDataManager.getClassDescription(cls.getName());
        list = cd.getSearchablePropertyDescriptionsList();
        return list;
    }

    public static List doSimpleSearch(List objectsCollection, Class clazz, String type, MetaDataManager metaDataManager, String searchPattern, boolean caseSensitive, boolean stopAtFirst, boolean useRegEx, boolean not) {
        ArrayList<SearchResultObject> results = new ArrayList<SearchResultObject>();
        ArrayList searchableProperties = new ArrayList();
        searchableProperties.addAll(ReportUtils.getSearchableProperties(objectsCollection, metaDataManager));
        Iterator objectsIt = objectsCollection.iterator();
        block0: while (objectsIt.hasNext()) {
            boolean braked = false;
            ModelIDObject obj = (ModelIDObject)objectsIt.next();
            for (PropertyObject po : searchableProperties) {
                SearchResultObject resObject = ReportUtils.search(obj, clazz, type, po, searchPattern, caseSensitive, useRegEx, not, false);
                if (resObject == null) continue;
                results.add(resObject);
                if (!searchPattern.equals("*") && !stopAtFirst) continue;
                braked = true;
                break;
            }
            if (braked) continue;
            Iterator it = obj.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String propValue = obj.getProperty(propName);
                int idx = ReportUtils.match(propValue, searchPattern, caseSensitive, useRegEx, not);
                if (idx <= -1) continue;
                SearchResultObject ro = new SearchResultObject(obj, clazz, propName, type, ReportUtils.getContentToShow(searchPattern, propValue, caseSensitive, idx, useRegEx), propValue);
                results.add(ro);
                if (!stopAtFirst) continue;
                continue block0;
            }
        }
        return results;
    }

    public static SearchResultObject search(ModelIDObject obj, Class clazz, String type, PropertyObject po, String searchPattern, boolean caseSensitive, boolean useRegEx, boolean not, boolean advancedMode) {
        int idx1;
        ClassDescription.PropertyDescription pd = po.getPropertyDescription();
        String value = ReportUtils.getValue(obj, pd.getter, pd.className);
        int idx = ReportUtils.match(value, searchPattern, caseSensitive, useRegEx, not, advancedMode);
        if (idx > -1) {
            SearchResultObject ro = new SearchResultObject(obj, clazz, pd.name, type, ReportUtils.getContentToShow(searchPattern, value, caseSensitive, idx, useRegEx), value);
            return ro;
        }
        if (!advancedMode && bValues.contains(value) && (idx1 = ReportUtils.match(pd.name, searchPattern, caseSensitive, useRegEx, not, false)) > -1) {
            SearchResultObject ro = new SearchResultObject(obj, clazz, pd.name, type, value, value);
            return ro;
        }
        return null;
    }

    public static String getValue(ModelIDObject obj, Method method, String className) {
        String value = "";
        try {
            if (method != null) {
                Object object = method.invoke((Object)obj, new Object[0]);
                if (object != null && object instanceof List) {
                    value = ReportUtils.listToString((List)object);
                    return value;
                }
                if (className.indexOf("java.lang.String") > -1) {
                    if (object != null) {
                        value = (String)object;
                    }
                } else if (className.indexOf("java.lang.Integer") > -1) {
                    if (object != null) {
                        value = ((Integer)object).toString();
                    }
                } else if (className.indexOf("java.lang.Boolean") > -1) {
                    if (object != null) {
                        value = ((Boolean)object).toString();
                    }
                } else if (className.indexOf("boolean") > -1 || className.indexOf("float") > -1 || className.indexOf("short") > -1 || className.indexOf("long") > -1 || className.indexOf("double") > -1 || className.indexOf("int") > -1) {
                    if (object != null) {
                        value = object.toString();
                    }
                } else if (className.indexOf("java.util.Map") <= -1 && object != null) {
                    value = object instanceof ModelObject ? ((ModelObject)object).getName() : object.toString();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in ReportUtils.getValue() ", e);
        }
        return value;
    }

    public static String listToString(List list) {
        String res = null;
        for (Object obj : list) {
            if (res == null) {
                res = obj.toString();
                continue;
            }
            res = res + "\n" + obj.toString();
        }
        if (res == null) {
            return "";
        }
        return res;
    }

    public static int match(String string, String searchString, boolean isCaseSensitive, boolean useRegEx, boolean not) {
        return ReportUtils.match(string, searchString, isCaseSensitive, useRegEx, not, false);
    }

    public static int match(String string, String searchString, boolean isCaseSensitive, boolean useRegEx, boolean not, boolean advancedMode) {
        if (string != null) {
            if (advancedMode && "".equals(searchString) && "".equals(string)) {
                if (not) {
                    return -1;
                }
                return 0;
            }
            if (advancedMode && "".equals(searchString) && !"".equals(string) && not) {
                return 0;
            }
            if (!"".equalsIgnoreCase(searchString)) {
                if ("*".equalsIgnoreCase(searchString)) {
                    return 0;
                }
                if (searchString.indexOf(42) > -1) {
                    searchString = searchString.replaceAll("\\*", "\\.*");
                }
                Pattern p = null;
                try {
                    if (useRegEx) {
                        p = isCaseSensitive ? Pattern.compile(searchString) : Pattern.compile(searchString, 2);
                        Matcher m = p.matcher(string);
                        if (not) {
                            return m.find() ? -1 : 0;
                        }
                        return m.find() ? 0 : -1;
                    }
                    if (isCaseSensitive) {
                        int position = string.indexOf(searchString);
                        if (not) {
                            if (position > -1) {
                                return -1;
                            }
                            if (position == -1) {
                                return 0;
                            }
                            return -1;
                        }
                        return position;
                    }
                    int position = string.toUpperCase().indexOf(searchString.toUpperCase());
                    if (not) {
                        if (position > -1) {
                            return -1;
                        }
                        if (position == -1) {
                            return 0;
                        }
                        return -1;
                    }
                    return position;
                }
                catch (PatternSyntaxException ex) {
                    return -1;
                }
            }
            return -1;
        }
        return -1;
    }

    public static String getContentToShow(String pattern, String content, boolean caseSensitive, int start, boolean useRegEx) {
        String s;
        block13: {
            s = content;
            Pattern p = null;
            try {
                if ("".equals(content)) {
                    return content;
                }
                if ("*".equalsIgnoreCase(pattern)) {
                    if ("".equals(content)) {
                        return content;
                    }
                    if (20 > content.length()) {
                        return content;
                    }
                    return content.substring(0, 20);
                }
                if (content.length() < pattern.length()) break block13;
                String strBefore = "";
                String strAfter = "";
                String actualFoundText = "";
                int sS = 0;
                int eE = 0;
                if (useRegEx) {
                    p = caseSensitive ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
                    Matcher m = p.matcher(content);
                    m.find();
                    sS = m.start();
                    eE = m.end() - 1;
                    if (eE > sS) {
                        actualFoundText = content.substring(sS, eE);
                    }
                } else {
                    sS = start;
                    eE = sS + pattern.length();
                    if (eE > sS) {
                        actualFoundText = content.substring(start, start + pattern.length());
                    }
                }
                try {
                    strBefore = "..." + content.substring(sS - 20, sS);
                }
                catch (StringIndexOutOfBoundsException e) {
                    strBefore = content.substring(0, sS);
                }
                if (eE < 0) {
                    eE = 0;
                }
                strAfter = content.substring(eE, content.length());
                s = strBefore + "<b>" + actualFoundText + "</b>" + strAfter;
            }
            catch (PatternSyntaxException ex) {
                boolean i = false;
            }
        }
        return s;
    }

    public static boolean isReadOnlyProperty(ClassDescription classDescription, String propertyId) {
        for (ClassDescription.PropertyDescription pd : classDescription.getROPropertiesList()) {
            if (!pd.name.equals(propertyId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isObjectTypeProperty(ClassDescription classDescription, String propertyId) {
        for (PropertyObject propertyObject : classDescription.getSearchablePropertyObjectsList()) {
            ClassDescription.PropertyDescription pd = propertyObject.getPropertyDescription();
            String className = pd.className;
            if (!pd.name.equals(propertyId)) continue;
            return className.indexOf("java.lang.String") <= -1 && className.indexOf("java.lang.Integer") <= -1 && className.indexOf("java.lang.Boolean") <= -1 && className.indexOf("boolean") <= -1 && className.indexOf("float") <= -1 && className.indexOf("short") <= -1 && className.indexOf("long") <= -1 && className.indexOf("double") <= -1 && className.indexOf("int") <= -1;
        }
        return false;
    }

    public static String getReportFileName(String reportsPath, String reportName) {
        long lastUsedIdx = 0L;
        long currIdx = 0L;
        try {
            File[] listOfFiles;
            File folder = new File(reportsPath);
            if (!folder.exists()) {
                folder.mkdir();
            }
            if ((listOfFiles = folder.listFiles()) == null) {
                listOfFiles = new File(folder.getParent()).listFiles();
            }
            for (int i = 0; i < listOfFiles.length; ++i) {
                File currentFile = listOfFiles[i];
                String reportFileName = currentFile.getName();
                if (!currentFile.isFile() || !reportFileName.startsWith(reportName) || reportFileName.indexOf("_rs") != -1) continue;
                String currentIndex = reportFileName.substring(reportFileName.indexOf("_") + 1, reportFileName.indexOf("."));
                try {
                    currIdx = new Long(currentIndex);
                    if (currIdx <= lastUsedIdx) continue;
                    lastUsedIdx = currIdx;
                    continue;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("ReportUtils.getLastUsedFileIdx() Exception : " + e);
        }
        return reportName + "_" + (lastUsedIdx + 1L);
    }

    public static String getReportsPath(ApplicationView appView) {
        String reportsPath = "";
        reportsPath = appView.getSettings().getDefaultReportsPath();
        if (reportsPath.equals("") || reportsPath == null) {
            reportsPath = new File(ApplicationView.basePath, "reports").getAbsolutePath();
        }
        if (!ReportUtils.hasPermissions(reportsPath)) {
            reportsPath = new File(appView.getUserHomeDirectory().getFile()).getAbsolutePath();
        }
        return reportsPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasPermissions(String path) {
        PrintWriter out = null;
        try {
            File f = new File(path + "/test.log");
            FileWriter outFile = new FileWriter(f);
            out = new PrintWriter(outFile);
            out.write("test");
            out.flush();
            out.close();
            out = null;
            f.delete();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("ReportsGenerator.hasPermissions() " + e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
                out = null;
            }
        }
    }

    static {
        bValues = Arrays.asList("true", "yes", "y", "TRUE", "YES", "Y");
        LOGGER = new Logger(ReportUtils.class);
    }

    public static class SearchSetsComparator
    implements Comparator {
        public int compare(Object one, Object two) {
            String v1 = "";
            String v2 = "";
            v1 = one instanceof SearchSet ? ((SearchSet)one).getTypeName() : (String)one;
            v2 = two instanceof SearchSet ? ((SearchSet)two).getTypeName() : (String)two;
            return v1.compareTo(v2);
        }
    }

    static class SortedComboBoxModel
    extends DefaultComboBoxModel {
        private Comparator comparator;

        protected static Vector sortVector(Vector items, Comparator comparator) {
            Collections.sort(items, comparator);
            return items;
        }

        protected static Object[] sortArray(Object[] items, Comparator comparator) {
            Arrays.sort(items, comparator);
            return items;
        }

        public SortedComboBoxModel() {
        }

        public SortedComboBoxModel(Comparator comparator) {
            this.comparator = comparator;
        }

        public SortedComboBoxModel(Object[] items) {
            super(SortedComboBoxModel.sortArray(items, null));
        }

        public SortedComboBoxModel(Object[] items, Comparator comparator) {
            super(SortedComboBoxModel.sortArray(items, comparator));
            this.comparator = comparator;
        }

        public SortedComboBoxModel(Vector items) {
            this(items, null);
        }

        public SortedComboBoxModel(Vector items, Comparator comparator) {
            super(SortedComboBoxModel.sortVector(items, comparator));
            this.comparator = comparator;
        }

        @Override
        public void addElement(Object element) {
            this.insertElementAt(element, 0);
        }

        @Override
        public void insertElementAt(Object element, int index) {
            Comparable c;
            Object o;
            int size = this.getSize();
            for (index = 0; index < size && !(this.comparator != null ? this.comparator.compare(o = this.getElementAt(index), element) > 0 : (c = (Comparable)this.getElementAt(index)).compareTo(element) > 0); ++index) {
            }
            super.insertElementAt(element, index);
        }
    }

    public static class ResultObjectsComparator
    implements Comparator {
        public int compare(Object one, Object two) {
            SearchResultObject s1 = (SearchResultObject)one;
            SearchResultObject s2 = (SearchResultObject)two;
            return ((ModelIDObject)s1.getObj()).getLongName().compareTo(((ModelIDObject)s2.getObj()).getLongName());
        }
    }

    static class ColumnsComparator
    implements Comparator {
        ColumnsComparator() {
        }

        public int compare(Object one, Object two) {
            ReportColumn s1 = (ReportColumn)one;
            ReportColumn s2 = (ReportColumn)two;
            if (s1.getColumnName().equalsIgnoreCase("name")) {
                return -1;
            }
            if (s2.getColumnName().equalsIgnoreCase("name")) {
                return 1;
            }
            return s1.getColumnName().compareTo(s2.getColumnName());
        }
    }
}

