/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.ToStringComparator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReportsHTMLTOC {
    private static final Logger LOGGER = new Logger(ReportsHTMLTOC.class);

    public static StringBuffer createHTMLIndexPage(String TOCFileName, String reportFileName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        buffer.append("\n");
        buffer.append("<head>");
        buffer.append("\n");
        buffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>");
        buffer.append("\n");
        buffer.append("<title>" + reportFileName.substring(0, reportFileName.indexOf(".")) + "</title>");
        buffer.append("\n");
        buffer.append("</head>");
        buffer.append("\n");
        buffer.append("<frameset cols=\"20%,80%\">");
        buffer.append("\n");
        buffer.append("<frame name=\"toc\" src=\"" + TOCFileName + "\">");
        buffer.append("\n");
        buffer.append("<frame name=\"details\" src=\"" + reportFileName + "\"></frameset>");
        buffer.append("\n");
        buffer.append("</html>");
        return buffer;
    }

    public static StringBuffer createHTMLTOCPage(String reportFileName, File rawXMLFile, String tocTagName, List objectsBookmarksNamesList) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        buffer.append("\n");
        buffer.append("<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/></head>");
        buffer.append("\n");
        buffer.append("<style>");
        buffer.append("\n");
        buffer.append("div.tab div{height:21px;float:left;margin:0;}");
        buffer.append("\n");
        buffer.append("div.tab div a{margin:0 8px;height:21px;line-height:21px;display:block;text-decoration:none;vertical-align:middle;float:left;}");
        buffer.append("\n");
        buffer.append("</style>");
        buffer.append("\n");
        buffer.append("<script>\nfunction $x(pNd){\n\tvar lThis;\n\tswitch(typeof (pNd)){\n\t\tcase 'string':lThis = document.getElementById(pNd);break;\n\t\tcase 'object':lThis = pNd;break;\n\t\tdefault:return false;break;\n\t}\n\treturn (lThis.nodeType == 1)?lThis:false;\n}\nvar gRegex=false;\nvar gHeight=0;\nfunction $d_Find(pThis,pString,pTags,pClass){\n       if(!pTags){pTags = 'DIV';}\n       pThis = $x(pThis);\n       if(pThis){\n           var d=pThis.getElementsByTagName(pTags);\n           pThis.style.display=\"none\";\n           if(!gRegex){gRegex =new RegExp(\"test\");}\n           gRegex.compile(pString,\"i\");\n           for(var i=0,len=d.length ;i<len;i++){\n               if(gRegex.test(d[i].innerHTML)){\n                   d[i].style.display=\"table-row\";\n                   d[i].style.visiblilty=\"visible\";\n                   d[i].style.height=gHeight;\n               } else{\n                   if ( gHeight==0)  gHeight=d[i].style.height;\n                   d[i].style.height='0';\n                   d[i].style.display=\"none\";\n                   d[i].style.visiblilty=\"hidden\";\n               }\n           }\n       pThis.style.display=\"block\";\n   }\n   return;\n}\n</script>");
        buffer.append("\n");
        buffer.append("<body>");
        buffer.append("\n");
        buffer.append("<table id=\"toc_table\" width=\"100%\" style=\"empty-cells:show; font-family:Tahoma; font-size:small; text-align:left; vertical-align:top; word-wrap:break-word;\">");
        buffer.append("\n");
        buffer.append("<tr>");
        buffer.append("<td style=\"color:navy; font-family:Tahoma; font-size:small; font-style:italic; font-weight:bold;\">Content</td>");
        buffer.append("</tr>");
        buffer.append("\n");
        buffer.append("<tr><td style=\"color:navy; font-family:Tahoma; font-size:small; font-style:italic; font-weight:bold;\"><input type=\"text\" onkeyup=\"$d_Find('toc_list',this.value,'a')\"/></td></tr>");
        buffer.append("\n");
        buffer.append("<tr><td>&nbsp;</td></tr>");
        buffer.append("\n");
        buffer.append("</table>");
        buffer.append("<div id=\"toc_list\">");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        ArrayList<String> list = new ArrayList<String>();
        if (objectsBookmarksNamesList.size() > 0) {
            list.addAll(objectsBookmarksNamesList);
        } else {
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(rawXMLFile);
                Element docEle = dom.getDocumentElement();
                NodeList nl = docEle.getElementsByTagName(tocTagName);
                if (nl != null && nl.getLength() > 0) {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Element el = (Element)nl.item(i);
                        String tc = el.getTextContent();
                        if (list.contains(tc)) continue;
                        list.add(tc);
                    }
                }
            }
            catch (ParserConfigurationException e) {
                LOGGER.error("Exception during report generation createHTMLTOCPage() " + e);
            }
            catch (SAXException e) {
                LOGGER.error("Exception during report generation createHTMLTOCPage() " + e);
            }
            catch (IOException e) {
                LOGGER.error("Exception during report generation createHTMLTOCPage() " + e);
            }
        }
        Collections.sort(list, new ToStringComparator());
        for (String item : list) {
            buffer.append("\n");
            buffer.append("<div><a href=\"" + reportFileName + "#" + item + "\" target=\"details\">" + item + "</a></div>");
        }
        buffer.append("</div");
        buffer.append("\n");
        buffer.append("</body>");
        buffer.append("</html>");
        return buffer;
    }
}

