/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.RowFilter;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerationDialog;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportConfiguration;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportConfigurationsPersistence;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.ToStringComparator;

public class StandardReportsConfigurationDialog
extends CustomDialog {
    private static final String TEMPLATE_NAME = "Standard Report Configuration";
    private ToStringComparator toStringComparator = new ToStringComparator();
    private JDialog dialog;
    private boolean result = false;
    private JPanel mainPanel;
    private DefaultListModel standardReportsModel;
    private JList standardReportConfigurationsList;
    private int cgCounter = 0;
    private JButton btnSubviewAdd;
    private JButton btnSubviewRemove;
    private JButton btnSave = new JButton(Messages.getString("StandardReportsConfigurationDialog.Save"));
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnRemove;
    private JRadioButton rbIncludeAll;
    private JRadioButton rbChooseObjects;
    private JTextField subviewsFilter;
    private JTextField objectsFilter;
    private SelectedSubViewsModel selectedSubviewsListModel;
    private FilteredSUbViewsJList subviewsList;
    private JList selectedSubviewsList;
    private JButton btnSelectAll;
    private JButton btnDeselectAll;
    private JScrollPane subviewsSPane;
    private JScrollPane standardReportSP;
    private JScrollPane selectedSubviewsSPane;
    private ObjectsModel objecstModel;
    private JTable objectsTable;
    private List<ReportsGenerationDialog.ReportObject> initialObjectsList = new ArrayList<ReportsGenerationDialog.ReportObject>();
    private boolean isLD;
    private JTextField txtName;
    private JTextArea description;
    private List<ReportsGenerationDialog.ReportObject> currentObjectsList;
    private StandardReportConfiguration editedStandardReportConfiguration;
    private boolean isSaved = true;
    private boolean manuallyClicked = false;
    private JCheckBox chbIncludeDuplicates;
    private StandardReportsConfigurationDialog srd;
    private StandardReportConfigsListSelectionHandler rcListHandler;
    private StandardReportConfigurationsPersistence standardReportPersistence;
    private List<StandardReportConfiguration> allConfigurationsList;
    private Object allAvailableSubViewsList;
    private List currentNonSelectedSubViewsList = new ArrayList();
    private String designObjId;
    private String modelObjId;
    private ReportsGenerationDialog parent;
    private TableRowSorter<ObjectsModel> objectsSorter;
    private JPanel subviewsPanel;
    private JScrollPane objectsSPane;
    private Class clazz;
    private static final Logger LOGGER = new Logger(StandardReportsConfigurationDialog.class);

    public StandardReportsConfigurationDialog(ApplicationView appView, Class clazz, HashMap extraParams) {
        super(appView);
        this.clazz = clazz;
        this.parent = (ReportsGenerationDialog)extraParams.get("parent");
        this.allAvailableSubViewsList = extraParams.get("subviews");
        this.designObjId = (String)extraParams.get("design_id");
        this.modelObjId = (String)extraParams.get("model_id");
        this.initialObjectsList = (List)extraParams.get("objects_list");
        this.isLD = (Boolean)extraParams.get("loaded_designs");
        this.srd = this;
        this.allConfigurationsList = appView.getStandardReportConfigurations();
        this.standardReportPersistence = (StandardReportConfigurationsPersistence)extraParams.get("srp_persistence");
        this.initUI();
        this.initData();
        this.initButtonsPanel();
        this.loadReportConfigurations();
    }

    private void initUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(560, 700));
        JPanel reportsPanel = new JPanel(new SpringLayout());
        reportsPanel.setPreferredSize(new Dimension(560, 160));
        reportsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("StandardReportsConfigurationDialog.StandardReportConfiguration")));
        this.standardReportsModel = new DefaultListModel();
        this.standardReportConfigurationsList = new JList(this.standardReportsModel);
        this.rcListHandler = new StandardReportConfigsListSelectionHandler();
        this.standardReportConfigurationsList.addListSelectionListener(this.rcListHandler);
        this.standardReportConfigurationsList.setCellRenderer(new ReportsConfigurationRenderer());
        this.standardReportConfigurationsList.setSelectionMode(0);
        this.standardReportSP = new JScrollPane(this.standardReportConfigurationsList);
        this.standardReportSP.setPreferredSize(new Dimension(340, 120));
        CommonUtil.setObjectConstraints((SpringLayout)reportsPanel.getLayout(), this.standardReportSP, 5, 5);
        reportsPanel.add(this.standardReportSP);
        this.btnAdd = new JButton(Messages.getString("ReportTemplatesDialog.Add"));
        this.btnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnAdd.setEnabled(true);
        this.btnAdd.addActionListener(new AddAction());
        this.btnAdd.setMnemonic(65);
        CommonUtil.setObjectConstraints((SpringLayout)reportsPanel.getLayout(), this.btnAdd, 360, 5);
        reportsPanel.add(this.btnAdd);
        this.btnEdit = new JButton(Messages.getString("ReportTemplatesDialog.Edit"));
        this.btnEdit.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnEdit.setEnabled(false);
        this.btnEdit.addActionListener(new EditAction());
        this.btnEdit.setMnemonic(69);
        CommonUtil.setObjectConstraints((SpringLayout)reportsPanel.getLayout(), this.btnEdit, 360, 35);
        reportsPanel.add(this.btnEdit);
        this.btnRemove = new JButton(Messages.getString("ReportTemplatesDialog.Remove"));
        this.btnRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new RemoveAction());
        this.btnRemove.setMnemonic(82);
        CommonUtil.setObjectConstraints((SpringLayout)reportsPanel.getLayout(), this.btnRemove, 360, 65);
        reportsPanel.add(this.btnRemove);
        this.btnSave = new JButton(Messages.getString("ReportTemplatesDialog.Save"));
        this.btnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnSave.setEnabled(false);
        this.btnSave.addActionListener(new SaveAction());
        this.btnSave.setMnemonic(83);
        CommonUtil.setObjectConstraints((SpringLayout)reportsPanel.getLayout(), this.btnSave, 360, 95);
        reportsPanel.add(this.btnSave);
        JPanel nameDescriptionScopePanel = new JPanel(new SpringLayout());
        nameDescriptionScopePanel.setPreferredSize(new Dimension(280, 100));
        JLabel lblName = new JLabel(Messages.getString("StandardReportsConfigurationDialog.Name"));
        lblName.setPreferredSize(new Dimension(70, 20));
        CommonUtil.setLabelConstraints((SpringLayout)nameDescriptionScopePanel.getLayout(), lblName, 5, 5);
        this.txtName = new JTextField();
        this.txtName.setEnabled(false);
        this.txtName.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                StandardReportsConfigurationDialog.this.isSaved = false;
                StandardReportsConfigurationDialog.this.btnSave.setEnabled(true);
            }
        });
        this.txtName.setPreferredSize(new Dimension(250, 20));
        CommonUtil.setObjectConstraints((SpringLayout)nameDescriptionScopePanel.getLayout(), this.txtName, 100, 5);
        JLabel lblComments = new JLabel(Messages.getString("StandardReportsConfigurationDialog.Description"));
        lblComments.setPreferredSize(new Dimension(70, 20));
        CommonUtil.setLabelConstraints((SpringLayout)nameDescriptionScopePanel.getLayout(), lblComments, 5, 35);
        this.description = new JTextArea();
        this.description.setEnabled(false);
        this.description.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                StandardReportsConfigurationDialog.this.isSaved = false;
                StandardReportsConfigurationDialog.this.btnSave.setEnabled(true);
            }
        });
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        JScrollPane commentsScrollPane = new JScrollPane(this.description);
        commentsScrollPane.setPreferredSize(new Dimension(250, 50));
        CommonUtil.setObjectConstraints((SpringLayout)nameDescriptionScopePanel.getLayout(), commentsScrollPane, 100, 35);
        nameDescriptionScopePanel.add(lblName);
        nameDescriptionScopePanel.add(this.txtName);
        nameDescriptionScopePanel.add(lblComments);
        nameDescriptionScopePanel.add(commentsScrollPane);
        this.rbIncludeAll = new JRadioButton(Messages.getString("StandardReportsConfigurationDialog.INcludeAllObjects"));
        this.rbIncludeAll.setEnabled(false);
        this.rbIncludeAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1 && StandardReportsConfigurationDialog.this.manuallyClicked) {
                    StandardReportsConfigurationDialog.this.isSaved = false;
                }
            }
        });
        CommonUtil.setObjectConstraints((SpringLayout)nameDescriptionScopePanel.getLayout(), this.rbIncludeAll, 360, 5);
        this.rbChooseObjects = new JRadioButton(Messages.getString("StandardReportsConfigurationDialog.ChooseSWObjects"));
        this.rbChooseObjects.setEnabled(false);
        this.rbChooseObjects.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1 && StandardReportsConfigurationDialog.this.manuallyClicked) {
                    StandardReportsConfigurationDialog.this.isSaved = false;
                }
            }
        });
        CommonUtil.setObjectConstraints((SpringLayout)nameDescriptionScopePanel.getLayout(), this.rbChooseObjects, 360, 35);
        this.rbIncludeAll.addItemListener(new RadioButtonListener());
        this.rbChooseObjects.addItemListener(new RadioButtonListener());
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbIncludeAll);
        group.add(this.rbChooseObjects);
        this.chbIncludeDuplicates = new JCheckBox(Messages.getString("StandardReportsConfigurationDialog.IncludeDuplicates"));
        this.chbIncludeDuplicates.setEnabled(false);
        CommonUtil.setObjectConstraints((SpringLayout)nameDescriptionScopePanel.getLayout(), this.chbIncludeDuplicates, 380, 65);
        nameDescriptionScopePanel.add(this.rbIncludeAll);
        nameDescriptionScopePanel.add(this.rbChooseObjects);
        JPanel allSubviewsPanel = new JPanel(new BorderLayout());
        allSubviewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("StandardReportsConfigurationDialog.All")));
        this.subviewsList = new FilteredSUbViewsJList();
        this.subviewsList.setCellRenderer(new AllSubviewsRenderer());
        this.subviewsSPane = new JScrollPane(this.subviewsList);
        this.subviewsSPane.setPreferredSize(new Dimension(250, 100));
        this.subviewsList.setEnabled(false);
        this.subviewsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (StandardReportsConfigurationDialog.this.subviewsList.getSelectedIndex() == -1) {
                    StandardReportsConfigurationDialog.this.btnSubviewAdd.setEnabled(false);
                } else {
                    StandardReportsConfigurationDialog.this.btnSubviewAdd.setEnabled(true);
                }
            }
        });
        JPanel subviewsFilterPanel = new JPanel(new SpringLayout());
        subviewsFilterPanel.setPreferredSize(new Dimension(200, 25));
        JLabel subviewsFilterLabel = new JLabel(Messages.getString("StandardReportsConfigurationDialog.Filter"));
        this.subviewsFilter = new JTextField();
        this.subviewsFilter.setPreferredSize(new Dimension(148, 20));
        this.subviewsFilter.setEnabled(false);
        this.subviewsFilter.getDocument().addDocumentListener(new SubViewsFilterListener());
        CommonUtil.setObjectConstraints((SpringLayout)subviewsFilterPanel.getLayout(), subviewsFilterLabel, 5, 0);
        CommonUtil.setObjectConstraints((SpringLayout)subviewsFilterPanel.getLayout(), this.subviewsFilter, 50, 0);
        subviewsFilterPanel.add(subviewsFilterLabel);
        subviewsFilterPanel.add(this.subviewsFilter);
        allSubviewsPanel.add((Component)subviewsFilterPanel, "North");
        allSubviewsPanel.add((Component)this.subviewsSPane, "Center");
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnSubviewAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.btnSubviewAdd.addActionListener(new AddSubviewActionListener());
        this.btnSubviewAdd.setEnabled(false);
        this.btnSubviewAdd.setPreferredSize(new Dimension(32, 32));
        this.btnSubviewRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.btnSubviewRemove.addActionListener(new RemoveSubviewActionListener());
        this.btnSubviewRemove.setEnabled(false);
        this.btnSubviewRemove.setPreferredSize(new Dimension(32, 32));
        JPanel jpButtons = new JPanel();
        jpButtons.setLayout(new BoxLayout(jpButtons, 3));
        jpButtons.add(this.btnSubviewAdd);
        jpButtons.add(this.btnSubviewRemove);
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(jpButtons);
        verticalBox.add(Box.createVerticalGlue());
        JPanel allS = new JPanel(new BorderLayout());
        allS.add((Component)allSubviewsPanel, "West");
        allS.add((Component)verticalBox, "East");
        JPanel selectedSubviewsPanel = new JPanel(new BorderLayout());
        selectedSubviewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("StandardReportsConfigurationDialog.Selected")));
        this.selectedSubviewsListModel = new SelectedSubViewsModel();
        this.selectedSubviewsList = new JList(this.selectedSubviewsListModel);
        this.selectedSubviewsList.setCellRenderer(new SelectedSubviewsRenderer());
        this.selectedSubviewsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (StandardReportsConfigurationDialog.this.selectedSubviewsList.getSelectedIndex() == -1) {
                    StandardReportsConfigurationDialog.this.btnSubviewRemove.setEnabled(false);
                } else {
                    StandardReportsConfigurationDialog.this.btnSubviewRemove.setEnabled(true);
                }
            }
        });
        this.selectedSubviewsSPane = new JScrollPane(this.selectedSubviewsList);
        this.selectedSubviewsSPane.setPreferredSize(new Dimension(248, 100));
        this.selectedSubviewsList.setEnabled(false);
        selectedSubviewsPanel.add(this.selectedSubviewsSPane);
        this.subviewsPanel = new JPanel(new BorderLayout());
        this.subviewsPanel.setPreferredSize(new Dimension(460, 200));
        this.subviewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("StandardReportsConfigurationDialog.SubViews")));
        this.subviewsPanel.add((Component)allS, "West");
        this.subviewsPanel.add((Component)selectedSubviewsPanel, "East");
        JPanel selectedObjectsPanel = new JPanel(new BorderLayout());
        selectedObjectsPanel.setPreferredSize(new Dimension(460, 200));
        selectedObjectsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("StandardReportsConfigurationDialog.Objects")));
        this.currentObjectsList = new ArrayList<ReportsGenerationDialog.ReportObject>();
        this.objecstModel = new ObjectsModel();
        this.objectsSorter = new TableRowSorter<ObjectsModel>(this.objecstModel);
        this.objectsTable = new JTable(this.objecstModel);
        this.objectsTable.setEnabled(false);
        TableColumn col1 = this.objectsTable.getColumnModel().getColumn(1);
        col1.setCellRenderer(new CheckBoxRenderer());
        col1.setWidth(50);
        col1.setMaxWidth(50);
        this.objectsSPane = new JScrollPane(this.objectsTable);
        JPanel objectsFilterPanel = new JPanel(new SpringLayout());
        objectsFilterPanel.setPreferredSize(new Dimension(200, 25));
        JLabel selectedObjectsFilterLabel = new JLabel(Messages.getString("StandardReportsConfigurationDialog.Filter"));
        this.objectsFilter = new JTextField();
        this.objectsFilter.setEnabled(false);
        this.objectsFilter.setPreferredSize(new Dimension(148, 20));
        this.objectsFilter.getDocument().addDocumentListener(new FilterObjectListener());
        CommonUtil.setObjectConstraints((SpringLayout)objectsFilterPanel.getLayout(), selectedObjectsFilterLabel, 5, 0);
        CommonUtil.setObjectConstraints((SpringLayout)objectsFilterPanel.getLayout(), this.objectsFilter, 50, 0);
        this.btnSelectAll = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL"));
        this.btnSelectAll.setEnabled(false);
        this.btnSelectAll.setMnemonic(83);
        this.btnSelectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAll.setToolTipText(Messages.getString("StandardReportsConfigurationDialog.SelectAll"));
        CommonUtil.setObjectConstraints((SpringLayout)objectsFilterPanel.getLayout(), this.btnSelectAll, 480, 0);
        this.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardReportsConfigurationDialog.this.checkAll(StandardReportsConfigurationDialog.this.objectsTable, StandardReportsConfigurationDialog.this.currentObjectsList, true);
                StandardReportsConfigurationDialog.this.objectsTable.updateUI();
                StandardReportsConfigurationDialog.this.isSaved = false;
            }
        });
        this.btnDeselectAll = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL"));
        this.btnDeselectAll.setEnabled(false);
        this.btnDeselectAll.setMnemonic(68);
        this.btnDeselectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnDeselectAll.setToolTipText(Messages.getString("StandardReportsConfigurationDialog.DeselectAll"));
        CommonUtil.setObjectConstraints((SpringLayout)objectsFilterPanel.getLayout(), this.btnDeselectAll, 510, 0);
        this.btnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardReportsConfigurationDialog.this.checkAll(StandardReportsConfigurationDialog.this.objectsTable, StandardReportsConfigurationDialog.this.currentObjectsList, false);
                StandardReportsConfigurationDialog.this.objectsTable.updateUI();
                StandardReportsConfigurationDialog.this.isSaved = false;
            }
        });
        objectsFilterPanel.add(selectedObjectsFilterLabel);
        objectsFilterPanel.add(this.objectsFilter);
        objectsFilterPanel.add(this.btnSelectAll);
        objectsFilterPanel.add(this.btnDeselectAll);
        selectedObjectsPanel.add((Component)objectsFilterPanel, "North");
        selectedObjectsPanel.add((Component)this.objectsSPane, "Center");
        JPanel reportPanel = new JPanel(new BorderLayout());
        reportPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomizableReportsTemplatesDialog.Report")));
        reportPanel.add((Component)nameDescriptionScopePanel, "North");
        reportPanel.add((Component)this.subviewsPanel, "Center");
        reportPanel.add((Component)selectedObjectsPanel, "South");
        this.mainPanel.add((Component)reportsPanel, "North");
        this.mainPanel.add((Component)reportPanel, "Center");
        this.add((Component)this.mainPanel, "Center");
    }

    private void initData() {
        this.currentObjectsList.clear();
        this.selectedSubviewsListModel.clear();
        SubViewsFilterModel subViewsFilterModel = (SubViewsFilterModel)this.subviewsList.getModel();
        subViewsFilterModel.clear();
        if (this.isLD) {
            Iterator it0 = ((SubViewObjectSet)this.allAvailableSubViewsList).iterator();
            while (it0.hasNext()) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it0.next();
                subViewsFilterModel.addElement(ph);
            }
        } else {
            for (ReportsGenerationDialog.RSchemaSubView rs : (List)this.allAvailableSubViewsList) {
                subViewsFilterModel.addElement(rs);
            }
        }
        ((SubViewsFilterModel)this.subviewsList.getModel()).setInitialState();
        this.currentObjectsList.addAll(this.initialObjectsList);
        ((ObjectsModel)this.objectsTable.getModel()).fireTableDataChanged();
        this.objectsTable.updateUI();
    }

    private void initButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        JButton btnClose = new JButton("Close");
        btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnClose.addActionListener(new CloseAction());
        btnClose.setMnemonic(67);
        buttonsPanel.add(btnClose);
        JButton btnHelp = new JButton(this.getHelpAction());
        btnHelp.setMnemonic(72);
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        buttonsPanel.add(btnHelp);
        this.mainPanel.add((Component)buttonsPanel, "South");
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("StandardReportsConfigurationDialog.StandardReportConfiguration"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "REPORTS_CONFIGURATIONS_DIALOG";
    }

    boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    private DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                String s1 = list.get(i).toString();
                String s2 = list.get(i - 1).toString();
                if (s1.toString().compareTo(s2.toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private DefaultListModel sortSRC(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                String s1 = ((StandardReportConfiguration)list.get(i)).getName().toString();
                String s2 = ((StandardReportConfiguration)list.get(i - 1)).getName().toString();
                if (s1.toString().compareTo(s2.toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private void newFilter(JTextField filterText, JTable currentTable) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), 0);
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    private void reloadObjects() {
        try {
            this.currentObjectsList.clear();
            this.objectsTable.updateUI();
            ArrayList<ReportsGenerationDialog.ReportObject> objectsFromsubviewsList = new ArrayList<ReportsGenerationDialog.ReportObject>();
            if (this.selectedSubviewsList.getModel().getSize() > 0) {
                for (int i = 0; i < this.selectedSubviewsList.getModel().getSize(); ++i) {
                    Object currentSubView = this.selectedSubviewsList.getModel().getElementAt(i);
                    if (currentSubView instanceof DesignPartViewPlaceHolder) {
                        DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)currentSubView;
                        for (TopView tv : ph.getDesignPartView().getTopviewsList()) {
                            DesignObject desObj = tv.getModel();
                            for (ReportsGenerationDialog.ReportObject ro : this.initialObjectsList) {
                                if (!desObj.getObjectID().equals(ro.getObjectUniqueIdentifier()) || objectsFromsubviewsList.contains(ro)) continue;
                                ro.setSubviewUniqueIdentifier(ph.getObjectID());
                                objectsFromsubviewsList.add(ro);
                            }
                        }
                        continue;
                    }
                    if (!(currentSubView instanceof ReportsGenerationDialog.RSchemaSubView)) continue;
                    ReportsGenerationDialog.RSchemaSubView sw = (ReportsGenerationDialog.RSchemaSubView)currentSubView;
                    for (ReportsGenerationDialog.ReportObject ro : this.initialObjectsList) {
                        if (!sw.getObjectOVID().equals(ro.getSubviewUniqueIdentifier())) continue;
                        objectsFromsubviewsList.add(ro);
                    }
                }
                this.currentObjectsList.addAll(objectsFromsubviewsList);
            } else {
                this.currentObjectsList.addAll(this.initialObjectsList);
            }
            ((ObjectsModel)this.objectsTable.getModel()).fireTableDataChanged();
            this.objectsTable.updateUI();
        }
        catch (Exception ex) {
            LOGGER.error(" Standard Report Config dialog - reload objects ", ex);
        }
    }

    @Override
    protected boolean canClose() {
        if (!this.isSaved) {
            String s1 = "Yes";
            String s2 = "No";
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("StandardReportsConfigurationDialog.NotSaved"), Messages.getString("StandardReportsConfigurationDialog.ClosConfirmation"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    private String generateName() {
        String name = TEMPLATE_NAME;
        int newNumber = 0;
        int lastNumber = this.standardReportsModel.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String nName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.nameExistsInModel(nName, null)) {
            newNumber = ++this.cgCounter;
            nName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return nName;
    }

    private boolean nameExistsInModel(String name, StandardReportConfiguration current) {
        for (int i = 0; i < this.standardReportsModel.size(); ++i) {
            StandardReportConfiguration rc = (StandardReportConfiguration)this.standardReportsModel.get(i);
            if (rc == current || !rc.getModelID().equals(this.modelObjId) || !rc.getDesignID().equals(this.designObjId) || rc.getClazz() != this.clazz || !name.equalsIgnoreCase(rc.getName())) continue;
            return true;
        }
        return false;
    }

    private void loadReportConfigurations() {
        this.standardReportsModel.clear();
        for (StandardReportConfiguration sr : this.allConfigurationsList) {
            if (!this.designObjId.equals(sr.getDesignID()) || !this.modelObjId.equals(sr.getModelID()) || sr.getClazz() != this.clazz) continue;
            this.standardReportsModel.addElement(sr);
        }
        this.sortSRC(this.standardReportsModel);
        if (this.standardReportsModel.getSize() > 0) {
            this.standardReportConfigurationsList.setSelectedIndex(0);
        }
    }

    private void showDetails(StandardReportConfiguration r) {
        this.txtName.setText(r.getName());
        this.description.setText(r.getDescription());
        this.chbIncludeDuplicates.setSelected(r.isIncludeDuplicates());
        if (r.getSubviews().size() > 0) {
            this.rbChooseObjects.setSelected(true);
            this.chbIncludeDuplicates.setEnabled(false);
            this.subviewsList.setEnabled(false);
            this.selectedSubviewsList.setEnabled(false);
            this.subviewsFilter.setEnabled(false);
            this.initData();
            ArrayList<Object> tempList = new ArrayList<Object>();
            block0: for (String swID : r.getSubviews()) {
                Iterator allSWIt = null;
                if (this.isLD) {
                    allSWIt = ((SubViewObjectSet)this.allAvailableSubViewsList).iterator();
                    while (allSWIt.hasNext()) {
                        DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)allSWIt.next();
                        if (!designPartViewPlaceHolder.getObjectID().equals(swID)) continue;
                        this.selectedSubviewsListModel.addElement(designPartViewPlaceHolder);
                        tempList.add(designPartViewPlaceHolder);
                        continue block0;
                    }
                    continue;
                }
                for (ReportsGenerationDialog.RSchemaSubView rSchemaSubView : (List)this.allAvailableSubViewsList) {
                    if (!rSchemaSubView.getObjectOVID().equals(swID)) continue;
                    this.selectedSubviewsListModel.addElement(rSchemaSubView);
                    tempList.add(rSchemaSubView);
                    continue block0;
                }
            }
            SubViewsFilterModel subViewsFilterModel = (SubViewsFilterModel)this.subviewsList.getModel();
            for (Object e : tempList) {
                subViewsFilterModel.remove(e);
            }
            this.reloadObjects();
            for (ReportsGenerationDialog.ReportObject ro : this.currentObjectsList) {
                ro.setInReport(false);
                for (String objectId : r.getObjects()) {
                    if (!ro.getObjectUniqueIdentifier().equals(objectId)) continue;
                    ro.setInReport(true);
                }
            }
        } else {
            this.rbIncludeAll.setSelected(true);
            this.reloadObjects();
            for (ReportsGenerationDialog.ReportObject ro : this.currentObjectsList) {
                ro.setInReport(false);
                for (String objectId : r.getObjects()) {
                    if (!ro.getObjectUniqueIdentifier().equals(objectId)) continue;
                    ro.setInReport(true);
                }
            }
        }
    }

    private void checkAll(JTable table, List<ReportsGenerationDialog.ReportObject> objects, boolean checked) {
        int[] selected = table.getSelectedRows();
        if (selected.length > 0) {
            for (int i = selected.length - 1; i >= 0; --i) {
                ReportsGenerationDialog.ReportObject obj = this.currentObjectsList.get(table.convertRowIndexToModel(selected[i]));
                obj.setInReport(checked);
            }
        } else {
            this.selectAll(table, objects, checked);
        }
        table.updateUI();
    }

    private void selectAll(JTable table, List<ReportsGenerationDialog.ReportObject> objects, boolean selected) {
        if (selected) {
            this.selectAll(table, objects);
        } else {
            this.deselectAll(table, objects);
        }
    }

    private void selectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                ReportsGenerationDialog.ReportObject o = (ReportsGenerationDialog.ReportObject)list.get(index);
                this.setSelected(o, true);
            }
        } else {
            for (ReportsGenerationDialog.ReportObject o : list) {
                this.setSelected(o, true);
            }
        }
    }

    private void deselectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                ReportsGenerationDialog.ReportObject o = (ReportsGenerationDialog.ReportObject)list.get(index);
                this.setSelected(o, false);
            }
        } else {
            for (ReportsGenerationDialog.ReportObject o : list) {
                this.setSelected(o, false);
            }
        }
    }

    private void setSelected(ReportsGenerationDialog.ReportObject obj, boolean selected) {
        if (obj != null) {
            obj.setInReport(selected);
        }
    }

    private static boolean match(String string, String regex) {
        if ("*".equalsIgnoreCase(regex)) {
            return true;
        }
        if (regex.indexOf(42) > -1) {
            regex = regex.replaceAll("\\*", "\\.*");
        }
        Pattern p = null;
        try {
            p = Pattern.compile(regex, 2);
            Matcher m = p.matcher(string);
            return m.find();
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }

    private class SelectedSubViewsModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();

        private SelectedSubViewsModel() {
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        private List getItems() {
            return this.items;
        }

        @Override
        public Object getElementAt(int index) {
            return this.items.get(index);
        }

        private void clear() {
            this.items.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private boolean contains(Object element) {
            return this.items.contains(element);
        }

        private void addElement(Object o) {
            this.items.add(o);
            this.fireIntervalAdded(this, 0, this.getSize());
        }

        private void removeElement(Object o) {
            this.items.remove(o);
            this.fireIntervalRemoved(this, 0, this.getSize());
        }
    }

    private class SubViewsFilterModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();
        ArrayList filterItems = new ArrayList();

        @Override
        public Object getElementAt(int index) {
            if (index < this.filterItems.size()) {
                return this.filterItems.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.filterItems.size();
        }

        private void add(Object o) {
            this.filterItems.add(o);
            StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.add(o);
            this.fireIntervalAdded(this, 0, this.getSize());
            Collections.sort(this.filterItems, StandardReportsConfigurationDialog.this.toStringComparator);
        }

        private void remove(Object o) {
            this.filterItems.remove(o);
            StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.remove(o);
            this.fireIntervalRemoved(this, 0, this.getSize());
        }

        private void refilter() {
            this.filterItems.clear();
            String term = StandardReportsConfigurationDialog.this.subviewsFilter.getText();
            for (int i = 0; i < StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.size(); ++i) {
                String name = "";
                name = StandardReportsConfigurationDialog.this.isLD ? ((DesignPartViewPlaceHolder)StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.get(i)).getName() : ((ReportsGenerationDialog.RSchemaSubView)StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.get(i)).getName();
                if (StandardReportsConfigurationDialog.match(name, term)) {
                    this.filterItems.add(StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.get(i));
                }
                this.fireContentsChanged(this, 0, this.getSize());
            }
            Collections.sort(this.filterItems, StandardReportsConfigurationDialog.this.toStringComparator);
        }

        public Object getObjectByID(String id) {
            for (Object obj : this.filterItems) {
                String objID = "";
                if (obj instanceof DesignPartViewPlaceHolder) {
                    DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)obj;
                    objID = ph.getObjectID();
                } else if (obj instanceof ReportsGenerationDialog.RSchemaSubView) {
                    ReportsGenerationDialog.RSchemaSubView rs = (ReportsGenerationDialog.RSchemaSubView)obj;
                    objID = rs.getObjectOVID();
                }
                if (!objID.equals(id)) continue;
                return obj;
            }
            return "";
        }

        private void setInitialState() {
            this.filterItems.addAll(this.items);
            Collections.sort(this.filterItems, StandardReportsConfigurationDialog.this.toStringComparator);
            StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.addAll(this.items);
        }

        private void addElement(Object o) {
            this.items.add(o);
        }

        private void clear() {
            this.items.clear();
            this.filterItems.clear();
            StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private boolean contains(Object element) {
            return this.filterItems.contains(element);
        }
    }

    class FilteredSUbViewsJList
    extends JList {
        public FilteredSUbViewsJList() {
            this.setModel((ListModel)new SubViewsFilterModel());
        }

        public void setModel(ListModel m) {
            if (!(m instanceof SubViewsFilterModel)) {
                throw new IllegalArgumentException();
            }
            super.setModel(m);
        }
    }

    private class StandardReportConfigsListSelectionHandler
    implements ListSelectionListener {
        private StandardReportConfigsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int selected = StandardReportsConfigurationDialog.this.standardReportConfigurationsList.getSelectedIndex();
                if (selected == -1) {
                    StandardReportsConfigurationDialog.this.btnAdd.setEnabled(true);
                    StandardReportsConfigurationDialog.this.btnEdit.setEnabled(false);
                    StandardReportsConfigurationDialog.this.btnRemove.setEnabled(false);
                    StandardReportsConfigurationDialog.this.btnSave.setEnabled(false);
                    StandardReportsConfigurationDialog.this.subviewsList.setEnabled(false);
                    StandardReportsConfigurationDialog.this.selectedSubviewsList.setEnabled(false);
                } else {
                    StandardReportsConfigurationDialog.this.btnAdd.setEnabled(true);
                    StandardReportsConfigurationDialog.this.btnEdit.setEnabled(true);
                    StandardReportsConfigurationDialog.this.btnRemove.setEnabled(true);
                    StandardReportsConfigurationDialog.this.btnSave.setEnabled(false);
                    StandardReportsConfigurationDialog.this.editedStandardReportConfiguration = (StandardReportConfiguration)StandardReportsConfigurationDialog.this.standardReportsModel.get(StandardReportsConfigurationDialog.this.standardReportConfigurationsList.getSelectedIndex());
                    StandardReportsConfigurationDialog.this.showDetails(StandardReportsConfigurationDialog.this.editedStandardReportConfiguration);
                }
            }
        }
    }

    private class SelectedSubviewsRenderer
    extends JLabel
    implements ListCellRenderer {
        private SelectedSubviewsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DesignPartViewPlaceHolder) {
                this.setText(((DesignPartViewPlaceHolder)value).getName());
            } else if (value instanceof ReportsGenerationDialog.RSchemaSubView) {
                this.setText(((ReportsGenerationDialog.RSchemaSubView)value).getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class AllSubviewsRenderer
    extends JLabel
    implements ListCellRenderer {
        private AllSubviewsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DesignPartViewPlaceHolder) {
                this.setText(((DesignPartViewPlaceHolder)value).getName());
            } else if (value instanceof ReportsGenerationDialog.RSchemaSubView) {
                this.setText(((ReportsGenerationDialog.RSchemaSubView)value).getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class ReportsConfigurationRenderer
    extends JLabel
    implements ListCellRenderer {
        private ReportsConfigurationRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            StandardReportConfiguration r = (StandardReportConfiguration)value;
            this.setText(r.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class EditAction
    implements ActionListener {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardReportsConfigurationDialog.this.description.setEnabled(true);
            StandardReportsConfigurationDialog.this.txtName.setEnabled(true);
            StandardReportsConfigurationDialog.this.rbIncludeAll.setEnabled(true);
            StandardReportsConfigurationDialog.this.rbChooseObjects.setEnabled(true);
            StandardReportsConfigurationDialog.this.objectsFilter.setEnabled(true);
            StandardReportsConfigurationDialog.this.objectsTable.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnSelectAll.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnDeselectAll.setEnabled(true);
            StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnAdd.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnEdit.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnSave.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnRemove.setEnabled(false);
            if (StandardReportsConfigurationDialog.this.rbChooseObjects.isSelected()) {
                StandardReportsConfigurationDialog.this.subviewsFilter.setEnabled(true);
                StandardReportsConfigurationDialog.this.subviewsList.setEnabled(true);
                StandardReportsConfigurationDialog.this.selectedSubviewsList.setEnabled(true);
                StandardReportsConfigurationDialog.this.chbIncludeDuplicates.setEnabled(true);
                StandardReportsConfigurationDialog.this.chbIncludeDuplicates.setSelected(true);
            } else {
                StandardReportsConfigurationDialog.this.subviewsFilter.setEnabled(false);
                StandardReportsConfigurationDialog.this.subviewsList.clearSelection();
                StandardReportsConfigurationDialog.this.subviewsList.setEnabled(false);
                StandardReportsConfigurationDialog.this.selectedSubviewsList.clearSelection();
                StandardReportsConfigurationDialog.this.selectedSubviewsList.setEnabled(false);
                StandardReportsConfigurationDialog.this.chbIncludeDuplicates.setEnabled(false);
            }
            StandardReportsConfigurationDialog.this.objectsSorter.setSortsOnUpdates(true);
            if (StandardReportsConfigurationDialog.this.currentObjectsList.size() > 0) {
                StandardReportsConfigurationDialog.this.objectsTable.setRowSorter(StandardReportsConfigurationDialog.this.objectsSorter);
                StandardReportsConfigurationDialog.this.objectsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(StandardReportsConfigurationDialog.this.objectsTable, 0);
            }
            StandardReportsConfigurationDialog.this.isSaved = false;
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (StandardReportsConfigurationDialog.this.txtName.getText().equals("")) {
                    JOptionPane.showMessageDialog(StandardReportsConfigurationDialog.this.srd, Messages.getString("StandardReportsConfigurationDialog.NameCanNotBeEmpty"), Messages.getString("StandardReportsConfigurationDialog.Error"), 0);
                    StandardReportsConfigurationDialog.this.txtName.requestFocus();
                } else {
                    StandardReportConfiguration rc = (StandardReportConfiguration)StandardReportsConfigurationDialog.this.standardReportsModel.get(StandardReportsConfigurationDialog.this.standardReportConfigurationsList.getSelectedIndex());
                    String name = StandardReportsConfigurationDialog.this.txtName.getText();
                    int counter = 0;
                    while (StandardReportsConfigurationDialog.this.nameExistsInModel(name, rc)) {
                        name = StandardReportsConfigurationDialog.this.txtName.getText().concat("_").concat(Integer.toString(++counter));
                    }
                    rc.setName(name);
                    rc.setDescription(StandardReportsConfigurationDialog.this.description.getText());
                    rc.setIncludeDuplicates(StandardReportsConfigurationDialog.this.chbIncludeDuplicates.isSelected());
                    List<String> sw = rc.getSubviews();
                    sw.clear();
                    for (Object obj : StandardReportsConfigurationDialog.this.selectedSubviewsListModel.getItems()) {
                        String id = "";
                        if (obj instanceof DesignPartViewPlaceHolder) {
                            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)obj;
                            id = ph.getObjectID();
                        } else if (obj instanceof ReportsGenerationDialog.RSchemaSubView) {
                            ReportsGenerationDialog.RSchemaSubView rs = (ReportsGenerationDialog.RSchemaSubView)obj;
                            id = rs.getObjectOVID();
                        }
                        sw.add(id);
                    }
                    List objs = rc.getObjects();
                    objs.clear();
                    for (ReportsGenerationDialog.ReportObject ro : StandardReportsConfigurationDialog.this.currentObjectsList) {
                        if (!ro.isInReport()) continue;
                        objs.add(ro.getObjectUniqueIdentifier());
                    }
                    boolean found = false;
                    for (StandardReportConfiguration rcf : StandardReportsConfigurationDialog.this.allConfigurationsList) {
                        if (!rc.getModelID().equals(rcf.getModelID()) || !rc.getDesignID().equals(rcf.getDesignID()) || rc.getClazz() != StandardReportsConfigurationDialog.this.clazz || !rc.getName().equalsIgnoreCase(rcf.getName())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        StandardReportsConfigurationDialog.this.allConfigurationsList.add(rc);
                    }
                    StandardReportsConfigurationDialog.this.standardReportPersistence.saveStandardReportConfigurations();
                    StandardReportsConfigurationDialog.this.parent.reloadReportConfigurations(StandardReportsConfigurationDialog.this.isLD);
                    StandardReportsConfigurationDialog.this.txtName.setEnabled(false);
                    StandardReportsConfigurationDialog.this.description.setEnabled(false);
                    StandardReportsConfigurationDialog.this.rbIncludeAll.setEnabled(false);
                    StandardReportsConfigurationDialog.this.rbIncludeAll.setSelected(false);
                    StandardReportsConfigurationDialog.this.rbChooseObjects.setEnabled(false);
                    StandardReportsConfigurationDialog.this.objectsTable.setEnabled(false);
                    StandardReportsConfigurationDialog.this.objectsFilter.setEnabled(false);
                    StandardReportsConfigurationDialog.this.subviewsFilter.setEnabled(false);
                    StandardReportsConfigurationDialog.this.btnSelectAll.setEnabled(false);
                    StandardReportsConfigurationDialog.this.btnDeselectAll.setEnabled(false);
                    StandardReportsConfigurationDialog.this.subviewsList.clearSelection();
                    StandardReportsConfigurationDialog.this.subviewsList.setEnabled(false);
                    StandardReportsConfigurationDialog.this.selectedSubviewsList.clearSelection();
                    StandardReportsConfigurationDialog.this.selectedSubviewsList.setEnabled(false);
                    StandardReportsConfigurationDialog.this.btnSave.setEnabled(false);
                    StandardReportsConfigurationDialog.this.btnAdd.setEnabled(true);
                    StandardReportsConfigurationDialog.this.btnEdit.setEnabled(true);
                    StandardReportsConfigurationDialog.this.btnRemove.setEnabled(true);
                    StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setEnabled(true);
                    StandardReportsConfigurationDialog.this.manuallyClicked = true;
                    StandardReportsConfigurationDialog.this.sortSRC(StandardReportsConfigurationDialog.this.standardReportsModel);
                    StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setSelectedValue(rc, true);
                    StandardReportsConfigurationDialog.this.objectsTable.setRowSorter(null);
                    StandardReportsConfigurationDialog.this.objectsTable.setAutoCreateRowSorter(false);
                    StandardReportsConfigurationDialog.this.objectsTable.updateUI();
                }
                StandardReportsConfigurationDialog.this.isSaved = true;
            }
            catch (Exception ex) {
                LOGGER.error(" Standard Report Config dialog - Error when save ", ex);
            }
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardReportConfiguration src = (StandardReportConfiguration)StandardReportsConfigurationDialog.this.standardReportsModel.get(StandardReportsConfigurationDialog.this.standardReportConfigurationsList.getSelectedIndex());
            int result = JOptionPane.showConfirmDialog(StandardReportsConfigurationDialog.this, MessageFormat.format(Messages.getString("CustomizableReportsTemplatesDialog.AreYouSure"), src.getName()), Messages.getString("CustomizableReportsTemplatesDialog.SelectAnOption"), 0);
            if (result == 0) {
                StandardReportsConfigurationDialog.this.standardReportsModel.remove(StandardReportsConfigurationDialog.this.standardReportConfigurationsList.getSelectedIndex());
                for (StandardReportConfiguration rc : StandardReportsConfigurationDialog.this.allConfigurationsList) {
                    if (rc.getReportId() != src.getReportId()) continue;
                    StandardReportsConfigurationDialog.this.allConfigurationsList.remove(rc);
                    StandardReportsConfigurationDialog.this.standardReportPersistence.saveStandardReportConfigurations();
                    StandardReportsConfigurationDialog.this.parent.reloadReportConfigurations(StandardReportsConfigurationDialog.this.isLD);
                    break;
                }
                if (StandardReportsConfigurationDialog.this.standardReportConfigurationsList.getModel().getSize() > 0) {
                    StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setSelectedIndex(0);
                }
            }
            StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setEnabled(true);
            StandardReportsConfigurationDialog.this.txtName.setEnabled(false);
            StandardReportsConfigurationDialog.this.description.setEnabled(false);
            StandardReportsConfigurationDialog.this.rbChooseObjects.setEnabled(false);
            StandardReportsConfigurationDialog.this.rbIncludeAll.setEnabled(false);
            StandardReportsConfigurationDialog.this.objectsFilter.setEnabled(false);
            StandardReportsConfigurationDialog.this.objectsTable.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnSelectAll.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnDeselectAll.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnSave.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnAdd.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnEdit.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnRemove.setEnabled(true);
            StandardReportsConfigurationDialog.this.isSaved = true;
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = StandardReportsConfigurationDialog.this.generateName();
            ArrayList<String> objectIDs = new ArrayList<String>();
            for (ReportsGenerationDialog.ReportObject ro : StandardReportsConfigurationDialog.this.currentObjectsList) {
                objectIDs.add(ro.getObjectUniqueIdentifier());
            }
            StandardReportConfiguration report = new StandardReportConfiguration(StandardReportsConfigurationDialog.this.clazz, name, "", StandardReportsConfigurationDialog.this.designObjId, StandardReportsConfigurationDialog.this.modelObjId, true, new ArrayList(), objectIDs);
            StandardReportsConfigurationDialog.this.standardReportsModel.addElement(report);
            StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setSelectedValue(report, true);
            StandardReportsConfigurationDialog.this.manuallyClicked = true;
            StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setEnabled(false);
            StandardReportsConfigurationDialog.this.objectsTable.setEnabled(true);
            StandardReportsConfigurationDialog.this.objectsFilter.setEnabled(true);
            StandardReportsConfigurationDialog.this.txtName.setText(name);
            StandardReportsConfigurationDialog.this.txtName.setEnabled(true);
            StandardReportsConfigurationDialog.this.description.setText("");
            StandardReportsConfigurationDialog.this.description.setEnabled(true);
            StandardReportsConfigurationDialog.this.rbIncludeAll.setEnabled(true);
            StandardReportsConfigurationDialog.this.rbIncludeAll.setSelected(true);
            StandardReportsConfigurationDialog.this.rbChooseObjects.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnSelectAll.setSelected(true);
            StandardReportsConfigurationDialog.this.btnDeselectAll.setSelected(true);
            StandardReportsConfigurationDialog.this.rbIncludeAll.setSelected(true);
            StandardReportsConfigurationDialog.this.btnSelectAll.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnDeselectAll.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnAdd.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnEdit.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnRemove.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnSave.setEnabled(true);
            StandardReportsConfigurationDialog.this.objectsSorter.setSortsOnUpdates(true);
            if (StandardReportsConfigurationDialog.this.currentObjectsList.size() > 0) {
                StandardReportsConfigurationDialog.this.objectsTable.setRowSorter(StandardReportsConfigurationDialog.this.objectsSorter);
                StandardReportsConfigurationDialog.this.objectsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(StandardReportsConfigurationDialog.this.objectsTable, 0);
            }
            StandardReportsConfigurationDialog.this.isSaved = false;
        }
    }

    private class FilterObjectListener
    implements DocumentListener {
        private FilterObjectListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            StandardReportsConfigurationDialog.this.newFilter(StandardReportsConfigurationDialog.this.objectsFilter, StandardReportsConfigurationDialog.this.objectsTable);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            StandardReportsConfigurationDialog.this.newFilter(StandardReportsConfigurationDialog.this.objectsFilter, StandardReportsConfigurationDialog.this.objectsTable);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            StandardReportsConfigurationDialog.this.newFilter(StandardReportsConfigurationDialog.this.objectsFilter, StandardReportsConfigurationDialog.this.objectsTable);
        }
    }

    private class SubViewsFilterListener
    implements DocumentListener {
        private SubViewsFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ((SubViewsFilterModel)StandardReportsConfigurationDialog.this.subviewsList.getModel()).refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ((SubViewsFilterModel)StandardReportsConfigurationDialog.this.subviewsList.getModel()).refilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ((SubViewsFilterModel)StandardReportsConfigurationDialog.this.subviewsList.getModel()).refilter();
        }
    }

    public class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean val = (Boolean)value;
            this.setSelected(val);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private class RadioButtonListener
    implements ItemListener {
        private RadioButtonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (StandardReportsConfigurationDialog.this.rbIncludeAll.isSelected()) {
                    StandardReportsConfigurationDialog.this.subviewsList.clearSelection();
                    StandardReportsConfigurationDialog.this.subviewsList.setEnabled(false);
                    StandardReportsConfigurationDialog.this.subviewsFilter.setEnabled(false);
                    StandardReportsConfigurationDialog.this.selectedSubviewsList.setEnabled(false);
                    StandardReportsConfigurationDialog.this.selectedSubviewsList.clearSelection();
                    StandardReportsConfigurationDialog.this.selectedSubviewsList.removeAll();
                    StandardReportsConfigurationDialog.this.chbIncludeDuplicates.setSelected(false);
                    StandardReportsConfigurationDialog.this.chbIncludeDuplicates.setEnabled(false);
                    StandardReportsConfigurationDialog.this.initData();
                }
                if (StandardReportsConfigurationDialog.this.rbChooseObjects.isSelected()) {
                    StandardReportsConfigurationDialog.this.subviewsList.setEnabled(true);
                    StandardReportsConfigurationDialog.this.subviewsFilter.setEnabled(true);
                    StandardReportsConfigurationDialog.this.selectedSubviewsList.setEnabled(true);
                    StandardReportsConfigurationDialog.this.chbIncludeDuplicates.setEnabled(true);
                    StandardReportsConfigurationDialog.this.chbIncludeDuplicates.setSelected(true);
                }
            }
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StandardReportsConfigurationDialog.this.canClose()) {
                StandardReportsConfigurationDialog.this.close();
            }
        }
    }

    private class RemoveSubviewActionListener
    implements ActionListener {
        private RemoveSubviewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ArrayList removalList = new ArrayList();
                ArrayList selectedObjects = new ArrayList();
                int[] selectedSubviewsIndices = StandardReportsConfigurationDialog.this.selectedSubviewsList.getSelectedIndices();
                for (int i = 0; i < selectedSubviewsIndices.length; ++i) {
                    Object o = StandardReportsConfigurationDialog.this.selectedSubviewsList.getModel().getElementAt(selectedSubviewsIndices[i]);
                    selectedObjects.add(o);
                    if (((SubViewsFilterModel)StandardReportsConfigurationDialog.this.subviewsList.getModel()).contains(o)) continue;
                    ((SubViewsFilterModel)StandardReportsConfigurationDialog.this.subviewsList.getModel()).add(o);
                    removalList.add(o);
                }
                Iterator it = removalList.iterator();
                while (it.hasNext()) {
                    StandardReportsConfigurationDialog.this.selectedSubviewsListModel.removeElement(it.next());
                }
                StandardReportsConfigurationDialog.this.reloadObjects();
                StandardReportsConfigurationDialog.this.isSaved = false;
                StandardReportsConfigurationDialog.this.btnSave.setEnabled(true);
            }
            catch (Exception ex) {
                LOGGER.error(" Standard Report Config dialog - Error when deselecting subview ", ex);
            }
        }
    }

    private class AddSubviewActionListener
    implements ActionListener {
        private AddSubviewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ArrayList selectedObjects = new ArrayList();
                ArrayList removalList = new ArrayList();
                int[] selectedSubviewsIndices = StandardReportsConfigurationDialog.this.subviewsList.getSelectedIndices();
                for (int i = 0; i < selectedSubviewsIndices.length; ++i) {
                    Object o = StandardReportsConfigurationDialog.this.subviewsList.getModel().getElementAt(selectedSubviewsIndices[i]);
                    selectedObjects.add(o);
                    if (StandardReportsConfigurationDialog.this.selectedSubviewsListModel.contains(o)) continue;
                    StandardReportsConfigurationDialog.this.selectedSubviewsListModel.addElement(o);
                    removalList.add(o);
                }
                SubViewsFilterModel subViewsFilterModel = (SubViewsFilterModel)StandardReportsConfigurationDialog.this.subviewsList.getModel();
                Iterator it = removalList.iterator();
                while (it.hasNext()) {
                    subViewsFilterModel.remove(it.next());
                }
                StandardReportsConfigurationDialog.this.reloadObjects();
                StandardReportsConfigurationDialog.this.isSaved = false;
                StandardReportsConfigurationDialog.this.btnSave.setEnabled(true);
            }
            catch (Exception ex) {
                LOGGER.error(" Standard Report Config dialog - Error when selecting subview ", ex);
            }
        }
    }

    private class ObjectsModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("StandardReportsConfigurationDialog.ObjectName"), Messages.getString("StandardReportsConfigurationDialog.Use")};

        private ObjectsModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public int getRowCount() {
            return StandardReportsConfigurationDialog.this.currentObjectsList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return ReportsGenerationDialog.ReportObject.class;
            }
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ReportsGenerationDialog.ReportObject o = (ReportsGenerationDialog.ReportObject)StandardReportsConfigurationDialog.this.currentObjectsList.get(rowIndex);
            if (columnIndex == 0) {
                return o.getObjectName();
            }
            if (columnIndex == 1) {
                return o.isInReport();
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ReportsGenerationDialog.ReportObject o = (ReportsGenerationDialog.ReportObject)StandardReportsConfigurationDialog.this.currentObjectsList.get(row);
            if (col == 1) {
                o.setInReport((Boolean)value);
                StandardReportsConfigurationDialog.this.isSaved = false;
                StandardReportsConfigurationDialog.this.btnSave.setEnabled(true);
            }
        }
    }
}

