/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

public class FileUtils {
    public static final String SEPARATOR = "...";

    public static String longToShortPath(String path, int limit) {
        int free;
        int i;
        if (path == null) {
            return "";
        }
        if (path.length() <= limit) {
            return path;
        }
        char[] shortPathArray = new char[limit];
        char[] pathArray = path.toCharArray();
        char[] separatorArray = SEPARATOR.toCharArray();
        int pathindex = pathArray.length - 1;
        int shortpathindex = limit - 1;
        for (i = 0; i <= limit; ++i) {
            if (pathArray[pathindex - i] == '/' || pathArray[pathindex - i] == '\\') {
                shortPathArray[shortpathindex - i] = pathArray[pathindex - i];
                break;
            }
            shortPathArray[shortpathindex - i] = pathArray[pathindex - i];
        }
        if ((free = limit - i) < SEPARATOR.length()) {
            for (int j = 0; j < separatorArray.length; ++j) {
                shortPathArray[j] = separatorArray[j];
            }
        } else {
            int j = 0;
            while (j + separatorArray.length < free - 1) {
                shortPathArray[j] = pathArray[j];
                ++j;
            }
            int k = 0;
            while (j + k < free - 1) {
                shortPathArray[j + k] = separatorArray[k];
                ++k;
            }
        }
        return new String(shortPathArray);
    }

    public static String addLastSlash(String path) {
        if (!path.endsWith("/")) {
            return path.concat("/");
        }
        return path;
    }

    public static String fixPath(String path) {
        if (path != null) {
            return path.replaceAll("[\\\\]", "/");
        }
        return path;
    }

    public static String removeExt(String name) {
        int dotPos = name.lastIndexOf(46);
        if (dotPos == -1) {
            return name;
        }
        return name.substring(0, dotPos);
    }
}

