/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.propertymap;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectPropertyTranslator;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.propertymap.PropertyMapComparer;
import oracle.dbtools.crest.util.propertymap.PropertyTranslator;

public class PropertyMapWrapper
implements PropertyMap,
Cloneable {
    public static final String KEY_PREFIX = "object.property.auto.";
    private static final PropertyTranslator[] EMPTY_TRANSLATORS = new PropertyTranslator[0];
    private boolean printErrors = false;
    private static final Logger LOGGER = new Logger(PropertyMapWrapper.class);
    private static PropertyTranslator[] sharedTranslators = new PropertyTranslator[]{new StringPropertyTranslator(), new ShortPropertyTranslator(), new IntegerPropertyTranslator(), new LongPropertyTranslator(), new FloatPropertyTranslator(), new DoublePropertyTranslator(), new BooleanPropertyTranslator()};
    private PropertyTranslator[] translators = EMPTY_TRANSLATORS;
    private Object wrappee = null;
    private Class wrappeeClass = Object.class;
    private PropertyMap delegatePropertyMap = PropertyMap.NULL_INSTANCE;
    private Class baseClass = Object.class;
    private Map accessorMap;

    protected Map getAccessorMap() {
        return this.accessorMap;
    }

    public void setWrappeeClass(Class c) {
        if (!this.getBaseClass().isAssignableFrom(c)) {
            throw new IllegalStateException("baseClass is not a super class of wrappee class.");
        }
        this.wrappeeClass = c == null ? Object.class : c;
        this.discoverMethods();
    }

    public Class getWrappeeClass() {
        return this.wrappeeClass;
    }

    public void setBaseClass(Class c) {
        this.baseClass = c == null ? Object.class : c;
    }

    public Class getBaseClass() {
        return this.baseClass;
    }

    public void setWrappee(Object object) {
        if (object != null && this.getWrappeeClass().isAssignableFrom(object.getClass())) {
            this.wrappee = object;
            this.delegatePropertyMap = this.wrappee instanceof PropertyMap ? (PropertyMap)this.wrappee : PropertyMap.NULL_INSTANCE;
        } else if (object == null) {
            this.wrappee = null;
            this.delegatePropertyMap = PropertyMap.NULL_INSTANCE;
        }
    }

    public Object getWrappee() {
        return this.wrappee;
    }

    private void discoverMethods() {
        try {
            Method[] methods = this.wrappeeClass.getMethods();
            HashMap setters = new HashMap();
            HashMap getters = new HashMap();
            HashMap isers = new HashMap();
            for (int i = 0; i < methods.length; ++i) {
                if (!this.isAccepted(methods[i])) continue;
                if (methods[i].getName().startsWith("set")) {
                    this.addToMap(methods[i], setters, 3);
                    continue;
                }
                if (methods[i].getName().startsWith("get")) {
                    this.addToMap(methods[i], getters, 3);
                    continue;
                }
                if (!methods[i].getName().startsWith("is")) continue;
                this.addToMap(methods[i], isers, 2);
            }
            this.accessorMap = new TreeMap();
            this.constructMapping(getters, isers, setters);
        }
        catch (SecurityException e) {
            LOGGER.error("Can not discover methods: ", e);
        }
    }

    private void addToMap(Method method, Map map, int prefixLength) {
        String name = method.getName().substring(prefixLength);
        map.put(name, method);
    }

    private void constructMapping(Map getters, Map isers, Map setters) {
        StringBuffer buffer = new StringBuffer();
        Iterator it = setters.keySet().iterator();
        while (it.hasNext()) {
            buffer.setLength(0);
            String name = (String)it.next();
            Method setter = (Method)setters.get(name);
            Method getter = null;
            if (getters.containsKey(name)) {
                getter = (Method)getters.get(name);
            } else if (isers.containsKey(name)) {
                getter = (Method)isers.get(name);
            }
            if (getter == null || setter == null) continue;
            Class<?> returnType = getter.getReturnType();
            Class<?> singleArgument = setter.getParameterTypes()[0];
            PropertyTranslator translator = this.getPropertyTranslatorFor(singleArgument);
            if (translator == null) continue;
            if (translator.isStatefull()) {
                int position = this.getPosition(translator);
                if (position != -1) {
                    translator = new ArrayPositionWrapper(position);
                } else if (this.getPrintErrors()) {
                    LOGGER.error("A statefull PropertyTranslator is not in array: " + translator.getClass());
                }
            }
            if (!returnType.equals(singleArgument)) continue;
            AccessorPair pair = new AccessorPair();
            pair.setSetter(setter);
            pair.setGetter(getter);
            pair.setPropertyTranslator(translator);
            buffer.append(KEY_PREFIX);
            buffer.append(name);
            name = buffer.toString();
            this.accessorMap.put(name, pair);
        }
    }

    public void setPrintErrors(boolean value) {
        this.printErrors = value;
    }

    public boolean getPrintErrors() {
        return this.printErrors;
    }

    protected boolean isAccepted(Method method) {
        boolean result = this.isPublicNonStaticMethod(method) && this.isBelowBaseClass(method) && (this.hasSingleArgument(method) || this.hasNoArgument(method) && !this.hasVoidReturn(method));
        return result;
    }

    protected boolean hasSingleArgument(Method method) {
        return method.getParameterTypes().length == 1;
    }

    protected boolean hasNoArgument(Method method) {
        return method.getParameterTypes().length == 0;
    }

    protected boolean hasVoidReturn(Method method) {
        return Void.TYPE.equals(method.getReturnType());
    }

    protected boolean isBelowBaseClass(Method method) {
        return this.getBaseClass().isAssignableFrom(method.getDeclaringClass());
    }

    protected boolean isPublicNonStaticMethod(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers);
    }

    public boolean hasAccessorPair(String key) {
        return this.accessorMap.containsKey(key);
    }

    protected AccessorPair getAccessorPair(String key) {
        return (AccessorPair)this.accessorMap.get(key);
    }

    @Override
    public void setProperty(String key, String value) {
        if (this.wrappee != null) {
            if (this.hasAccessorPair(key)) {
                AccessorPair pair = this.getAccessorPair(key);
                PropertyTranslator tr = pair.getPropertyTranslator();
                if (tr instanceof StorageObjectPropertyTranslator && this.wrappee instanceof StorageObject) {
                    ((StorageObjectPropertyTranslator)tr).setStorageDesign(((StorageObject)this.wrappee).getStorageDesign());
                }
                Method method = pair.getSetter();
                try {
                    method.invoke(this.wrappee, tr.translateFromString(value));
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("No access rights for setter method", e);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Illegal argument for setter", e);
                }
                catch (InvocationTargetException e) {
                    LOGGER.error("Invocation error for setter: ", e);
                }
            } else {
                this.delegatePropertyMap.setProperty(key, value);
            }
        }
    }

    @Override
    public String getProperty(String key) {
        if (this.wrappee != null) {
            if (this.hasAccessorPair(key)) {
                AccessorPair pair = this.getAccessorPair(key);
                Method method = pair.getGetter();
                try {
                    Object result = method.invoke(this.wrappee, new Object[0]);
                    return pair.getPropertyTranslator().translateToString(result);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("No access rights for getter method", e);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Illegal argument for getter", e);
                }
                catch (InvocationTargetException e) {
                    LOGGER.error("Invocation error for getter", e);
                }
            } else {
                return this.delegatePropertyMap.getProperty(key);
            }
        }
        return null;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.hasAccessorPair(key) || this.delegatePropertyMap.hasProperty(key);
    }

    @Override
    public boolean hasProperty(String key, String value) {
        return this.getProperty(key) != null;
    }

    @Override
    public void removeProperty(String key) {
        this.delegatePropertyMap.removeProperty(key);
    }

    @Override
    public void clearProperties() {
        this.delegatePropertyMap.clearProperties();
    }

    @Override
    public Iterator getPropertyNames() {
        ArrayList<String> list = new ArrayList<String>();
        PropertyNameIterator it = new PropertyNameIterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (list.contains(key)) continue;
            list.add(key);
        }
        return list.iterator();
    }

    public void setTranslators(PropertyTranslator[] translators) {
        int sizeBefore = this.translators.length;
        this.translators = translators != null ? translators : EMPTY_TRANSLATORS;
        int sizeAfter = this.translators.length;
        if (sizeAfter != sizeBefore) {
            this.discoverMethods();
        }
    }

    public PropertyTranslator[] getTranslators() {
        return this.translators;
    }

    protected PropertyTranslator getTranslator(int position) {
        if (position < this.getTranslators().length && position >= 0) {
            return this.getTranslators()[position];
        }
        throw new IllegalStateException("Trying to find a PropertyTranslator that is no longer available (position)");
    }

    public int getPosition(PropertyTranslator translator) {
        for (int i = 0; i < sharedTranslators.length; ++i) {
            if (sharedTranslators[i] != translator) continue;
            return i;
        }
        return -1;
    }

    private PropertyTranslator getPropertyTranslatorFor(Class cls) {
        int i;
        for (i = 0; i < sharedTranslators.length; ++i) {
            if (!sharedTranslators[i].canHandleClass(cls)) continue;
            return sharedTranslators[i];
        }
        for (i = 0; i < this.translators.length; ++i) {
            if (!this.translators[i].canHandleClass(cls)) continue;
            return this.translators[i];
        }
        return null;
    }

    public PropertyMapWrapper makeClone() {
        try {
            return (PropertyMapWrapper)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("PropertyMapWrapper should implement Cloneable", e);
            return null;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        TreeMap mapCopy;
        PropertyMapWrapper clone = (PropertyMapWrapper)super.clone();
        clone.accessorMap = mapCopy = new TreeMap(this.accessorMap);
        return clone;
    }

    public String toString() {
        return PropertyMapComparer.toString(this);
    }

    class PropertyNameIterator
    implements Iterator {
        private boolean propertyAccessors = true;
        private Iterator delegate = null;

        PropertyNameIterator() {
        }

        private Iterator getDelegate() {
            if (this.propertyAccessors && this.delegate == null) {
                this.delegate = PropertyMapWrapper.this.accessorMap.keySet().iterator();
            }
            return this.delegate;
        }

        @Override
        public boolean hasNext() {
            if (this.getDelegate().hasNext()) {
                return true;
            }
            if (this.propertyAccessors) {
                this.delegate = PropertyMapWrapper.this.delegatePropertyMap.getPropertyNames();
                this.propertyAccessors = false;
                return this.delegate.hasNext();
            }
            return false;
        }

        public Object next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("only allowed to read target reference");
        }
    }

    public static class BooleanPropertyTranslator
    extends StringPropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            return string.equalsIgnoreCase(Boolean.TRUE.toString()) ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public boolean canHandleClass(Class cls) {
            return Boolean.TYPE.equals(cls) || Boolean.class.equals((Object)cls);
        }
    }

    public static class DoublePropertyTranslator
    extends StringPropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException e) {
                return new Double(0.0);
            }
        }

        @Override
        public boolean canHandleClass(Class cls) {
            return Double.TYPE.equals(cls) || Double.class.equals((Object)cls);
        }
    }

    public static class FloatPropertyTranslator
    extends StringPropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            try {
                return Float.valueOf(string);
            }
            catch (NumberFormatException e) {
                return new Float(0.0);
            }
        }

        @Override
        public boolean canHandleClass(Class cls) {
            return Float.TYPE.equals(cls) || Float.class.equals((Object)cls);
        }
    }

    public static class ColorPropertyTranslator
    extends StringPropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            try {
                int rgb = Integer.parseInt(string);
                return new Color(rgb);
            }
            catch (NumberFormatException e) {
                return new Color(0);
            }
        }

        @Override
        public boolean canHandleClass(Class cls) {
            return Color.class.equals((Object)cls);
        }

        @Override
        public String translateToString(Object object) {
            if (object != null) {
                return String.valueOf(((Color)object).getRGB());
            }
            return null;
        }
    }

    public static class ShortPropertyTranslator
    extends StringPropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            try {
                return Short.valueOf(string);
            }
            catch (NumberFormatException e) {
                return new Short(0);
            }
        }

        @Override
        public boolean canHandleClass(Class cls) {
            return Short.TYPE.equals(cls) || Short.class.equals((Object)cls);
        }
    }

    public static class LongPropertyTranslator
    extends StringPropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            try {
                return Long.valueOf(string);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }

        @Override
        public boolean canHandleClass(Class cls) {
            return Long.TYPE.equals(cls) || Long.class.equals((Object)cls);
        }
    }

    public static class IntegerPropertyTranslator
    extends StringPropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException e) {
                return new Integer(0);
            }
        }

        @Override
        public boolean canHandleClass(Class cls) {
            return Integer.TYPE.equals(cls) || Integer.class.equals((Object)cls);
        }
    }

    public static class StringPropertyTranslator
    implements PropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            return string;
        }

        @Override
        public String translateToString(Object object) {
            if (object != null) {
                return object.toString();
            }
            return null;
        }

        @Override
        public boolean canHandleClass(Class cls) {
            return String.class.equals((Object)cls);
        }

        @Override
        public boolean isStatefull() {
            return false;
        }
    }

    class ArrayPositionWrapper
    implements PropertyTranslator {
        private int position;

        public ArrayPositionWrapper(int position) {
            this.position = position;
        }

        @Override
        public Object translateFromString(String string) {
            return PropertyMapWrapper.this.getTranslator(this.position).translateFromString(string);
        }

        @Override
        public String translateToString(Object object) {
            return PropertyMapWrapper.this.getTranslator(this.position).translateToString(object);
        }

        @Override
        public boolean canHandleClass(Class cls) {
            return PropertyMapWrapper.this.getTranslator(this.position).canHandleClass(cls);
        }

        @Override
        public boolean isStatefull() {
            return true;
        }
    }

    static class AccessorPair {
        private Method getter;
        private Method setter;
        private String name;
        private PropertyTranslator translator;

        AccessorPair() {
        }

        public void setSetter(Method method) {
            this.setter = method;
        }

        public Method getSetter() {
            return this.setter;
        }

        public void setGetter(Method method) {
            this.getter = method;
        }

        public Method getGetter() {
            return this.getter;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setPropertyTranslator(PropertyTranslator translator) {
            this.translator = translator;
        }

        public PropertyTranslator getPropertyTranslator() {
            return this.translator;
        }
    }
}

