/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.string;

public class StringUtilities {
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = System.getProperty("line.separator");

    private StringUtilities() {
    }

    public static String replace(String text, String oldPart, String newPart) {
        StringBuffer buffer = new StringBuffer();
        StringUtilities.replace(text, oldPart, newPart, buffer);
        return buffer.toString();
    }

    public static void replace(String text, String oldPart, String newPart, StringBuffer buffer) {
        int pos = 0;
        int oldpos = 0;
        while (pos >= 0) {
            pos = text.indexOf(oldPart, oldpos);
            if (pos == -1) {
                buffer.append(text.substring(oldpos));
                continue;
            }
            buffer.append(text.substring(oldpos, pos));
            buffer.append(newPart);
            oldpos = pos + oldPart.length();
        }
    }

    public static String labeledComment(String label, String comment) {
        return new StringBuffer().append(StringUtilities.labeledStart(label)).append(comment).append(StringUtilities.labeledEnd()).toString();
    }

    public static String labeledStart(String label) {
        return new StringBuffer().append('[').append(label).append(": ").toString();
    }

    public static String labeledEnd() {
        return "]";
    }

    public static String removeAllBetween(String text, String start, String end) {
        StringBuffer buffer = new StringBuffer();
        int posStart = 0;
        int posEnd = 0;
        int posCopy = 0;
        int endLength = end.length();
        do {
            posStart = text.indexOf(start, posEnd);
            posEnd = text.indexOf(end, posStart);
            if (posStart >= 0 && posStart < posEnd) {
                buffer.append(text.substring(posCopy, posStart));
                posCopy = posEnd + endLength;
                continue;
            }
            buffer.append(text.substring(posCopy, text.length()));
        } while (posStart >= 0);
        return buffer.toString();
    }

    public static boolean isEmpty(String text) {
        return text == null || text.trim().equals(EMPTY_STRING);
    }

    public static boolean isNotEmpty(String text) {
        return !StringUtilities.isEmpty(text);
    }

    public static String decodeAttributeValue(String encoded) {
        if (encoded == null || EMPTY_STRING.equalsIgnoreCase(encoded)) {
            return encoded;
        }
        String string = encoded;
        if (string.indexOf(38) >= 0) {
            string = StringUtilities.replace(string, "&apos;", "'");
            string = StringUtilities.replace(string, "&quot;", "\"");
            string = StringUtilities.replace(string, "&lt;", "<");
            string = StringUtilities.replace(string, "&gt;", ">");
            string = StringUtilities.replace(string, "&amp;", "&");
        }
        if (string.indexOf("<br>") >= 0) {
            string = StringUtilities.replace(string, "<br>", "\r\n");
        }
        if (string.indexOf("<br/>") >= 0) {
            string = StringUtilities.replace(string, "<br/>", "\n");
        }
        if (string.indexOf("</br>") >= 0) {
            string = StringUtilities.replace(string, "</br>", "\r");
        }
        return string;
    }

    public static String encodeAttributeValue(String unencoded) {
        if (unencoded == null || EMPTY_STRING.equalsIgnoreCase(unencoded)) {
            return unencoded;
        }
        String string = StringUtilities.clearInvalidXMLCharacters(unencoded);
        if (string.indexOf("&quot;") >= 0) {
            string = StringUtilities.replace(string, "&quot;", "&amp;quot;");
        }
        if (string.indexOf("&lt;") >= 0) {
            string = StringUtilities.replace(string, "&lt;", "&amp;lt;");
        }
        if (string.indexOf("&gt;") >= 0) {
            string = StringUtilities.replace(string, "&gt;", "&amp;gt;");
        }
        if (string.indexOf(38) >= 0) {
            string = StringUtilities.replace(string, "&", "&amp;");
        }
        if (string.indexOf(34) >= 0) {
            string = StringUtilities.replace(string, "\"", "&quot;");
        }
        if (string.indexOf(39) >= 0) {
            string = StringUtilities.replace(string, "'", "&apos;");
        }
        if (string.indexOf(60) >= 0) {
            string = StringUtilities.replace(string, "<", "&lt;");
        }
        if (string.indexOf(62) >= 0) {
            string = StringUtilities.replace(string, ">", "&gt;");
        }
        if (string.indexOf("\r\n") >= 0) {
            string = StringUtilities.replace(string, "\r\n", "&lt;br&gt;");
        }
        if (string.indexOf(10) >= 0) {
            string = StringUtilities.replace(string, "\n", "&lt;br/&gt;");
        }
        if (string.indexOf("\r") >= 0) {
            string = StringUtilities.replace(string, "\r", "&lt;/br&gt;");
        }
        return string;
    }

    public static String clearInvalidXMLCharacters(String string) {
        StringBuffer out = new StringBuffer();
        if (string == null || EMPTY_STRING.equals(string)) {
            return EMPTY_STRING;
        }
        for (int i = 0; i < string.length(); ++i) {
            char current = string.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }
}

