/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.jdbc;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.thirdparty.jdbc.DMJDBCConnectionPanel;
import oracle.dbtools.thirdparty.jdbc.JDBCMessages;
import oracle.ide.natives.NativeHandler;
import oracle.javatools.util.PlatformUtils;

public class DMJDBCBasicPanel
extends JPanel
implements CDComponentView {
    public static final String DB_TYPE_CLASS_REFTYPE_STRING = "DB_TYPE";
    public static final String[] DB_TYPES = new String[]{null, "Oracle", "SQL Server", "DB2/390", "DB2/UDB"};
    private static final long serialVersionUID = -3381627083207173706L;
    private JRadioButton m_JdbcOdbcBridge;
    private JRadioButton m_ThirdPartyDriver;
    private ButtonGroup m_DrvTypeGroup;
    private JPanel m_DrvTypePanel;
    private JPanel m_ContainterPanel;
    private JPanel m_JdbcOdbcPanel;
    private JLabel m_lblDataSource;
    private JTextField m_cbxDSNs;
    private JLabel m_lblExtraParams;
    private JTextField m_txtExtraParams;
    private JPanel m_ThirdPartyDrvPanel;
    private JLabel m_lblJdbcUrl;
    private JTextField m_txtJdbcUrl;
    private CardLayout m_CardLayout = new CardLayout(0, 0);
    private boolean m_JdbcOdbcSelected = true;
    private final NativeHandler m_NativeHandler = new NativeHandler();
    private JLabel m_lblDrvClassName;
    private JTextField m_txtDrvClassName;
    private JPanel m_DBTypePanel;
    private JLabel m_lblDBType;
    private JComboBox m_cbDBType;
    private DMJDBCConnectionPanel m_connPanel;
    private static final String DRIVER_CLASSNAME = "sun.jdbc.odbc.JdbcOdbcDriver";

    public DMJDBCBasicPanel(DMJDBCConnectionPanel panel) {
        this.m_connPanel = panel;
        try {
            this.m_NativeHandler.initialize();
            this.setLayout(new BorderLayout());
            this.m_JdbcOdbcBridge = new JRadioButton(JDBCMessages.getString("ODBC_BRIDGE"), true);
            this.m_JdbcOdbcBridge.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DMJDBCBasicPanel.this.m_CardLayout.show(DMJDBCBasicPanel.this.m_ContainterPanel, "Card1");
                    DMJDBCBasicPanel.this.m_JdbcOdbcSelected = true;
                }
            });
            this.m_ThirdPartyDriver = new JRadioButton(JDBCMessages.getString("THIRD_PARTY_DRIVER"));
            this.m_ThirdPartyDriver.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DMJDBCBasicPanel.this.m_CardLayout.show(DMJDBCBasicPanel.this.m_ContainterPanel, "Card2");
                    DMJDBCBasicPanel.this.m_JdbcOdbcSelected = false;
                }
            });
            this.m_DrvTypeGroup = new ButtonGroup();
            this.m_DrvTypeGroup.add(this.m_JdbcOdbcBridge);
            this.m_DrvTypeGroup.add(this.m_ThirdPartyDriver);
            this.m_DrvTypePanel = new JPanel();
            this.m_DrvTypePanel.setLayout(new GridBagLayout());
            this.m_DrvTypePanel.add((Component)this.m_JdbcOdbcBridge, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 5, 10, 5), 0, 0));
            this.m_DrvTypePanel.add((Component)this.m_ThirdPartyDriver, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 12, 2, new Insets(10, 5, 10, 5), 0, 0));
            this.m_JdbcOdbcPanel = new JPanel();
            this.m_ThirdPartyDrvPanel = new JPanel();
            this.m_ContainterPanel = new JPanel();
            this.m_ContainterPanel.setLayout(this.m_CardLayout);
            this.m_lblJdbcUrl = new JLabel(JDBCMessages.getString("JDBC_URL"));
            this.m_txtJdbcUrl = new JTextField();
            this.m_lblDrvClassName = new JLabel(JDBCMessages.getString("DRV_CLASS"));
            this.m_txtDrvClassName = new JTextField();
            this.m_lblDataSource = new JLabel(JDBCMessages.getString("DSN_LBL"));
            this.m_cbxDSNs = new JTextField();
            this.m_lblExtraParams = new JLabel(JDBCMessages.getString("EXTRA_PARAM"));
            this.m_txtExtraParams = new JTextField();
            this.m_DBTypePanel = new JPanel(new FlowLayout(0));
            this.m_lblDBType = new JLabel(JDBCMessages.getString(DB_TYPE_CLASS_REFTYPE_STRING));
            this.m_cbDBType = new JComboBox<String>(DB_TYPES);
            this.m_cbDBType.setSelectedIndex(0);
            this.m_DBTypePanel.add((Component)this.m_lblDBType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.m_DBTypePanel.add((Component)this.m_cbDBType, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_JdbcOdbcPanel.setLayout(new GridBagLayout());
            this.m_JdbcOdbcPanel.add((Component)this.m_lblDataSource, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.m_JdbcOdbcPanel.add((Component)this.m_cbxDSNs, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_JdbcOdbcPanel.add((Component)this.m_lblExtraParams, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.m_JdbcOdbcPanel.add((Component)this.m_txtExtraParams, new GridBagConstraints(1, 1, 0, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ThirdPartyDrvPanel.setLayout(new GridBagLayout());
            this.m_ThirdPartyDrvPanel.add((Component)this.m_lblJdbcUrl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ThirdPartyDrvPanel.add((Component)this.m_txtJdbcUrl, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ThirdPartyDrvPanel.add((Component)this.m_lblDrvClassName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ThirdPartyDrvPanel.add((Component)this.m_txtDrvClassName, new GridBagConstraints(1, 1, 0, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ContainterPanel.add((Component)this.m_JdbcOdbcPanel, "Card1");
            this.m_ContainterPanel.add((Component)this.m_ThirdPartyDrvPanel, "Card2");
            this.m_CardLayout.show(this.m_ContainterPanel, "Card1");
            JPanel pnMain = new JPanel(new BorderLayout());
            pnMain.add((Component)this.m_DrvTypePanel, "North");
            pnMain.add((Component)this.m_ContainterPanel, "Center");
            this.add((Component)pnMain, "North");
            this.add((Component)this.m_DBTypePanel, "Center");
        }
        catch (Exception e) {
            Logger.getLogger(DMJDBCBasicPanel.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void clear() {
        this.m_connPanel.clear();
    }

    public void populateComponent(Properties cd) {
        if (this.m_JdbcOdbcSelected) {
            cd.setProperty("driver", DRIVER_CLASSNAME);
            String selDSN = this.m_cbxDSNs.getText();
            String extraParam = this.m_txtExtraParams.getText();
            if (selDSN != null && selDSN.trim().length() > 0) {
                cd.setProperty("dataSourceName", selDSN);
                cd.setProperty("customUrl", "jdbc:odbc:" + selDSN);
            } else {
                cd.remove("dataSourceName");
                cd.setProperty("customUrl", null);
            }
            if (extraParam != null && extraParam.trim().length() > 0) {
                cd.setProperty("parameters", extraParam);
            }
        } else {
            String drvClass = this.m_txtDrvClassName.getText();
            String jdbcUrl = this.m_txtJdbcUrl.getText();
            if (drvClass != null && drvClass.trim().length() > 0) {
                cd.setProperty("driver", drvClass);
            }
            if (jdbcUrl != null && jdbcUrl.trim().length() > 0) {
                cd.setProperty("customUrl", jdbcUrl);
            }
        }
        String dbType = (String)this.m_cbDBType.getSelectedItem();
        if (dbType == null) {
            cd.remove(DB_TYPE_CLASS_REFTYPE_STRING);
        } else {
            cd.setProperty(DB_TYPE_CLASS_REFTYPE_STRING, dbType);
        }
    }

    public void setDefaultPrompts() {
    }

    public void setDBType(String dbType) {
        if (dbType == null) {
            this.m_cbDBType.setSelectedIndex(0);
        } else {
            for (int i = 0; i < DB_TYPES.length; ++i) {
                String type = DB_TYPES[i];
                if (!dbType.equalsIgnoreCase(type)) continue;
                this.m_cbDBType.setSelectedIndex(i);
                return;
            }
        }
    }

    private String getDsn() {
        return this.m_JdbcOdbcSelected ? this.m_cbxDSNs.getText() : null;
    }

    public void setDsn(String dsn) {
        if (dsn != null && this.m_JdbcOdbcSelected) {
            this.m_cbxDSNs.setText(dsn);
        }
    }

    private String getExtraParams() {
        String retVal = this.m_txtExtraParams.getText();
        return retVal != null ? retVal.trim() : retVal;
    }

    public void setExtraParams(String params) {
        if (this.m_JdbcOdbcSelected) {
            this.m_txtExtraParams.setText(params != null ? params : "");
        }
    }

    public String getDriverClass() {
        String retVal = null;
        retVal = !this.m_JdbcOdbcSelected ? ((retVal = this.m_txtDrvClassName.getText()) != null ? retVal.trim() : retVal) : (PlatformUtils.isWindows() ? DRIVER_CLASSNAME : RaptorClassLoader.class.getName());
        return retVal;
    }

    public void setDriverClass(String drvCls) {
        if (!this.m_JdbcOdbcSelected) {
            this.m_txtDrvClassName.setText(drvCls != null ? drvCls : "");
        }
    }

    public String getThirdPartyJdbcUrl() {
        String retVal = null;
        if (!this.m_JdbcOdbcSelected) {
            retVal = this.m_txtJdbcUrl.getText();
            retVal = retVal != null ? retVal.trim() : retVal;
        } else {
            String dsn = this.getDsn();
            String params = this.getExtraParams();
            retVal = "jdbc:odbc:" + (params != null && params.length() > 0 ? dsn + ";" + params : dsn);
        }
        return retVal;
    }

    public void setThirdPartyJdbcUrl(String url) {
        if (!this.m_JdbcOdbcSelected) {
            this.m_txtJdbcUrl.setText(url != null ? url : "");
        }
    }

    public boolean isJdbcOdbc() {
        return this.m_JdbcOdbcSelected;
    }

    public void setDriverType(boolean jdbc_odbc) {
        if (jdbc_odbc) {
            this.m_JdbcOdbcBridge.setSelected(true);
            this.m_JdbcOdbcSelected = true;
            this.m_CardLayout.show(this.m_ContainterPanel, "Card1");
        } else {
            this.m_ThirdPartyDriver.setSelected(true);
            this.m_JdbcOdbcSelected = false;
            this.m_CardLayout.show(this.m_ContainterPanel, "Card2");
        }
    }
}

