/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.jdbc;

import java.awt.BorderLayout;
import java.util.Properties;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.thirdparty.jdbc.DMJDBCBasicPanel;

public class DMJDBCConnectionPanel
extends IConnectionPanel {
    public static final String SUBTYPE_JDBC = "JDBC";
    public static final String CONNECTION_TYPE = "JDBC";
    private static final long serialVersionUID = -2722778367897023975L;
    private DMJDBCBasicPanel m_basicPanel;

    public DMJDBCConnectionPanel() {
        this.setLayout(new BorderLayout());
        this.m_basicPanel = new DMJDBCBasicPanel(this);
        this.add(this.m_basicPanel, "Center");
    }

    public void clear() {
    }

    public Properties getConnectionProperties() {
        this.m_props.setProperty("subtype", "JDBC");
        this.m_props.setProperty("RaptorConnectionType", "JDBC");
        this.m_basicPanel.populateComponent(this.m_props);
        return this.m_props;
    }

    public String getConnectionType() {
        return "JDBC";
    }

    public String getDriver() {
        return this.m_basicPanel.getDriverClass();
    }

    public void setDefaultPrompts() {
    }

    public void updatePrompts(Properties props) {
        String urlString = props.getProperty("customUrl");
        String drvClass = "";
        String dsnName = "";
        String extraParam = "";
        String customUrl = "";
        boolean odbcjdbc = false;
        String string = urlString = urlString != null ? urlString : "";
        if (urlString.startsWith("jdbc:odbc")) {
            odbcjdbc = true;
        }
        if (odbcjdbc) {
            dsnName = props.getProperty("dataSourceName");
            extraParam = props.getProperty("parameters");
        } else {
            drvClass = props.getProperty("driver");
            customUrl = urlString;
        }
        if (odbcjdbc) {
            this.m_basicPanel.setDriverType(true);
            this.m_basicPanel.setDsn(dsnName);
            this.m_basicPanel.setExtraParams(extraParam);
        } else {
            this.m_basicPanel.setDriverType(false);
            this.m_basicPanel.setDriverClass(drvClass);
            this.m_basicPanel.setThirdPartyJdbcUrl(customUrl);
        }
        String dbType = props.getProperty("DB_TYPE");
        this.m_basicPanel.setDBType(dbType);
    }
}

