/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.sqlserver;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.sqlserver.DMSQLServerBasicPanel;
import oracle.ide.util.ResourceUtils;

public class DMSQLServerConnectionPanel
extends IConnectionPanel {
    public static String SUBTYPE_SQL_SERVER = "SQLServer";
    public static final String CONNECTION_TYPE = "Microsoft SQL Server";
    private static final long serialVersionUID = 1L;
    private JPanel _panel;
    private DMSQLServerBasicPanel _basicPanel;
    private CardLayout _layout;
    public static final String DRIVER_CLASSNAME = "net.sourceforge.jtds.jdbc.Driver";
    public static final String DRIVER_2000_CLASSNAME = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    public static final String DRIVER_2005_CLASSNAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String HOST = "localhost";
    public static final String PORT = "1433";
    public static String SQLSERVER_WINDOWS_AUTHENTICATION = "sqlserver_windows_authentication";
    public static String IS_WINDOWS = "is_windows";
    public static String SQLSERVER_DEFAULT_PASSWORD = "sqlserver_default_password";
    public static String SQLSERVER_DOMAIN = "sqlserver_domain";

    public DMSQLServerConnectionPanel() {
        this.setLayout(new GridBagLayout());
        this._basicPanel = new DMSQLServerBasicPanel(this);
        this._layout = new CardLayout(0, 0);
        this._panel = new JPanel(this._layout);
        JLabel typeLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)typeLbl, null, (String)ConnectionDialogArb.getString((String)"CONNECTION_TYPE"));
        this._panel.add((Component)this._basicPanel, "Basic");
        this.add(this._panel, new GridBagConstraints(0, 2, 8, 1, 1.0, 4.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this._layout.show(this._panel, "Basic");
    }

    private Properties getInput(Properties cd) {
        if (this._basicPanel.get_autoPasswordCheck().isSelected()) {
            cd.put(SQLSERVER_DEFAULT_PASSWORD, Boolean.TRUE.toString());
            cd.setProperty("password", "");
            cd.setProperty("NoPasswordConnection", Boolean.FALSE.toString());
        }
        cd.setProperty("subtype", SUBTYPE_SQL_SERVER);
        cd.setProperty("driver", DRIVER_CLASSNAME);
        cd.setProperty("RaptorConnectionType", CONNECTION_TYPE);
        if (this._basicPanel.get_windowsAuthenticate().isSelected()) {
            if (this._basicPanel.get_isWindows()) {
                cd.put("user", "");
                cd.put("password", "");
                cd.put(SQLSERVER_DOMAIN, "");
                cd.put(IS_WINDOWS, Boolean.TRUE.toString());
                cd.setProperty("NoPasswordConnection", Boolean.FALSE.toString());
            } else {
                cd.put(SQLSERVER_DOMAIN, this._basicPanel.getTfdDomain().getText());
            }
            cd.put(SQLSERVER_WINDOWS_AUTHENTICATION, Boolean.TRUE.toString());
        }
        CDComponentView cdv = this.getPanel();
        cdv.populateComponent(cd);
        return cd;
    }

    private CDComponentView getPanel() {
        return this._basicPanel;
    }

    public void clear() {
        this._basicPanel.clear();
    }

    public void updatePrompts(Properties cd) {
        String hostname = cd.getProperty("hostname");
        this._basicPanel.tfdHost.setText(hostname);
        String port = cd.getProperty("port");
        this._basicPanel.tfdPort.setText(port != null ? port : PORT);
        boolean windowsAuth = Boolean.parseBoolean(cd.getProperty(SQLSERVER_WINDOWS_AUTHENTICATION, "false"));
        this._basicPanel.setWindowsAuthSelected(windowsAuth);
        boolean defaultPassword = Boolean.parseBoolean(cd.getProperty(SQLSERVER_DEFAULT_PASSWORD, "false"));
        this._basicPanel.setDefaultPasswordSelected(defaultPassword);
        this._basicPanel.setDomain(cd.getProperty(SQLSERVER_DOMAIN, ""));
        cd.setProperty("ConnName", this.getConnectionName());
    }

    public Properties getConnectionProperties() {
        return this.getInput(this.m_props);
    }

    public String getDriver() {
        return DRIVER_CLASSNAME;
    }

    public String[] getSupportedDrivers() {
        return new String[]{DRIVER_CLASSNAME, DRIVER_2000_CLASSNAME, DRIVER_2005_CLASSNAME};
    }

    public void setDefaultPrompts() {
        this._basicPanel.setDefaultPrompts();
        this.getDialog().useUserName(true);
        this.getDialog().usePassword(true);
    }

    public String getConnectionType() {
        return CONNECTION_TYPE;
    }
}

