/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.babelfish.sqlserver;

import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.parser.ParserFactory;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.migration.parser.internalapi.TranslateResultWithASTs;
import oracle.dbtools.migration.parser.plugin.Fingerprint;
import oracle.dbtools.migration.translation.RepoTranslationAPI;
import oracle.dbtools.migration.translation.SchemaDetails;
import oracle.dbtools.migration.translation.api.exceptions.TranslationException;
import oracle.dbtools.migration.translation.api.prefs.TranslationPreferences;
import oracle.sql.CLOB;

public class SQLServerTSQLTranslator {
    private static final boolean ENABLE_TEMPLATE = true;
    private static final boolean DEBUG = true;
    private static Connection m_conn;
    private static final Hashtable<Integer, SQLServerTSQLTranslator> m_translators;
    private final String m_profileName;
    private final int m_profileID;
    private final boolean m_registerTemplate;
    private final ITranslationAll m_translator;
    private static boolean _isLocalTesting;
    private static String _callingSchema;
    private static final String TESTING_PROFILE_NAME = "SQLDEVPROFILETESTNAME";

    private static void Debug(String string) {
        System.out.println("SQLServerTSQLTranslator: " + string);
    }

    private static SQLServerTSQLTranslator getTranslator() throws SQLException {
        Object object;
        int n = 0;
        try {
            object = "/*+ no_sql_translation */ select sys_context('USERENV', 'SQL_TRANSLATION_PROFILE_ID') from dual";
            PreparedStatement preparedStatement = m_conn.prepareStatement((String)object);
            preparedStatement.execute();
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new InternalError("sys_context('USERENV', 'SQL_TRANSLATION_PROFILE_ID') not available");
            }
            n = resultSet.getInt(1);
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            throw new InternalError(sQLException.getMessage());
        }
        object = m_translators.get(n);
        if (object == null) {
            object = new SQLServerTSQLTranslator();
        }
        return object;
    }

    private SQLServerTSQLTranslator() throws SQLException {
        if (_isLocalTesting) {
            this.m_profileName = TESTING_PROFILE_NAME;
            this.m_profileID = 0;
            this.m_registerTemplate = true;
            this.m_translator = (ITranslationAll)ParserFactory.getParserNonOSGI((String)"oracle.dbtools.migration.parser.tsql.TSQLParserMain");
        } else {
            String string = "/*+ no_sql_translation */ select sys_context('USERENV', 'SQL_TRANSLATION_PROFILE_NAME'), sys_context('USERENV', 'SQL_TRANSLATION_PROFILE_ID'), p.TRANSLATE_NEW_SQL from all_sql_translation_profiles p, all_objects o where p.owner = o.owner and p.profile_name = o.object_name and o.object_id = sys_context('USERENV', 'SQL_TRANSLATION_PROFILE_ID')";
            PreparedStatement preparedStatement = m_conn.prepareStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new SQLException("SQL translation profile not found");
            }
            this.m_profileName = resultSet.getString(1);
            this.m_profileID = resultSet.getInt(2);
            String string2 = resultSet.getString(3);
            resultSet.close();
            preparedStatement.close();
            this.m_registerTemplate = string2.equals("TRUE");
            this.m_translator = (ITranslationAll)ParserFactory.getParserNonOSGI((String)"oracle.dbtools.migration.parser.tsql.TSQLParserMain");
        }
        m_translators.put(this.m_profileID, this);
    }

    private static String clobToString(CLOB cLOB) throws SQLException {
        Reader reader = cLOB.getCharacterStream();
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[4096];
        try {
            int n;
            while ((n = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new SQLException(iOException);
        }
        return stringBuffer.toString();
    }

    private static CLOB stringToCLOB(String string) throws SQLException {
        CLOB cLOB = null;
        cLOB = _isLocalTesting ? CLOB.createTemporary((Connection)m_conn, (boolean)false, (int)10) : CLOB.createTemporary((Connection)m_conn, (boolean)false, (int)12);
        cLOB.setString(1L, string);
        return cLOB;
    }

    private String removeTrailingComma(String string) {
        if ((string = string.trim()).startsWith("CREATE OR REPLACE PACKAGE") || string.startsWith("CREATE OR REPLACE PROCEDURE") || string.startsWith("CREATE OR REPLACE FUNCTION") || string.startsWith("CREATE OR REPLACE TRIGGER") || string.startsWith("DECLARE") || string.startsWith("BEGIN")) {
            return string;
        }
        return string.endsWith(";") ? string.substring(0, string.length() - 1) : string;
    }

    private String lookupTemplate(String string) throws SQLException {
        String string2 = "/*+ no_sql_translation */ select st.translated_text from all_sql_translations st, all_objects o where st.owner = o.owner and st.profile_name = o.object_name and o.object_id = ? and dbms_sql_translator.sql_hash(st.sql_text) = dbms_sql_translator.sql_hash(?) and dbms_lob.compare(UPPER(st.sql_text),UPPER(?)) = 0 and st.enabled = 'TRUE'";
        CLOB cLOB = SQLServerTSQLTranslator.stringToCLOB(string);
        PreparedStatement preparedStatement = m_conn.prepareStatement(string2);
        preparedStatement.setInt(1, this.m_profileID);
        preparedStatement.setClob(2, (Clob)cLOB);
        preparedStatement.setClob(3, (Clob)cLOB);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string3 = resultSet.next() ? SQLServerTSQLTranslator.clobToString((CLOB)resultSet.getClob(1)) : null;
        resultSet.close();
        preparedStatement.close();
        SQLServerTSQLTranslator.Debug("found " + string3 + " for " + string);
        return string3;
    }

    private void registerTemplate(String string, String string2) throws SQLException {
        SQLServerTSQLTranslator.Debug("registering " + string2 + " for " + string);
        if (!_isLocalTesting) {
            String string3 = "/*+ no_sql_translation */ begin dbms_sql_translator.register_sql_translation(?,?,?,true); end;";
            CallableStatement callableStatement = m_conn.prepareCall(string3);
            callableStatement.setString(1, this.m_profileName);
            callableStatement.setClob(2, (Clob)SQLServerTSQLTranslator.stringToCLOB(string));
            callableStatement.setClob(3, (Clob)SQLServerTSQLTranslator.stringToCLOB(string2));
            callableStatement.execute();
            callableStatement.close();
        }
    }

    public void translateSQL_(CLOB cLOB, CLOB[] cLOBArray) throws SQLException, TranslationException, NoSuchObjectException, PersistenceException {
        String string;
        String string2;
        String string3 = SQLServerTSQLTranslator.clobToString(cLOB);
        String string4 = null;
        String string5 = null;
        Fingerprint fingerprint = null;
        HashMap hashMap = null;
        SQLServerTSQLTranslator.Debug("original SQL " + string3);
        try {
            fingerprint = this.m_translator.fingerprint(string3);
            string5 = fingerprint.getFingerprint();
            hashMap = fingerprint.getValues();
            SQLServerTSQLTranslator.Debug("fingerprint " + string5);
            string4 = this.lookupTemplate(string5);
            if (string4 == null) {
                string2 = "";
                TranslateResultWithASTs translateResultWithASTs = null;
                String string6 = new TranslationPreferences();
                string6.setIs12c(true);
                translateResultWithASTs = this.isRepo(m_conn) ? ((string = this.getSchemaDetails(m_conn, this.m_profileName)) != null ? RepoTranslationAPI.translate((String)string5, (SchemaDetails)string, (PersistenceManager)new PersistenceManager(m_conn), (ITranslationAll)this.m_translator) : RepoTranslationAPI.translate((String)string5, (ITranslationAll)this.m_translator, (TranslationPreferences)string6)) : RepoTranslationAPI.translate((String)string5, (ITranslationAll)this.m_translator, (TranslationPreferences)string6);
                string2 = translateResultWithASTs.getTargetString();
                string4 = this.removeTrailingComma(string2);
            }
            SQLServerTSQLTranslator.Debug("template " + string4);
        }
        catch (SQLException sQLException) {
            System.out.println("original SQL: " + string3);
        }
        catch (TranslationException translationException) {
            System.out.println("original SQL: " + string3);
        }
        catch (PersistenceException persistenceException) {
            System.out.println("original SQL: " + string3);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            System.out.println("original SQL: " + string3);
        }
        if (this.m_registerTemplate) {
            if (string4 != null && string5 != null) {
                this.registerTemplate(string5, string4);
            } else if (string5 != null) {
                string4 = string5;
                this.registerTemplate(string5, string4);
            }
        }
        if ((string2 = string4) != null && hashMap != null) {
            for (String string6 : hashMap.keySet()) {
                string = (String)hashMap.get(string6);
                SQLServerTSQLTranslator.Debug("replace " + string6 + " with " + string);
                string2 = string2.replace(string6, string);
            }
        }
        SQLServerTSQLTranslator.Debug("translated SQL " + string2);
        cLOBArray[0] = SQLServerTSQLTranslator.stringToCLOB(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaDetails getSchemaDetails(Connection connection, String string) {
        String string2 = "/*+ no_sql_translation */ SELECT value from MD_ADDITIONAL_PROPERTIES WHERE PROP_KEY=:targetSchemaName";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        SchemaDetails schemaDetails = null;
        try {
            preparedStatement = connection.prepareStatement(string2);
            String string3 = "BABELFISH:" + string;
            preparedStatement.setString(1, string3);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                schemaDetails = new SchemaDetails(string4);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return schemaDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRepo(Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            if (connection != null) {
                statement = connection.createStatement();
                resultSet = statement.executeQuery("/*+ no_sql_translation */ SELECT REVISION FROM MD_REPOVERSIONS");
                resultSet.next();
                n = resultSet.getInt("REVISION");
            }
        }
        catch (SQLException sQLException) {
            boolean bl = false;
            return bl;
        }
        finally {
            CloseableResultSet.close((Statement)statement, resultSet);
        }
        return true;
    }

    public void translateError_(int n, int[] nArray, String[] stringArray) throws SQLException, TranslationException {
        nArray[0] = 0;
        stringArray[0] = "00000";
    }

    public static void translateSQL(CLOB cLOB, CLOB[] cLOBArray) throws SQLException, TranslationException, NoSuchObjectException, PersistenceException {
        SQLServerTSQLTranslator sQLServerTSQLTranslator = SQLServerTSQLTranslator.getTranslator();
        sQLServerTSQLTranslator.translateSQL_(cLOB, cLOBArray);
    }

    public static void translateSQL(CLOB cLOB, CLOB[] cLOBArray, Connection connection, String string) throws Exception {
        _isLocalTesting = true;
        m_conn = connection;
        _callingSchema = string;
        SQLServerTSQLTranslator.translateSQL(cLOB, cLOBArray);
    }

    public static void translateError(int n, int[] nArray, String[] stringArray) throws SQLException, TranslationException {
        SQLServerTSQLTranslator sQLServerTSQLTranslator = SQLServerTSQLTranslator.getTranslator();
        sQLServerTSQLTranslator.translateError_(n, nArray, stringArray);
    }

    static {
        m_translators = new Hashtable();
        _isLocalTesting = false;
        _callingSchema = null;
        try {
            m_conn = DriverManager.getConnection("jdbc:default:connection");
        }
        catch (SQLException sQLException) {
            throw new InternalError(sQLException.getMessage());
        }
    }
}

