/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sqlserver2005;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdGroupMember;
import oracle.dbtools.metadata.persistence.MdGroupPrivilege;
import oracle.dbtools.metadata.persistence.MdPrivilege;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdUserPrivilege;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.metadata.persistence.PrepareClobHelper;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.core.MigrationContext;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

public abstract class SQLServer2005AbstractCapturerPrivilegeExtra {
    private static int s_overSize = 5000;

    protected abstract String capturePrivilegesString(String var1);

    protected abstract String captureRoleMembershipString(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void capturePrivileges(Connection connection, MigrationStorer migrationStorer, CaptureContext captureContext, ArrayList<MdGroup> arrayList, MdGroup mdGroup, MdUser mdUser, boolean bl) throws SQLException, PersistenceException {
        PersistenceUtility persistenceUtility = migrationStorer.getPersistenceUtility();
        String string = SQLServer2005AbstractCapturerPrivilegeExtra.getDatabase(connection, (MigrationContext)captureContext);
        String string2 = this.capturePrivilegesString(string);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        PrepareClobHelper prepareClobHelper = null;
        try {
            String string3 = string2;
            preparedStatement = connection.prepareStatement(string3);
            boolean bl2 = true;
            String string4 = null;
            if (mdGroup == null) {
                bl2 = false;
                string4 = mdUser.getUsername();
            } else {
                string4 = mdGroup.getGroupName();
            }
            if (!bl) {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string4);
            } else {
                preparedStatement.setString(1, string4);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                MdUserPrivilege mdUserPrivilege;
                String string5;
                String string6;
                String string7 = resultSet.getString(4);
                if (string7.equals("REFERENCES")) {
                    string7 = "REFERENCES";
                } else if (string7.equals("SELECT")) {
                    string7 = "SELECT";
                } else if (string7.equals("INSERT")) {
                    string7 = "INSERT";
                } else if (string7.equals("UPDATE")) {
                    string7 = "UPDATE";
                } else if (string7.equals("DELETE")) {
                    string7 = "DELETE";
                }
                prepareClobHelper = new PrepareClobHelper();
                prepareClobHelper.append("GRANT " + string7 + " ON [" + string + "].[" + resultSet.getString(2) + "].[" + resultSet.getString(3) + "] TO " + string4);
                DBObjectId dBObjectId = null;
                DBObjectId dBObjectId2 = null;
                try {
                    string6 = resultSet.getString(1);
                    dBObjectId = SQLServer2005AbstractCapturerPrivilegeExtra.getSchemaIdForRoleUser(persistenceUtility, (DBObjectId)captureContext.getContextVariable("CATALOGID"), string6);
                    string5 = resultSet.getString(2);
                    dBObjectId2 = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), string5);
                }
                catch (PersistenceException persistenceException) {
                    if (prepareClobHelper == null) continue;
                    try {
                        prepareClobHelper.close();
                    }
                    catch (IOException iOException) {
                        MigrationLogUtil.logThrowable((String)iOException.getLocalizedMessage(), (String)"Capture", (Throwable)iOException);
                    }
                    continue;
                }
                string6 = new MdPrivilege(dBObjectId, "TABLE:[" + string + "].[" + resultSet.getString(2) + "].[" + resultSet.getString(3) + "]:" + string7, "MD_TABLES", resultSet.getString(4), prepareClobHelper.getClobHelper());
                prepareClobHelper.close();
                if (resultSet.getString(5).equals("NO")) {
                    string6.setAdminOption("Y");
                } else {
                    string6.setAdminOption("N");
                }
                string5 = null;
                try {
                    string5 = SQLServer2005AbstractCapturerPrivilegeExtra.getIdInRepo(persistenceUtility, "U", dBObjectId2, resultSet.getString(3));
                    if (string5 == null) {
                        continue;
                    }
                }
                catch (PersistenceException persistenceException) {
                    if (string5 == null) continue;
                    throw persistenceException;
                }
                string6.setPrivelegeObjectId((DBObjectId)string5);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_PRIVILEGE"), resultSet.getString(3));
                captureContext.getAudience().fireListeners(captureEvent);
                string6 = (MdPrivilege)migrationStorer.storeObject((PersistableObject)string6);
                captureEvent.setEventId(4);
                if (bl2) {
                    mdUserPrivilege = new MdGroupPrivilege(mdGroup.getKey(), string6.getKey());
                    mdUserPrivilege = (MdGroupPrivilege)migrationStorer.storeObject((PersistableObject)mdUserPrivilege);
                    continue;
                }
                mdUserPrivilege = new MdUserPrivilege(mdUser.getKey());
                mdUserPrivilege.setPrivilegeId(string6.getKey());
                mdUserPrivilege = (MdUserPrivilege)migrationStorer.storeObject((PersistableObject)mdUserPrivilege);
            }
        }
        catch (IOException iOException) {
            try {
                MigrationLogUtil.logThrowable((String)iOException.getLocalizedMessage(), (String)"Capture", (Throwable)iOException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(preparedStatement, resultSet);
                if (prepareClobHelper != null) {
                    try {
                        prepareClobHelper.close();
                    }
                    catch (IOException iOException2) {
                        MigrationLogUtil.logThrowable((String)iOException2.getLocalizedMessage(), (String)"Capture", (Throwable)iOException2);
                    }
                }
                throw throwable;
            }
            CloseableResultSet.close((Statement)preparedStatement, resultSet);
            if (prepareClobHelper != null) {
                try {
                    prepareClobHelper.close();
                }
                catch (IOException iOException3) {
                    MigrationLogUtil.logThrowable((String)iOException3.getLocalizedMessage(), (String)"Capture", (Throwable)iOException3);
                }
            }
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
        if (prepareClobHelper != null) {
            try {
                prepareClobHelper.close();
            }
            catch (IOException iOException) {
                MigrationLogUtil.logThrowable((String)iOException.getLocalizedMessage(), (String)"Capture", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void captureRoleMembership(Connection connection, MigrationStorer migrationStorer, CaptureContext captureContext, ArrayList<MdGroup> arrayList, boolean bl) throws SQLException, PersistenceException {
        PersistenceUtility persistenceUtility = migrationStorer.getPersistenceUtility();
        Statement statement = null;
        ResultSet resultSet = null;
        Object var9_9 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet2 = null;
        try {
            String string = SQLServer2005AbstractCapturerPrivilegeExtra.getDatabase(connection, (MigrationContext)captureContext);
            CloseableIterator closeableIterator = persistenceUtility.getSchemasforCatalogId((DBObjectId)captureContext.getContextVariable("CATALOGID"));
            ArrayList<MdGroup> arrayList2 = new ArrayList<MdGroup>();
            while (closeableIterator.hasNext()) {
                CloseableIterator closeableIterator2 = persistenceUtility.getUsersforSchemaId(((MdSchema)closeableIterator.next()).getKey());
                while (closeableIterator2.hasNext()) {
                    MdGroup mdGroup = (MdUser)closeableIterator2.next();
                    arrayList2.add(mdGroup);
                }
            }
            for (MdGroup mdGroup : arrayList) {
                CaptureEvent captureEvent;
                Object object;
                String string2 = mdGroup.getGroupName();
                if (string2.equals("public")) {
                    for (MdUser mdUser : arrayList2) {
                        object = new MdGroupMember(mdGroup.getKey());
                        object.setUserId(mdUser.getKey());
                        captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_GROUP_MEMBERS"), string2);
                        captureContext.getAudience().fireListeners(captureEvent);
                        object = (MdGroupMember)migrationStorer.storeObject((PersistableObject)object);
                        captureEvent.setEventId(4);
                    }
                    continue;
                }
                String string3 = this.captureRoleMembershipString(string);
                preparedStatement = null;
                resultSet2 = null;
                try {
                    Object object2 = string3;
                    preparedStatement = connection.prepareStatement((String)object2);
                    if (!bl) {
                        preparedStatement.setString(1, string);
                        preparedStatement.setString(2, string2);
                    } else {
                        preparedStatement.setString(1, string2);
                    }
                    resultSet2 = preparedStatement.executeQuery();
                    while (resultSet2.next()) {
                        object = resultSet2.getString(1);
                        captureEvent = null;
                        DBObjectId dBObjectId = null;
                        for (MdUser mdUser : arrayList2) {
                            if (!mdUser.getUsername().equals(object)) continue;
                            captureEvent = mdUser.getKey();
                            break;
                        }
                        if (captureEvent == null) {
                            for (MdGroup mdGroup2 : arrayList) {
                                if (!mdGroup2.getGroupName().equals(object)) continue;
                                dBObjectId = mdGroup2.getKey();
                                break;
                            }
                        }
                        if (captureEvent == null && dBObjectId == null) continue;
                        Iterator<Object> iterator = new MdGroupMember(mdGroup.getKey());
                        if (captureEvent != null) {
                            iterator.setUserId((DBObjectId)captureEvent);
                        } else {
                            if (dBObjectId == null) continue;
                            iterator.setGroupMemberId(dBObjectId);
                        }
                        CaptureEvent captureEvent2 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_GROUP_MEMBERS"), string2);
                        captureContext.getAudience().fireListeners(captureEvent2);
                        iterator = (MdGroupMember)migrationStorer.storeObject(iterator);
                        captureEvent2.setEventId(4);
                    }
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close(preparedStatement, resultSet2);
                    throw throwable;
                    return;
                }
                CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet2);
            }
        }
        finally {
            CloseableResultSet.close(statement, resultSet);
            if (var9_9 != null) {
                try {
                    var9_9.close();
                }
                catch (Exception exception) {
                    MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)"Capture", (Throwable)exception);
                }
            }
        }
    }

    public static DBObjectId getIdInRepo(PersistenceUtility persistenceUtility, String string, DBObjectId dBObjectId, String string2) throws PersistenceException {
        if (string.equals("FN") || string.equals("IF") || string.trim().equals("P") || string.equals("TF") || string.trim().equals("X")) {
            return persistenceUtility.getIdForStoredProgram(dBObjectId, string2);
        }
        if (string.trim().equals("U")) {
            return persistenceUtility.getIdForTable(dBObjectId, string2);
        }
        if (string.trim().equals("V")) {
            return persistenceUtility.getIdForView(dBObjectId, string2);
        }
        return null;
    }

    public static DBObjectId getSchemaIdForRoleUser(PersistenceUtility persistenceUtility, DBObjectId dBObjectId, String string) throws PersistenceException {
        try {
            return persistenceUtility.getSchemaIdForUser(dBObjectId, string);
        }
        catch (PersistenceException persistenceException) {
            return persistenceUtility.getSchemaIdForGroup(dBObjectId, string);
        }
    }

    public static String getDatabase(Connection connection, MigrationContext migrationContext) {
        String string = null;
        MdCatalog mdCatalog = (MdCatalog)migrationContext.getContextVariable("CATALOG");
        string = mdCatalog.getCatalogName();
        return string;
    }
}

