/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.security.redaction.dialogs;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.security.SecurityArb;
import oracle.dbtools.security.redaction.controller.RedactController;
import oracle.dbtools.security.redaction.model.RedactModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;

public abstract class CoreRedactPolicyAction
extends ActionDialog {
    protected String classArgs;
    protected String policyName = null;
    protected String policyDescription = null;
    protected String oldPolicyName = null;
    protected String schemaName = null;
    protected String objectName = null;
    protected String columnName = null;
    private String columnDescription = null;
    protected boolean redactionEnabled = true;
    protected ActionControl enabledCtl = null;
    protected TextBoxActionControl policyNameCtl = null;
    protected TextBoxActionControl policyDescriptionCtl = null;
    protected TextBoxActionControl columnDescriptionCtl = null;
    protected SqlComboBoxActionControl alterPolicyNameCtl = null;
    protected TextBoxActionControl schemaNameCtl = null;
    protected TextBoxActionControl objectNameCtl = null;
    protected ComboBoxActionControl columnNameCtl = null;
    private Map<String, Object> binds = null;
    private String[] allColumnNames = null;
    protected boolean objectHasPolicy = false;
    protected RedactModel redactModel = null;
    protected RedactController redactController = null;

    protected List<ActionControl> createControls(Connection connection) {
        String string = this.getArgs();
        if (string.equals("DROP,TABLE") || string.equals("DROP,VIEW") || string.equals("DROP,MATERIALIZED_VIEW") || string.equals("DROP,COLUMN")) {
            this.policyName = this.redactModel.getPolicyName();
            this.policyDescription = this.redactModel.getPolicyDescription();
        } else if (string.equals("ENABLE_DISABLE,TABLE") || string.equals("ENABLE_DISABLE,VIEW") || string.equals("ENABLE_DISABLE,MATERIALIZED_VIEW") || string.equals("ENABLE_DISABLE,COLUMN")) {
            this.policyName = this.redactModel.getPolicyName();
            this.policyDescription = this.redactModel.getPolicyDescription();
            this.redactionEnabled = new Boolean(this.redactModel.isEnabled());
        } else if (string.equals("ALTER,TABLE") || string.equals("ALTER,VIEW") || string.equals("ALTER,MATERIALIZED_VIEW") || string.equals("ALTER,COLUMN")) {
            this.policyName = this.redactModel.getPolicyName();
            this.policyDescription = this.redactModel.getPolicyDescription();
            this.allColumnNames = this.redactModel.getNonRedactedColumnNames();
            this.redactionEnabled = new Boolean(this.redactModel.isEnabled());
            if (string.equals("ALTER,TABLE") || string.equals("ALTER,VIEW") || string.equals("ALTER,MATERIALIZED_VIEW")) {
                if (this.allColumnNames != null && this.allColumnNames.length > 0) {
                    this.columnName = this.allColumnNames[0];
                    this.columnDescription = "";
                } else {
                    this.columnName = "";
                    this.columnDescription = "";
                }
                this.redactModel.setColumnName(this.columnName);
                this.redactModel.setColumnDescription(this.columnDescription);
            }
            if (string.equals("ALTER,COLUMN")) {
                // empty if block
            }
        } else if (string.equals("ADD,TABLE") || string.equals("ADD,VIEW") || string.equals("ADD,MATERIALIZED_VIEW") || string.equals("ADD,COLUMN")) {
            this.policyName = "";
            this.policyDescription = "";
            this.columnDescription = "";
            this.redactionEnabled = true;
            if (string.equals("ADD,TABLE") || string.equals("ADD,VIEW") || string.equals("ADD,MATERIALIZED_VIEW")) {
                this.allColumnNames = this.redactModel.getAllColumnNames();
                if (this.allColumnNames != null && this.allColumnNames.length > 0) {
                    this.columnName = this.allColumnNames[0];
                    this.redactModel.setColumnName(this.columnName);
                    this.redactModel.setColumnDescription(this.columnDescription);
                }
            }
            if (string.equals("ADD,COLUMN")) {
                if (this.columnName != null) {
                    this.allColumnNames = new String[]{this.columnName};
                    this.redactModel.setColumnName(this.columnName);
                    this.redactModel.setColumnDescription(this.columnDescription);
                } else {
                    this.allColumnNames = new String[]{""};
                }
            }
        }
        this.policyNameCtl = new TextBoxActionControl("redaction_policy_name", SecurityArb.getString("SECURITY_REDACTION_POLICY_NAME_LABEL"), this.policyName, null, true);
        this.policyNameCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        this.policyDescriptionCtl = new TextBoxActionControl("redaction_policy_description", SecurityArb.getString("SECURITY_REDACTION_POLICY_DESCRIPTION_LABEL"), this.policyDescription, null, true);
        this.policyDescriptionCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        this.schemaNameCtl = new TextBoxActionControl("redaction_schema_name", SecurityArb.getString("SECURITY_REDACTION_POLICY_SCHEMA_NAME_LABEL"), this.schemaName, null, true);
        this.schemaNameCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        this.objectNameCtl = new TextBoxActionControl("redaction_object_name", SecurityArb.getString("SECURITY_REDACTION_POLICY_OBJECT_NAME_LABEL"), this.objectName, null, true);
        this.objectNameCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        if (!this.isDropEnableContext(string)) {
            this.columnNameCtl = new ComboBoxActionControl("redaction_column_name", SecurityArb.getString("SECURITY_REDACTION_POLICY_COLUMN_NAME_LABEL"), this.allColumnNames, this.columnName, true);
            this.columnNameCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
            this.columnDescriptionCtl = new TextBoxActionControl("redaction_column_description", SecurityArb.getString("SECURITY_REDACTION_POLICY_COLUMN_DESCRIPTION_LABEL"), this.columnDescription, null, true);
            this.columnDescriptionCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        }
        this.enabledCtl = new BooleanCheckBoxActionControl("redaction_policy_enabled", SecurityArb.getString("SECURITY_REDACTION_POLICY_ENABLED_LABEL"), this.redactionEnabled, false, true);
        this.enabledCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        Vector<ActionControl> vector = new Vector<ActionControl>();
        return vector;
    }

    public void launch() {
        boolean bl = this.checkRedactionPriviledges();
        if (bl) {
            this.objectHasPolicy = this.doesPolicyExist();
            if (!this.objectHasPolicy) {
                if (this.getArgs().startsWith("ENABLE_DISABLE") || this.getArgs().startsWith("DROP")) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)SecurityArb.getString("RedactionNoPolicyWarning"), (String)SecurityArb.getString("RedactionNoPolicyTitle"), null);
                } else {
                    this.createPolicy();
                }
            } else {
                this.createPolicy();
            }
        } else {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)SecurityArb.getString("RedactionGrantsMessageMissingWarning"), (String)SecurityArb.getString("RedactionGrantsTitleMissingWarning"), null);
        }
    }

    private void createPolicy() {
        DBObject dBObject = this.getDBObject();
        this.setContextInformation(dBObject);
        this.redactModel = new RedactModel(dBObject);
        this.redactController = new RedactController(this.redactModel, this);
        super.launch();
    }

    public abstract String getArgs();

    private void printDBObject(DBObject dBObject) {
    }

    private void setContextInformation(DBObject dBObject) {
        this.schemaName = dBObject.getSchemaName();
        this.objectName = dBObject.getObjectName();
        this.columnName = dBObject.getChildName();
    }

    public abstract String getOperationalContext();

    private boolean isDropEnableContext(String string) {
        return string.equals("DROP,TABLE") || string.equals("DROP,VIEW") || string.equals("DROP,MATERIALIZED_VIEW") || string.equals("DROP,COLUMN") || string.equals("ENABLE_DISABLE,TABLE") || string.equals("ENABLE_DISABLE,COLUMN") || string.equals("ENABLE_DISABLE,VIEW") || string.equals("ENABLE_DISABLE,MATERIALIZED_VIEW");
    }

    private boolean isDropContext() {
        String string = this.getArgs();
        return string.equals("DROP,TABLE") || string.equals("DROP,VIEW") || string.equals("DROP,MATERIALIZED_VIEW") || string.equals("DROP,COLUMN");
    }

    private boolean isEnableDisableContext() {
        String string = this.getArgs();
        return string.equals("ENABLE_DISABLE,TABLE") || string.equals("ENABLE_DISABLE,VIEW") || string.equals("ENABLE_DISABLE,MATERIALIZED_VIEW") || string.equals("ENABLE_DISABLE,COLUMN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRedactionPriviledges() {
        DBObject dBObject = this.getDBObject();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Vector<String> vector = new Vector<String>();
        if (dBObject != null) {
            ResultSetWrapper resultSetWrapper;
            Connection connection = dBObject.getConnection();
            if (Connections.getInstance().lock(connection)) {
                resultSetWrapper = null;
                try {
                    Object object;
                    ResultSetWrapper resultSetWrapper2 = DBUtil.getInstance((Connection)connection);
                    resultSetWrapper2.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("OWNER", dBObject.getSchemaName());
                    String string = this.getQuery(connection, "getRedactionPriviledges");
                    resultSetWrapper = resultSetWrapper2.executeOracleQuery(string, hashMap);
                    if (resultSetWrapper != null && (object = resultSetWrapper.getResultSet()) != null) {
                        while (object.next()) {
                            String string2 = object.getString("TABNAME");
                            if (string2 == null) continue;
                            vector.add(string2);
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    if (resultSetWrapper != null) {
                        resultSetWrapper.close();
                    }
                    Connections.getInstance().unlock(connection);
                }
            }
            if (vector.size() > 0) {
                resultSetWrapper = new String[vector.size()];
                vector.copyInto((Object[])resultSetWrapper);
                for (Object object : resultSetWrapper) {
                    if (((String)object).equalsIgnoreCase("REDACTION_POLICIES")) {
                        bl2 = true;
                    }
                    if (!((String)object).equalsIgnoreCase("REDACTION_COLUMNS")) continue;
                    bl3 = true;
                }
                bl = bl2 && bl3;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isEnabled(Context context) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesPolicyExist() {
        String string = null;
        boolean bl = false;
        DBObject dBObject = this.getDBObject();
        if (dBObject != null) {
            Connection connection = dBObject.getConnection();
            if (Connections.getInstance().lock(connection)) {
                ResultSetWrapper resultSetWrapper = null;
                try {
                    ResultSet resultSet;
                    String string2;
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("OWNER", dBObject.getSchemaName());
                    hashMap.put("OBJECT", dBObject.getObjectName());
                    if (connection == null) {
                        // empty if block
                    }
                    if ((resultSetWrapper = dBUtil.executeOracleQuery(string2 = this.getQuery(connection, "getPolicyPerObject"), hashMap)) != null && (resultSet = resultSetWrapper.getResultSet()) != null && resultSet.next()) {
                        string = resultSet.getString("POLICY_NAME");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    if (resultSetWrapper != null) {
                        resultSetWrapper.close();
                    }
                    Connections.getInstance().unlock(connection);
                }
            }
            bl = string != null && string.trim().length() > 0;
        }
        return bl;
    }

    public TextBoxActionControl getPolicyDescriptionCtl() {
        return this.policyDescriptionCtl;
    }

    protected boolean isDbVersion12() {
        boolean bl = DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)DBUtil.ORACLE12c_VERSION);
        return bl;
    }
}

