/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.security.redaction.dialogs;

import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.SimpleActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.CardLayoutActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.EditorActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.controls.SideBySideActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.security.SecurityArb;
import oracle.dbtools.security.redaction.controller.RedactController;
import oracle.dbtools.security.redaction.dialogs.ExpressionPropertyChangeListener;
import oracle.dbtools.security.redaction.dialogs.RedactConstants;
import oracle.dbtools.security.redaction.model.RedactModel;
import oracle.javatools.util.ArrayMap;

public class ExpressionActionDialog
extends SimpleActionDialog {
    protected EditorActionControl expressionEditorDefaultCtl = null;
    protected EditorActionControl expressionEditorAdvancedCtl = null;
    protected EditorActionControl expressionEditorApexCtl = null;
    protected BooleanCheckBoxActionControl editCheckCtl = null;
    protected BooleanCheckBoxActionControl defaultEditCheckCtl = null;
    protected SideBySideActionControl expressionEditorCheckCtl = null;
    protected ComboBoxActionControl userenvCtl = null;
    protected ComboBoxActionControl conditionChoiceCtl = null;
    protected TextBoxActionControl otherSchemaCtl = null;
    protected ComboBoxActionControl apexUserCtl = null;
    protected ComboBoxActionControl apexConditionCtl = null;
    protected TextBoxActionControl apexOtherUserCtl = null;
    protected String redactionExpressionValue = null;
    protected String redactionExpressionType = null;
    protected RedactModel redactModel = null;
    protected RedactController redactController = null;
    private CardLayoutActionControl whatExpressionTypeCtl = null;
    protected ExpressionPropertyChangeListener expressionPropertyChangeListener = null;
    private String defaultSession = RedactConstants.EXPRESSION_BUILDER_SESSION_LIST[0];
    private String defaultSessionChoice = RedactConstants.EXPRESSION_BUILDER_SESSION_CHOICE_LIST[0];
    private String otherUserName = "";
    private String expressionDefaultType = SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_DEFAULT_TYPE");
    private String expressionAdvancedType = SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_ADVANCED_TYPE");
    private String expressionApexType = SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_APEX_TYPE");

    public void setArgs(String string) {
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.redactionExpressionValue = this.redactModel.getExpression();
        this.redactionExpressionType = this.redactModel.getExpressionType();
        final PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl(RedactConstants.REDACTION_EXPRESSION_BUILDER_DEFAULT_PANEL_TYPE, RedactConstants.REDACTION_EXPRESSION_BUILDER_DEFAULT_PANEL_TYPE);
        this.expressionEditorDefaultCtl = new EditorActionControl("EXPRESSION_BUILDER_DEFAULT_EDITOR", SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_EDITOR_LABEL"), "1=1", "x.pls");
        this.expressionEditorDefaultCtl.addPropertyChangeListener((PropertyChangeListener)this.expressionPropertyChangeListener);
        this.expressionEditorDefaultCtl.setSpringVertical(true);
        this.expressionEditorDefaultCtl.setFillVertical(true);
        this.expressionEditorDefaultCtl.enableUI(false);
        this.expressionEditorDefaultCtl.setEditable(false);
        this.redactController.setUserEnv("1=1");
        propertyPanelActionControl.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(ExpressionActionDialog.this.expressionEditorDefaultCtl);
            }
        });
        propertyPanelActionControl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        final PropertyPanelActionControl propertyPanelActionControl2 = new PropertyPanelActionControl(RedactConstants.REDACTION_EXPRESSION_BUILDER_ADVANCED_PANEL_TYPE, RedactConstants.REDACTION_EXPRESSION_BUILDER_ADVANCED_PANEL_TYPE);
        this.userenvCtl = new ComboBoxActionControl("EXPRESSION_BUILDER_SESSION", SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_SESSION_LABEL"), RedactConstants.EXPRESSION_BUILDER_SESSION_LIST, this.defaultSession, true);
        this.redactModel.setUserEnv(this.defaultSession);
        this.userenvCtl.addPropertyChangeListener((PropertyChangeListener)this.expressionPropertyChangeListener);
        this.conditionChoiceCtl = new ComboBoxActionControl("EXPRESSION_BUILDER_SESSION_CHOICE", SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_USER_CHOICE_LABEL"), RedactConstants.EXPRESSION_BUILDER_SESSION_CHOICE_LIST, this.defaultSessionChoice, true);
        this.redactModel.setConditionChoice(this.defaultSessionChoice);
        this.conditionChoiceCtl.addPropertyChangeListener((PropertyChangeListener)this.expressionPropertyChangeListener);
        this.otherSchemaCtl = new TextBoxActionControl("EXPRESSION_BUILDER_OTHER_SCHEMA_NAME", SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_OTHER_SCHEMA_LABEL"), this.otherUserName, null, true);
        this.redactController.setOtherUser(this.otherUserName);
        this.otherSchemaCtl.addPropertyChangeListener((PropertyChangeListener)this.expressionPropertyChangeListener);
        this.expressionEditorAdvancedCtl = new EditorActionControl("EXPRESSION_BUILDER_ADVANCED_EDITOR", SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_EDITOR_LABEL"), this.redactionExpressionValue, "x.pls");
        this.expressionEditorAdvancedCtl.addPropertyChangeListener((PropertyChangeListener)this.expressionPropertyChangeListener);
        this.expressionEditorAdvancedCtl.setSpringVertical(true);
        this.expressionEditorAdvancedCtl.setFillVertical(true);
        this.expressionEditorAdvancedCtl.enableUI(false);
        this.editCheckCtl = new BooleanCheckBoxActionControl("EXPRESSION_BUILDER_EDITOR_ENABLE_CHECKBOX", SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_EDITOR_EDIT_CHECKBOX_LABEL"), false, false, true);
        this.editCheckCtl.addPropertyChangeListener((PropertyChangeListener)this.expressionPropertyChangeListener);
        propertyPanelActionControl2.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(ExpressionActionDialog.this.userenvCtl);
                this.add(ExpressionActionDialog.this.conditionChoiceCtl);
                this.add(ExpressionActionDialog.this.otherSchemaCtl);
                this.add(ExpressionActionDialog.this.editCheckCtl);
                this.add(ExpressionActionDialog.this.expressionEditorAdvancedCtl);
            }
        });
        propertyPanelActionControl2.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        ArrayMap<String, ActionControl> arrayMap = new ArrayMap<String, ActionControl>(){
            {
                this.put(RedactConstants.REDACTION_EXPRESSION_BUILDER_DEFAULT_PANEL_TYPE, propertyPanelActionControl);
                this.put(RedactConstants.REDACTION_EXPRESSION_BUILDER_ADVANCED_PANEL_TYPE, propertyPanelActionControl2);
            }
        };
        this.whatExpressionTypeCtl = new CardLayoutActionControl("EXPRESSION_BUILDER_TYPE_CARD_PANEL", null, CardLayoutPanel.Type.TITLE_BORDER, SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_TYPE_PANEL_TITLE"), (Map)arrayMap, true);
        if (this.redactionExpressionValue.equals("1=1")) {
            this.whatExpressionTypeCtl.setSelected((Object)RedactConstants.REDACTION_EXPRESSION_BUILDER_DEFAULT_PANEL_TYPE);
        } else if (this.redactionExpressionValue.equals("apex")) {
            this.whatExpressionTypeCtl.setSelected((Object)RedactConstants.REDACTION_EXPRESSION_BUILDER_APEX_PANEL_TYPE);
        } else {
            this.whatExpressionTypeCtl.setSelected((Object)RedactConstants.REDACTION_EXPRESSION_BUILDER_ADVANCED_PANEL_TYPE);
        }
        this.whatExpressionTypeCtl.setSpringVertical(true);
        this.whatExpressionTypeCtl.setFillVertical(true);
        this.whatExpressionTypeCtl.addPropertyChangeListener((PropertyChangeListener)this.expressionPropertyChangeListener);
        Vector<ActionControl> vector = new Vector<ActionControl>();
        vector.add((ActionControl)this.whatExpressionTypeCtl);
        return vector;
    }

    protected String getScript(SimpleActionDialog.Values values) {
        return null;
    }

    protected String getTitle() {
        return SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER");
    }

    public String getArgs() {
        return null;
    }

    public void invoke(RedactModel redactModel, RedactController redactController) {
        this.redactModel = redactModel;
        this.redactController = redactController;
        this.expressionPropertyChangeListener = new ExpressionPropertyChangeListener(this, this.redactModel, this.redactController);
        super.invoke(this.redactModel.getDBObject());
    }

    public void unsetDefaultExpression() {
        this.userenvCtl.enableUI(true);
        this.conditionChoiceCtl.enableUI(true);
        this.otherSchemaCtl.enableUI(true);
        this.defaultEditCheckCtl.set(false);
        this.editCheckCtl.enableUI(true);
        this.editCheckCtl.setEditable(true);
        this.expressionEditorAdvancedCtl.set(this.redactModel.getAdvancedExpression());
        this.enableAdvancedEditor();
    }

    public void setDefaultExpression() {
        this.userenvCtl.enableUI(false);
        this.conditionChoiceCtl.enableUI(false);
        this.otherSchemaCtl.enableUI(false);
        this.editCheckCtl.enableUI(false);
        this.editCheckCtl.setEditable(false);
        this.defaultEditCheckCtl.set(true);
        this.expressionEditorDefaultCtl.set("1=1");
        this.redactController.setDefaultExpression();
        this.disableAdvancedEditor();
    }

    public void enableAdvancedEditor() {
        this.expressionEditorAdvancedCtl.enableUI(true);
        this.expressionEditorAdvancedCtl.setEditable(true);
    }

    public void disableAdvancedEditor() {
        this.expressionEditorAdvancedCtl.enableUI(false);
        this.expressionEditorAdvancedCtl.setEditable(false);
    }

    public void createUserPolicyExpression() {
        String string = this.redactModel.getUserEnv();
        string = string.equals(SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_SESSION_USER")) ? "SESSION_USER" : (string.equals(SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_SESSION_ROLE")) ? "SESSION_ROLE" : (string.equals(SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_SESSION_APPLICATION")) ? "APPLICATION_MODULE" : (string.equals(SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_SESSION_CLIENT_IDENTIFIER")) ? "CLIENT_IDENTIFIER" : (string.equals(SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_SESSION_CLIENT_INFORMATION")) ? "CLIENT_INFORMATION" : (string.equals(SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_SESSION_CLIENT_IP_ADDRESS")) ? "CLIENT_IP_ADDRESS" : (string.equals(SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_SESSION_CLIENT_MACHINE_NAME")) ? "CLIENT_MACHINE_NAME" : "SESSION_USER"))))));
        String string2 = this.redactModel.getConditionChoice();
        string2 = string2.equals(SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_USER_CHOICE_ISNOT")) ? "!=" : (string2.equals(SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_BUILDER_USER_CHOICE_IS")) ? "=" : "!=");
        String string3 = this.redactModel.getOtherUser();
        String string4 = "SYS_CONTEXT ( ''USERENV'',''" + string + "''" + " ) " + string2 + "''" + this.redactModel.getOtherUser() + "''";
        this.redactController.setAdvancedExpression(string4);
        this.enableAdvancedEditor();
        this.expressionEditorAdvancedCtl.set(this.redactModel.getAdvancedExpression());
    }

    protected void processDialogOnApply(JEWTDialog jEWTDialog) {
        this.redactController.updateExpressionOnDialog();
    }
}

