/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.security.redaction.generator;

import java.sql.Connection;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorGroupLoader;
import oracle.javatools.db.DBException;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class RedactCodeGenerator {
    private static volatile RedactCodeGenerator _instance;
    private Map<String, StringTemplateGroup> templateGroups = new Hashtable<String, StringTemplateGroup>();

    private RedactCodeGenerator() {
        this.initGroupLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedactCodeGenerator getInstance() {
        if (_instance != null) return _instance;
        Class<RedactCodeGenerator> clazz = RedactCodeGenerator.class;
        synchronized (RedactCodeGenerator.class) {
            if (_instance != null) return _instance;
            _instance = new RedactCodeGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private void initGroupLoader() {
        try {
            RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader("oracle/dbtools/security/redaction/generator/templates", this.getClass().getClassLoader());
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringTemplateGroup getTemplateGroup(String string) {
        if (string == null || string.length() == 0) {
            StringTemplateGroup stringTemplateGroup = this.fetchTemplateGroup("");
            return stringTemplateGroup;
        }
        StringTemplateGroup stringTemplateGroup = this.templateGroups.get(string);
        if (stringTemplateGroup == null) {
            Map<String, StringTemplateGroup> map = this.templateGroups;
            synchronized (map) {
                stringTemplateGroup = this.templateGroups.get(string);
                if (stringTemplateGroup == null) {
                    String[] stringArray = string.split("\\.");
                    for (int i = stringArray.length; i > 0; --i) {
                        String string2 = "";
                        for (int j = 0; j < i; ++j) {
                            string2 = j == 0 ? string2 + stringArray[j] : string2 + "_" + stringArray[j];
                        }
                        stringTemplateGroup = this.fetchTemplateGroup(string2);
                        if (stringTemplateGroup != null) break;
                    }
                    if (stringTemplateGroup == null) {
                        stringTemplateGroup = this.fetchTemplateGroup("");
                    }
                }
                if (stringTemplateGroup != null) {
                    this.templateGroups.put(string, stringTemplateGroup);
                }
            }
        }
        return stringTemplateGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringTemplateGroup fetchTemplateGroup(String string) {
        StringTemplateGroup stringTemplateGroup = this.templateGroups.get(string);
        if (stringTemplateGroup == null) {
            Map<String, StringTemplateGroup> map = this.templateGroups;
            synchronized (map) {
                stringTemplateGroup = this.templateGroups.get(string);
                if (stringTemplateGroup == null) {
                    String string2 = "DBMS_REDACT_" + string;
                    stringTemplateGroup = StringTemplateGroup.loadGroup((String)string2);
                    if (stringTemplateGroup == null) {
                        return null;
                    }
                    this.templateGroups.put(string, stringTemplateGroup);
                }
            }
        }
        return stringTemplateGroup;
    }

    public StringTemplate getTemplate(String string, String string2) {
        try {
            StringTemplateGroup stringTemplateGroup = this.getTemplateGroup(string);
            if (stringTemplateGroup != null) {
                StringTemplate stringTemplate = stringTemplateGroup.lookupTemplate(string2);
                if (stringTemplate != null) {
                    stringTemplate.reset();
                }
                return stringTemplate;
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(RedactCodeGenerator.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        }
        return null;
    }

    public String generateForConnection(String string, String string2, Map<String, Object> map) {
        try {
            return this.generate(Connections.getInstance().getConnection(string), string2, map);
        }
        catch (DBException dBException) {
            return null;
        }
    }

    public String generate(Connection connection, String string, Map<String, Object> map) {
        String string2 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
        return this.generate(string2, string, map);
    }

    public String generate(String string, String string2, Map<String, Object> map) {
        String string3 = null;
        try {
            StringTemplate stringTemplate = this.getTemplate(string, string2);
            if (stringTemplate != null) {
                stringTemplate.reset();
                if (map != null) {
                    stringTemplate.setAttributes(map);
                }
                string3 = stringTemplate.toString();
                if (string.startsWith("10")) {
                    string3 = string3.replaceAll("\r\n", "\n");
                }
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(RedactCodeGenerator.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        }
        return string3;
    }

    public String getQuery(String string, String string2) {
        StringTemplateGroup stringTemplateGroup = this.getTemplateGroup(string2);
        StringTemplate stringTemplate = stringTemplateGroup.lookupTemplate(string);
        if (stringTemplate == null) {
            return null;
        }
        return stringTemplate.toString();
    }
}

