/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.security.redaction.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.security.redaction.dialogs.RedactConstants;
import oracle.dbtools.security.redaction.model.RedactColumn;
import oracle.dbtools.security.redaction.utils.RedactUtils;

public class RedactModel {
    private HashMap<String, String> redactModel = null;
    private HashMap<String, String> oldRedactModel = null;
    private RedactColumn[] oldRedactColumns = null;
    private DBObject dbObject;
    private Connection connection;
    private String operationMode = null;
    private String operationObject = null;
    private String[] allColumnNames = null;
    private String[] redactedColumnNames = null;
    private String[] nonRedactedColumnNames = null;
    private String sessionUser = null;
    private String sessionChoice = null;
    private String otherUser = null;
    private String advancedExpression = null;
    private String defaultExpression = null;

    public RedactModel(DBObject dBObject) {
        this.createOldModel();
        this.createDefaultModel();
        this.setDBObject(dBObject);
        this.setPreviousPolicyName();
        this.setAllObjectColumns();
        this.setPreviousRedactedColumns();
        this.setPreviousNonRedactedColumns();
        this.setPreviousExpression();
        this.setPreviousEnableDisabled();
        this.setOldRedactionModel();
        if (dBObject.getChildName() != null) {
            this.setPreviousFunctionInformation();
            this.setPreviousRegexpInformation();
        }
    }

    private void setContextInformation(DBObject dBObject) {
        this.setSchemaName(dBObject.getSchemaName());
        this.setObjectName(dBObject.getObjectName());
        this.setColumnName(dBObject.getChildName());
    }

    public void setDBObject(DBObject dBObject) {
        this.dbObject = dBObject;
        this.connection = dBObject != null ? dBObject.getConnection() : null;
        this.setContextInformation(this.dbObject);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DBObject getDBObject() {
        return this.dbObject;
    }

    public String getDBObjectSchemaName() {
        return this.getDBObject().getSchemaName();
    }

    public String getDBObjectName() {
        return this.getDBObject().getObjectName();
    }

    public String getDBObjectChildName() {
        return this.getDBObject().getChildName();
    }

    public String getDBVersion() {
        return this.dbObject != null ? this.dbObject.getDBVersion() : null;
    }

    public void setArgsContext(String string) {
        String[] stringArray = string.split(",");
        this.operationMode = stringArray[0].trim();
        this.operationObject = stringArray[1].trim();
    }

    public String getOperationMode() {
        return this.operationMode;
    }

    public String getOperationObject() {
        return this.operationObject;
    }

    public HashMap<String, String> getRedactModel() {
        return this.redactModel;
    }

    private void createOldModel() {
        this.oldRedactModel = new HashMap();
        this.oldRedactModel.put("redaction_policy_name", null);
        this.oldRedactModel.put("redaction_policy_description", null);
        this.oldRedactModel.put("redaction_schema_name", null);
        this.oldRedactModel.put("redaction_object_name", null);
        this.oldRedactModel.put("redaction_column_name", null);
        this.oldRedactModel.put("redaction_column_description", null);
        this.oldRedactModel.put("redaction_policy_enabled", null);
        this.oldRedactModel.put("redaction_expression", null);
        this.oldRedactModel.put("redaction_expression_type", null);
        this.oldRedactModel.put("redaction_function_type", null);
        this.oldRedactModel.put("redaction_function_parameters", null);
        this.oldRedactModel.put("redaction_regexp_pattern", null);
        this.oldRedactModel.put("redaction_regexp_replace_string", null);
        this.oldRedactModel.put("redaction_regexp_position", "1");
        this.oldRedactModel.put("redaction_regexp_occurrence", "0");
        this.oldRedactModel.put("redaction_regexp_match_parameter", null);
        this.setOldActionType(null);
    }

    private void createDefaultModel() {
        this.redactModel = new HashMap();
        this.redactModel.put("redaction_policy_name", null);
        this.redactModel.put("redaction_policy_description", null);
        this.redactModel.put("redaction_schema_name", null);
        this.redactModel.put("redaction_object_name", null);
        this.redactModel.put("redaction_column_name", null);
        this.redactModel.put("redaction_column_description", null);
        this.redactModel.put("redaction_policy_enabled", "TRUE");
        this.redactModel.put("redaction_expression", null);
        this.redactModel.put("redaction_expression_type", null);
        this.redactModel.put("redaction_function_parameters_isregexp", "false");
        this.redactModel.put("redaction_function_type", "DBMS_REDACT.FULL");
        this.redactModel.put("redaction_function_parameters_none", null);
        this.redactModel.put("redaction_function_parameters_full", null);
        this.redactModel.put("redaction_function_parameters_partial", null);
        this.redactModel.put("redaction_function_parameters_random", null);
        this.redactModel.put("redaction_regexp_pattern", null);
        this.redactModel.put("redaction_regexp_replace_string", null);
        this.redactModel.put("redaction_regexp_position", "1");
        this.redactModel.put("redaction_regexp_occurrence", "0");
        this.redactModel.put("redaction_regexp_match_parameter", null);
        this.setActionType(RedactConstants.REDACTION_ALTER_ACTION_TYPE_ADD_COLUMN);
    }

    public void setPolicyName(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_policy_name", string.trim());
        } else {
            this.redactModel.put("redaction_policy_name", "");
        }
    }

    public String getPolicyName() {
        return this.redactModel.get("redaction_policy_name");
    }

    public void printPolicyName() {
        this.printHashValue("redaction_policy_name", this.getPolicyName());
    }

    public void setOldPolicyName(String string) {
        if (string != null && string.length() > 0) {
            this.oldRedactModel.put("redaction_policy_name", string);
        }
    }

    public String getOldPolicyName() {
        return this.oldRedactModel.get("redaction_policy_name");
    }

    public void printOldPolicyName() {
        this.printHashValue("redaction_policy_name", this.getOldPolicyName());
    }

    public void setPolicyDescription(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_policy_description", string);
        }
    }

    public String getPolicyDescription() {
        return this.redactModel.get("redaction_policy_description");
    }

    public void printPolicyDescription() {
        this.printHashValue("redaction_policy_description", this.getPolicyDescription());
    }

    public void setOldPolicyDescription(String string) {
        if (string != null && string.length() > 0) {
            this.oldRedactModel.put("redaction_policy_description", string);
        }
    }

    public String getOldPolicyDescription() {
        return this.oldRedactModel.get("redaction_policy_description");
    }

    public void printOldPolicyDescription() {
        this.printHashValue("redaction_policy_description", this.getOldPolicyDescription());
    }

    public void setSchemaName(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_schema_name", string);
        }
    }

    public String getSchemaName() {
        return this.redactModel.get("redaction_schema_name");
    }

    public void printSchemaName() {
        this.printHashValue("redaction_schema_name", this.getSchemaName());
    }

    public void setOldSchemaName(String string) {
        if (string != null && string.length() > 0) {
            this.oldRedactModel.put("redaction_schema_name", string);
        }
    }

    public String getOldSchemaName() {
        return this.oldRedactModel.get("redaction_schema_name");
    }

    public void printOldSchemaName() {
        this.printHashValue("redaction_schema_name", this.getOldSchemaName());
    }

    public void setObjectName(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_object_name", string);
        }
    }

    public String getObjectName() {
        return this.redactModel.get("redaction_object_name");
    }

    public void printObjectName() {
        this.printHashValue("redaction_object_name", this.getObjectName());
    }

    public void setOldObjectName(String string) {
        if (string != null && string.length() > 0) {
            this.oldRedactModel.put("redaction_object_name", string);
        }
    }

    public String getOldObjectName() {
        return this.oldRedactModel.get("redaction_object_name");
    }

    public void printOldObjectName() {
        this.printHashValue("redaction_object_name", this.getOldObjectName());
    }

    public void setEnabled(String string) {
        if (string != null && string.length() > 0) {
            if ((string = string.trim()).equalsIgnoreCase("YES") || string.equalsIgnoreCase("TRUE")) {
                this.redactModel.put("redaction_policy_enabled", "TRUE");
            } else if (string.equalsIgnoreCase("NO") || string.equalsIgnoreCase("FALSE")) {
                this.redactModel.put("redaction_policy_enabled", "FALSE");
            } else {
                this.redactModel.put("redaction_policy_enabled", "FALSE");
            }
        }
    }

    public String isEnabled() {
        String string = this.redactModel.get("redaction_policy_enabled");
        if (string != null) {
            string.toUpperCase();
        }
        return string;
    }

    public void printIsEnabled() {
        this.printHashValue("redaction_policy_enabled", this.isEnabled());
    }

    public void setOldEnabled(String string) {
        if (string != null && string.length() > 0) {
            this.oldRedactModel.put("redaction_policy_enabled", string.toUpperCase());
        }
    }

    public String isOldEnabled() {
        String string = this.oldRedactModel.get("redaction_policy_enabled");
        if (string != null) {
            string.toUpperCase();
        }
        return string;
    }

    public void printOldIsEnabled() {
        this.printHashValue("redaction_policy_enabled", this.isOldEnabled());
    }

    public void setExpression(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_expression", string);
        }
    }

    public String getExpression() {
        return this.redactModel.get("redaction_expression");
    }

    public void printExpression() {
        this.printHashValue("redaction_expression", this.getExpression());
    }

    public void setOldExpression(String string) {
        if (string != null && string.length() > 0) {
            this.oldRedactModel.put("redaction_expression", string);
        }
    }

    public String getOldExpression() {
        return this.oldRedactModel.get("redaction_expression");
    }

    public void printOldExpression() {
        this.printHashValue("redaction_expression", this.getOldExpression());
    }

    public void setExpressionType(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_expression_type", string);
        }
    }

    public String getExpressionType() {
        return this.redactModel.get("redaction_expression_type");
    }

    public void printExpressionType() {
        this.printHashValue("redaction_expression_type", this.getExpressionType());
    }

    public void setOldExpressionType(String string) {
        if (string != null && string.length() > 0) {
            this.oldRedactModel.put("redaction_expression_type", string);
        }
    }

    public String getOldExpressionType() {
        return this.oldRedactModel.get("redaction_expression_type");
    }

    public void printOldExpressionType() {
        this.printHashValue("redaction_expression_type", this.getOldExpressionType());
    }

    public void setColumnName(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_column_name", string);
        }
    }

    public String getColumnName() {
        return this.redactModel.get("redaction_column_name");
    }

    public void printColumnName() {
        this.printHashValue("redaction_column_name", this.getColumnName());
    }

    public void setOldColumnName(String string) {
        this.oldRedactModel.put("redaction_column_name", string);
    }

    public String getOldColumnName() {
        return this.oldRedactModel.get("redaction_column_name");
    }

    public void printOldColumnName() {
        this.printHashValue("redaction_column_name", this.getOldColumnName());
    }

    public void setColumnDescription(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_column_description", string);
        }
    }

    public String getColumnDescription() {
        return this.redactModel.get("redaction_column_description");
    }

    public void printColumnDescription() {
        this.printHashValue("redaction_column_description", this.getColumnDescription());
    }

    public void setOldColumnDescription(String string) {
        this.oldRedactModel.put("redaction_column_description", string);
    }

    public String getOldColumnDescription() {
        return this.oldRedactModel.get("redaction_column_description");
    }

    public void printOldColumnDescription() {
        this.printHashValue("redaction_column_description", this.getOldColumnDescription());
    }

    public void setFunctionType(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_function_type", this.convertToDMBS_Constant(string));
        }
    }

    public String getFunctionType() {
        return this.redactModel.get("redaction_function_type");
    }

    public void printFunctionType() {
        this.printHashValue("redaction_function_type", this.getFunctionType());
    }

    public String convertToDMBS_Constant(String string) {
        if (string.equals(RedactConstants.REDACTION_FUNCTION_TYPE_NONE) || string.equals("NONE REDACTION")) {
            return "DBMS_REDACT.NONE";
        }
        if (string.equals(RedactConstants.REDACTION_FUNCTION_TYPE_FULL) || string.equals("FULL REDACTION")) {
            return "DBMS_REDACT.FULL";
        }
        if (string.equals(RedactConstants.REDACTION_FUNCTION_TYPE_PARTIAL) || string.equals("PARTIAL REDACTION")) {
            return "DBMS_REDACT.PARTIAL";
        }
        if (string.equals(RedactConstants.REDACTION_FUNCTION_TYPE_RANDOM) || string.equals("RANDOM REDACTION")) {
            return "DBMS_REDACT.RANDOM";
        }
        if (string.equals(RedactConstants.REDACTION_FUNCTION_TYPE_REGEXP) || string.equals("REGEXP REDACTION")) {
            return "DBMS_REDACT.REGEXP";
        }
        return "DBMS_REDACT.FULL";
    }

    public void setOldFunctionType(String string) {
        this.oldRedactModel.put("redaction_function_type", this.convertToDMBS_Constant(string));
    }

    public String getOldFunctionType() {
        return this.oldRedactModel.get("redaction_function_type");
    }

    public String convertDatabaseToModelConstant(String string) {
        if (string.equals("NONE REDACTION")) {
            return RedactConstants.REDACTION_FUNCTION_TYPE_NONE;
        }
        if (string.equals("FULL REDACTION")) {
            return RedactConstants.REDACTION_FUNCTION_TYPE_FULL;
        }
        if (string.equals("PARTIAL REDACTION")) {
            return RedactConstants.REDACTION_FUNCTION_TYPE_PARTIAL;
        }
        if (string.equals("RANDOM REDACTION")) {
            return RedactConstants.REDACTION_FUNCTION_TYPE_RANDOM;
        }
        if (string.equals("REGEXP REDACTION")) {
            return RedactConstants.REDACTION_FUNCTION_TYPE_REGEXP;
        }
        return RedactConstants.REDACTION_FUNCTION_TYPE_FULL;
    }

    public void printOldFunctionType() {
        this.printHashValue("redaction_function_type", this.getOldFunctionType());
    }

    public void setFunctionParameterNone(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_function_parameters_none", string);
            this.redactModel.put("redaction_function_parameters", string);
        }
    }

    public String getFunctionParameterNone() {
        return this.redactModel.get("redaction_function_parameters_none");
    }

    public void printFunctionParametersNone() {
        this.printHashValue("redaction_function_parameters_none", this.getFunctionParameterNone());
    }

    public void setFunctionParameterFull(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_function_parameters_full", string);
            this.redactModel.put("redaction_function_parameters", string);
        }
    }

    public String getFunctionParameterFull() {
        return this.redactModel.get("redaction_function_parameters_full");
    }

    public void printFunctionParametersFull() {
        this.printHashValue("redaction_function_parameters_full", this.getFunctionParameterFull());
    }

    public void setFunctionParameterPartial(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_function_parameters_partial", string);
            this.redactModel.put("redaction_function_parameters", string);
        }
    }

    public String getFunctionParameterPartial() {
        return this.redactModel.get("redaction_function_parameters_partial");
    }

    public void printFunctionParametersPartial() {
        this.printHashValue("redaction_function_parameters_partial", this.getFunctionParameterPartial());
    }

    public void setFunctionParameterRandom(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_function_parameters_random", string);
            this.redactModel.put("redaction_function_parameters", string);
        }
    }

    public String getFunctionParameterRandom() {
        return this.redactModel.get("redaction_function_parameters_random");
    }

    public void printFunctionParametersRandom() {
        this.printHashValue("redaction_function_parameters_random", this.getFunctionParameterRandom());
    }

    public void setFunctionParameters(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_function_parameters", string);
        }
    }

    public void resetFunctionParameters() {
        this.redactModel.put("redaction_function_parameters", null);
    }

    public String getFunctionParameters() {
        return this.redactModel.get("redaction_function_parameters");
    }

    public void printFunctionParameters() {
        this.printHashValue("redaction_function_parameters", this.getFunctionParameters());
    }

    public void setOldFunctionParameters(String string) {
        this.oldRedactModel.put("redaction_function_parameters", string);
    }

    public String getOldFunctionParameters() {
        return this.oldRedactModel.get("redaction_function_parameters");
    }

    public void printOldFunctionParameters() {
        this.printHashValue("redaction_function_parameters", this.getOldFunctionParameters());
    }

    public void setActionType(String string) {
        if (string != null && string.length() > 0) {
            if (string.equals(RedactConstants.REDACTION_ALTER_ACTION_TYPE_ADD_COLUMN) || string.equals("DBMS_REDACT.ADD_COLUMN")) {
                this.redactModel.put("redaction_alter_action", "DBMS_REDACT.ADD_COLUMN");
            } else if (string.equals(RedactConstants.REDACTION_ALTER_ACTION_TYPE_MODIFY_COLUMN) || string.equals("DBMS_REDACT.MODIFY_COLUMN")) {
                this.redactModel.put("redaction_alter_action", "DBMS_REDACT.MODIFY_COLUMN");
            } else if (string.equals(RedactConstants.REDACTION_ALTER_ACTION_TYPE_DROP_COLUMN) || string.equals("DBMS_REDACT.DROP_COLUMN")) {
                this.redactModel.put("redaction_alter_action", "DBMS_REDACT.DROP_COLUMN");
            } else if (string.equals(RedactConstants.REDACTION_ALTER_ACTION_TYPE_MODIFY_EXPRESSION) || string.equals("DBMS_REDACT.MODIFY_EXPRESSION")) {
                this.redactModel.put("redaction_alter_action", "DBMS_REDACT.MODIFY_EXPRESSION");
            }
        } else {
            this.redactModel.put("redaction_alter_action", null);
        }
    }

    public String getActionType() {
        return this.redactModel.get("redaction_alter_action");
    }

    public void printActionType() {
        this.printHashValue("redaction_alter_action", this.getActionType());
    }

    public void setOldActionType(String string) {
        if (string != null && string.length() > 0) {
            if (string.equals(RedactConstants.REDACTION_ALTER_ACTION_TYPE_ADD_COLUMN) || string.equals("DBMS_REDACT.ADD_COLUMN")) {
                this.oldRedactModel.put("redaction_alter_action", "DBMS_REDACT.ADD_COLUMN");
            } else if (string.equals(RedactConstants.REDACTION_ALTER_ACTION_TYPE_MODIFY_COLUMN) || string.equals("DBMS_REDACT.MODIFY_COLUMN")) {
                this.oldRedactModel.put("redaction_alter_action", "DBMS_REDACT.MODIFY_COLUMN");
            } else if (string.equals(RedactConstants.REDACTION_ALTER_ACTION_TYPE_DROP_COLUMN) || string.equals("DBMS_REDACT.DROP_COLUMN")) {
                this.oldRedactModel.put("redaction_alter_action", "DBMS_REDACT.DROP_COLUMN");
            } else if (string.equals(RedactConstants.REDACTION_ALTER_ACTION_TYPE_MODIFY_EXPRESSION) || string.equals("DBMS_REDACT.MODIFY_EXPRESSION")) {
                this.oldRedactModel.put("redaction_alter_action", "DBMS_REDACT.MODIFY_EXPRESSION");
            }
        } else {
            this.oldRedactModel.put("redaction_alter_action", null);
        }
    }

    public String getOldActionType() {
        return this.oldRedactModel.get("redaction_alter_action");
    }

    public void printOldActionType() {
        this.printHashValue("redaction_alter_action", this.getOldActionType());
    }

    public void setIsRegexp(String string) {
        this.redactModel.put("redaction_function_parameters_isregexp", string);
    }

    public String getIsRegexp() {
        return this.redactModel.get("redaction_function_parameters_isregexp");
    }

    public void printIsRegexp() {
        this.printHashValue("redaction_function_parameters_isregexp", this.getIsRegexp());
    }

    public void setOldIsRegexp(String string) {
        this.oldRedactModel.put("redaction_function_parameters_isregexp", string);
    }

    public String getOldIsRegexp() {
        return this.oldRedactModel.get("redaction_function_parameters_isregexp");
    }

    public void printOldIsRegexp() {
        this.printHashValue("redaction_function_parameters_isregexp", this.getOldIsRegexp());
    }

    public void setRegexpPattern(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_regexp_pattern", string);
        }
    }

    public String getRegexpPattern() {
        return this.redactModel.get("redaction_regexp_pattern");
    }

    public void printRegexpPattern() {
        this.printHashValue("redaction_regexp_pattern", this.getRegexpPattern());
    }

    public void setOldRegexpPattern(String string) {
        this.oldRedactModel.put("redaction_regexp_pattern", string);
    }

    public String getOldRegexpPattern() {
        return this.oldRedactModel.get("redaction_regexp_pattern");
    }

    public void printOldRegexpPattern() {
        this.printHashValue("redaction_regexp_pattern", this.getOldRegexpPattern());
    }

    public void setRegexpReplaceString(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_regexp_replace_string", string);
        }
    }

    public String getRegexpReplaceString() {
        return this.redactModel.get("redaction_regexp_replace_string");
    }

    public void printRegexpReplaceString() {
        this.printHashValue("redaction_regexp_replace_string", this.getRegexpReplaceString());
    }

    public void setOldRegexpReplaceString(String string) {
        this.oldRedactModel.put("redaction_regexp_replace_string", string);
    }

    public String getOldRegexpReplaceString() {
        return this.oldRedactModel.get("redaction_regexp_replace_string");
    }

    public void printOldRegexpReplaceString() {
        this.printHashValue("redaction_regexp_replace_string", this.getOldRegexpReplaceString());
    }

    public void setRegexpPosition(String string) {
        if (string != null && string.length() > 0) {
            if (Integer.parseInt(string) <= 0) {
                string = "1";
            }
            this.redactModel.put("redaction_regexp_position", string);
        }
    }

    public String getRegexpPosition() {
        return this.redactModel.get("redaction_regexp_position");
    }

    public void printRegexpPosition() {
        this.printHashValue("redaction_regexp_position", this.getRegexpPosition());
    }

    public void setOldRegexpPosition(String string) {
        if (Integer.parseInt(string) <= 0) {
            string = "1";
        }
        this.oldRedactModel.put("redaction_regexp_position", string);
    }

    public String getOldRegexpPosition() {
        return this.oldRedactModel.get("redaction_regexp_position");
    }

    public void printOldRegexpPosition() {
        this.printHashValue("redaction_regexp_position", this.getOldRegexpPosition());
    }

    public void setRegexpOccurrence(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_regexp_occurrence", string);
        }
    }

    public String getRegexpOccurrence() {
        return this.redactModel.get("redaction_regexp_occurrence");
    }

    public void printRegexpOccurrence() {
        this.printHashValue("redaction_regexp_occurrence", this.getRegexpOccurrence());
    }

    public void setOldRegexpOccurrence(String string) {
        this.oldRedactModel.put("redaction_regexp_occurrence", string);
    }

    public String getOldRegexpOccurrence() {
        return this.oldRedactModel.get("redaction_regexp_occurrence");
    }

    public void printOldRegexpOccurrence() {
        this.printHashValue("redaction_regexp_occurrence", this.getOldRegexpOccurrence());
    }

    public void setRegexpMatchParameter(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_regexp_match_parameter", string);
        }
    }

    public String getRegexpMatchParameter() {
        return this.redactModel.get("redaction_regexp_match_parameter");
    }

    public void printRegexpMatchParameter() {
        this.printHashValue("redaction_regexp_match_parameter", this.getRegexpMatchParameter());
    }

    public void setOldRegexpMatchParameter(String string) {
        this.oldRedactModel.put("redaction_regexp_match_parameter", string);
    }

    public String getOldRegexpMatchParameter() {
        return this.oldRedactModel.get("redaction_regexp_match_parameter");
    }

    public void printOldRegexpMatchParameter() {
        this.printHashValue("redaction_regexp_match_parameter", this.getOldRegexpMatchParameter());
    }

    private void printHashValue(String string, String string2) {
        RedactUtils.printKeyValue(string, string2);
    }

    public void printModel() {
        this.printPolicyName();
        this.printPolicyDescription();
        this.printSchemaName();
        this.printObjectName();
        this.printColumnName();
        this.printColumnDescription();
        this.printIsEnabled();
        this.printExpression();
        this.printFunctionType();
        this.printFunctionParameters();
        this.printRegexpPattern();
        this.printRegexpReplaceString();
        this.printRegexpPosition();
        this.printRegexpOccurrence();
        this.printRegexpMatchParameter();
        this.printActionType();
    }

    protected String getQuery(Connection connection, String string) {
        return Utils.getQuery(this.getClass(), (Connection)connection, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousPolicyName() {
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OWNER", this.getDBObjectSchemaName());
                hashMap.put("OBJECT", this.getDBObjectName());
                String string = this.getQuery(connection, "getPoliciesGivenOwnerObject");
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setPolicyFromResultSet(resultSet, connection);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    protected void setPolicyFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "NAME_POLICY");
                String string2 = this.getStringFromRS(resultSet, "DESCRIPTION_POLICY");
                this.setPolicyName(string);
                this.setPolicyDescription(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllObjectColumns() {
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OWNER", this.getDBObjectSchemaName());
                hashMap.put("OBJECT", this.getDBObjectName());
                String string = this.getQuery(connection, "getColumnsGivenOwnerObject");
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setAllColumnNamesFromResultSet(resultSet, connection);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public void setAllColumnNamesFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "COLUMN_NAME");
                arrayList.add(string);
            }
        }
        this.allColumnNames = new String[arrayList.size()];
        arrayList.toArray(this.allColumnNames);
    }

    public String[] getAllColumnNames() {
        return this.allColumnNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousExpression() {
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                String string;
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OWNER", this.getDBObjectSchemaName());
                hashMap.put("OBJECT", this.getDBObjectName());
                if (connection == null) {
                    // empty if block
                }
                if ((resultSetWrapper = dBUtil.executeOracleQuery(string = this.getQuery(connection, "getExpressionGivenOwnerObject"), hashMap)) != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setExpressionFromResultSet(resultSet, connection);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    protected void setExpressionFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "EXPRESSION");
                if (string != null && string.contains("'")) {
                    string = string.replace("'", "''");
                }
                this.setExpression(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousEnableDisabled() {
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OWNER", this.getDBObjectSchemaName());
                hashMap.put("OBJECT", this.getDBObjectName());
                String string = this.getQuery(connection, "getEnableGivenOwnerObject");
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setEnableFromResultSet(resultSet, connection);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    protected void setEnableFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "ENABLE");
                this.setEnabled(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousFunctionInformation() {
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("XOWNER", this.getDBObjectSchemaName());
                hashMap.put("XOBJECT", this.getDBObjectName());
                hashMap.put("XCOLUMN", this.getDBObjectChildName());
                String string = this.getQuery(connection, "getFuntionInformationGivenOwnerObject");
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setFunctionInformationFromResultSet(resultSet, connection);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    protected void setFunctionInformationFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "FUNCTION_TYPE");
                this.setDBMSFunctionTypeFromDB(string);
                String string2 = this.getStringFromRS(resultSet, "FUNCTION_PARAMETERS");
                this.setFunctionParameters(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousRegexpInformation() {
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("XOWNER", this.getDBObjectSchemaName());
                hashMap.put("XOBJECT", this.getDBObjectName());
                hashMap.put("XCOLUMN", this.getDBObjectChildName());
                String string = this.getQuery(connection, "getRegexpInformationGivenOwnerObject");
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setRegexpInformationFromResultSet(resultSet, connection);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    protected void setRegexpInformationFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "REGEXP_PATTERN");
                this.setRegexpPattern(string);
                String string2 = this.getStringFromRS(resultSet, "REGEXP_REPLACE_STRING");
                this.setRegexpReplaceString(string2);
                String string3 = this.getStringFromRS(resultSet, "REGEXP_POSITION");
                this.setRegexpPosition(string3);
                String string4 = this.getStringFromRS(resultSet, "REGEXP_OCCURRENCE");
                this.setRegexpOccurrence(string4);
                String string5 = this.getStringFromRS(resultSet, "REGEXP_MATCH_PARAMETER");
                this.setRegexpMatchParameter(string5);
            }
        }
    }

    private String getStringFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getString(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private int getIntFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getInt(string);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public void setDBMSFunctionTypeFromDB(String string) {
        if (string != null && string.length() > 0) {
            this.redactModel.put("redaction_function_type", this.convertFunctionTypeToDBMSContantsFromDBValues(string));
        }
    }

    private String convertFunctionTypeToDBMSContantsFromDBValues(String string) {
        if (string.equals("NO REDACTION")) {
            RedactUtils.printDebug("BaseRedactPolicyAction.convertFunctionType=NO REDACTION", string);
            return "DBMS_REDACT.NONE";
        }
        if (string.equals("RANDOM REDACTION")) {
            RedactUtils.printDebug("BaseRedactPolicyAction.convertFunctionType=RANDOM REDACTION", string);
            return "DBMS_REDACT.RANDOM";
        }
        if (string.equals("FULL REDACTION")) {
            RedactUtils.printDebug("BaseRedactPolicyAction.convertFunctionType=FULL REDACTION", string);
            return "DBMS_REDACT.FULL";
        }
        if (string.equals("PARTIAL REDACTION")) {
            RedactUtils.printDebug("BaseRedactPolicyAction.convertFunctionType=PARTIAL REDACTION", string);
            return "DBMS_REDACT.PARTIAL";
        }
        if (string.equals("REGEXP REDACTION")) {
            RedactUtils.printDebug("BaseRedactPolicyAction.convertFunctionType=REGEXP REDACTION", string);
            return "DBMS_REDACT.REGEXP";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousRedactedColumns() {
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OWNER", this.getDBObjectSchemaName());
                hashMap.put("OBJECT", this.getDBObjectName());
                String string = this.getQuery(connection, "MODEL_getRedactedColumnsGivenObject");
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setRedactedColumnNamesFromResultSet(resultSet, connection);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public void setRedactedColumnNamesFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "COLUMN_NAME");
                arrayList.add(string);
            }
        }
        this.redactedColumnNames = new String[arrayList.size()];
        arrayList.toArray(this.redactedColumnNames);
    }

    public String[] getRedactedColumnNames() {
        return this.redactedColumnNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnDescriptionForGivenColumn(String string) {
        String string2 = null;
        String[] stringArray = null;
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("XOWNER", this.getDBObjectSchemaName());
                hashMap.put("XOBJECT", this.getDBObjectName());
                hashMap.put("XCOLUMN", string);
                String string3 = this.getQuery(connection, "getColumnDescriptionGivenOwnerObjectColumn");
                resultSetWrapper = dBUtil.executeOracleQuery(string3, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    stringArray = this.getColumnDescriptionFromResultSet(resultSet, connection);
                    string2 = stringArray != null && stringArray.length > 0 ? stringArray[0] : "";
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return string2;
    }

    public String[] getColumnDescriptionFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        String[] stringArray = null;
        if (resultSet != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "DESCRIPTION_COLUMN");
                arrayList.add(string);
            }
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousNonRedactedColumns() {
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OWNER", this.getDBObjectSchemaName());
                hashMap.put("OBJECT", this.getDBObjectName());
                String string = this.getQuery(connection, "MODEL_getNonRedactedColumnsGivenObject");
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setNonRedactedColumnNamesFromResultSet(resultSet, connection);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public void setNonRedactedColumnNamesFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "COLUMN_NAME");
                arrayList.add(string);
            }
        }
        this.nonRedactedColumnNames = new String[arrayList.size()];
        arrayList.toArray(this.nonRedactedColumnNames);
    }

    public String[] getNonRedactedColumnNames() {
        return this.nonRedactedColumnNames;
    }

    public void setUserEnv(String string) {
        this.sessionUser = string;
    }

    public String getUserEnv() {
        return this.sessionUser;
    }

    public void setConditionChoice(String string) {
        this.sessionChoice = string;
    }

    public String getConditionChoice() {
        return this.sessionChoice;
    }

    public void setOtherUser(String string) {
        this.otherUser = string;
    }

    public String getOtherUser() {
        return this.otherUser;
    }

    public void setDefaultExpression() {
        this.defaultExpression = "1=1";
        this.setExpression(this.defaultExpression);
    }

    public String getDefaultExpression() {
        return this.defaultExpression;
    }

    public void setAdvancedExpression(String string) {
        this.advancedExpression = string;
        this.setExpression(this.advancedExpression);
    }

    public String getAdvancedExpression() {
        return this.advancedExpression;
    }

    private void setOldRedactionModel() {
        this.setOldDataFromRedactionPolicies();
        this.setOldDataFromRedactionColumns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOldDataFromRedactionPolicies() {
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OWNER", this.getDBObjectSchemaName());
                hashMap.put("OBJECT", this.getDBObjectName());
                String string = this.getQuery(connection, "getRedactionPolicesAllAttributesGivenOwnerObject");
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setOldRedactionPoliciesResultSet(resultSet, connection);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    private void setOldRedactionPoliciesResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "POLICY_POLICY_NAME");
                String string2 = this.getStringFromRS(resultSet, "POLICY_POLICY_DESCRIPTION");
                String string3 = this.getStringFromRS(resultSet, "POLICY_OBJECT_OWNER");
                String string4 = this.getStringFromRS(resultSet, "POLICY_OBJECT_NAME");
                String string5 = this.getStringFromRS(resultSet, "POLICY_EXPRESSION");
                String string6 = this.getStringFromRS(resultSet, "POLICY_ENABLE");
                this.setOldPolicyName(string);
                this.setOldPolicyDescription(string2);
                this.setOldSchemaName(string3);
                this.setOldObjectName(string4);
                this.setOldExpression(string5);
                this.setOldEnabled(string6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOldDataFromRedactionColumns() {
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("XOWNER", this.getDBObjectSchemaName());
                hashMap.put("XOBJECT", this.getDBObjectName());
                String string = this.getQuery(connection, "getRedactionColumnsAllAttributesGivenOwnerObject");
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setOldRedactionColumnsResultSet(resultSet, connection);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    private void setOldRedactionColumnsResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        Vector<RedactColumn> vector = null;
        if (resultSet != null) {
            vector = new Vector<RedactColumn>();
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "COLUMN_NAME_COLUMN");
                String string2 = this.getStringFromRS(resultSet, "COLUMN_DESCRIPTION_COLUMN");
                String string3 = this.getStringFromRS(resultSet, "FUNCTION_TYPE_COLUMN");
                String string4 = this.getStringFromRS(resultSet, "FUNCTION_PARAMETERS_COLUMN");
                String string5 = this.getStringFromRS(resultSet, "REGEXP_PATTERN_COLUMN");
                String string6 = this.getStringFromRS(resultSet, "REGEXP_REPLACE_STRING_COLUMN");
                String string7 = new Integer(this.getIntFromRS(resultSet, "REGEXP_POSITION_COLUMN")).toString();
                String string8 = new Integer(this.getIntFromRS(resultSet, "REGEXP_OCCURRENCE_COLUMN")).toString();
                String string9 = this.getStringFromRS(resultSet, "REGEXP_MATCH_PARAMETER_COLUMN");
                RedactColumn redactColumn = new RedactColumn(string);
                redactColumn.setDescription(string2);
                redactColumn.setFunctionType(string3);
                redactColumn.setFunctionParameters(string4);
                redactColumn.setRegexpPattern(string5);
                redactColumn.setRegexpReplaceString(string6);
                redactColumn.setRegexpOccurrence(string8);
                redactColumn.setRegexpPosition(string7);
                redactColumn.setRegexpMatchParameters(string9);
                vector.add(redactColumn);
            }
        }
        if (vector != null) {
            this.oldRedactColumns = new RedactColumn[vector.size()];
            vector.copyInto(this.oldRedactColumns);
        }
        this.setOldExpression("1=1");
        this.setOldRegexpPosition("1");
        this.setOldRegexpOccurrence("0");
    }

    public void printOldModel() {
        System.out.println("============== MODEL for OLD DATA ================");
        this.printOldPolicyName();
        this.printOldPolicyDescription();
        this.printOldSchemaName();
        this.printOldObjectName();
        this.printOldColumnName();
        this.printOldColumnDescription();
        this.printOldExpression();
        this.printOldFunctionType();
        this.printOldFunctionParameters();
        this.printOldRegexpPattern();
        this.printOldRegexpReplaceString();
        this.printOldRegexpPosition();
        this.printOldRegexpOccurrence();
        this.printOldRegexpMatchParameter();
        this.printOldActionType();
    }

    public boolean comparePolicyDescription() {
        String string = this.getPolicyDescription();
        String string2 = this.getOldPolicyDescription();
        return this.equals(string, string2);
    }

    public boolean compareEnabled() {
        String string = this.isEnabled();
        String string2 = this.isOldEnabled();
        return this.equals(string, string2);
    }

    public boolean compareExpression() {
        String string = this.getExpression();
        String string2 = this.getOldExpression();
        return this.equals(string, string2);
    }

    public boolean compareAction() {
        String string = this.getActionType();
        String string2 = this.getOldActionType();
        return this.equals(string, string2);
    }

    public boolean compareColumnName() {
        String string = this.getColumnName();
        String string2 = this.getOldColumnName();
        return this.equals(string, string2);
    }

    public boolean compareColumnDescription() {
        String string = this.getColumnDescription();
        String string2 = this.getOldColumnDescription();
        return this.equals(string, string2);
    }

    public boolean compareFunctionType() {
        String string = this.getFunctionType();
        String string2 = this.getOldFunctionType();
        return this.equals(string, string2);
    }

    public boolean compareFunctionParameters() {
        String string = this.getFunctionParameters();
        String string2 = this.getOldFunctionParameters();
        return this.equals(string, string2);
    }

    public boolean compareRegexpMatchParameter() {
        String string = this.getRegexpMatchParameter();
        String string2 = this.getOldRegexpMatchParameter();
        return this.equals(string, string2);
    }

    public boolean compareRegexpPattern() {
        String string = this.getRegexpPattern();
        String string2 = this.getOldRegexpPattern();
        return this.equals(string, string2);
    }

    public boolean compareRegexpReplaceString() {
        String string = this.getRegexpReplaceString();
        String string2 = this.getOldRegexpReplaceString();
        return this.equals(string, string2);
    }

    public boolean compareRegexpPosition() {
        String string = this.getRegexpPosition();
        String string2 = this.getOldRegexpPosition();
        return this.equals(string, string2);
    }

    public boolean compareRegexpOccurrence() {
        String string = this.getRegexpOccurrence();
        String string2 = this.getOldRegexpOccurrence();
        return this.equals(string, string2);
    }

    public boolean alterPolicyChanges() {
        if (this.getActionType().equals("DBMS_REDACT.ADD_COLUMN")) {
            return true;
        }
        if (this.getActionType().equals("DBMS_REDACT.DROP_COLUMN")) {
            return true;
        }
        if (this.getActionType().equals("DBMS_REDACT.MODIFY_COLUMN")) {
            return !this.compareExpression() || !this.comparePolicyDescription() || !this.compareColumnName() || !this.compareAction() || !this.compareFunctionType() || !this.compareFunctionParameters() || !this.compareRegexpReplaceString() || !this.compareRegexpPosition() || !this.compareRegexpPattern() || !this.compareRegexpOccurrence() || !this.compareRegexpMatchParameter();
        }
        if (this.getActionType().equals("DBMS_REDACT.MODIFY_EXPRESSION")) {
            return !this.compareExpression();
        }
        return false;
    }

    private boolean equals(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string != null && string2 != null) {
            string = string.trim();
            string2 = string2.trim();
            return string.equals(string2);
        }
        if (string == null && string2 != null) {
            return false;
        }
        if (string != null && string2 == null) {
            return false;
        }
        return false;
    }

    public RedactColumn findOldColumnDetails(String string) {
        RedactColumn redactColumn = null;
        String string2 = null;
        if (this.oldRedactColumns != null) {
            for (RedactColumn redactColumn2 : this.oldRedactColumns) {
                string2 = redactColumn2.getColumnName();
                if (!string2.equals(string)) continue;
                redactColumn = redactColumn2;
                break;
            }
        }
        return redactColumn;
    }
}

