/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.ActionContext;
import oracle.bali.inspector.InspectorBundle;
import oracle.bali.inspector.PropertyModel;

public abstract class AbstractCustomEditorAction
extends AbstractAction {
    public AbstractCustomEditorAction() {
        this(InspectorBundle.get("CUSTOM_EDITOR_TEXT"));
    }

    public AbstractCustomEditorAction(String name) {
        super(name);
    }

    public abstract Component getCustomEditor();

    private ActionContext context() {
        return ActionContext.contextFrom(this);
    }

    public void actionPerformed(ActionEvent e) {
        ActionContext context = this.context();
        Object oldValue = context.propertyEditorFactory().getValue();
        Component editorComponent = context.editorComponent();
        Component customEditor = this.getCustomEditor();
        boolean hasHelp = HelpUtils.getHelpProvider((Component)customEditor) != null;
        JEWTDialog editDialog = this.editPropertyDialog(hasHelp);
        editDialog.setContent(customEditor);
        editDialog.pack();
        VetoableChangeListener listener = this.vetoableChangeListenerFrom(customEditor);
        if (listener != null) {
            editDialog.addVetoableChangeListener(listener);
        }
        if (editDialog.runDialog()) {
            final Object source = e.getSource();
            if (source instanceof JComponent) {
                ((JComponent)source).setEnabled(false);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((JComponent)source).setEnabled(true);
                    }
                });
            }
            context.updateModelWithEditorFactoryValue();
        } else if (oldValue != context.propertyEditorFactory().getValue()) {
            context.propertyEditorFactory().setValue(oldValue);
        }
        if (listener != null) {
            editDialog.removeVetoableChangeListener(listener);
        }
        editDialog.dispose();
        if (editorComponent != null) {
            editorComponent.repaint();
        }
    }

    private VetoableChangeListener vetoableChangeListenerFrom(Component customEditor) {
        return customEditor instanceof VetoableChangeListener ? (VetoableChangeListener)((Object)customEditor) : null;
    }

    private JEWTDialog editPropertyDialog(boolean includeHelpButton) {
        this.context().propertyModel().getPropertyDisplayName(this.context().propertyModelRow());
        JButton button = this.context().customEditorButton();
        int buttonMask = 3;
        if (includeHelpButton) {
            buttonMask |= 4;
        }
        JEWTDialog dialog = JEWTDialog.createDialog((Component)button, (String)this.dialogTitle(this.propertyName()), (int)buttonMask);
        dialog.setModal(true);
        dialog.setResizable(true);
        return dialog;
    }

    private String propertyName() {
        PropertyModel model = this.context().propertyModel();
        if (model == null) {
            return null;
        }
        int row = this.context().propertyModelRow();
        if (row < 0) {
            return null;
        }
        return model.getPropertyDisplayName(row);
    }

    private String dialogTitle(String propertyName) {
        String title = InspectorBundle.get("CUSTOM_EDITOR_DIALOG_TITLE");
        if (propertyName == null || propertyName.length() == 0) {
            return title;
        }
        return title + ": " + propertyName;
    }
}

