/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.accessibility.AccessibleContext;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.InspectorPropertyEditor;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyEditorFactory2ValueApplier;
import oracle.bali.inspector.editor.ComboBoxEditor;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.EditorFactoryUtils;
import oracle.bali.inspector.editor.PropertyModelValueApplier;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.PropertyValueApplierUtil;
import oracle.bali.inspector.editor.TextFieldEditor;
import oracle.bali.inspector.editor.TextFieldEditorBehavior;
import oracle.bali.inspector.editor.ToStringConverter;

public class ComboBoxEditorBehavior
extends FocusAdapter
implements KeyListener,
PopupMenuListener,
ActionListener,
ItemListener,
DocumentListener {
    JComboBox editor;
    PropertyEditorFactory2 propertyEditor;
    boolean valueApplied;
    private boolean isTyping;

    public ComboBoxEditorBehavior(JComboBox editor, PropertyEditorFactory2 propertyEditor) {
        this.editor = editor;
        this.propertyEditor = propertyEditor;
        if (editor.isEditable()) {
            editor.putClientProperty("JComboBox.isTableCellEditor", true);
            JTextComponent realEditor = this.realEditor();
            if (realEditor != null) {
                this.addListenersTo(realEditor);
                TextFieldEditorBehavior.setDirty(realEditor, false);
            }
        }
    }

    private void addListenersTo(JTextComponent realEditor) {
        ArrayList<ComboBoxEditorBehavior> toRemove = new ArrayList<ComboBoxEditorBehavior>();
        for (KeyListener l : realEditor.getKeyListeners()) {
            if (!(l instanceof ComboBoxEditorBehavior)) continue;
            toRemove.add((ComboBoxEditorBehavior)l);
        }
        Document document = realEditor.getDocument();
        for (ComboBoxEditorBehavior l : toRemove) {
            realEditor.removeKeyListener(l);
            if (document == null) continue;
            document.removeDocumentListener(l);
        }
        realEditor.addKeyListener(this);
        if (document != null) {
            document.addDocumentListener(this);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        this.applyValueFromEditor();
    }

    private BasicComboBoxUI editorUI() {
        ComboBoxUI ui = this.editor.getUI();
        if (!(ui instanceof BasicComboBoxUI)) {
            return null;
        }
        return (BasicComboBoxUI)ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JList editorPopupList(BasicComboBoxUI ui) {
        if (ui == null) {
            return null;
        }
        Field f = null;
        boolean accessible = false;
        try {
            f = BasicComboBoxUI.class.getDeclaredField("listBox");
            accessible = f.isAccessible();
            f.setAccessible(true);
            Object val = f.get(ui);
            if (!(val instanceof JList)) {
                JList jList = null;
                return jList;
            }
            JList jList = (JList)val;
            return jList;
        }
        catch (Exception e) {
            JList jList = null;
            return jList;
        }
        finally {
            if (f != null) {
                f.setAccessible(accessible);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    private void applyValueFromEditor() {
        Object value = null;
        value = this.isTyping ? this.realEditor().getText() : this.getItemFromList();
        this.applyValue(value);
        this.isTyping = false;
    }

    private Object getItemFromList() {
        JList list = this.editorPopupList(this.editorUI());
        return list != null ? list.getSelectedValue() : this.editor.getEditor().getItem();
    }

    private JTextComponent realEditor() {
        if (!this.editor.isEditable()) {
            return null;
        }
        Component realEditor = this.editor.getEditor().getEditorComponent();
        if (realEditor instanceof JTextComponent) {
            return (JTextComponent)realEditor;
        }
        return null;
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.makeComboBoxTableCellEditor(true);
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
        this.makeComboBoxTableCellEditor(false);
    }

    private void makeComboBoxTableCellEditor(boolean b) {
        if (this.editor.isEditable()) {
            return;
        }
        this.editor.putClientProperty("JComboBox.isTableCellEditor", b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyValue(Object selectedItem) {
        if (this.valueApplied) {
            this.valueApplied = false;
            return;
        }
        ToStringConverter converter = this.converter();
        this.updateToStringConverterInEditor(converter);
        String selectedItemAsText = this.asString(selectedItem, converter);
        PropertyValueApplier applier = PropertyValueApplierUtil.retrievePropertyValueApplier(this.editor);
        if (applier == null) {
            PropertyEditorFactory2ValueApplier.applyValueFromComboBoxEditor(this.propertyEditor, this.editor, converter);
            return;
        }
        int selectedIndex = this.editor.getSelectedIndex();
        String oldValue = this.propertyEditor.getAsText();
        if (oldValue == null && selectedItemAsText != null || oldValue != null && !oldValue.equals(selectedItemAsText)) {
            try {
                if (this.editor.isEditable()) {
                    this.validateInput();
                }
                this.propertyEditor.setAsText(selectedItemAsText);
                this.valueApplied = true;
                applier.apply(this.propertyEditor.getValue());
            }
            catch (Exception e) {
                Throwable cause;
                try {
                    this.applyValueToEditor(oldValue);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                if (e.getClass() == Exception.class && (cause = e.getCause()) instanceof Exception) {
                    e = (Exception)cause;
                }
                EditorFactoryUtils.showErrorMessage(this.editor.getParent(), e, selectedItemAsText);
            }
            finally {
                if (applier instanceof PropertyModelValueApplier) {
                    this.applyValueToEditor(((PropertyModelValueApplier)applier).value());
                }
                this.valueApplied = false;
            }
        }
    }

    private void applyValueToEditor(Object value) {
        this.propertyEditor.setValue(value);
        String newText = TextFieldEditor.cleanNullText(this.propertyEditor.getAsText());
        int index = this.find(value, this.editor);
        if (index != -1) {
            this.editor.setSelectedIndex(index);
        } else if (this.editor.isEditable()) {
            String currentText = this.realEditor().getText();
            if (!newText.equals(currentText)) {
                this.realEditor().setText(newText);
            }
        } else {
            this.editor.setSelectedIndex(0);
        }
    }

    protected void validateInput() {
    }

    private void updateToStringConverterInEditor(ToStringConverter converter) {
        if (!(this.editor instanceof ComboBoxEditor)) {
            return;
        }
        ComboBoxEditor comboBoxEditor = (ComboBoxEditor)this.editor;
        comboBoxEditor.setToStringConverter(converter);
    }

    private String asString(Object o, ToStringConverter converter) {
        if (converter != null) {
            return converter.convertToString(o);
        }
        return o != null ? o.toString() : null;
    }

    private ToStringConverter converter() {
        EditorComponentInfo info = this.propertyEditor.getEditorComponentInfo();
        if (info == null) {
            return null;
        }
        ToStringConverter converter = info.editorValueToStringConverter();
        if (converter != null) {
            return converter;
        }
        if (this.propertyEditor instanceof InspectorPropertyEditor) {
            InspectorPropertyEditor e = (InspectorPropertyEditor)this.propertyEditor;
            return e.getSelectedItemToStringConverter();
        }
        return null;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 0: 
            case 16: 
            case 17: 
            case 27: 
            case 37: 
            case 39: {
                return;
            }
            case 38: 
            case 40: {
                this.fireAccessibleChange();
                return;
            }
            case 10: {
                return;
            }
        }
        this.isTyping = true;
        if (this.editor.isPopupVisible()) {
            this.editor.setPopupVisible(false);
        }
    }

    private void fireAccessibleChange() {
        AccessibleContext ac = this.editorPopupList(this.editorUI()).getAccessibleContext();
        if (ac != null) {
            ac.setAccessibleDescription(String.valueOf(this.getItemFromList()));
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.dirtyEditor(true);
    }

    public void removeUpdate(DocumentEvent e) {
        this.dirtyEditor(true);
    }

    public void changedUpdate(DocumentEvent e) {
        this.dirtyEditor(true);
    }

    private void dirtyEditor(boolean val) {
        if (!this.isTyping) {
            return;
        }
        JTextComponent realEditor = this.realEditor();
        if (realEditor != null) {
            TextFieldEditorBehavior.setDirty(realEditor, val);
        }
    }

    private int find(Object value, JComboBox jComboBox) {
        if (value == null || jComboBox == null) {
            return -1;
        }
        ComboBoxModel boxModel = jComboBox.getModel();
        if (boxModel == null) {
            return -1;
        }
        ToStringConverter converter = this.converter();
        int modelSize = boxModel.getSize();
        for (int i = 0; i < modelSize; ++i) {
            Object element = boxModel.getElementAt(i);
            String elementAsText = this.asString(element, converter);
            if (!value.equals(elementAsText)) continue;
            return i;
        }
        return -1;
    }
}

