/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.multi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.PropertyModelListener;
import oracle.bali.inspector.PropertyModelUpdateEvent;
import oracle.bali.inspector.multi.SelectionEvent;
import oracle.bali.inspector.multi.SelectionListener;
import oracle.bali.inspector.multi.SelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiObjectModel
extends PropertyModel {
    private static final Object _UNINITIALIZED_VALUE = new Object();
    private static final String _KEY_MULTIPLE = "MULTIPLE";
    private SelectionModel _selectionModel;
    private BitSet _commonProperties;
    private transient int _valueColumnIndex;
    private transient int _displayValueColumnIndex;
    private transient PropertyModel _primaryModel;
    private transient SelectionListenerImpl _listener;
    private transient Object[][] _mergedValues;
    private transient Vector<Object> _properties = new Vector();
    private transient Object[] _columnIDs;
    private transient int[][] _columnMap;
    private transient BitSet _conflictFlags;

    public MultiObjectModel() {
        this._clearColumnData();
        this._listener = new SelectionListenerImpl();
    }

    @Override
    public Object[] getColumnMapping() {
        return this._columnIDs;
    }

    public void setSelectionModel(SelectionModel newSelectionModel) {
        if (this._selectionModel == newSelectionModel) {
            return;
        }
        if (this._selectionModel != null) {
            this._selectionModel.removeSelectionListener(this._listener);
            this._listener.__updateModelListeners(this._selectionModel, false);
        }
        this._selectionModel = newSelectionModel;
        if (newSelectionModel != null) {
            newSelectionModel.addSelectionListener(this._listener);
            this._listener.__updateModelListeners(newSelectionModel, true);
            this._updateProperties();
        } else {
            this._clearColumnData();
        }
    }

    public SelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    @Override
    public String getTargetDisplayName() {
        if (this._selectionModel == null) {
            return null;
        }
        int numTargets = this._selectionModel.getSelectedItemCount();
        if (numTargets == 0) {
            return null;
        }
        if (numTargets == 1) {
            return this._primaryModel.getTargetDisplayName();
        }
        return this._getTranslatedString(_KEY_MULTIPLE);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._selectionModel == null) {
            return;
        }
        int numTargets = this._selectionModel.getSelectedItemCount();
        for (int i = 0; i < numTargets; ++i) {
            PropertyModel ds = (PropertyModel)this._selectionModel.getSelectedItem(i);
            ds.setLocale(locale);
        }
        if (numTargets <= 1) {
            return;
        }
        this.firePropertyChanged("targetDisplayName", null, this._getTranslatedString(_KEY_MULTIPLE));
    }

    @Override
    public int getRowCount() {
        return this._properties.size();
    }

    @Override
    public boolean isDataConflicting(int columnIndex, int rowIndex) {
        this._getValue(columnIndex, rowIndex);
        int bit = columnIndex + this.getColumnCount() * rowIndex;
        boolean conflicting = this._getConflictFlags().get(bit);
        if (conflicting) {
            return true;
        }
        SelectionModel model = this.getSelectionModel();
        if (model != null) {
            int modelCount = model.getSelectedItemCount();
            for (int i = 0; i < modelCount; ++i) {
                PropertyModel child = (PropertyModel)model.getSelectedItem(i);
                if (rowIndex >= child.getRowCount() || !child.isDataConflicting(columnIndex, rowIndex)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this._getValue(columnIndex, rowIndex);
    }

    @Override
    public void setValueAt(Object data, int rowIndex, int columnIndex) {
        if (this._selectionModel == null) {
            return;
        }
        this._getConflictFlags().clear(columnIndex + this.getColumnCount() * rowIndex);
        Object propertyID = this._properties.elementAt(rowIndex);
        int numModels = this._selectionModel.getSelectedItemCount();
        for (int i = 0; i < numModels; ++i) {
            PropertyModel current = (PropertyModel)this._selectionModel.getSelectedItem(i);
            try {
                current.setPropertyByID(this._columnMap[i][columnIndex], propertyID, data);
                continue;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                this.throwIllegalArgumentException(t, this.getPropertyDisplayName(rowIndex, this.getLocale()), data);
            }
        }
        this.invalidateValueData();
        if (rowIndex < this.getRowCount()) {
            this._invalidateCell(columnIndex, rowIndex);
        }
    }

    @Override
    public Object getPropertyByID(int columnIndex, Object propertyID) {
        int rowIndex = this._getRowIndex(propertyID);
        if (rowIndex == -1) {
            return DOES_NOT_EXIST;
        }
        return this.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public void setPropertyByID(int columnIndex, Object propertyID, Object data) throws Exception {
        int rowIndex = this._getRowIndex(propertyID);
        if (rowIndex == -1) {
            return;
        }
        this.setValueAt(data, rowIndex, columnIndex);
    }

    @Override
    public Enumeration getPropertyIDs() {
        return this._properties.elements();
    }

    @Override
    public void invalidateValueData() {
        this._invalidateColumn(PropertyModel.COLUMN_VALUE);
        SelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        int modelCount = model.getSelectedItemCount();
        for (int i = 0; i < modelCount; ++i) {
            PropertyModel child = (PropertyModel)model.getSelectedItem(i);
            child.invalidateValueData();
        }
    }

    @Override
    public boolean isPropertyCommon(int rowIndex) {
        if (this._commonProperties != null && !this._commonProperties.get(rowIndex)) {
            return false;
        }
        SelectionModel model = this.getSelectionModel();
        if (model == null) {
            return true;
        }
        int modelCount = model.getSelectedItemCount();
        for (int i = 0; i < modelCount; ++i) {
            PropertyModel child = (PropertyModel)model.getSelectedItem(i);
            if (child.isPropertyCommon(rowIndex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        SelectionModel model = this.getSelectionModel();
        if (model != null) {
            int modelCount = model.getSelectedItemCount();
            for (int i = 0; i < modelCount; ++i) {
                PropertyModel child = (PropertyModel)model.getSelectedItem(i);
                child.dispose();
            }
        }
        this.setSelectionModel(null);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this._selectionModel == null) {
            return false;
        }
        boolean editable = false;
        int numTargets = this._selectionModel.getSelectedItemCount();
        for (int i = 0; i < numTargets; ++i) {
            PropertyModel ds = (PropertyModel)this._selectionModel.getSelectedItem(i);
            editable |= ds.isCellEditable(row, col);
        }
        return editable;
    }

    @Override
    public boolean isSettable(Object oldValue, Object newValue) {
        if (this._selectionModel == null) {
            return false;
        }
        boolean settable = false;
        int numTargets = this._selectionModel.getSelectedItemCount();
        for (int i = 0; i < numTargets; ++i) {
            PropertyModel ds = (PropertyModel)this._selectionModel.getSelectedItem(i);
            settable |= ds.isSettable(oldValue, newValue);
        }
        return settable;
    }

    @Override
    public void startRead() {
        super.startRead();
        if (this._selectionModel == null) {
            return;
        }
        int numTargets = this._selectionModel.getSelectedItemCount();
        for (int i = 0; i < numTargets; ++i) {
            PropertyModel ds = (PropertyModel)this._selectionModel.getSelectedItem(i);
            ds.startRead();
        }
    }

    @Override
    public Object getMatchingId(Object id) {
        SelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel == null) {
            return false;
        }
        for (int i = 0; i < selectionModel.getSelectedItemCount(); ++i) {
            PropertyModel model = (PropertyModel)selectionModel.getSelectedItem(i);
            Object realId = model.getMatchingId(id);
            if (realId == null) continue;
            return realId;
        }
        return null;
    }

    @Override
    public boolean isMatchingPropertyID(Object id, int rowIndex) {
        SelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel == null) {
            return false;
        }
        Object propertyId = this._properties.elementAt(rowIndex);
        for (int i = 0; i < selectionModel.getSelectedItemCount(); ++i) {
            PropertyModel propertyModel = (PropertyModel)selectionModel.getSelectedItem(i);
            int realRowIndex = propertyModel.getPropertyIndex(propertyId);
            if (realRowIndex < 0 || !propertyModel.isMatchingPropertyID(id, realRowIndex)) continue;
            return true;
        }
        return id.equals(propertyId);
    }

    @Override
    public void stopRead() {
        super.stopRead();
        if (this._selectionModel == null) {
            return;
        }
        int numTargets = this._selectionModel.getSelectedItemCount();
        for (int i = 0; i < numTargets; ++i) {
            PropertyModel ds = (PropertyModel)this._selectionModel.getSelectedItem(i);
            ds.stopRead();
        }
    }

    private String _getTranslatedString(String key) {
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.inspector.resource.InspectorBundle", this.getLocale());
        return b.getString(key);
    }

    private void _invalidateColumn(Object columnID) {
        this._invalidateColumn(this.getColumnIndex(columnID));
    }

    private void _invalidateColumn(int columnIndex) {
        int displayValueIndex;
        if (columnIndex == -1) {
            return;
        }
        Object[][] mergedValues = this._mergedValues;
        int numRows = this.getRowCount();
        if (mergedValues != null) {
            for (int y = 0; y < numRows; ++y) {
                mergedValues[columnIndex][y] = _UNINITIALIZED_VALUE;
            }
        }
        TableModelEvent event = new TableModelEvent(this, 0, numRows - 1, columnIndex);
        this.fireTableChanged(event);
        if (columnIndex == this._valueColumnIndex && (displayValueIndex = this._displayValueColumnIndex) != -1) {
            this._invalidateColumn(displayValueIndex);
        }
    }

    private void _invalidateRow(int rowIndex) {
        if (rowIndex == -1) {
            return;
        }
        Object[][] mergedValues = this._mergedValues;
        if (mergedValues == null) {
            return;
        }
        int numColumns = this.getColumnCount();
        for (int x = 0; x < numColumns; ++x) {
            mergedValues[x][rowIndex] = _UNINITIALIZED_VALUE;
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    private void _invalidateCell(int columnIndex, int rowIndex) {
        int displayValueIndex;
        if (columnIndex == -1 || rowIndex == -1) {
            return;
        }
        if (this._mergedValues != null) {
            this._mergedValues[columnIndex][rowIndex] = _UNINITIALIZED_VALUE;
        }
        if (rowIndex < this.getRowCount()) {
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
        if (columnIndex == this._valueColumnIndex && (displayValueIndex = this._displayValueColumnIndex) != -1) {
            this._invalidateCell(displayValueIndex, rowIndex);
        }
    }

    private BitSet _getConflictFlags() {
        if (this._conflictFlags == null) {
            this._conflictFlags = new BitSet(this.getColumnCount() * this.getRowCount());
        }
        return this._conflictFlags;
    }

    private synchronized Object _getValue(int columnIndex, int rowIndex) {
        int numColumns = this.getColumnCount();
        int numRows = this.getRowCount();
        if (columnIndex < 0 || columnIndex >= numColumns || rowIndex < 0 || rowIndex >= numRows) {
            String msg = MessageFormat.format("Invalid cell [{0}, {1}] out of {2} cols and {3} rows", columnIndex, rowIndex, numColumns, numRows);
            throw new IllegalArgumentException(msg);
        }
        Object[][] mergedValues = this._mergedValues;
        if (mergedValues == null) {
            mergedValues = new Object[numColumns][numRows];
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < numColumns; ++j) {
                    mergedValues[j][i] = _UNINITIALIZED_VALUE;
                }
            }
            this._mergedValues = mergedValues;
        }
        Object value = this._mergedValues[columnIndex][rowIndex];
        if (columnIndex != this.getColumnIndex(PropertyModel.COLUMN_VALIDATION_ISSUES) && value != _UNINITIALIZED_VALUE) {
            return value;
        }
        int numModels = this._selectionModel != null ? this._selectionModel.getSelectedItemCount() : 0;
        Object propertyID = this._properties.elementAt(rowIndex);
        value = this._primaryModel.getPropertyByID(this._columnMap[0][columnIndex], propertyID);
        for (int i = 1; i < numModels && this._selectionModel != null; ++i) {
            PropertyModel current = (PropertyModel)this._selectionModel.getSelectedItem(i);
            Object newValue = current.getPropertyByID(this._columnMap[i][columnIndex], propertyID);
            if (newValue == value) continue;
            if (value == DOES_NOT_EXIST) {
                value = newValue;
                continue;
            }
            if (newValue == DOES_NOT_EXIST || newValue != null && newValue.equals(value)) continue;
            this._getConflictFlags().set(columnIndex + this.getColumnCount() * rowIndex);
            break;
        }
        if (null != this._mergedValues) {
            this._mergedValues[columnIndex][rowIndex] = value;
        }
        return value;
    }

    private boolean _updateColumnMap() {
        int numOldColumns = this._columnIDs.length;
        int numModels = this._selectionModel.getSelectedItemCount();
        if (numModels > 0) {
            Object[] newColumnIDs;
            boolean numColumnsChanged;
            int i;
            PropertyModel primary = (PropertyModel)this._selectionModel.getSelectedItem(0);
            Object[] primaryColumnIDs = primary.getColumnMapping();
            int numPrimaryColumns = primaryColumnIDs.length;
            ArrayList<Object> columnVector = new ArrayList<Object>(numModels);
            for (i = 0; i < numPrimaryColumns; ++i) {
                columnVector.add(primaryColumnIDs[i]);
            }
            for (i = 1; i < numModels; ++i) {
                PropertyModel currModel = (PropertyModel)this._selectionModel.getSelectedItem(i);
                for (Object currColumnID : currModel.getColumnMapping()) {
                    if (columnVector.indexOf(currColumnID) != -1) continue;
                    columnVector.add(currColumnID);
                }
            }
            boolean columnsChanged = true;
            int numNewColumns = columnVector.size();
            boolean bl = numColumnsChanged = numOldColumns != numNewColumns;
            if (!numColumnsChanged) {
                int i2;
                newColumnIDs = this._columnIDs;
                for (i2 = 0; i2 < numOldColumns; ++i2) {
                    if (this._columnIDs[i2].equals(columnVector.get(i2))) continue;
                    this._columnIDs = null;
                    break;
                }
                columnsChanged = i2 != numOldColumns;
            } else {
                newColumnIDs = new Object[numNewColumns];
            }
            columnVector.toArray(newColumnIDs);
            this._columnIDs = newColumnIDs;
            int numOldModels = this._columnMap.length;
            Object newColumnMap = numOldModels == numModels ? this._columnMap : (Object)new int[numModels][];
            for (int i3 = 0; i3 < numModels; ++i3) {
                int[] currColumnMap = !numColumnsChanged && i3 < numOldModels ? this._columnMap[i3] : new int[numNewColumns];
                PropertyModel currModel = (PropertyModel)this._selectionModel.getSelectedItem(i3);
                Object[] currColumnIDs = currModel.getColumnMapping();
                int currNumColumns = currColumnIDs.length;
                for (int j = 0; j < numNewColumns; ++j) {
                    int k;
                    Object currColumnID = newColumnIDs[j];
                    for (k = 0; k < currNumColumns && currColumnID != currColumnIDs[k]; ++k) {
                    }
                    currColumnMap[j] = k < currNumColumns ? k : -1;
                }
                newColumnMap[i3] = currColumnMap;
            }
            this._columnMap = newColumnMap;
            if (columnsChanged) {
                this._updateCachedIndices();
            }
            return columnsChanged;
        }
        this._clearColumnData();
        return numOldColumns != 0;
    }

    private int _getRowIndex(Object propertyID) {
        int rowIndex = this._properties.indexOf(propertyID);
        if (rowIndex != -1) {
            return rowIndex;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _updateProperties() {
        this._mergedValues = null;
        this._conflictFlags = null;
        this._commonProperties = null;
        PropertyModel newPrimary = null;
        Vector<Object> properties = new Vector<Object>();
        PropertyModel oldPrimary = this._primaryModel;
        int numModels = this._selectionModel.getSelectedItemCount();
        if (0 == numModels) {
            Logger.getAnonymousLogger().logp(Level.INFO, this.getClass().getName(), "_updateProperties", "SelectionModel has no selected items");
            return;
        }
        if (numModels > 0) {
            int i;
            Map[] modelProperties = null;
            if (numModels > 1) {
                modelProperties = new Map[numModels];
                for (int i2 = 1; i2 < numModels; ++i2) {
                    PropertyModel currModel = (PropertyModel)this._selectionModel.getSelectedItem(i2);
                    currModel.startRead();
                    try {
                        Enumeration ids = currModel.getPropertyIDs();
                        modelProperties[i2] = this.createIdMap(ids);
                        continue;
                    }
                    finally {
                        currModel.stopRead();
                    }
                }
            }
            newPrimary = (PropertyModel)this._selectionModel.getSelectedItem(0);
            int numPrimaryProperties = newPrimary.getRowCount();
            properties = new Vector(numPrimaryProperties);
            BitSet commonProperties = new BitSet(numPrimaryProperties);
            newPrimary.startRead();
            try {
                for (i = 0; i < numPrimaryProperties; ++i) {
                    boolean isCommon = true;
                    Object currKey = newPrimary.getPropertyID(i);
                    properties.addElement(currKey);
                    for (int j = 1; j < numModels; ++j) {
                        Object currObject = modelProperties[j].remove(currKey);
                        isCommon &= currObject != null;
                    }
                    if (!isCommon) continue;
                    commonProperties.set(i);
                }
            }
            finally {
                newPrimary.stopRead();
            }
            this._commonProperties = commonProperties;
            for (i = 1; i < numModels; ++i) {
                Set keys = modelProperties[i].keySet();
                for (Object currKey : keys) {
                    properties.addElement(currKey);
                    for (int j = i + 1; j < numModels; ++j) {
                        modelProperties[j].remove(currKey);
                    }
                }
            }
        }
        this._properties = properties;
        this._primaryModel = newPrimary;
        this._updateColumnMap();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        if (newPrimary != oldPrimary) {
            String oldValue = oldPrimary != null ? oldPrimary.getTargetDisplayName() : null;
            String newValue = newPrimary != null ? newPrimary.getTargetDisplayName() : null;
            this.firePropertyChanged("targetDisplayName", oldValue, newValue);
        }
    }

    private void _fireDisplayChange(String oldValue, String newValue) {
        if (this._selectionModel != null && this._selectionModel.getSelectedItemCount() == 1) {
            this.firePropertyChanged("targetDisplayName", oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHelpTopic() {
        try {
            this.startRead();
            String string = this._primaryModel != null ? this._primaryModel.getHelpTopic() : null;
            return string;
        }
        finally {
            this.stopRead();
        }
    }

    private void _clearColumnData() {
        this._columnIDs = new Object[0];
        this._columnMap = new int[0][0];
        this._updateCachedIndices();
    }

    private Map<Object, Object> createIdMap(Enumeration propertyIDs) {
        HashMap<Object, Object> idHashTable = new HashMap<Object, Object>();
        if (propertyIDs != null) {
            while (propertyIDs.hasMoreElements()) {
                Object currPropertyID = propertyIDs.nextElement();
                idHashTable.put(currPropertyID, _UNINITIALIZED_VALUE);
            }
        }
        return idHashTable;
    }

    private void _updateCachedIndices() {
        this._valueColumnIndex = this.getColumnIndex(COLUMN_VALUE);
        this._displayValueColumnIndex = this.getColumnIndex(COLUMN_DISPLAY_VALUE);
    }

    private class SelectionListenerImpl
    implements SelectionListener,
    TableModelListener,
    PropertyChangeListener,
    PropertyModelListener {
        public void propertyChange(PropertyChangeEvent e) {
            if ("targetDisplayName".equals(e.getPropertyName())) {
                MultiObjectModel.this._fireDisplayChange((String)e.getOldValue(), (String)e.getNewValue());
            }
        }

        public void updatePropertyInspector(PropertyModelUpdateEvent event) {
            MultiObjectModel.this.firePropertyModelUpdate(event);
        }

        public void itemsAdded(SelectionEvent event) {
            this._updateListeners(event, true);
            MultiObjectModel.this._updateProperties();
        }

        public void itemsRemoving(SelectionEvent event) {
            this._updateListeners(event, false);
        }

        public void itemsRemoved(SelectionEvent event) {
            MultiObjectModel.this._updateProperties();
        }

        public void tableChanged(TableModelEvent e) {
            int type = e.getType();
            if (type != 0 || e.getLastRow() == Integer.MAX_VALUE) {
                MultiObjectModel.this._updateProperties();
            } else if (e.getColumn() == -1) {
                this._invalidateRows(e);
            } else {
                this._invalidateCells(e);
            }
        }

        private void _invalidateRows(TableModelEvent event) {
            if (event.getFirstRow() == -1) {
                return;
            }
            int startIndex = event.getFirstRow();
            int endIndex = event.getLastRow();
            PropertyModel model = (PropertyModel)event.getSource();
            for (int i = startIndex; i <= endIndex; ++i) {
                MultiObjectModel.this._invalidateRow(MultiObjectModel.this._getRowIndex(model.getPropertyID(i)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _invalidateCells(TableModelEvent event) {
            PropertyModel model = (PropertyModel)event.getSource();
            int columnIndex = event.getColumn();
            int startRowIndex = event.getFirstRow();
            int endRowIndex = event.getLastRow();
            Object[] columnMapping = model.getColumnMapping();
            model.startRead();
            try {
                for (int j = startRowIndex; j <= endRowIndex; ++j) {
                    int rowIndex = MultiObjectModel.this._getRowIndex(model.getPropertyID(j));
                    MultiObjectModel.this._invalidateCell(MultiObjectModel.this.getColumnIndex(columnMapping[columnIndex]), rowIndex);
                }
            }
            finally {
                model.stopRead();
            }
        }

        void __updateModelListeners(SelectionModel model, boolean addListeners) {
            int count = model.getSelectedItemCount();
            for (int i = 0; i < count; ++i) {
                PropertyModel currModel = (PropertyModel)model.getSelectedItem(i);
                if (addListeners) {
                    this.addListenersTo(currModel);
                    continue;
                }
                this.removeListenersFrom(currModel);
            }
        }

        private void _updateListeners(SelectionEvent event, boolean addListeners) {
            SelectionModel model = event.getSelectionModel();
            int startIndex = event.getStartIndex();
            int endIndex = startIndex + event.getItemCount();
            for (int i = startIndex; i < endIndex; ++i) {
                PropertyModel currModel = (PropertyModel)model.getSelectedItem(i);
                if (addListeners) {
                    this.addListenersTo(currModel);
                    continue;
                }
                this.removeListenersFrom(currModel);
            }
        }

        private void addListenersTo(PropertyModel model) {
            if (null == model) {
                return;
            }
            model.addTableModelListener(this);
            model.addPropertyChangeListener(this);
            model.setLocale(MultiObjectModel.this.getLocale());
            model.addPropertyModelListener(this);
        }

        private void removeListenersFrom(PropertyModel model) {
            if (null == model) {
                return;
            }
            model.removePropertyChangeListener(this);
            model.removeTableModelListener(this);
            model.removePropertyModelListener(this);
        }
    }
}

