/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public final class StringEscape {
    public static String escapeJava(String str) {
        return StringEscape.escapeJavaStyleString(str, false);
    }

    private static String escapeJavaStyleString(String str, boolean escapeSingleQuotes) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            StringEscape.escapeJavaStyleString(writer, str, escapeSingleQuotes);
            return writer.toString();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private static void escapeJavaStyleString(Writer w, String str, boolean escapeSingleQuote) throws IOException {
        if (w == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        WriterWrapper out = new WriterWrapper(w);
        block12: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                out.write("\\u" + StringEscape.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out.write("\\u0" + StringEscape.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out.write("\\u00" + StringEscape.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.write(92).write(98);
                        break;
                    }
                    case '\n': {
                        out.write(92).write(110);
                        break;
                    }
                    case '\t': {
                        out.write(92).write(116);
                        break;
                    }
                    case '\f': {
                        out.write(92).write(102);
                        break;
                    }
                    case '\r': {
                        out.write(92).write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.write("\\u00" + StringEscape.hex(ch));
                            break;
                        }
                        out.write("\\u000" + StringEscape.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    if (escapeSingleQuote) {
                        out.write(92);
                    }
                    out.write(39);
                    continue block12;
                }
                case '\"': {
                    out.write(92).write(34);
                    continue block12;
                }
                case '\\': {
                    out.write(92).write(92);
                    continue block12;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    public static String unescapeJava(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length());
            StringEscape.unescapeJava(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private static void unescapeJava(Writer w, String str) throws IOException {
        if (w == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        StringBuilder unicode = new StringBuilder(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    w.write((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        w.write(92);
                        break;
                    }
                    case '\'': {
                        w.write(39);
                        break;
                    }
                    case '\"': {
                        w.write(34);
                        break;
                    }
                    case 'r': {
                        w.write(13);
                        break;
                    }
                    case 'f': {
                        w.write(12);
                        break;
                    }
                    case 't': {
                        w.write(9);
                        break;
                    }
                    case 'n': {
                        w.write(10);
                        break;
                    }
                    case 'b': {
                        w.write(8);
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        w.write(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            w.write(ch);
        }
        if (hadSlash) {
            w.write(92);
        }
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase();
    }

    private StringEscape() {
    }

    private static class WriterWrapper {
        final Writer w;

        WriterWrapper(Writer w) {
            this.w = w;
        }

        WriterWrapper write(int c) throws IOException {
            this.w.write(c);
            return this;
        }

        WriterWrapper write(String s) throws IOException {
            this.w.write(s);
            return this;
        }
    }
}

