/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.impl.handlers.element;

import java.lang.reflect.Method;
import java.util.List;
import oracle.bali.xml.beanmodel.XmlBaseType;
import oracle.bali.xml.beanmodel.annotation.Operation;
import oracle.bali.xml.beanmodel.annotation.OperationLiteral;
import oracle.bali.xml.beanmodel.impl.DynamicProxyContext;
import oracle.bali.xml.beanmodel.impl.handlers.element.ElementInvocationHandler;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementSetInvocationHandler
extends ElementInvocationHandler {
    @Override
    public Operation getOperation() {
        return new OperationLiteral("set", "simple");
    }

    @Override
    protected Object invokeImpl(XmlBaseType proxy, Method method, Object[] args, DynamicProxyContext context, Element parent, XmlKey childKey, List<QualifiedName> childNames) throws Throwable {
        if (args[0] == null) {
            throw new IllegalArgumentException("Method: " + method + " cannot be called with a null argument");
        }
        if (args[0] instanceof XmlBaseType) {
            XmlBaseType childBean = (XmlBaseType)args[0];
            this.setElementChild(context, parent, context.getXmlKey(), childBean, childNames);
        } else {
            this.setElementChild(context, parent, context.getXmlKey(), childNames.get(0), args[0]);
        }
        return null;
    }

    protected void setElementChild(DynamicProxyContext context, Element parent, XmlKey parentKey, XmlBaseType childBean, List<QualifiedName> expectedNames) {
        Node childNode = childBean.getDomNode();
        if (!DomUtils.isElement((Node)childNode)) {
            throw new IllegalStateException("Expected new child Node to be of Element type, but found: " + childNode);
        }
        Element childElement = (Element)childNode;
        QualifiedName childElementName = DomUtils.getQualifiedName((Node)childElement);
        if (!expectedNames.contains(childElementName)) {
            throw new UnsupportedOperationException("Attempt to set a child that was created with a conflicting qualified name.");
        }
        XmlKey childKey = context.getXmlModel().getElementKey(parentKey, childElementName);
        DomPosition requestedPosition = DomPositionFactory.inside((Node)parent);
        List existingChildren = DomUtils.getNamedChildElements((Element)parent, expectedNames);
        if (!existingChildren.isEmpty()) {
            if (existingChildren.size() == 1 && existingChildren.get(0) == childElement) {
                return;
            }
            Element lastExistingChild = (Element)existingChildren.get(existingChildren.size() - 1);
            Node nodeAfterLastExistingChild = lastExistingChild.getNextSibling();
            if (nodeAfterLastExistingChild != null) {
                requestedPosition = DomPositionFactory.before((Node)nodeAfterLastExistingChild);
            }
            for (Element existingChild : existingChildren) {
                parent.removeChild(existingChild);
            }
        }
        this.insertChild(context.getXmlModel(), parent, parentKey, childElement, childKey, requestedPosition);
    }

    protected void setElementChild(DynamicProxyContext context, Element parent, XmlKey parentKey, QualifiedName childName, Object childValue) {
        XmlKey childKey = context.getXmlModel().getElementKey(context.getXmlKey(), childName);
        String stringValue = this.convertSimpleTypeToString(context.getXmlModel(), childKey, childValue);
        List existingChildren = DomUtils.getNamedChildElements((Element)parent, (QualifiedName)childName);
        Element firstExistingChild = null;
        for (Element existingChild : existingChildren) {
            if (firstExistingChild == null) {
                firstExistingChild = existingChild;
                continue;
            }
            parent.removeChild(existingChild);
        }
        Document document = context.getXmlModel().getDocument();
        boolean preferCDATA = context.getXmlModel().getXmlMetadataResolver().getPrefersCDATAValue(childKey);
        if (firstExistingChild != null) {
            DomUtils.setTextContent((Node)firstExistingChild, (String)stringValue, (boolean)preferCDATA);
        } else {
            Element newChild = document.createElementNS(childName.getNamespace(), childName.getName());
            DomUtils.setTextContent((Node)newChild, (String)stringValue, (boolean)preferCDATA);
            this.insertChild(context.getXmlModel(), parent, parentKey, newChild, childKey, DomPositionFactory.inside((Node)parent));
        }
    }

    protected void insertChild(XmlModel model, Node parent, XmlKey parentKey, Node child, XmlKey childKey, DomPosition requestedPosition) {
        DomPosition chosenPosition;
        if (requestedPosition == null) {
            requestedPosition = DomPositionFactory.inside((Node)parent);
        }
        if ((chosenPosition = model.findValidInsertionPosition(childKey, child, requestedPosition, parentKey)) == null) {
            chosenPosition = requestedPosition;
        }
        if (model.isInModelDocumentHierarchy(parent)) {
            model.fixPrefixes(parent, child);
        }
        DomUtils.insertNodeAtPosition((DomPosition)chosenPosition, (Node)child);
    }
}

