/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.locator;

import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.javatools.buffer.LineMap;

public abstract class Locator
implements org.xml.sax.Locator {
    private final LineMap _lineMap;

    public static void attach(LocatorManager manager, boolean attach, Locator loc) {
        if (loc != null) {
            loc.attach(manager, attach);
        }
    }

    public static Locator getCopy(Locator source) {
        if (source == null) {
            return null;
        }
        return source.getCopy();
    }

    public static int getColumnNumber(LineMap lineMap, int offset) {
        int column = -1;
        int line = Locator.getLineNumber(lineMap, offset);
        if (line > 0) {
            int lineStart = lineMap.getLineStartOffset(line - 1);
            column = offset - lineStart + 1;
        }
        return column;
    }

    public static int getLineNumber(LineMap lineMap, int offset) {
        int line = -1;
        if (offset != -1) {
            line = lineMap.getLineFromOffset(offset) + 1;
        }
        return line;
    }

    public abstract Locator getCopy();

    public abstract int getStartOffset();

    public abstract int getEndOffset();

    public abstract void attach(LocatorManager var1, boolean var2);

    @Override
    public final int getColumnNumber() {
        return this.getEndColumnNumber();
    }

    @Override
    public final int getLineNumber() {
        return this.getEndLineNumber();
    }

    public final int getEndColumnNumber() {
        return Locator.getColumnNumber(this._lineMap, this.getEndOffset());
    }

    public final int getEndLineNumber() {
        return Locator.getLineNumber(this._lineMap, this.getEndOffset());
    }

    public final int getStartColumnNumber() {
        return Locator.getColumnNumber(this._lineMap, this.getStartOffset());
    }

    public final int getStartLineNumber() {
        return Locator.getLineNumber(this._lineMap, this.getStartOffset());
    }

    public final int getLength() {
        int len = this.getEndOffset() - this.getStartOffset();
        if (len < 0) {
            throw new IllegalStateException("locator.getLength called but length is negative! " + this);
        }
        return len;
    }

    public final boolean contains(int offset) {
        return offset >= this.getStartOffset() && offset < this.getEndOffset();
    }

    public final boolean containsNotAtStart(int offset) {
        return offset > this.getStartOffset() && offset < this.getEndOffset();
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    protected LineMap getLineMap() {
        return this._lineMap;
    }

    protected Locator(LineMap lineMap) {
        this._lineMap = lineMap;
    }
}

