/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.textsync;

import oracle.bali.xml.dom.buffer.TextSyncContext;
import oracle.bali.xml.dom.buffer.textsync.ReformatInfo;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class ReformatInfoTracker
implements DomChangeHandler {
    private final ReformatInfo _result;
    private final TextSyncContext _context;

    public static ReformatInfo create(DomChange change, TextSyncContext context) {
        ReformatInfoTracker instance = new ReformatInfoTracker(context);
        change.process(instance);
        return instance._result;
    }

    @Override
    public void handleAttrAddedChange(AttrAddedChange change) {
        this._result.addedAttrs.add(this._context.getEventAttr());
    }

    @Override
    public void handleAttrRemovedChange(AttrRemovedChange change) {
    }

    @Override
    public void handleAttrValueChange(AttrValueChange change) {
        this._result.addedAttrs.add(this._context.getEventAttr());
    }

    @Override
    public void handleNodeInsertedChange(NodeInsertedChange change) {
        Node inserted = this._context.getEventTargetNode();
        assert (inserted != null);
        this._gatherInformationFromInsertedNode(inserted);
    }

    @Override
    public void handleNodeRemovedChange(NodeRemovedChange change) {
    }

    @Override
    public void handleNodeValueChange(NodeValueChange change) {
        Node changed = this._context.getEventTargetNode();
        if (DomUtils.isText((Node)changed)) {
            this._result.changedTextNodes.add(changed);
        }
    }

    private void _gatherInformationFromInsertedNode(Node node) {
        this._addAttrs(node);
        this._findInsertedTextNodes(node);
        this._checkForElementStartTagWrapping(node);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this._gatherInformationFromInsertedNode(child);
        }
    }

    private void _checkForElementStartTagWrapping(Node node) {
        if (DomUtils.isElement((Node)node)) {
            Element elem = (Element)node;
            if (this._context.getOptions().wrapBeforeEndOfStartTag(elem)) {
                this._result.elementsToWrapStartTag.add(elem);
            }
        }
    }

    private void _addAttrs(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                this._result.addedAttrs.add(attrs.item(i));
            }
        }
    }

    private void _findInsertedTextNodes(Node node) {
        if (DomUtils.isText((Node)node)) {
            this._result.insertedTextNodes.add(node);
        }
    }

    private ReformatInfoTracker(TextSyncContext context) {
        this._context = context;
        this._result = new ReformatInfo();
    }
}

