/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.changes.DomChangesUndoableEdit;
import oracle.bali.xml.dom.impl.DomModelPlugin;
import oracle.bali.xml.dom.impl.DomModelPluginContext;
import oracle.bali.xml.dom.parser.TextSynchronizer;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.SimulateInsertingFragmentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.dom.whitespace.WhitespaceUtils;
import oracle.bali.xml.sax.StringCaptureXmlFilter;
import oracle.bali.xml.sax.TreeWalkerXmlReader;
import oracle.bali.xml.share.BaliXmlProvider;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.logging.LogUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ParserDomModel
extends DomModelPlugin {
    private volatile int _synchedChangeCount;
    private volatile boolean _forceSync = true;
    private volatile boolean _syncInProgress = false;
    private volatile boolean _needsInit = true;
    private TextSynchronizer _textSource;
    private final BaliXmlProvider _parser;
    private final ReadWriteLock _lock = new ReadWriteLock();

    public ParserDomModel(DomModelPluginContext context, BaliXmlProvider parser, TextSynchronizer textBuffer) {
        super(context);
        if (parser == null) {
            throw new IllegalArgumentException("No parser provided");
        }
        this._parser = parser;
        this._textSource = textBuffer;
    }

    public void setTextSynchronizer(TextSynchronizer textSynchronizer) {
        this._textSource = textSynchronizer;
        this._needsInit = true;
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this._parser.getDOMImplementation();
    }

    @Override
    protected void handleCommittedDomChanges(DomChangesUndoableEdit domChanges) {
        this._syncToText();
    }

    @Override
    protected void ensureDocumentAvailable() {
        if (this._needsInit) {
            this._needsInit = false;
            this._ensureDocUpToDate();
        }
    }

    @Override
    public void postReplaceDocument(Document newDocument) {
        if (newDocument == null) {
            this._needsInit = true;
        }
    }

    @Override
    public List getCurrentDomParseProblems() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public DomModel.FragmentParseResult parseFragment(Document document, Node contextNode, Map predefinedPrefixes, String text) {
        if (document != null) {
            StringBuffer buf = new StringBuffer(text.length() + 200);
            buf.append("<a");
            Map prefixes = NamespaceUtils.getPrefixesInScope((Node)contextNode);
            prefixes.putAll(predefinedPrefixes);
            if (!prefixes.isEmpty()) {
                for (Map.Entry entry : prefixes.entrySet()) {
                    buf.append(" xmlns");
                    String key = (String)entry.getKey();
                    if (key.length() > 0) {
                        buf.append(':');
                        buf.append(key);
                    }
                    buf.append("=\"");
                    buf.append(entry.getValue());
                    buf.append("\"");
                }
            }
            buf.append(">");
            buf.append(text);
            buf.append("</a>");
            InputSource source = new InputSource(new StringReader(buf.toString()));
            try {
                Node child;
                Document tempDoc = this._parser.parseDocument(source);
                DocumentFragment fragment = document.createDocumentFragment();
                for (child = tempDoc.getDocumentElement().getFirstChild(); child != null; child = child.getNextSibling()) {
                    Node imported = document.importNode(child, true);
                    fragment.appendChild(imported);
                }
                Object traversal = null;
                traversal = DomUtils.isElement((Node)contextNode) ? new SimulateInsertingFragmentTreeTraversal((Element)contextNode, fragment) : DocumentTreeTraversal.INSTANCE;
                child = fragment.getFirstChild();
                while (child != null) {
                    Node next = child.getNextSibling();
                    WhitespaceUtils.applyWhitespaceRulesToSubtree(this.getContext().getWhitespaceHandler(), (TreeTraversal)traversal, child);
                    child = next;
                }
                return new DomModel.FragmentParseResult(fragment);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                LogUtils.log((Logger)this.getContext().getLogger(), (Level)Level.WARNING, (String)"Error parsing fragment:\n{0}\ncontext node: {1}", (Object[])new Object[]{text, contextNode}, (Throwable)t);
            }
        }
        return null;
    }

    @Override
    protected UndoableEdit removeDocType() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected UndoableEdit setDocType(String qualifiedName, String publicId, String systemId) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void refreshModel(boolean force) {
        if (force) {
            this._forceSync = true;
        }
        this._ensureDocUpToDate();
    }

    @Override
    public boolean needsReparse() {
        return !this._syncInProgress && (this._forceSync || this._synchedChangeCount != this._textSource.getChangeId() || this._needsInit);
    }

    @Override
    protected void acquireWriteLockDirectly() {
        this._lock.writeLock();
    }

    @Override
    protected void releaseWriteLockDirectly() {
        this._lock.writeUnlock();
    }

    @Override
    protected void acquireReadLockDirectly() {
        this._lock.readLock();
    }

    @Override
    protected void releaseReadLockDirectly() {
        this._lock.readUnlock();
    }

    @Override
    public int getLockStatus() {
        return this.getContext().getLockStatus(this._lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _ensureDocUpToDate() {
        if (this.needsReparse()) {
            this._forceSync = false;
            this._syncInProgress = true;
            this._synchedChangeCount = this._textSource.getChangeId();
            InputSource source = new InputSource();
            source.setSystemId(this._textSource.getSystemId());
            source.setCharacterStream(this._textSource.getReader());
            this.acquireWriteLockDirectly();
            try {
                Document newDocument = this._parser.parseDocument(source);
                WhitespaceUtils.applyWhitespaceRulesToSubtree(this.getContext().getWhitespaceHandler(), null, newDocument);
                this.getContext().replaceDocument(newDocument);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getContext().replaceDocument(null);
            }
            finally {
                this._syncInProgress = false;
                this.releaseWriteLockDirectly();
            }
        }
    }

    public static Reader createXmlTextFromDocument(Document document, final WhitespaceHandler wsHandler, String systemId, Logger logger) {
        String retString;
        final TreeWalker treeWalker = DomUtils.createTreeWalker((Node)document, (int)-1, null, null);
        TreeWalkerXmlReader xmlReader = new TreeWalkerXmlReader(treeWalker);
        xmlReader.setNamespacePrefixesFeature(true);
        StringCaptureXmlFilter captureFilter = new StringCaptureXmlFilter((XMLReader)xmlReader){

            protected boolean putWhitespaceBeforeCurrent() {
                Node node = treeWalker.getCurrentNode();
                Node parent = node.getParentNode();
                if (DomUtils.isElement((Node)parent)) {
                    WhitespaceMode mode = wsHandler.getElementContentWhitespaceMode(null, (Element)parent);
                    return mode.allowsAddingExtraWhitespace(DomPositionFactory.before((Node)node));
                }
                return super.putWhitespaceBeforeCurrent();
            }

            protected boolean putWhitespaceInsideCurrent() {
                Element node = (Element)treeWalker.getCurrentNode();
                if (DomUtils.isElement((Node)node)) {
                    WhitespaceMode mode = wsHandler.getElementContentWhitespaceMode(null, node);
                    return Boolean.TRUE.equals(mode.allowsAddingExtraWhitespace(DomPositionFactory.inside((Node)node)));
                }
                return super.putWhitespaceInsideCurrent();
            }
        };
        try {
            captureFilter.parse(systemId);
            retString = captureFilter.getXMLSource();
        }
        catch (Exception e) {
            retString = "<!-- Exception encountered producing text for Document: " + e + " -->";
            logger.log(Level.WARNING, "Exception encountered producing text for Document", e);
        }
        return new StringReader(retString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _syncToText() {
        if (!this._syncInProgress) {
            this._syncInProgress = true;
            try {
                Reader newText = ParserDomModel.createXmlTextFromDocument(this.getContext().getDocument(), this.getContext().getWhitespaceHandler(), this._textSource.getSystemId(), this.getContext().getLogger());
                this._textSource.contentUpdated(newText, this._textSource.getSystemId());
            }
            finally {
                this._syncInProgress = false;
                this._synchedChangeCount = this._textSource.getChangeId();
            }
        }
    }
}

