/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.awt.event.ActionEvent;
import oracle.bali.inspector.ActionContext;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.BasePropertyLevelAction;
import oracle.bali.xml.gui.base.inspector.PropertyModelUtils;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;

class ResetToDefaultAction
extends BasePropertyLevelAction {
    ResetToDefaultAction(BaseInspectorGui gui) {
        this.putValue("Name", gui.getTranslatedString("INSPECTOR.RESET_ACTION"));
        this.putValue("show-in-context-menu-even-when-inline-editing-disabled", true);
    }

    static boolean __supported(PropertyRow row) {
        return !Boolean.TRUE.equals(row.getColumnValue(19));
    }

    @Override
    protected void actionPerformedImpl(ActionEvent e, ActionContext context) {
        int isSetIndex = context.propertyModel().getColumnIndex(XmlDomPropertyModel.COLUMN_IS_SET);
        try {
            context.propertyModel().setPropertyValue(context.propertyModelRow(), null);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    @Override
    protected boolean computeEnabledStatusImpl(ActionContext context) {
        PropertyModel model = context.propertyModel();
        if (model != null) {
            int row = context.propertyModelRow();
            int count = model.getRowCount();
            if (count > 0 && row < count) {
                if (!model.getBooleanData(XmlDomPropertyModel.COLUMN_IS_WRITABLE, row)) {
                    return false;
                }
                if (!model.isPropertyWritable(row)) {
                    return false;
                }
                boolean isRequired = PropertyModelUtils.isRequired(model, row);
                Boolean isSet = PropertyModelUtils.getData(model, row, XmlDomPropertyModel.COLUMN_IS_SET, Boolean.class);
                if (isSet == null) {
                    return false;
                }
                return isSet != false && !isRequired;
            }
        }
        return false;
    }
}

