/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.xmlComponent;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.NodeFilterTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.inspector.XmlComponentSupport;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.message.MessageUtils;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.util.AttributeValueItemProvider;
import oracle.bali.xml.util.ContextualActionProvider;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;

public class XmlComponentModel {
    private static final Logger _LOGGER = Logger.getLogger(XmlComponentModel.class.getName());
    private XmlGui _xmlGui;
    private Node _startNode;
    private XmlKey _xmlKey;
    private XmlKey _navigationXmlKey;
    private XmlKey _rootXmlKey;
    private Node _node;
    private Node _precreatedNode;
    private Node _parentAttrNode;
    private XmlComponentModel _parentXmlComponentModel;
    private boolean _currentValueContainsError;
    private boolean _currentValueContainsWarning;
    private String _currentErrorMessage;
    private String _currentWarningMessage;
    private int _selectedIndex;

    public static XmlComponentModel createXmlComponentModel(XmlKey xmlKey, XmlKey rootXmlKey, XmlGui xmlGui) {
        return new XmlComponentModel(xmlKey, rootXmlKey, xmlGui);
    }

    public XmlComponentModel(XmlKey xmlKey, XmlKey rootXmlKey, XmlGui xmlGui) {
        this._xmlKey = xmlKey;
        this._navigationXmlKey = ImmutableXmlKey.createElementKey((QualifiedName)xmlKey.getElementQName());
        this._rootXmlKey = rootXmlKey;
        this._xmlGui = xmlGui;
        this._selectedIndex = -1;
    }

    public XmlKey getXmlKey() {
        return this._xmlKey;
    }

    public XmlKey getNavigationXmlKey() {
        return this._navigationXmlKey;
    }

    public void setNavigationXmlKey(XmlKey xmlKey) {
        this._navigationXmlKey = xmlKey;
    }

    public XmlKey getRootXmlKey() {
        return this._rootXmlKey;
    }

    public XmlGui getXmlGui() {
        return this._xmlGui;
    }

    public XmlView getView() {
        return this._xmlGui.getView();
    }

    public XmlComponentModel getParentXmlComponentModel() {
        return this._parentXmlComponentModel;
    }

    public void setParentXmlComponentModel(XmlComponentModel parentXmlComponentModel) {
        this._parentXmlComponentModel = parentXmlComponentModel;
    }

    public XmlMetadataResolver getXmlMetadataResolver() {
        return this.getView().getXmlMetadataResolver();
    }

    public String getShortDisplayName() {
        return this.getView().getXmlMetadataResolver().getShortDisplayName(this._xmlKey);
    }

    public Boolean isRequired() {
        boolean isRequired = false;
        if (this.getXmlKey().getNodeType() == 2) {
            XmlKey parentKey = ImmutableXmlKey.createElementKey((List)this.getXmlKey().getElementQNamePath());
            isRequired = this.getView().getXmlMetadataResolver().isRequired(this.getXmlKey(), parentKey);
        } else {
            XmlKey parentKey = this._parentXmlComponentModel != null ? this._parentXmlComponentModel.getXmlKey() : this._rootXmlKey;
            isRequired = this.getView().getXmlMetadataResolver().isRequired(this.getXmlKey(), parentKey);
        }
        return isRequired;
    }

    public String getMediumDisplayName() {
        return this.getView().getXmlMetadataResolver().getMediumDisplayName(this._xmlKey);
    }

    public String getLongDisplayName() {
        return this.getView().getXmlMetadataResolver().getLongDisplayName(this._xmlKey);
    }

    public Icon getSmallIcon() {
        return this.getView().getXmlMetadataResolver().getSmallIcon(this._xmlKey);
    }

    public String getSmallIconLocation() {
        return this.getView().getXmlMetadataResolver().getSmallIconLocation(this._xmlKey);
    }

    public AttributeValueItemProvider getAttributeValueProvider() {
        return this.getView().getXmlMetadataResolver().getAttributeValueProvider(this.getNode());
    }

    public ContextualActionProvider getContextualActionProvider() {
        return this.getView().getXmlMetadataResolver().getContextualActionProvider(this.getNode());
    }

    public String getDeprecated() {
        return this.getView().getXmlMetadataResolver().getDeprecated(this.getNode());
    }

    public int getDisplayOrder() {
        return this.getView().getXmlMetadataResolver().getDisplayOrder(this.getNode());
    }

    public PropertyEditor getPropertyEditor() {
        Node node = this.getNode();
        Object value = node;
        if (node != null) {
            value = this.getModelValue();
        } else {
            node = this.getPrecreatedNode();
        }
        PropertyEditor metadataPropertyEditor = XmlComponentSupport.getPropertyEditor(this.getXmlGui(), this.getXmlKey(), node, value);
        Node ownerNode = node;
        if (this.getXmlKey().getNodeType() == 2) {
            ownerNode = this.getParentAttrNode();
        }
        XmlKey ownerKey = ImmutableXmlKey.createElementKey((List)this.getXmlKey().getElementQNamePath());
        Node nearestAncestor = null;
        if (ownerNode != null) {
            nearestAncestor = ownerNode.getParentNode();
        }
        if (nearestAncestor == null) {
            nearestAncestor = this._getRootNode();
        }
        Node targetNode = node;
        XmlComponentSupport.setPropertyEditorContext(metadataPropertyEditor, this.getXmlGui(), this.getXmlKey(), node, ownerNode, ownerKey, nearestAncestor, targetNode);
        return metadataPropertyEditor;
    }

    public void setupPropertyEditor(PropertyEditor propertyEditor) {
        Node node = this.getNode();
        Object value = node;
        if (node != null) {
            value = this.getModelValue();
        } else {
            node = this.getPrecreatedNode();
        }
        Node ownerNode = node;
        if (this.getXmlKey().getNodeType() == 2) {
            ownerNode = this.getParentAttrNode();
        }
        XmlKey ownerKey = ImmutableXmlKey.createElementKey((List)this.getXmlKey().getElementQNamePath());
        Node nearestAncestor = null;
        if (ownerNode != null) {
            nearestAncestor = ownerNode.getParentNode();
        }
        if (nearestAncestor == null) {
            nearestAncestor = this._getRootNode();
        }
        Node targetNode = node;
        XmlComponentSupport.setPropertyEditorContext(propertyEditor, this.getXmlGui(), this.getXmlKey(), node, ownerNode, ownerKey, nearestAncestor, targetNode);
    }

    public Node getNode() {
        if (this._node != null) {
            return this._node;
        }
        this._node = this.createFindNodeTask().run(this.getView());
        return this._node;
    }

    public ReadOnlyTask<Node> createFindNodeTask() {
        return new ReadOnlyTask<Node>(){

            @Override
            protected Node runImpl(AbstractModel model) {
                return XmlComponentModel.this.findNode(XmlComponentModel.this.getParentXmlComponentModel(), XmlComponentModel.this.getNavigationXmlKey());
            }
        };
    }

    public void setNode(Node node) {
        this._node = node;
    }

    public void invalidateNode() {
        this._node = null;
        this._precreatedNode = null;
    }

    public void setSelection() {
        new NonDomMutationTransactionTask(){

            @Override
            protected void performTask(AbstractModel model) {
                Node selection = XmlComponentModel.this.getNode();
                if (selection != null && selection.getNodeType() == 2) {
                    selection = XmlComponentModel.this.getParentAttrNode();
                }
                if (selection != null) {
                    model.getSelection().set(selection);
                }
            }
        }.run(this.getView());
    }

    public boolean isReadOnly() {
        return (Boolean)new ReadOnlyTask<Boolean>(){

            @Override
            protected Boolean runImpl(AbstractModel model) {
                return model.getXmlMetadataResolver().isImmutable(XmlComponentModel.this.getXmlKey());
            }
        }.run(this.getView());
    }

    public boolean isViewReadOnly() {
        return (Boolean)new ReadOnlyTask<Boolean>(){

            @Override
            protected Boolean runImpl(AbstractModel model) {
                return model.isReadOnly();
            }
        }.run(this.getView());
    }

    public Node getStartNode() {
        if (this._startNode != null) {
            return this._startNode;
        }
        this._startNode = this.createStartNodeTask().run(this.getView());
        return this._startNode;
    }

    public ReadOnlyTask<Node> createStartNodeTask() {
        return new ReadOnlyTask<Node>(){

            @Override
            protected Node runImpl(AbstractModel model) {
                Element startNode = model.getDocument().getDocumentElement();
                if (startNode == null) {
                    return null;
                }
                if (XmlComponentModel.this.getView().getNodeXmlKey(startNode).equals((Object)XmlComponentModel.this.getRootXmlKey())) {
                    return startNode;
                }
                return model.getTreeTraversal().getFirstChild((Node)startNode);
            }
        };
    }

    public void setStartNode(Node startNode) {
        this._startNode = startNode;
    }

    public String getModelValue() {
        return (String)new ReadOnlyTask<String>(){

            @Override
            protected String runImpl(AbstractModel model) {
                Node currNode = XmlComponentModel.this.getNode();
                if (currNode == null) {
                    return null;
                }
                return DomUtils.getTextNodeValue((Node)currNode);
            }
        }.run(this.getView());
    }

    public void updateModelValue(String value) {
        this.createUpdateModelValueTask(value).run(this.getView());
    }

    public FixedNameTransactionTask createUpdateModelValueTask(final String value) {
        String msg = this.getXmlGui().getTranslatedString("XMLCOMPONENTMODEL_UNDO_CHANGE");
        String undoChangeMsg = FastMessageFormat.formatMessage(msg, this.getShortDisplayName());
        return new FixedNameTransactionTask(undoChangeMsg){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                Node currNode = XmlComponentModel.this.getNode();
                if (value == null || value.length() == 0) {
                    if (currNode == null) {
                        return;
                    }
                    if (currNode.getNodeType() == 2) {
                        DomUtils.removeAttribute((Element)((Element)XmlComponentModel.this._parentAttrNode), (QualifiedName)XmlComponentModel.this.getXmlKey().getAttributeQName());
                    } else if (currNode.getParentNode() != null) {
                        currNode.getParentNode().removeChild(currNode);
                    }
                    XmlComponentModel.this.invalidateNode();
                    return;
                }
                if (currNode == null) {
                    currNode = XmlComponentModel.this.findOrCreateNode(XmlComponentModel.this.getParentXmlComponentModel(), XmlComponentModel.this.getNavigationXmlKey());
                    if (value.isEmpty()) {
                        return;
                    }
                }
                if (currNode == null) {
                    return;
                }
                if (currNode.getNodeType() == 2) {
                    currNode.setNodeValue(value);
                } else {
                    DomUtils.setTextNodeValue((Node)currNode, (String)value);
                }
            }
        };
    }

    public void checkForErrorsAndWarnings() {
        this._currentValueContainsError = false;
        this._currentValueContainsWarning = false;
        this._currentErrorMessage = null;
        this._currentWarningMessage = null;
        new ReadOnlyTask<Boolean>(){

            @Override
            protected Boolean runImpl(AbstractModel model) {
                IssueList issueList;
                List<Issue> issuesForNode;
                Node node = XmlComponentModel.this.getNode();
                if (node != null && (issuesForNode = MessageUtils.getIssuesForNode(issueList = XmlComponentModel.this.getView().getContext().getIssueList(), node)) != null && !issuesForNode.isEmpty()) {
                    for (Issue issue : issuesForNode) {
                        if (issue.getSeverity() == Severity.WARNING) {
                            XmlComponentModel.this._currentValueContainsWarning = true;
                            XmlComponentModel.this._currentWarningMessage = issue.getMessage();
                        }
                        if (issue.getSeverity() != Severity.ERROR) continue;
                        XmlComponentModel.this._currentValueContainsError = true;
                        XmlComponentModel.this._currentErrorMessage = issue.getMessage();
                    }
                }
                if (node == null && XmlComponentModel.this.isRequired().booleanValue() && XmlComponentModel.this.getXmlKey().getNodeType() == 2) {
                    issueList = XmlComponentModel.this.getView().getBaseModel().getXmlModelInternalMessageLog();
                    node = XmlComponentModel.this.getParentAttrNode();
                    for (int i = 0; i < issueList.size(); ++i) {
                        Issue issue = issueList.getIssueAt(i);
                        XmlComponentModel.this.handleIssue(issue, XmlComponentModel.this.getXmlKey().getAttributeQName().getName());
                    }
                }
                return true;
            }
        }.run(this.getXmlGui().getView());
    }

    private void handleIssue(Issue issue, String nodeName) {
        String issueMessage = issue.getMessage();
        if (issue.getSeverity() == Severity.WARNING && issueMessage.indexOf(" " + nodeName + " ") > 0) {
            this._currentValueContainsWarning = true;
            this._currentWarningMessage = issueMessage;
        }
        if (issue.getSeverity() == Severity.ERROR && issueMessage.indexOf(" " + nodeName + " ") > 0) {
            this._currentValueContainsError = true;
            this._currentErrorMessage = issueMessage;
        }
    }

    public boolean modelValueContainsError() {
        return this._currentValueContainsError;
    }

    public boolean modelValueContainsWarning() {
        return this._currentValueContainsWarning;
    }

    public String getCurrentErrorMessage() {
        return this._currentErrorMessage;
    }

    public String getCurrentWarningMessage() {
        return this._currentWarningMessage;
    }

    public void insertChildNode() {
        String msg = this.getXmlGui().getTranslatedString("XMLCOMPONENTMODEL_UNDO_INSERT");
        String undoInsertMsg = FastMessageFormat.formatMessage(msg, this.getShortDisplayName());
        new FixedNameTransactionTask(undoInsertMsg){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                int i;
                ArrayList qualifiedElementNameList;
                List qNavXmlKey;
                Node currNode = XmlComponentModel.this.getNode();
                Node parentNode = null;
                XmlKey parentXmlKey = null;
                if (currNode != null) {
                    parentNode = currNode.getParentNode();
                    parentXmlKey = XmlComponentModel.this.getNavigationXmlKey();
                } else if (XmlComponentModel.this.getParentXmlComponentModel() != null) {
                    parentNode = XmlComponentModel.this.getParentXmlComponentModel().getNode();
                    parentXmlKey = XmlComponentModel.this.getParentXmlComponentModel().getXmlKey();
                } else {
                    qNavXmlKey = XmlComponentModel.this.getNavigationXmlKey().getElementQNamePath();
                    if (qNavXmlKey.size() > 1) {
                        qualifiedElementNameList = new ArrayList();
                        for (i = 0; i < qNavXmlKey.size() - 1; ++i) {
                            qualifiedElementNameList.add(qNavXmlKey.get(i));
                        }
                        parentXmlKey = ImmutableXmlKey.createElementKey(qualifiedElementNameList);
                    }
                }
                if (parentNode == null) {
                    parentNode = parentXmlKey == null ? XmlComponentModel.this.getStartNode() : XmlComponentModel.this.findOrCreateNode(XmlComponentModel.this.getParentXmlComponentModel(), parentXmlKey);
                } else if (XmlComponentModel.this.getNavigationXmlKey().getElementQNamePath().size() > 1) {
                    qNavXmlKey = XmlComponentModel.this.getNavigationXmlKey().getElementQNamePath();
                    qualifiedElementNameList = new ArrayList();
                    for (i = 0; i < qNavXmlKey.size() - 1; ++i) {
                        qualifiedElementNameList.add(qNavXmlKey.get(i));
                    }
                    parentXmlKey = ImmutableXmlKey.createElementKey(qualifiedElementNameList);
                    parentNode = XmlComponentModel.this.findOrCreateNode(XmlComponentModel.this.getParentXmlComponentModel(), parentXmlKey);
                }
                if (parentNode != null) {
                    DomPosition position = DomPositionFactory.createInsideOrAfterPosition((Node)parentNode);
                    Node createdNode = XmlComponentModel.this.getView().insertXmlKey(XmlComponentModel.this.getXmlKey(), position);
                }
            }
        }.run(this.getView());
    }

    public void deleteNode(Node node) {
        boolean errorFlag = false;
        try {
            String msg = this.getXmlGui().getTranslatedString("XMLCOMPONENTMODEL_UNDO_DELETE");
            String undoDeleteMsg = FastMessageFormat.formatMessage(msg, this.getShortDisplayName());
            Collection modelRet = this.getView().deleteNodes(undoDeleteMsg, Collections.singleton(node), true);
        }
        catch (XmlCommitException xce) {
            errorFlag = true;
        }
    }

    public Node getParentNode() {
        return (Node)new ReadOnlyTask<Node>(){

            @Override
            protected Node runImpl(AbstractModel model) {
                Node node = XmlComponentModel.this.getNode();
                if (node == null) {
                    return null;
                }
                if (node.getNodeType() == 2) {
                    node = XmlComponentModel.this._parentAttrNode;
                }
                return XmlComponentModel.this.getView().getTreeTraversal().getParentNode(node);
            }
        }.run(this.getView());
    }

    public NodeFilter getNodeFilter() {
        NodeFilter nodeFilter = new NodeFilter(){

            @Override
            public short acceptNode(Node node) {
                String nodeName = node.getLocalName();
                Node parentNode = XmlComponentModel.this.getNode().getParentNode();
                String xmlKeyLocalName = XmlComponentModel.this.getXmlKey().getLocalName();
                Node traversalParentNode = XmlComponentModel.this.getView().getTreeTraversal().getParentNode(node);
                if (xmlKeyLocalName.equals(nodeName) && traversalParentNode == parentNode) {
                    return 1;
                }
                return 3;
            }
        };
        return nodeFilter;
    }

    public TreeTraversal getNodeFilterTreeTraversal() {
        NodeFilterTreeTraversal xmlKeyTreeTraversal = new NodeFilterTreeTraversal(this.getView().getTreeTraversal(), 1, this.getNodeFilter());
        return xmlKeyTreeTraversal;
    }

    public int getChildCount(Object parent) {
        if (parent == null || !(parent instanceof Node)) {
            return 0;
        }
        final Node parentNode = (Node)parent;
        return (Integer)new ReadOnlyTask<Integer>(){

            @Override
            protected Integer runImpl(AbstractModel model) {
                return XmlComponentModel.this.getNodeFilterTreeTraversal().getChildCount(parentNode);
            }
        }.run(this.getView());
    }

    public Object getChild(Object parent, final int index) {
        if (parent == null || !(parent instanceof Node)) {
            return null;
        }
        final Node parentNode = (Node)parent;
        return new ReadOnlyTask<Node>(){

            @Override
            protected Node runImpl(AbstractModel model) {
                return XmlComponentModel.this.getNodeFilterTreeTraversal().getChild(parentNode, index);
            }
        }.run(this.getView());
    }

    public boolean isNodeOrDescendant(Node changeRoot) {
        Node textNode;
        boolean isNodeOrDescendant;
        Node node = this.createFindNodeTask().run(this.getView());
        if (node == null) {
            if (this.getXmlKey().getNodeType() == 2 && this._parentAttrNode != null) {
                return DomUtils.isNodeOrDescendant((TreeTraversal)this.getView().getTreeTraversal(), (Node)this._parentAttrNode, (Node)changeRoot);
            }
            return false;
        }
        if (node.getNodeType() == 2) {
            node = this._parentAttrNode;
        }
        if (!(isNodeOrDescendant = DomUtils.isNodeOrDescendant((TreeTraversal)this.getView().getTreeTraversal(), (Node)node, (Node)changeRoot)) && node.getNodeType() == 1 && (textNode = XmlComponentModel._getTextNode(node)) != null && textNode == changeRoot) {
            isNodeOrDescendant = true;
        }
        return isNodeOrDescendant;
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        this._selectedIndex = selectedIndex;
    }

    public Node findNode(XmlComponentModel parentXmlComponentModel, XmlKey navigationXmlKey) {
        Node startNode = null;
        XmlKey startKey = null;
        Node currNode = null;
        Node attrNode = null;
        if (parentXmlComponentModel == null) {
            startNode = this.getStartNode();
            startKey = navigationXmlKey;
        } else {
            startNode = parentXmlComponentModel.getNode();
            if (startNode == null) {
                return null;
            }
            if (startNode.getNodeType() == 2) {
                startNode = parentXmlComponentModel.getParentAttrNode();
            }
            startKey = navigationXmlKey;
        }
        if (startNode == null) {
            return null;
        }
        List qNamePath = startKey.getElementQNamePath();
        currNode = startNode;
        for (QualifiedName qn : qNamePath) {
            if (currNode.getNamespaceURI() == null) {
                String localName = currNode.getLocalName();
                return null;
            }
            if (qn.compareTo((Object)DomUtils.getQualifiedName((Node)currNode)) == 0) break;
            Element newNode = XmlComponentModel._findChildElement(this.getView().getTreeTraversal(), currNode, qn);
            if (newNode == null) {
                return null;
            }
            currNode = newNode;
        }
        if (this.getXmlKey().getNodeType() == 2) {
            attrNode = XmlComponentModel._getAttrNode(currNode, this.getXmlKey(), false);
            this._parentAttrNode = currNode;
            return attrNode;
        }
        this._parentAttrNode = null;
        return currNode;
    }

    public Node findOrCreateNode(XmlComponentModel parentXmlComponentModel, XmlKey navigationXmlKey) {
        DomPosition position;
        Element newNode;
        Node startNode = null;
        XmlKey startKey = null;
        Node currNode = null;
        Node attrNode = null;
        if (parentXmlComponentModel == null) {
            startNode = this.getStartNode();
            startKey = navigationXmlKey;
            if (startNode == null) {
                startNode = this.getView().getBaseModel().getDocument();
                try {
                    List qRootKeyPath = this._rootXmlKey.getElementQNamePath();
                    for (QualifiedName qn : qRootKeyPath) {
                        newNode = XmlComponentModel._findChildElement(this.getView().getBaseModel().getTreeTraversal(), startNode, qn);
                        if (newNode == null) {
                            newNode = this.getView().getBaseModel().getDocument().createElementNS(qn.getNamespace(), qn.getName());
                            position = DomPositionFactory.inside((Node)startNode);
                            this.getView().getBaseModel().insertNode(newNode, position);
                        }
                        startNode = newNode;
                    }
                }
                catch (XmlCommitException xce) {
                    _LOGGER.log(Level.SEVERE, "XmlComponentModel.findOrCreateNode() XmlCommitException startNode=" + startNode, xce);
                }
            }
        } else {
            startNode = parentXmlComponentModel.getNode();
            if (startNode == null && (startNode = this.createParentNode(parentXmlComponentModel)) == null) {
                return null;
            }
            startKey = navigationXmlKey;
        }
        try {
            QualifiedName qn;
            List qNamePath = startKey.getElementQNamePath();
            currNode = startNode;
            Iterator i$ = qNamePath.iterator();
            while (i$.hasNext() && (qn = (QualifiedName)i$.next()).compareTo((Object)DomUtils.getQualifiedName((Node)currNode)) != 0) {
                newNode = XmlComponentModel._findChildElement(this.getView().getTreeTraversal(), currNode, qn);
                if (newNode == null) {
                    newNode = this.getView().getDocument().createElementNS(qn.getNamespace(), qn.getName());
                    position = DomPositionFactory.inside((Node)currNode);
                    this.getView().insertNode(newNode, position, false);
                }
                currNode = newNode;
            }
            if (this.getXmlKey().getNodeType() == 2) {
                attrNode = XmlComponentModel._getAttrNode(currNode, this.getXmlKey(), true);
                this._parentAttrNode = currNode;
                return attrNode;
            }
            this._parentAttrNode = null;
        }
        catch (XmlCommitException xce) {
            _LOGGER.log(Level.SEVERE, "XmlComponentModel.findOrCreateNode() XmlCommitException currNode=" + currNode, xce);
        }
        return currNode;
    }

    public Node createParentNode(XmlComponentModel xmlComponentModel) {
        if (xmlComponentModel.getParentXmlComponentModel() == null) {
            if (xmlComponentModel.getView().getDocument().getDocumentElement() == null) {
                Element rootNode = xmlComponentModel.getView().getDocument().createElementNS(this.getRootXmlKey().getNamespace(), this.getRootXmlKey().getLocalName());
                xmlComponentModel.getView().getDocument().appendChild(rootNode);
            }
        } else {
            return this.createParentNode(xmlComponentModel.getParentXmlComponentModel());
        }
        xmlComponentModel.insertChildNode();
        return xmlComponentModel.getNode();
    }

    public Node getParentAttrNode() {
        return this._parentAttrNode;
    }

    public Node getPrecreatedNode() {
        if (this._precreatedNode != null) {
            return this._precreatedNode;
        }
        final QualifiedName qn = this.getXmlKey().getElementQName();
        this._precreatedNode = (Node)new ReadOnlyTask<Node>(){

            @Override
            protected Node runImpl(AbstractModel model) {
                Element currNode = XmlComponentModel.this.getView().getDocument().createElementNS(qn.getNamespace(), qn.getName());
                if (XmlComponentModel.this.getXmlKey().getNodeType() == 2) {
                    XmlComponentModel.this._parentAttrNode = currNode;
                    return XmlComponentModel._getAttrNode(currNode, XmlComponentModel.this.getXmlKey(), true);
                }
                return currNode;
            }
        }.run(this.getView());
        return this._precreatedNode;
    }

    private static Node _getAttrNode(Node currNode, XmlKey key, boolean create) {
        if (currNode instanceof Element) {
            QualifiedName qn = key.getAttributeQName();
            String namespace = qn.getNamespace();
            String name = qn.getName();
            Attr attrNode = DomUtils.getAttribute((Element)((Element)currNode), (QualifiedName)qn);
            if (attrNode == null && create) {
                ((Element)currNode).setAttributeNS(namespace, name, "");
                attrNode = DomUtils.getAttribute((Element)((Element)currNode), (QualifiedName)qn);
            }
            return attrNode;
        }
        return null;
    }

    private static Element _findChildElement(TreeTraversal treeTraversal, Node parent, QualifiedName child) {
        if (parent == null) {
            return null;
        }
        int childCount = treeTraversal.getChildCount(parent);
        for (int i = 0; i < childCount; ++i) {
            Node n = treeTraversal.getChild(parent, i);
            if (!XmlComponentModel._matches(n, child)) continue;
            return (Element)n;
        }
        return null;
    }

    private static boolean _matches(Node n, QualifiedName qn) {
        if (n instanceof Element) {
            String nsUri = n.getNamespaceURI();
            String localName = n.getLocalName();
            if (qn.getNamespace() == null) {
                return nsUri == null && qn.getName().equals(localName);
            }
            return qn.getNamespace().equals(nsUri) && qn.getName().equals(localName);
        }
        return false;
    }

    private static Node _getTextNode(Node node) {
        Node textNode = null;
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3) continue;
                textNode = child;
                break;
            }
        }
        return textNode;
    }

    private Node _getRootNode() {
        Node rootNode = (Node)new ReadOnlyTask<Node>(){

            @Override
            protected Node runImpl(AbstractModel model) {
                return XmlComponentModel.this.getView().getDocument().getDocumentElement();
            }
        }.run(this.getView());
        return rootNode;
    }
}

