/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.io.IOException;
import java.util.List;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.sax.StringCaptureXmlFilter;
import oracle.bali.xml.sax.TreeWalkerXmlReader;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlInvalidOnCommitException
extends XmlCommitException {
    public XmlInvalidOnCommitException(XmlModel model, List<XmlModelMessage> transactionBlockingErrors) {
        this(model, transactionBlockingErrors, true);
    }

    public XmlInvalidOnCommitException(XmlModel model, List<XmlModelMessage> transactionBlockingErrors, boolean verboseMessage) {
        super(model, XmlInvalidOnCommitException._createMessage(model, transactionBlockingErrors, verboseMessage), null);
    }

    @Override
    public boolean isValidationFailure() {
        return true;
    }

    private static String _getInvalidSubtree(XmlModel model, Node root) {
        if (root == null) {
            root = model.getDocument();
        }
        if (root.getNodeType() == 9 && (root = ((Document)root).getDocumentElement()) == null) {
            return model.getTranslatedString("XML_MODEL_INVALID.NO_ROOT_REASON");
        }
        TreeWalker walker = DomUtils.createTreeWalker((Node)root, (int)-1, null, (TreeTraversal)model.getTreeTraversal());
        TreeWalkerXmlReader twxr = new TreeWalkerXmlReader(walker);
        StringCaptureXmlFilter s = new StringCaptureXmlFilter((XMLReader)twxr, false);
        try {
            s.parse("ignored");
        }
        catch (IOException e) {
        }
        catch (SAXException e) {
            // empty catch block
        }
        return s.getXMLSource();
    }

    private static String _createMessage(XmlModel model, List<XmlModelMessage> transactionBlockingErrors, boolean verboseMessage) {
        StringBuilder builder = new StringBuilder();
        for (XmlModelMessage error : transactionBlockingErrors) {
            builder.append(error);
            builder.append("\n");
        }
        if (verboseMessage) {
            builder.append("\n\n");
            Node ancestor = XmlInvalidOnCommitException._getCommonAncestor(transactionBlockingErrors);
            if (ancestor != null) {
                builder.append(XmlInvalidOnCommitException._getInvalidSubtree(model, ancestor));
            }
        }
        return builder.toString();
    }

    private static Node _getCommonAncestor(List<XmlModelMessage> transactionBlockingErrors) {
        Node parent;
        Node ancestor = null;
        for (XmlModelMessage error : transactionBlockingErrors) {
            Node bad = error.getRelatedNode();
            if (bad == null) continue;
            if (bad.getNodeType() == 2) {
                bad = ((Attr)bad).getOwnerElement();
            }
            if (ancestor == null) {
                ancestor = bad;
                continue;
            }
            ancestor = DomUtils.lowestCommonAncestor((Node)ancestor, (Node)bad);
        }
        if (ancestor != null && (parent = ancestor.getParentNode()) != null) {
            ancestor = parent;
        }
        return ancestor;
    }
}

